/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.utils;

import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.navigation.EmptyNavigatable;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.SymbolNavigationService;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.polySymbols.CompositePolySymbol;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.PolySymbolApiStatus;
import com.intellij.polySymbols.PolySymbolKind;
import com.intellij.polySymbols.PolySymbolNameSegment;
import com.intellij.polySymbols.PolySymbolQualifiedName;
import com.intellij.polySymbols.completion.PolySymbolCodeCompletionItem;
import com.intellij.polySymbols.html.PolySymbolHtmlAttributeValue;
import com.intellij.polySymbols.impl.PolySymbolNameSegmentImpl;
import com.intellij.polySymbols.impl.PolySymbolsImplUtilsKt;
import com.intellij.polySymbols.patterns.PolySymbolPattern;
import com.intellij.polySymbols.patterns.impl.MatchResult;
import com.intellij.polySymbols.patterns.impl.PatternImplUtilsKt;
import com.intellij.polySymbols.query.PolySymbolCodeCompletionQueryParams;
import com.intellij.polySymbols.query.PolySymbolListSymbolsQueryParams;
import com.intellij.polySymbols.query.PolySymbolMatch;
import com.intellij.polySymbols.query.PolySymbolNameMatchQueryParams;
import com.intellij.polySymbols.query.PolySymbolNamesProvider;
import com.intellij.polySymbols.query.PolySymbolQueryExecutor;
import com.intellij.polySymbols.query.PolySymbolQueryStack;
import com.intellij.polySymbols.query.PolySymbolScope;
import com.intellij.polySymbols.query.PolySymbolWithPattern;
import com.intellij.polySymbols.query.impl.PolySymbolMatchBase;
import com.intellij.polySymbols.search.PsiSourcedPolySymbol;
import com.intellij.polySymbols.utils.PolySymbolDelegate;
import com.intellij.polySymbols.utils.PolySymbolUtils;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntheticElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a_\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002\"\b\b\u0001\u0010\u0003*\u00020\u0002*\u0002H\u00012\b\u0010\u0004\u001a\u0004\u0018\u0001H\u00032\u001d\u0010\u0005\u001a\u0019\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00010\u0006\u00a2\u0006\u0002\b\u0007H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0000\u00a2\u0006\u0002\u0010\b\u001a\u0010\u0010\t\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\f0\u000b\u001a\u001c\u0010\r\u001a\u0004\u0018\u00010\f*\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\n\u001a\u0012\u0010\u000f\u001a\u00020\f*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0012\u0010\u0012\u001a\u00020\f*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016*\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0010\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a*\u00020\f\u001a\u0018\u0010\u001b\u001a\u00020\u001c*\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u001a\u0018\u0010\u001e\u001a\u00020\u001f*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u000b\u001a(\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\f2\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&\u001a(\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u000b*\u00020\f2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010#\u001a\u00020*2\u0006\u0010%\u001a\u00020&\u001a\u001a\u0010+\u001a\u00020\n*\u00020\f2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-\u001a\u001e\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000b*\b\u0012\u0004\u0012\u00020\u001c0\u000b2\u0006\u0010J\u001a\u00020K\u001a\u0016\u0010L\u001a\u00020M*\u0004\u0018\u00010M2\b\u0010N\u001a\u0004\u0018\u00010M\u001a6\u0010O\u001a\u00020M\"\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0010P\u001a\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010Q2\u0014\u0010R\u001a\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u00010M0S\u001a6\u0010O\u001a\u00020M\"\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0010T\u001a\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u001a2\u0014\u0010R\u001a\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u00010M0S\u001a\u0014\u0010U\u001a\u0004\u0018\u00010V*\n\u0012\u0006\u0012\u0004\u0018\u00010V0\u001a\u001a\u001a\u0010W\u001a\u00020X*\u00020Y2\u0006\u0010Z\u001a\u00020\u00182\u0006\u0010[\u001a\u00020K\u001a(\u0010\\\u001a\b\u0012\u0004\u0012\u00020(0\u000b*\u00020]2\u0006\u0010.\u001a\u00020/2\u0006\u0010#\u001a\u00020*2\u0006\u0010%\u001a\u00020&\u001a\u001e\u0010^\u001a\u00020_2\u0014\u0010`\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020_0a0\u000bH\u0007\u001a\u0010\u0010b\u001a\u00020\n2\u0006\u0010c\u001a\u00020dH\u0007\"\u0015\u0010.\u001a\u00020/*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101\"\u0019\u00102\u001a\u00060\u0011j\u0002`3*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b4\u00105\"\u0019\u00106\u001a\u00060\u0011j\u0002`7*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b8\u00105\"\u0015\u00109\u001a\u00020\n*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\"\u001b\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\"\u001b\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001a*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010A\"\u0018\u0010B\u001a\u00020\u0011*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u00105\"\u0015\u0010D\u001a\u00020\n*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010;\"\u0017\u0010F\u001a\u00020\n*\u0004\u0018\u00010G8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010H\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006e"}, d2={"applyIfNotNull", "T", "", "P", "param", "block", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "hasOnlyExtensions", "", "", "Lcom/intellij/polySymbols/PolySymbol;", "asSingleSymbol", "force", "withMatchedName", "matchedName", "", "withMatchedKind", "kind", "Lcom/intellij/polySymbols/PolySymbolKind;", "withNavigationTarget", "Lcom/intellij/polySymbols/utils/PolySymbolDelegate;", "target", "Lcom/intellij/psi/PsiElement;", "unwrapMatchedSymbols", "Lkotlin/sequences/Sequence;", "withSymbols", "Lcom/intellij/polySymbols/PolySymbolNameSegment;", "symbols", "withSegments", "Lcom/intellij/polySymbols/query/PolySymbolMatch;", "segments", "match", "nameToMatch", "params", "Lcom/intellij/polySymbols/query/PolySymbolNameMatchQueryParams;", "stack", "Lcom/intellij/polySymbols/query/PolySymbolQueryStack;", "toCodeCompletionItems", "Lcom/intellij/polySymbols/completion/PolySymbolCodeCompletionItem;", "name", "Lcom/intellij/polySymbols/query/PolySymbolCodeCompletionQueryParams;", "nameMatches", "queryExecutor", "Lcom/intellij/polySymbols/query/PolySymbolQueryExecutor;", "qualifiedName", "Lcom/intellij/polySymbols/PolySymbolQualifiedName;", "getQualifiedName", "(Lcom/intellij/polySymbols/PolySymbol;)Lcom/intellij/polySymbols/PolySymbolQualifiedName;", "namespace", "Lcom/intellij/polySymbols/PolySymbolNamespace;", "getNamespace", "(Lcom/intellij/polySymbols/PolySymbol;)Ljava/lang/String;", "kindName", "Lcom/intellij/polySymbols/PolySymbolKindName;", "getKindName", "completeMatch", "getCompleteMatch", "(Lcom/intellij/polySymbols/PolySymbol;)Z", "nameSegments", "getNameSegments", "(Lcom/intellij/polySymbols/PolySymbol;)Ljava/util/List;", "nameSegmentsWithProblems", "getNameSegmentsWithProblems", "(Lcom/intellij/polySymbols/PolySymbol;)Lkotlin/sequences/Sequence;", "matchedNameOrName", "getMatchedNameOrName", "hideFromCompletion", "getHideFromCompletion", "isCritical", "Lcom/intellij/polySymbols/PolySymbolNameSegment$MatchProblem;", "(Lcom/intellij/polySymbols/PolySymbolNameSegment$MatchProblem;)Z", "withOffset", "offset", "", "coalesceWith", "Lcom/intellij/polySymbols/PolySymbolApiStatus;", "other", "coalesceApiStatus", "collection", "", "mapper", "Lkotlin/Function1;", "sequence", "merge", "Lcom/intellij/polySymbols/html/PolySymbolHtmlAttributeValue;", "createPsiRangeNavigationItem", "Lcom/intellij/pom/Navigatable;", "Lcom/intellij/platform/backend/navigation/NavigationTarget;", "element", "offsetWithinElement", "getDefaultCodeCompletions", "Lcom/intellij/polySymbols/query/PolySymbolScope;", "createModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "trackersPointers", "Lcom/intellij/model/Pointer;", "acceptSymbolForPsiSourcedPolySymbolRenameHandler", "symbol", "Lcom/intellij/model/Symbol;", "intellij.platform.polySymbols"})
@JvmName(name="PolySymbolUtils")
@SourceDebugExtension(value={"SMAP\nPolySymbolUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolySymbolUtils.kt\ncom/intellij/polySymbols/utils/PolySymbolUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,401:1\n1786#2,3:402\n1807#2,3:405\n1586#2:409\n1661#2,3:410\n1807#2,3:413\n1786#2,3:416\n1586#2:420\n1661#2,3:421\n1391#2:431\n1480#2,5:432\n1642#2,10:437\n1915#2:447\n1916#2:449\n1652#2:450\n19#3:408\n1#4:419\n1#4:448\n2417#5,7:424\n*S KotlinDebug\n*F\n+ 1 PolySymbolUtils.kt\ncom/intellij/polySymbols/utils/PolySymbolUtils\n*L\n51#1:402,3\n60#1:405,3\n189#1:409\n189#1:410,3\n194#1:413,3\n208#1:416,3\n267#1:420\n267#1:421,3\n384#1:431\n384#1:432,5\n157#1:437,10\n157#1:447\n157#1:449\n157#1:450\n78#1:408\n157#1:448\n298#1:424,7\n*E\n"})
public final class PolySymbolUtils {
    @NotNull
    public static final <T, P> T applyIfNotNull(@NotNull T $this$applyIfNotNull, @Nullable P param, @NotNull Function2<? super T, ? super P, ? extends T> block) {
        Intrinsics.checkNotNullParameter($this$applyIfNotNull, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$applyIfNotNull = false;
        return (T)(param != null ? block.invoke($this$applyIfNotNull, param) : $this$applyIfNotNull);
    }

    public static final boolean hasOnlyExtensions(@NotNull List<? extends PolySymbol> $this$hasOnlyExtensions) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$hasOnlyExtensions, (String)"<this>");
            Iterable $this$all$iv = $this$hasOnlyExtensions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PolySymbol it = (PolySymbol)element$iv;
                    boolean bl2 = false;
                    if (it.isExtension()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final PolySymbol asSingleSymbol(@NotNull List<? extends PolySymbol> $this$asSingleSymbol, boolean force) {
        block7: {
            block5: {
                block8: {
                    block6: {
                        Intrinsics.checkNotNullParameter($this$asSingleSymbol, (String)"<this>");
                        if (!$this$asSingleSymbol.isEmpty()) break block6;
                        v0 = null;
                        break block7;
                    }
                    if ($this$asSingleSymbol.size() != 1) break block8;
                    v0 = $this$asSingleSymbol.get(0);
                    break block7;
                }
                first = $this$asSingleSymbol.get(0);
                if (force) ** GOTO lbl-1000
                $this$any$iv = $this$asSingleSymbol;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (PolySymbol)element$iv;
                        $i$a$-any-PolySymbolUtils$asSingleSymbol$1 = false;
                        if (!(Intrinsics.areEqual((Object)it.getKind(), (Object)first.getKind()) == false)) continue;
                        v1 = true;
                        break block5;
                    }
                    v1 = false;
                }
            }
            if (v1) {
                v2 = null;
            } else lbl-1000:
            // 2 sources

            {
                var3_3 = new PolySymbolNameSegment[]{PolySymbolNameSegment.Companion.create$default(PolySymbolNameSegment.Companion, 0, first.getName().length(), PolySymbolsImplUtilsKt.sortSymbolsByPriority$default($this$asSingleSymbol, false, 1, null), null, null, 0, null, null, null, 504, null)};
                v2 = PolySymbolMatch.Companion.create(first.getName(), first.getKind(), var3_3);
            }
            v0 = v2;
        }
        return v0;
    }

    public static /* synthetic */ PolySymbol asSingleSymbol$default(List list2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return PolySymbolUtils.asSingleSymbol(list2, bl);
    }

    @NotNull
    public static final PolySymbol withMatchedName(@NotNull PolySymbol $this$withMatchedName, @NotNull String matchedName) {
        PolySymbol polySymbol;
        Intrinsics.checkNotNullParameter((Object)$this$withMatchedName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matchedName, (String)"matchedName");
        if (!Intrinsics.areEqual((Object)matchedName, (Object)$this$withMatchedName.getName())) {
            PolySymbolNameSegment nameSegment = $this$withMatchedName instanceof PolySymbolMatch && ((PolySymbolMatch)$this$withMatchedName).getNameSegments().size() == 1 ? (PolySymbolNameSegment)PolySymbolsImplUtilsKt.withRange(((PolySymbolMatch)$this$withMatchedName).getNameSegments().get(0), 0, matchedName.length()) : PolySymbolNameSegment.Companion.create(0, matchedName.length(), $this$withMatchedName);
            PolySymbolNameSegment[] polySymbolNameSegmentArray = new PolySymbolNameSegment[]{nameSegment};
            polySymbol = PolySymbolMatch.Companion.create(matchedName, $this$withMatchedName.getKind(), polySymbolNameSegmentArray);
        } else {
            polySymbol = $this$withMatchedName;
        }
        return polySymbol;
    }

    @NotNull
    public static final PolySymbol withMatchedKind(@NotNull PolySymbol $this$withMatchedKind, @NotNull PolySymbolKind kind) {
        PolySymbol polySymbol;
        Intrinsics.checkNotNullParameter((Object)$this$withMatchedKind, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (!Intrinsics.areEqual((Object)kind, (Object)$this$withMatchedKind.getKind())) {
            Object object;
            PolySymbol $this$asSafely$iv = $this$withMatchedKind;
            boolean $i$f$asSafely = false;
            PolySymbol polySymbol2 = $this$asSafely$iv;
            if (!(polySymbol2 instanceof PolySymbolMatch)) {
                polySymbol2 = null;
            }
            if ((object = (PolySymbolMatch)polySymbol2) == null || (object = object.getMatchedName()) == null) {
                object = $this$withMatchedKind.getName();
            }
            Object matchedName = object;
            PolySymbolNameSegment nameSegment = $this$withMatchedKind instanceof PolySymbolMatch && ((PolySymbolMatch)$this$withMatchedKind).getNameSegments().size() == 1 ? (PolySymbolNameSegment)PolySymbolsImplUtilsKt.withRange(((PolySymbolMatch)$this$withMatchedKind).getNameSegments().get(0), 0, ((String)matchedName).length()) : PolySymbolNameSegment.Companion.create(0, ((String)matchedName).length(), $this$withMatchedKind);
            PolySymbolNameSegment[] polySymbolNameSegmentArray = new PolySymbolNameSegment[]{nameSegment};
            polySymbol = PolySymbolMatch.Companion.create((String)matchedName, kind, polySymbolNameSegmentArray);
        } else {
            polySymbol = $this$withMatchedKind;
        }
        return polySymbol;
    }

    @NotNull
    public static final PolySymbolDelegate<PolySymbol> withNavigationTarget(@NotNull PolySymbol $this$withNavigationTarget, @NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)$this$withNavigationTarget, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new PolySymbolDelegate<PolySymbol>($this$withNavigationTarget, target){
            final /* synthetic */ PolySymbol $this_withNavigationTarget;
            final /* synthetic */ PsiElement $target;
            {
                this.$this_withNavigationTarget = $receiver;
                this.$target = $target;
            }

            public PolySymbol getDelegate() {
                return this.$this_withNavigationTarget;
            }

            public Collection<NavigationTarget> getNavigationTargets(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return CollectionsKt.listOf((Object)SymbolNavigationService.getInstance().psiElementNavigationTarget(this.$target));
            }

            public Pointer<? extends PolySymbolDelegate<PolySymbol>> createPointer() {
                Pointer<? extends PolySymbol> symbolPtr = this.getDelegate().createPointer();
                SmartPsiElementPointer targetPtr = SmartPointersKt.createSmartPointer((PsiElement)this.$target);
                return () -> withNavigationTarget.1.createPointer$lambda$0(targetPtr, symbolPtr);
            }

            private static final PolySymbolDelegate createPointer$lambda$0(SmartPsiElementPointer $targetPtr, Pointer $symbolPtr) {
                PolySymbolDelegate<PolySymbol> polySymbolDelegate;
                PsiElement psiElement = $targetPtr.dereference();
                if (psiElement != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    PolySymbol polySymbol = (PolySymbol)$symbolPtr.dereference();
                    polySymbolDelegate = polySymbol != null ? PolySymbolUtils.withNavigationTarget(polySymbol, it) : null;
                } else {
                    polySymbolDelegate = null;
                }
                return polySymbolDelegate;
            }
        };
    }

    @NotNull
    public static final Sequence<PolySymbol> unwrapMatchedSymbols(@NotNull PolySymbol $this$unwrapMatchedSymbols) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrapMatchedSymbols, (String)"<this>");
        return $this$unwrapMatchedSymbols instanceof PolySymbolMatch ? (Sequence)new Sequence<PolySymbol>($this$unwrapMatchedSymbols){
            final /* synthetic */ PolySymbol $this_unwrapMatchedSymbols$inlined;
            {
                this.$this_unwrapMatchedSymbols$inlined = polySymbol;
            }

            public Iterator<PolySymbol> iterator() {
                boolean bl = false;
                return new Iterator<PolySymbol>(this.$this_unwrapMatchedSymbols$inlined){
                    private PolySymbol next;
                    private final LinkedList<PolySymbol> fifo;
                    {
                        this.fifo = new LinkedList<E>();
                        this.fifo.addLast($receiver);
                        this.advance();
                    }

                    public final LinkedList<PolySymbol> getFifo() {
                        return this.fifo;
                    }

                    private final void advance() {
                        while (!((Collection)this.fifo).isEmpty()) {
                            PolySymbol symbol;
                            Intrinsics.checkNotNullExpressionValue((Object)this.fifo.removeFirst(), (String)"removeFirst(...)");
                            if (symbol instanceof PolySymbolMatch) {
                                Iterable $this$forEach$iv = ((PolySymbolMatch)symbol).getNameSegments();
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    PolySymbolNameSegment it = (PolySymbolNameSegment)element$iv;
                                    boolean bl = false;
                                    this.fifo.addAll((Collection<PolySymbol>)it.getSymbols());
                                }
                                continue;
                            }
                            this.next = symbol;
                            return;
                        }
                        this.next = null;
                    }

                    public boolean hasNext() {
                        return this.next != null;
                    }

                    public PolySymbol next() {
                        PolySymbol polySymbol;
                        PolySymbol polySymbol2 = this.next;
                        Intrinsics.checkNotNull((Object)polySymbol2);
                        PolySymbol it = polySymbol = polySymbol2;
                        boolean bl = false;
                        this.advance();
                        return polySymbol;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        } : SequencesKt.sequenceOf((Object)$this$unwrapMatchedSymbols);
    }

    @NotNull
    public static final PolySymbolNameSegment withSymbols(@NotNull PolySymbolNameSegment $this$withSymbols, @NotNull List<? extends PolySymbol> symbols) {
        Intrinsics.checkNotNullParameter((Object)$this$withSymbols, (String)"<this>");
        Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
        return ((PolySymbolNameSegmentImpl)$this$withSymbols).withSymbols$intellij_platform_polySymbols(symbols);
    }

    @NotNull
    public static final PolySymbolMatch withSegments(@NotNull PolySymbolMatch $this$withSegments, @NotNull List<? extends PolySymbolNameSegment> segments) {
        Intrinsics.checkNotNullParameter((Object)$this$withSegments, (String)"<this>");
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        return ((PolySymbolMatchBase)$this$withSegments).withSegments$intellij_platform_polySymbols(segments);
    }

    @NotNull
    public static final List<PolySymbol> match(@NotNull PolySymbol $this$match, @NotNull String nameToMatch, @NotNull PolySymbolNameMatchQueryParams params, @NotNull PolySymbolQueryStack stack) {
        PolySymbolPattern polySymbolPattern;
        PolySymbolWithPattern polySymbolWithPattern;
        Intrinsics.checkNotNullParameter((Object)$this$match, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)nameToMatch, (String)"nameToMatch");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        PolySymbolWithPattern polySymbolWithPattern2 = polySymbolWithPattern = $this$match instanceof PolySymbolWithPattern ? (PolySymbolWithPattern)$this$match : null;
        if (polySymbolWithPattern != null && (polySymbolPattern = polySymbolWithPattern.getPattern()) != null) {
            PolySymbolPattern pattern = polySymbolPattern;
            boolean bl = false;
            return (List)stack.withSymbols($this$match.getQueryScope(), () -> PolySymbolUtils.match$lambda$0$0(pattern, $this$match, stack, nameToMatch, params));
        }
        return PolySymbolUtils.nameMatches($this$match, nameToMatch, params.getQueryExecutor()) ? CollectionsKt.listOf((Object)PolySymbolUtils.withMatchedName($this$match, nameToMatch)) : CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PolySymbolCodeCompletionItem> toCodeCompletionItems(@NotNull PolySymbol $this$toCodeCompletionItems, @NotNull String name, @NotNull PolySymbolCodeCompletionQueryParams params, @NotNull PolySymbolQueryStack stack) {
        Object object;
        block4: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$toCodeCompletionItems, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                object = $this$toCodeCompletionItems instanceof PolySymbolWithPattern ? (PolySymbolWithPattern)$this$toCodeCompletionItems : null;
                if (object == null || (object = object.getPattern()) == null) break block3;
                Object pattern = object;
                boolean bl = false;
                List list2 = (List)stack.withSymbols($this$toCodeCompletionItems.getQueryScope(), () -> PolySymbolUtils.toCodeCompletionItems$lambda$0$0((PolySymbolPattern)pattern, $this$toCodeCompletionItems, stack, name, params));
                object = list2;
                if (list2 != null) break block4;
            }
            Iterable iterable = params.getQueryExecutor().getNamesProvider().getNames(PolySymbolUtils.getQualifiedName($this$toCodeCompletionItems), PolySymbolNamesProvider.Target.CODE_COMPLETION_VARIANTS);
            boolean $i$f$map = false;
            void bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(PolySymbolCodeCompletionItem.Companion.create$default(PolySymbolCodeCompletionItem.Companion, (String)it, 0, $this$toCodeCompletionItems, null, 8, null));
            }
            object = (List)destination$iv$iv;
        }
        return object;
    }

    public static final boolean nameMatches(@NotNull PolySymbol $this$nameMatches, @NotNull String name, @NotNull PolySymbolQueryExecutor queryExecutor) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$nameMatches, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
            List<String> queryNames = queryExecutor.getNamesProvider().getNames($this$nameMatches.getKind().withName(name), PolySymbolNamesProvider.Target.NAMES_QUERY);
            Set symbolNames = CollectionsKt.toSet((Iterable)queryExecutor.getNamesProvider().getNames(PolySymbolUtils.getQualifiedName($this$nameMatches), PolySymbolNamesProvider.Target.NAMES_MAP_STORAGE));
            Iterable $this$any$iv = queryNames;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!symbolNames.contains(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final PolySymbolQualifiedName getQualifiedName(@NotNull PolySymbol $this$qualifiedName) {
        Intrinsics.checkNotNullParameter((Object)$this$qualifiedName, (String)"<this>");
        return $this$qualifiedName.getKind().withName($this$qualifiedName.getName());
    }

    @NotNull
    public static final String getNamespace(@NotNull PolySymbol $this$namespace) {
        Intrinsics.checkNotNullParameter((Object)$this$namespace, (String)"<this>");
        return $this$namespace.getKind().getNamespace();
    }

    @NotNull
    public static final String getKindName(@NotNull PolySymbol $this$kindName) {
        Intrinsics.checkNotNullParameter((Object)$this$kindName, (String)"<this>");
        return $this$kindName.getKind().getKindName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getCompleteMatch(@NotNull PolySymbol $this$completeMatch) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$completeMatch, (String)"<this>");
        if (!($this$completeMatch instanceof PolySymbolMatch)) return true;
        Iterable $this$all$iv = ((PolySymbolMatch)$this$completeMatch).getNameSegments();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                boolean bl2;
                PolySymbolNameSegment segment = (PolySymbolNameSegment)element$iv;
                boolean bl3 = false;
                if (segment.getProblem() != null) return false;
                Iterable $this$all$iv2 = segment.getSymbols();
                boolean $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv2) {
                        PolySymbol it = (PolySymbol)element$iv2;
                        boolean bl4 = false;
                        if (PolySymbolUtils.getCompleteMatch(it)) continue;
                        return false;
                    }
                    bl2 = true;
                }
                if (!bl2) return false;
                boolean bl5 = true;
                if (bl5) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        PolySymbolNameSegment polySymbolNameSegment = (PolySymbolNameSegment)CollectionsKt.lastOrNull(((PolySymbolMatch)$this$completeMatch).getNameSegments());
        if ((polySymbolNameSegment != null ? polySymbolNameSegment.getEnd() : 0) != PolySymbolUtils.getMatchedNameOrName($this$completeMatch).length()) return false;
        return true;
    }

    @NotNull
    public static final List<PolySymbolNameSegment> getNameSegments(@NotNull PolySymbol $this$nameSegments) {
        Intrinsics.checkNotNullParameter((Object)$this$nameSegments, (String)"<this>");
        Object object = $this$nameSegments instanceof CompositePolySymbol ? (CompositePolySymbol)$this$nameSegments : null;
        if (object == null || (object = object.getNameSegments()) == null) {
            Object object2 = $this$nameSegments instanceof PolySymbolWithPattern ? (PolySymbolWithPattern)$this$nameSegments : null;
            if (object2 != null && (object2 = object2.getPattern()) != null) {
                Object it = object2;
                boolean bl = false;
                object = CollectionsKt.listOf((Object)PolySymbolNameSegment.Companion.create(0, 0, $this$nameSegments));
            } else {
                object = CollectionsKt.listOf((Object)PolySymbolNameSegment.Companion.create($this$nameSegments));
            }
        }
        return object;
    }

    @NotNull
    public static final Sequence<PolySymbolNameSegment> getNameSegmentsWithProblems(@NotNull PolySymbol $this$nameSegmentsWithProblems) {
        Intrinsics.checkNotNullParameter((Object)$this$nameSegmentsWithProblems, (String)"<this>");
        return (Sequence)new Sequence<PolySymbolNameSegment>($this$nameSegmentsWithProblems){
            final /* synthetic */ PolySymbol $this_nameSegmentsWithProblems$inlined;
            {
                this.$this_nameSegmentsWithProblems$inlined = polySymbol;
            }

            public Iterator<PolySymbolNameSegment> iterator() {
                boolean bl = false;
                return new Iterator<PolySymbolNameSegment>(this.$this_nameSegmentsWithProblems$inlined){
                    private PolySymbolNameSegment next;
                    private final LinkedList<PolySymbolNameSegment> fifo;
                    private final Set<PolySymbol> visitedSymbols;
                    {
                        this.fifo = new LinkedList<E>();
                        this.visitedSymbols = new LinkedHashSet<E>();
                        this.addNameSegmentsToQueue($receiver);
                        this.advance();
                    }

                    public final LinkedList<PolySymbolNameSegment> getFifo() {
                        return this.fifo;
                    }

                    public final Set<PolySymbol> getVisitedSymbols() {
                        return this.visitedSymbols;
                    }

                    private final void addNameSegmentsToQueue(PolySymbol symbol) {
                        if (symbol instanceof CompositePolySymbol && this.visitedSymbols.add(symbol)) {
                            this.fifo.addAll((Collection<PolySymbolNameSegment>)((CompositePolySymbol)symbol).getNameSegments());
                        }
                    }

                    private final void advance() {
                        while (!((Collection)this.fifo).isEmpty()) {
                            PolySymbolNameSegment segment;
                            Intrinsics.checkNotNullExpressionValue((Object)this.fifo.removeFirst(), (String)"removeFirst(...)");
                            Iterable $this$forEach$iv = segment.getSymbols();
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                PolySymbol it = (PolySymbol)element$iv;
                                boolean bl = false;
                                this.addNameSegmentsToQueue(it);
                            }
                            if (segment.getProblem() == null) continue;
                            this.next = segment;
                            return;
                        }
                        this.next = null;
                    }

                    public boolean hasNext() {
                        return this.next != null;
                    }

                    public PolySymbolNameSegment next() {
                        PolySymbolNameSegment polySymbolNameSegment;
                        PolySymbolNameSegment polySymbolNameSegment2 = this.next;
                        Intrinsics.checkNotNull((Object)polySymbolNameSegment2);
                        PolySymbolNameSegment it = polySymbolNameSegment = polySymbolNameSegment2;
                        boolean bl = false;
                        this.advance();
                        return polySymbolNameSegment;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    @NotNull
    public static final String getMatchedNameOrName(@NotNull PolySymbol $this$matchedNameOrName) {
        Intrinsics.checkNotNullParameter((Object)$this$matchedNameOrName, (String)"<this>");
        Object object = $this$matchedNameOrName instanceof PolySymbolMatch ? (PolySymbolMatch)$this$matchedNameOrName : null;
        if (object == null || (object = object.getMatchedName()) == null) {
            object = $this$matchedNameOrName.getName();
        }
        return object;
    }

    public static final boolean getHideFromCompletion(@NotNull PolySymbol $this$hideFromCompletion) {
        Intrinsics.checkNotNullParameter((Object)$this$hideFromCompletion, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$hideFromCompletion.get(PolySymbol.PROP_HIDE_FROM_COMPLETION), (Object)true);
    }

    public static final boolean isCritical(@Nullable PolySymbolNameSegment.MatchProblem $this$isCritical) {
        return $this$isCritical == PolySymbolNameSegment.MatchProblem.MISSING_REQUIRED_PART || $this$isCritical == PolySymbolNameSegment.MatchProblem.UNKNOWN_SYMBOL;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PolySymbolNameSegment> withOffset(@NotNull List<? extends PolySymbolNameSegment> $this$withOffset, int offset) {
        List list2;
        Intrinsics.checkNotNullParameter($this$withOffset, (String)"<this>");
        if (offset != 0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$withOffset;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PolySymbolNameSegment polySymbolNameSegment = (PolySymbolNameSegment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(PolySymbolsImplUtilsKt.withOffset((PolySymbolNameSegment)it, offset));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = $this$withOffset;
        }
        return list2;
    }

    @NotNull
    public static final PolySymbolApiStatus coalesceWith(@Nullable PolySymbolApiStatus $this$coalesceWith, @Nullable PolySymbolApiStatus other) {
        PolySymbolApiStatus polySymbolApiStatus;
        PolySymbolApiStatus polySymbolApiStatus2 = $this$coalesceWith;
        if (polySymbolApiStatus2 == null) {
            polySymbolApiStatus = other;
            if (polySymbolApiStatus == null) {
                polySymbolApiStatus = PolySymbolApiStatus.Stable;
            }
        } else if (polySymbolApiStatus2 instanceof PolySymbolApiStatus.Obsolete) {
            polySymbolApiStatus = $this$coalesceWith;
        } else if (polySymbolApiStatus2 instanceof PolySymbolApiStatus.Deprecated) {
            polySymbolApiStatus = other instanceof PolySymbolApiStatus.Obsolete ? other : $this$coalesceWith;
        } else if (polySymbolApiStatus2 instanceof PolySymbolApiStatus.Experimental) {
            PolySymbolApiStatus polySymbolApiStatus3 = other;
            polySymbolApiStatus = polySymbolApiStatus3 instanceof PolySymbolApiStatus.Obsolete || polySymbolApiStatus3 instanceof PolySymbolApiStatus.Deprecated ? other : $this$coalesceWith;
        } else if (polySymbolApiStatus2 instanceof PolySymbolApiStatus.Stable) {
            PolySymbolApiStatus polySymbolApiStatus4 = other;
            polySymbolApiStatus = polySymbolApiStatus4 instanceof PolySymbolApiStatus.Obsolete || polySymbolApiStatus4 instanceof PolySymbolApiStatus.Deprecated || polySymbolApiStatus4 instanceof PolySymbolApiStatus.Experimental ? other : $this$coalesceWith;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return polySymbolApiStatus;
    }

    @NotNull
    public static final <T> PolySymbolApiStatus coalesceApiStatus(@Nullable Iterable<? extends T> collection, @NotNull Function1<? super T, ? extends PolySymbolApiStatus> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        Iterable<? extends T> iterable = collection;
        return PolySymbolUtils.coalesceApiStatus(iterable != null ? CollectionsKt.asSequence(iterable) : null, mapper);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> PolySymbolApiStatus coalesceApiStatus(@Nullable Sequence<? extends T> sequence, @NotNull Function1<? super T, ? extends PolySymbolApiStatus> mapper) {
        Object object;
        block7: {
            block6: {
                Object v1;
                Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
                object = sequence;
                if (object == null || (object = SequencesKt.map(object, mapper)) == null) break block6;
                Object $this$reduceOrNull$iv = object;
                boolean $i$f$reduceOrNull = false;
                Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v1 = null;
                } else {
                    Object accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        void b;
                        PolySymbolApiStatus polySymbolApiStatus = (PolySymbolApiStatus)iterator$iv.next();
                        PolySymbolApiStatus a = (PolySymbolApiStatus)accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = PolySymbolUtils.coalesceWith(a, (PolySymbolApiStatus)b);
                    }
                    v1 = accumulator$iv;
                }
                if ((object = (PolySymbolApiStatus)v1) != null) break block7;
            }
            object = PolySymbolApiStatus.Stable;
        }
        return object;
    }

    @Nullable
    public static final PolySymbolHtmlAttributeValue merge(@NotNull Sequence<? extends PolySymbolHtmlAttributeValue> $this$merge) {
        Intrinsics.checkNotNullParameter($this$merge, (String)"<this>");
        PolySymbolHtmlAttributeValue.Kind kind = null;
        PolySymbolHtmlAttributeValue.Type type = null;
        Boolean required = null;
        String string = null;
        Object langType = null;
        for (PolySymbolHtmlAttributeValue value : $this$merge) {
            if (value == null) continue;
            if (kind == null || kind == PolySymbolHtmlAttributeValue.Kind.PLAIN) {
                kind = value.getKind();
            }
            if (type == null) {
                type = value.getType();
            }
            if (required == null) {
                required = value.isRequired();
            }
            if (string == null) {
                string = value.getDefault();
            }
            if (langType != null) continue;
            langType = value.getLangType();
        }
        return kind != null || type != null || required != null || langType != null || string != null ? PolySymbolHtmlAttributeValue.Companion.create(kind, type, required, string, langType) : null;
    }

    @NotNull
    public static final Navigatable createPsiRangeNavigationItem(@NotNull NavigationTarget $this$createPsiRangeNavigationItem, @NotNull PsiElement element, int offsetWithinElement) {
        Intrinsics.checkNotNullParameter((Object)$this$createPsiRangeNavigationItem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            Navigatable navigatable2 = EmptyNavigatable.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)navigatable2, (String)"INSTANCE");
            return navigatable2;
        }
        VirtualFile vf = virtualFile;
        TargetPresentation targetPresentation = $this$createPsiRangeNavigationItem.computePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"computePresentation(...)");
        TargetPresentation targetPresentation2 = targetPresentation;
        OpenFileDescriptor descriptor = new OpenFileDescriptor(element.getProject(), vf, element.getTextRange().getStartOffset() + offsetWithinElement);
        return (Navigatable)new NavigationItem(descriptor, targetPresentation2){
            final /* synthetic */ OpenFileDescriptor $descriptor;
            final /* synthetic */ TargetPresentation $targetPresentation;
            {
                this.$descriptor = $descriptor;
                this.$targetPresentation = $targetPresentation;
            }

            public void navigate(boolean requestFocus) {
                this.$descriptor.navigate(requestFocus);
            }

            public boolean canNavigate() {
                return this.$descriptor.canNavigate();
            }

            public boolean canNavigateToSource() {
                return this.$descriptor.canNavigateToSource();
            }

            public String getName() {
                return this.$targetPresentation.getPresentableText();
            }

            public ItemPresentation getPresentation() {
                return this;
            }

            public String getPresentableText() {
                return this.$targetPresentation.getPresentableText();
            }

            public Icon getIcon(boolean unused) {
                return this.$targetPresentation.getIcon();
            }

            public String getLocationString() {
                String string;
                String container = this.$targetPresentation.getContainerText();
                String location = this.$targetPresentation.getLocationText();
                if (container != null || location != null) {
                    Object[] objectArray = new String[]{container, location};
                    string = SequencesKt.joinToString$default((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null);
                } else {
                    string = null;
                }
                return string;
            }

            public String toString() {
                return this.$descriptor.getFile().getName() + " [" + this.$descriptor.getOffset() + "]";
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PolySymbolCodeCompletionItem> getDefaultCodeCompletions(@NotNull PolySymbolScope $this$getDefaultCodeCompletions, @NotNull PolySymbolQualifiedName qualifiedName, @NotNull PolySymbolCodeCompletionQueryParams params, @NotNull PolySymbolQueryStack stack) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getDefaultCodeCompletions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Iterable iterable = $this$getDefaultCodeCompletions.getSymbols(qualifiedName.getKind(), PolySymbolListSymbolsQueryParams.Companion.create(params.getQueryExecutor(), false, (Function1<? super PolySymbolListSymbolsQueryParams.Builder, Unit>)((Function1)arg_0 -> PolySymbolUtils.getDefaultCodeCompletions$lambda$0(params, arg_0))), stack);
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PolySymbol it = (PolySymbol)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = PolySymbolUtils.toCodeCompletionItems(it, qualifiedName.getName(), params, stack);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @ApiStatus.Internal
    @NotNull
    public static final ModificationTracker createModificationTracker(@NotNull List<? extends Pointer<? extends ModificationTracker>> trackersPointers) {
        Intrinsics.checkNotNullParameter(trackersPointers, (String)"trackersPointers");
        return () -> PolySymbolUtils.createModificationTracker$lambda$0(trackersPointers);
    }

    @ApiStatus.Internal
    public static final boolean acceptSymbolForPsiSourcedPolySymbolRenameHandler(@NotNull Symbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        return symbol instanceof PsiSourcedPolySymbol && ((PsiSourcedPolySymbol)symbol).getSource() instanceof PsiNamedElement && !(((PsiSourcedPolySymbol)symbol).getSource() instanceof SyntheticElement);
    }

    /*
     * WARNING - void declaration
     */
    private static final List match$lambda$0$0(PolySymbolPattern $pattern, PolySymbol $this_match, PolySymbolQueryStack $stack, String $nameToMatch, PolySymbolNameMatchQueryParams $params) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = $pattern.match$intellij_platform_polySymbols($this_match, $stack, $nameToMatch, $params);
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PolySymbolMatch it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MatchResult matchResult = (MatchResult)element$iv$iv;
            boolean bl2 = false;
            PolySymbolNameSegment polySymbolNameSegment = (PolySymbolNameSegment)CollectionsKt.lastOrNull(matchResult.getSegments());
            if (((polySymbolNameSegment != null ? polySymbolNameSegment.getEnd() : 0) < $nameToMatch.length() ? null : PolySymbolMatch.Companion.create$default(PolySymbolMatch.Companion, $nameToMatch, matchResult.getSegments(), $this_match.getKind(), null, 8, null)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List toCodeCompletionItems$lambda$0$0(PolySymbolPattern $pattern, PolySymbol $this_toCodeCompletionItems, PolySymbolQueryStack $stack, String $name, PolySymbolCodeCompletionQueryParams $params) {
        return PatternImplUtilsKt.applyIcons($pattern.complete$intellij_platform_polySymbols($this_toCodeCompletionItems, $stack, $name, $params), $this_toCodeCompletionItems);
    }

    private static final Unit getDefaultCodeCompletions$lambda$0(PolySymbolCodeCompletionQueryParams $params, PolySymbolListSymbolsQueryParams.Builder $this$create) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        $this$create.copyFiltersFrom($params);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final long createModificationTracker$lambda$0(List $trackersPointers) {
        long modCount = 0L;
        for (Pointer tracker : $trackersPointers) {
            void it;
            long l;
            ModificationTracker modificationTracker = (ModificationTracker)tracker.dereference();
            if (modificationTracker == null) {
                return -1L;
            }
            long l2 = l = modificationTracker.getModificationCount();
            long l3 = modCount;
            boolean bl = false;
            if (it < 0L) {
                return -1L;
            }
            Unit unit = Unit.INSTANCE;
            modCount = l3 + l;
        }
        return modCount;
    }
}

