/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split.debugger;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorMouseHoverPopupControl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientRunConfigurationsHost;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientDebugProcess;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientDebuggerHost;
import com.intellij.platform.frontend.split.FrontendProcessInfo;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.evaluate.ValueLookupManagerController;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.jetbrains.codeWithMe.model.DebuggerModel;
import com.jetbrains.codeWithMe.model.DebuggerModel_GeneratedKt;
import com.jetbrains.codeWithMe.model.DebuggerSessionModel;
import com.jetbrains.codeWithMe.model.LightSuspendContextModel;
import com.jetbrains.codeWithMe.model.SessionTabInfo;
import com.jetbrains.ide.model.uiautomation.BeTab;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.codeWithMe.debugger.CommonDebuggerHost;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.thinclient.toolWindow.FrontendGenericToolWindowFactoryKt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0002*+B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010&\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010'\u001a\u00020\fJ\u000e\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\n\u001a2\u0012\u000e\u0012\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000e \u0010*\u0017\u0012\u000e\u0012\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000e0\u000f\u00a2\u0006\u0002\b\r0\u000b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006,"}, d2={"Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientDebuggerHost;", "Lcom/jetbrains/rd/platform/codeWithMe/debugger/CommonDebuggerHost;", "Lcom/intellij/openapi/Disposable;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "lastCommandId", "Ljava/util/concurrent/atomic/AtomicInteger;", "Lcom/jetbrains/rd/util/AtomicInteger;", "pendingCommandIds", "", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "debuggerModel", "Lcom/jetbrains/codeWithMe/model/DebuggerModel;", "getDebuggerModel", "()Lcom/jetbrains/codeWithMe/model/DebuggerModel;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "bindModel", "", "adviseWithLuxDebugger", "startSessionAndHandle", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "sessionModel", "Lcom/jetbrains/codeWithMe/model/DebuggerSessionModel;", "startSessionWithEnvironment", "Lcom/intellij/xdebugger/XDebugSession;", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "startSessionWithoutEnvironment", "handleSessionModel", "getNextStartCommandId", "markCommandIdCompleted", "commandId", "ProtocolListener", "Companion", "intellij.platform.execution.frontend.split"})
@SourceDebugExtension(value={"SMAP\nThinClientDebuggerHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientDebuggerHost.kt\ncom/intellij/platform/execution/frontend/split/debugger/ThinClientDebuggerHost\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,209:1\n1#2:210\n13#3:211\n*S KotlinDebug\n*F\n+ 1 ThinClientDebuggerHost.kt\ncom/intellij/platform/execution/frontend/split/debugger/ThinClientDebuggerHost\n*L\n198#1:211\n*E\n"})
public final class ThinClientDebuggerHost
extends CommonDebuggerHost
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final AtomicInteger lastCommandId;
    @NotNull
    private final Set<Integer> pendingCommandIds;
    @NotNull
    private static final Logger logger;

    public ThinClientDebuggerHost(@NotNull ClientProjectSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.lastCommandId = new AtomicInteger(0);
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.pendingCommandIds = set;
    }

    @NotNull
    public DebuggerModel getDebuggerModel() {
        return DebuggerModel_GeneratedKt.getDebuggerModel((Solution)FrontendSessionsUtilKt.getProtocolModel((ClientProjectSession)this.session));
    }

    private final Project getProject() {
        return this.session.getProject();
    }

    private final void bindModel() {
        if (Companion.useLuxDebugger()) {
            this.adviseWithLuxDebugger(this.getProject());
            return;
        }
        ToolWindowManager.Companion.getInstance(this.getProject()).invokeLater(() -> ThinClientDebuggerHost.bindModel$lambda$0(this));
    }

    private final void adviseWithLuxDebugger(Project project) {
        ValueLookupManagerController.Companion.getInstance(project).startListening();
        SourceExKt.adviseNotNull((ISource)((ISource)this.getDebuggerModel().getLightSuspendContext()), (Lifetime)this.getServiceLifetime(), arg_0 -> ThinClientDebuggerHost.adviseWithLuxDebugger$lambda$0(project, arg_0));
        this.getDebuggerModel().isMouseHoverPopupsEnabled().getChange().advise(this.getServiceLifetime(), arg_0 -> ThinClientDebuggerHost.adviseWithLuxDebugger$lambda$1(project, arg_0));
    }

    private final void startSessionAndHandle(Lifetime sessionLifetime, DebuggerSessionModel sessionModel) {
        Object v0;
        block1: {
            ThinClientRunConfigurationsHost runConfigHost = ThinClientRunConfigurationsHost.Companion.getInstance(this.getProject());
            RunManagerImpl runManager = RunManagerImpl.Companion.getInstanceImpl(this.getProject());
            Iterable iterable = runManager.getAllSettings();
            for (Object t : iterable) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)runConfigHost.getRemoteUniqueId(it), (Object)sessionModel.getUniqueID())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        RunnerAndConfigurationSettings settings = v0;
        XDebugSession session = settings == null ? this.startSessionWithoutEnvironment(sessionLifetime, sessionModel) : this.startSessionWithEnvironment(sessionLifetime, sessionModel, settings);
        this.handleSessionModel(session, sessionModel);
    }

    private final XDebugSession startSessionWithEnvironment(Lifetime sessionLifetime, DebuggerSessionModel sessionModel, RunnerAndConfigurationSettings settings) {
        ExecutionEnvironmentBuilder executionEnvironmentBuilder;
        XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)this.getProject());
        Executor executor = DefaultDebugExecutor.getDebugExecutorInstance();
        RunConfiguration runConfiguration = settings.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
        RunConfiguration configuration = runConfiguration;
        Project project = this.getProject();
        Intrinsics.checkNotNull((Object)executor);
        ExecutionEnvironmentBuilder $this$startSessionWithEnvironment_u24lambda_u240 = executionEnvironmentBuilder = new ExecutionEnvironmentBuilder(project, executor);
        boolean bl = false;
        ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)((RunProfile)configuration));
        if (runner != null) {
            $this$startSessionWithEnvironment_u24lambda_u240.runnerAndSettings(runner, settings);
        }
        ExecutionEnvironment effectiveEnvironment = ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)executionEnvironmentBuilder.runProfile((RunProfile)configuration), null, (int)1, null);
        XDebugProcessStarter starter2 = new XDebugProcessStarter(sessionLifetime, sessionModel){
            final /* synthetic */ Lifetime $sessionLifetime;
            final /* synthetic */ DebuggerSessionModel $sessionModel;
            {
                this.$sessionLifetime = $sessionLifetime;
                this.$sessionModel = $sessionModel;
            }

            public XDebugProcess start(XDebugSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                this.$sessionLifetime.onTerminationIfAlive(() -> startSessionWithEnvironment.starter.1.start$lambda$0(session));
                return (XDebugProcess)new ThinClientDebugProcess(session, this.$sessionLifetime, this.$sessionModel);
            }

            private static final Unit start$lambda$0(XDebugSession $session) {
                $session.stop();
                return Unit.INSTANCE;
            }
        };
        XDebugSession session = debuggerManager.newSessionBuilder(starter2).environment(effectiveEnvironment).startSession().getSession();
        Intrinsics.checkNotNull((Object)session, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
        ((XDebugSessionImpl)session).showSessionTab();
        ((XDebugSessionImpl)session).getDebugProcess().getProcessHandler().startNotify();
        return session;
    }

    private final XDebugSession startSessionWithoutEnvironment(Lifetime sessionLifetime, DebuggerSessionModel sessionModel) {
        XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)this.getProject());
        XDebugProcessStarter starter2 = new XDebugProcessStarter(sessionLifetime, sessionModel){
            final /* synthetic */ Lifetime $sessionLifetime;
            final /* synthetic */ DebuggerSessionModel $sessionModel;
            {
                this.$sessionLifetime = $sessionLifetime;
                this.$sessionModel = $sessionModel;
            }

            public XDebugProcess start(XDebugSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                this.$sessionLifetime.onTerminationIfAlive(() -> startSessionWithoutEnvironment.starter.1.start$lambda$0(session));
                return (XDebugProcess)new ThinClientDebugProcess(session, this.$sessionLifetime, this.$sessionModel);
            }

            private static final Unit start$lambda$0(XDebugSession $session) {
                $session.stop();
                return Unit.INSTANCE;
            }
        };
        IconModel iconModel = sessionModel.getSessionIcon();
        return debuggerManager.newSessionBuilder(starter2).sessionName(sessionModel.getSessionName()).icon(iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null).showTab(true).startSession().getSession();
    }

    public final void handleSessionModel(@NotNull XDebugSession session, @NotNull DebuggerSessionModel sessionModel) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        XDebugProcess xDebugProcess = session.getDebugProcess();
        Intrinsics.checkNotNull((Object)xDebugProcess, (String)"null cannot be cast to non-null type com.intellij.platform.execution.frontend.split.debugger.ThinClientDebugProcess");
        RunnerLayoutUi sessionTabUi = ((ThinClientDebugProcess)xDebugProcess).getSessionTabUi();
        if (sessionTabUi != null) {
            sessionTabUi.addListener(new ContentManagerListener(sessionModel){
                final /* synthetic */ DebuggerSessionModel $sessionModel;
                {
                    this.$sessionModel = $sessionModel;
                }

                public void selectionChanged(ContentManagerEvent event) {
                    Object v2;
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        if (!event.getContent().isSelected()) {
                            return;
                        }
                        Iterable $this$firstOrNull$iv = (Iterable)this.$sessionModel.getAdditionalSessionTabs().getTabs();
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            SessionTabInfo it = (SessionTabInfo)element$iv;
                            boolean bl = false;
                            BeTab beTab = it.getBeTab();
                            Content content = event.getContent();
                            Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
                            if (!Intrinsics.areEqual((Object)beTab, (Object)FrontendGenericToolWindowFactoryKt.getBeModel((Content)content))) continue;
                            v2 = element$iv;
                            break block2;
                        }
                        v2 = null;
                    }
                    SessionTabInfo sessionTabInfo = v2;
                    Integer id = sessionTabInfo != null ? Integer.valueOf(sessionTabInfo.getTabId()) : null;
                    this.$sessionModel.getAdditionalSessionTabs().getSelectedTab().set((Object)id);
                }
            }, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.getServiceLifetime(), null, (int)1, null));
            sessionModel.getAdditionalSessionTabs().getTabs().view(this.getServiceLifetime(), (arg_0, arg_1, arg_2) -> ThinClientDebuggerHost.handleSessionModel$lambda$0(sessionTabUi, this, arg_0, arg_1, arg_2));
        } else {
            logger.error("sessionTabUi is null, failed to synchronize additional content");
        }
        this.syncSessionSettingsWithModel(session, sessionModel, false);
    }

    public final int getNextStartCommandId() {
        int commandId = this.lastCommandId.incrementAndGet();
        this.pendingCommandIds.add(commandId);
        return commandId;
    }

    public final void markCommandIdCompleted(int commandId) {
        this.pendingCommandIds.remove(commandId);
    }

    private static final Unit bindModel$lambda$0$0(ThinClientDebuggerHost this$0, Lifetime sessionLifetime, int n, DebuggerSessionModel sessionModel) {
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        if (sessionModel.getStartCommandId() != null && CollectionsKt.contains((Iterable)this$0.pendingCommandIds, (Object)sessionModel.getStartCommandId())) {
            return Unit.INSTANCE;
        }
        this$0.startSessionAndHandle(sessionLifetime, sessionModel);
        return Unit.INSTANCE;
    }

    private static final void bindModel$lambda$0(ThinClientDebuggerHost this$0) {
        this$0.getDebuggerModel().getSessions().view(this$0.getServiceLifetime(), (arg_0, arg_1, arg_2) -> ThinClientDebuggerHost.bindModel$lambda$0$0(this$0, arg_0, arg_1, arg_2));
    }

    private static final Unit adviseWithLuxDebugger$lambda$0(Project $project, LightSuspendContextModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.getOnBreakpoint()) {
            return Unit.INSTANCE;
        }
        if (XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isShowDebuggerOnBreakpoint()) {
            boolean stealFocus = Registry.Companion.is("debugger.mayBringFrameToFrontOnBreakpoint");
            ProjectUtil.focusProjectWindow((Project)$project, (boolean)stealFocus);
        }
        return Unit.INSTANCE;
    }

    private static final Unit adviseWithLuxDebugger$lambda$1(Project $project, boolean it) {
        if (it) {
            EditorMouseHoverPopupControl.enablePopups((Project)$project);
        } else {
            EditorMouseHoverPopupControl.disablePopups((Project)$project);
        }
        return Unit.INSTANCE;
    }

    private static final Unit handleSessionModel$lambda$0$0(ContentManager $contentManager, Content $content) {
        $contentManager.removeContent($content, true);
        return Unit.INSTANCE;
    }

    private static final Unit handleSessionModel$lambda$0(RunnerLayoutUi $sessionTabUi, ThinClientDebuggerHost this$0, Lifetime contentLifetime, int n, SessionTabInfo tabInfo) {
        Intrinsics.checkNotNullParameter((Object)contentLifetime, (String)"contentLifetime");
        Intrinsics.checkNotNullParameter((Object)tabInfo, (String)"tabInfo");
        ContentManager contentManager = $sessionTabUi.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        ContentFactory contentFactory = contentManager2.getFactory();
        Intrinsics.checkNotNullExpressionValue((Object)contentFactory, (String)"getFactory(...)");
        Content content = FrontendGenericToolWindowFactoryKt.createToolWindowContent((ContentFactory)contentFactory, (Project)this$0.getProject(), (BeTab)tabInfo.getBeTab(), (Lifetime)contentLifetime);
        contentManager2.addContent(content);
        contentLifetime.onTermination(() -> ThinClientDebuggerHost.handleSessionModel$lambda$0$0(contentManager2, content));
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ThinClientDebuggerHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ThinClientDebuggerHost.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientDebuggerHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "useLuxDebugger", "", "getInstance", "Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientDebuggerHost;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "intellij.platform.execution.frontend.split"})
    @SourceDebugExtension(value={"SMAP\nThinClientDebuggerHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientDebuggerHost.kt\ncom/intellij/platform/execution/frontend/split/debugger/ThinClientDebuggerHost$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,209:1\n23#2:210\n*S KotlinDebug\n*F\n+ 1 ThinClientDebuggerHost.kt\ncom/intellij/platform/execution/frontend/split/debugger/ThinClientDebuggerHost$Companion\n*L\n207#1:210\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean useLuxDebugger() {
            return FrontendProcessInfo.INSTANCE.isController() && Registry.Companion.is("rdct.lux.debugger.toolwindow");
        }

        @Deprecated(message="Use an overload with client project session")
        @NotNull
        public final ThinClientDebuggerHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession((Project)project));
        }

        @NotNull
        public final ThinClientDebuggerHost getInstance(@NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(ThinClientDebuggerHost.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (ThinClientDebuggerHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientDebuggerHost$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/codeWithMe/model/DebuggerModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.platform.execution.frontend.split"})
    public static final class ProtocolListener
    implements SolutionExtListener<DebuggerModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull DebuggerModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Companion.getInstance(session).bindModel();
        }
    }
}

