/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.providers;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.appServers.appServerIntegrations.AppServerDeployedFileUrlProvider;
import com.intellij.javaee.appServers.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.appServers.deployment.DeploymentModel;
import com.intellij.javaee.appServers.ex.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.appServers.run.configuration.CommonModel;
import com.intellij.javaee.appServers.run.execution.J2EEProcess;
import com.intellij.javaee.appServers.serverInstances.J2EEServerInstance;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.deployment.JspDeploymentManager;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.model.xml.ServletMapping;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.jsp.JspLanguage;
import com.intellij.psi.jsp.JspxLanguage;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JspWebBrowserUrlProvider
extends WebBrowserUrlProvider
implements DumbAware {
    JspWebBrowserUrlProvider() {
    }

    @NotNull
    public Collection<Url> getUrls(@NotNull OpenInBrowserRequest request) throws WebBrowserUrlProvider.BrowserException {
        if (request == null) {
            JspWebBrowserUrlProvider.$$$reportNull$$$0(0);
        }
        Project project = request.getProject();
        WebFacet webFacet = WebUtil.getWebFacet((VirtualFile)request.getVirtualFile(), (Project)project);
        if (webFacet == null) {
            throw new WebBrowserUrlProvider.BrowserException(J2EEBundle.message((String)"browser.web.faced.not.configured", (Object[])new Object[0]));
        }
        String relativePath = (String)ReadAction.compute(() -> JspDeploymentManager.getInstance().computeRelativeTargetPath(request.getFile(), webFacet));
        if (relativePath != null) {
            ProcessHandler[] handlers;
            Set<String> urlPatterns = JspWebBrowserUrlProvider.processServletMappingUrlPatterns(relativePath, webFacet);
            for (ProcessHandler handler : handlers = ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
                if (handler.isProcessTerminated() || handler.isProcessTerminating() || !handler.isStartNotified() || !(handler instanceof J2EEProcess)) continue;
                J2EEServerInstance serverInstance = ((J2EEProcess)handler).getServerInstance();
                CommonModel commonModel = serverInstance.getCommonModel();
                DeploymentModel deploymentModel = DeploymentManagerEx.getInstanceEx((Project)project).getModelForFacet(commonModel, (JavaeeFacet)webFacet);
                if (deploymentModel == null) continue;
                AppServerDeployedFileUrlProvider deployedFileUrlProvider = commonModel.getIntegration().getDeployedFileUrlProvider();
                HashSet<Url> urls = new HashSet<Url>();
                for (String urlPattern : urlPatterns) {
                    String url = deployedFileUrlProvider instanceof ApplicationServerUrlMapping ? ((ApplicationServerUrlMapping)deployedFileUrlProvider).getUrlForDeployedFile(serverInstance, deploymentModel, (JavaeeFacet)webFacet, urlPattern) : deployedFileUrlProvider.getUrlForDeployedFile(serverInstance, deploymentModel, urlPattern);
                    if (url == null) continue;
                    ContainerUtil.addIfNotNull(urls, (Object)Urls.parseFromIdea((CharSequence)url));
                }
                HashSet<Url> hashSet = urls;
                if (hashSet == null) {
                    JspWebBrowserUrlProvider.$$$reportNull$$$0(1);
                }
                return hashSet;
            }
        }
        throw new WebBrowserUrlProvider.BrowserException(J2EEBundle.message((String)"browser.no.suitable.configuration.running", (Object[])new Object[0]));
    }

    @NotNull
    private static Set<String> processServletMappingUrlPatterns(@NotNull String path, @NotNull WebFacet facet) {
        List mappings;
        if (path == null) {
            JspWebBrowserUrlProvider.$$$reportNull$$$0(2);
        }
        if (facet == null) {
            JspWebBrowserUrlProvider.$$$reportNull$$$0(3);
        }
        if ((mappings = (List)ReadAction.compute(() -> {
            WebApp root = facet.getRoot();
            return root == null ? Collections.emptyList() : root.getServletMappings();
        })).isEmpty()) {
            Set<String> set = Collections.singleton(path);
            if (set == null) {
                JspWebBrowserUrlProvider.$$$reportNull$$$0(4);
            }
            return set;
        }
        HashSet<String> paths = new HashSet<String>();
        for (ServletMapping servletMapping : mappings) {
            CommonServlet servlet = (CommonServlet)servletMapping.getServletName().getValue();
            if (servlet == null) continue;
            for (GenericDomValue pattern : servletMapping.getUrlPatterns()) {
                String value = (String)pattern.getValue();
                if (value == null) continue;
                ContainerUtil.addIfNotNull(paths, (Object)JspWebBrowserUrlProvider.getPath(path, value.trim()));
            }
        }
        HashSet<String> hashSet = paths;
        if (hashSet == null) {
            JspWebBrowserUrlProvider.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @Nullable
    private static String getPath(@NotNull String filePath, @NotNull String servletMapping) {
        String extension;
        if (filePath == null) {
            JspWebBrowserUrlProvider.$$$reportNull$$$0(6);
        }
        if (servletMapping == null) {
            JspWebBrowserUrlProvider.$$$reportNull$$$0(7);
        }
        if (servletMapping.startsWith("/")) {
            if (servletMapping.endsWith("/*")) {
                return servletMapping.substring(0, servletMapping.lastIndexOf("/*")) + filePath;
            }
            if (servletMapping.endsWith("*") || !servletMapping.contains("*")) {
                // empty if block
            }
        }
        if (servletMapping.startsWith("*.") && StringUtil.isNotEmpty((String)(extension = servletMapping.substring(servletMapping.indexOf("*.") + 2)))) {
            int index = filePath.lastIndexOf(46);
            String nameWithoutExtension = index < 0 ? filePath : filePath.substring(0, index);
            return nameWithoutExtension + "." + extension;
        }
        return null;
    }

    public boolean canHandleElement(@NotNull OpenInBrowserRequest request) {
        Language language;
        if (request == null) {
            JspWebBrowserUrlProvider.$$$reportNull$$$0(8);
        }
        if ((language = request.getFile().getViewProvider().getBaseLanguage()) == PlainTextLanguage.INSTANCE) {
            return false;
        }
        if (language instanceof JspLanguage || language instanceof JspxLanguage) {
            return true;
        }
        if (HtmlUtil.isHtmlFile((PsiElement)request.getFile())) {
            return WebUtil.getWebFacet((VirtualFile)request.getVirtualFile(), (Project)request.getProject()) != null;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/providers/JspWebBrowserUrlProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servletMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/providers/JspWebBrowserUrlProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "processServletMappingUrlPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processServletMappingUrlPatterns";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canHandleElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5 -> new IllegalStateException(string);
        };
    }
}

