/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.fus;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lcom/jetbrains/jsonSchema/fus/JsonSchemaIdValidationRule;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule;", "<init>", "()V", "getRuleId", "", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "AllowListHolder", "intellij.json.backend"})
public final class JsonSchemaIdValidationRule
extends CustomValidationRule {
    @NotNull
    public String getRuleId() {
        return "json_schema_id_rule";
    }

    @NotNull
    protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return AllowListHolder.INSTANCE.getAllowedNames().contains(data) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/jsonSchema/fus/JsonSchemaIdValidationRule$AllowListHolder;", "", "<init>", "()V", "allowedNames", "", "", "getAllowedNames", "()Ljava/util/Set;", "allowedNames$delegate", "Lkotlin/Lazy;", "deserialiseBundledAllowedSchemaIds", "KnownJsonSchemaIdentity", "intellij.json.backend"})
    @SourceDebugExtension(value={"SMAP\nJsonSchemaIdValidationRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSchemaIdValidationRule.kt\ncom/jetbrains/jsonSchema/fus/JsonSchemaIdValidationRule$AllowListHolder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,58:1\n23#2:59\n*S KotlinDebug\n*F\n+ 1 JsonSchemaIdValidationRule.kt\ncom/jetbrains/jsonSchema/fus/JsonSchemaIdValidationRule$AllowListHolder\n*L\n44#1:59\n*E\n"})
    public static final class AllowListHolder {
        @NotNull
        public static final AllowListHolder INSTANCE = new AllowListHolder();
        @NotNull
        private static final Lazy allowedNames$delegate = LazyKt.lazy(AllowListHolder::allowedNames_delegate$lambda$0);

        private AllowListHolder() {
        }

        @NotNull
        public final Set<String> getAllowedNames() {
            Lazy lazy = allowedNames$delegate;
            return (Set)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Set<String> deserialiseBundledAllowedSchemaIds() {
            Object object;
            try {
                Object stream;
                object = JsonSchemaIdValidationRule.class.getResourceAsStream("KnownSchemaIdentifiers.json");
                Throwable throwable = null;
                try {
                    stream = (InputStream)object;
                    boolean bl = false;
                    ObjectMapper objectMapper = new ObjectMapper(JsonFactory.builder().enable(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION).build());
                    stream = (ArrayList)objectMapper.readValue((InputStream)stream, (JavaType)objectMapper.getTypeFactory().constructCollectionType(ArrayList.class, KnownJsonSchemaIdentity.class));
                }
                catch (Throwable bl) {
                    throwable = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = stream;
            }
            catch (IOException exception) {
                AllowListHolder $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(AllowListHolder.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to load bundled allowed schema identifiers", (Throwable)exception);
                return SetsKt.emptySet();
            }
            Object bundledDataStream = object;
            Intrinsics.checkNotNull((Object)bundledDataStream);
            return SequencesKt.toSet((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)bundledDataStream)), AllowListHolder::deserialiseBundledAllowedSchemaIds$lambda$1));
        }

        private static final Set allowedNames_delegate$lambda$0() {
            return INSTANCE.deserialiseBundledAllowedSchemaIds();
        }

        private static final Sequence deserialiseBundledAllowedSchemaIds$lambda$1(KnownJsonSchemaIdentity it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Object[] objectArray = new String[]{it.getUrl(), it.getFileName()};
            return SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray));
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/jsonSchema/fus/JsonSchemaIdValidationRule$AllowListHolder$KnownJsonSchemaIdentity;", "", "url", "", "fileName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "getFileName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.json.backend"})
        public static final class KnownJsonSchemaIdentity {
            @Nullable
            private final String url;
            @Nullable
            private final String fileName;

            public KnownJsonSchemaIdentity(@Nullable String url, @Nullable String fileName) {
                this.url = url;
                this.fileName = fileName;
            }

            public /* synthetic */ KnownJsonSchemaIdentity(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                if ((n & 2) != 0) {
                    string2 = null;
                }
                this(string, string2);
            }

            @Nullable
            public final String getUrl() {
                return this.url;
            }

            @Nullable
            public final String getFileName() {
                return this.fileName;
            }

            @Nullable
            public final String component1() {
                return this.url;
            }

            @Nullable
            public final String component2() {
                return this.fileName;
            }

            @NotNull
            public final KnownJsonSchemaIdentity copy(@Nullable String url, @Nullable String fileName) {
                return new KnownJsonSchemaIdentity(url, fileName);
            }

            public static /* synthetic */ KnownJsonSchemaIdentity copy$default(KnownJsonSchemaIdentity knownJsonSchemaIdentity, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = knownJsonSchemaIdentity.url;
                }
                if ((n & 2) != 0) {
                    string2 = knownJsonSchemaIdentity.fileName;
                }
                return knownJsonSchemaIdentity.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "KnownJsonSchemaIdentity(url=" + this.url + ", fileName=" + this.fileName + ")";
            }

            public int hashCode() {
                int result = this.url == null ? 0 : this.url.hashCode();
                result = result * 31 + (this.fileName == null ? 0 : this.fileName.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof KnownJsonSchemaIdentity)) {
                    return false;
                }
                KnownJsonSchemaIdentity knownJsonSchemaIdentity = (KnownJsonSchemaIdentity)other;
                if (!Intrinsics.areEqual((Object)this.url, (Object)knownJsonSchemaIdentity.url)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.fileName, (Object)knownJsonSchemaIdentity.fileName);
            }

            public KnownJsonSchemaIdentity() {
                this(null, null, 3, null);
            }
        }
    }
}

