/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.modulith.structure.model;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.spring.modulith.SpringModulithUtilsKt;
import com.intellij.spring.modulith.model.ApplicationModule;
import com.intellij.spring.modulith.model.ModulithDependency;
import com.intellij.spring.modulith.model.SpringModulithModelService;
import com.intellij.spring.modulith.structure.model.SpringModulithAllowedDependencyPresentationProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Presentation(provider=SpringModulithAllowedDependencyPresentationProvider.class)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/spring/modulith/structure/model/SpringModulithAllowedDependencyModel;", "Lcom/intellij/psi/PsiTarget;", "dependency", "", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/module/Module;)V", "getDependency", "()Ljava/lang/String;", "getModule", "()Lcom/intellij/openapi/module/Module;", "getNavigationElement", "Lcom/intellij/psi/PsiElement;", "isValid", "", "intellij.spring.modulith"})
public final class SpringModulithAllowedDependencyModel
implements PsiTarget {
    @NotNull
    private final String dependency;
    @NotNull
    private final Module module;

    public SpringModulithAllowedDependencyModel(@NotNull String dependency, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.dependency = dependency;
        this.module = module;
    }

    @NotNull
    public final String getDependency() {
        return this.dependency;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement;
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<ApplicationModule> model = SpringModulithModelService.Companion.getInstance$intellij_spring_modulith(project).getModel$intellij_spring_modulith(this.module);
        ModulithDependency modulithDependency = ModulithDependency.Companion.fromString(this.dependency);
        if (modulithDependency == null) {
            PsiElement psiElement2 = PsiUtilCore.NULL_PSI_ELEMENT;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"NULL_PSI_ELEMENT");
            return psiElement2;
        }
        ModulithDependency parsedDependency = modulithDependency;
        PsiPackage psiPackage = SpringModulithUtilsKt.findDependencyPackage(parsedDependency, model, this.module);
        if (psiPackage != null) {
            psiElement = (PsiElement)psiPackage;
        } else {
            PsiElement psiElement3 = PsiUtilCore.NULL_PSI_ELEMENT;
            psiElement = psiElement3;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"NULL_PSI_ELEMENT");
        }
        return psiElement;
    }

    public boolean isValid() {
        return true;
    }
}

