/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.editor;

import com.intellij.diff.editor.DiffContentVirtualFile;
import com.intellij.diff.editor.DiffEditorTabFilesManager;
import com.intellij.diff.editor.DiffEditorTabFilesManagerImplKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorComposite;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/diff/editor/DiffEditorTabFilesManagerImpl;", "Lcom/intellij/diff/editor/DiffEditorTabFilesManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "showDiffFile", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "diffFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "focusEditor", "", "openInEditor", "(Lcom/intellij/openapi/vfs/VirtualFile;ZZ)[Lcom/intellij/openapi/fileEditor/FileEditor;", "isDiffOpenedInWindow", "file", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nDiffEditorTabFilesManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffEditorTabFilesManagerImpl.kt\ncom/intellij/diff/editor/DiffEditorTabFilesManagerImpl\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n37#2,2:151\n1#3:153\n*S KotlinDebug\n*F\n+ 1 DiffEditorTabFilesManagerImpl.kt\ncom/intellij/diff/editor/DiffEditorTabFilesManagerImpl\n*L\n36#1:151,2\n*E\n"})
public final class DiffEditorTabFilesManagerImpl
implements DiffEditorTabFilesManager {
    @NotNull
    private final Project project;

    public DiffEditorTabFilesManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public FileEditor[] showDiffFile(@NotNull VirtualFile diffFile, boolean focusEditor, boolean openInEditor) {
        Intrinsics.checkNotNullParameter((Object)diffFile, (String)"diffFile");
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
        FileEditorManagerImpl editorManager = (FileEditorManagerImpl)fileEditorManager;
        FileEditorManagerImpl.OpenMode openMode = openInEditor ? FileEditorManagerImpl.OpenMode.DEFAULT : FileEditorManagerImpl.OpenMode.NEW_WINDOW;
        FileEditorComposite newTab = editorManager.openFile(diffFile, null, new FileEditorOpenOptions(false, true, false, focusEditor, false, 0, false, openMode, false, true, false, null, 3445, null));
        Collection $this$toTypedArray$iv = newTab.getAllEditors();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FileEditor[0]);
    }

    @Override
    public boolean isDiffOpenedInWindow(@NotNull VirtualFile file) {
        EditorWindow editorWindow;
        block4: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!(file instanceof DiffContentVirtualFile)) {
                return false;
            }
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.project);
            if (!(editorManager instanceof FileEditorManagerImpl)) {
                return false;
            }
            EditorWindow[] editorWindowArray = ((FileEditorManagerImpl)editorManager).getWindows();
            int n = editorWindowArray.length;
            for (int i = 0; i < n; ++i) {
                EditorWindow editorWindow2;
                EditorWindow it = editorWindow2 = editorWindowArray[i];
                boolean bl = false;
                if (!it.isFileOpen(file)) continue;
                editorWindow = editorWindow2;
                break block4;
            }
            editorWindow = null;
        }
        if (editorWindow == null) {
            return false;
        }
        EditorWindow window = editorWindow;
        return DiffEditorTabFilesManagerImplKt.isSingletonEditorInWindow(window);
    }
}

