/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.merge.ApplySelectedChangesActionBase;
import com.intellij.diff.merge.MergeThreesideViewer;
import com.intellij.diff.merge.TextMergeChange;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0015\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fH\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/diff/merge/ResetResolvedChangeAction;", "Lcom/intellij/diff/merge/ApplySelectedChangesActionBase;", "viewer", "Lcom/intellij/diff/merge/MergeThreesideViewer;", "<init>", "(Lcom/intellij/diff/merge/MergeThreesideViewer;)V", "apply", "", "side", "Lcom/intellij/diff/util/ThreeSide;", "changes", "", "Lcom/intellij/diff/merge/TextMergeChange;", "getSelectedChanges", "getText", "", "Lorg/jetbrains/annotations/Nls;", "isVisible", "", "isEnabled", "change", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nMergeThreesideViewerActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeThreesideViewerActions.kt\ncom/intellij/diff/merge/ResetResolvedChangeAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n777#2:229\n873#2,2:230\n*S KotlinDebug\n*F\n+ 1 MergeThreesideViewerActions.kt\ncom/intellij/diff/merge/ResetResolvedChangeAction\n*L\n153#1:229\n153#1:230,2\n*E\n"})
public final class ResetResolvedChangeAction
extends ApplySelectedChangesActionBase {
    public ResetResolvedChangeAction(@NotNull MergeThreesideViewer viewer) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        super(viewer);
        this.getTemplatePresentation().setIcon(AllIcons.Diff.Revert);
    }

    @Override
    protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        for (TextMergeChange change : changes) {
            this.getViewer().resetResolvedChange(change);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<TextMergeChange> getSelectedChanges(@NotNull ThreeSide side) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        EditorEx editorEx = this.getViewer().getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        EditorEx editor = editorEx;
        BitSet bitSet = DiffUtil.getSelectedLines((Editor)editor);
        Intrinsics.checkNotNullExpressionValue((Object)bitSet, (String)"getSelectedLines(...)");
        BitSet lines = bitSet;
        List<TextMergeChange> list = this.getViewer().getAllChanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllChanges(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextMergeChange change = (TextMergeChange)element$iv$iv;
            boolean bl = false;
            if (!this.isChangeSelected(change, lines, side)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    protected String getText(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        String string = DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    protected boolean isVisible(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return true;
    }

    @Override
    protected boolean isEnabled(@NotNull TextMergeChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        return change.isResolvedWithAI();
    }
}

