/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.comparison.InnerFragmentsPolicy;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.lang.DiffIgnoredRangeProvider;
import com.intellij.diff.lang.DiffLangSpecificProvider;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.SimpleTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProviderBase;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SlowOperations;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SmartTextDiffProvider
extends TwosideTextDiffProviderBase
implements TwosideTextDiffProvider {
    public static final IgnorePolicy[] IGNORE_POLICIES = new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES_CHUNKS, IgnorePolicy.FORMATTING};
    public static final HighlightPolicy[] HIGHLIGHT_POLICIES = new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD, HighlightPolicy.BY_WORD_SPLIT, HighlightPolicy.BY_CHAR, HighlightPolicy.DO_NOT_HIGHLIGHT};
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContent myContent1;
    @NotNull
    private final DiffContent myContent2;
    @Nullable
    private final DiffIgnoredRangeProvider myProvider;
    @Nullable
    private final DiffLangSpecificProvider myDiffProvider;

    @NotNull
    public static TwosideTextDiffProvider create(@Nullable Project project, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        if (request == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(1);
        }
        if (rediff == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(2);
        }
        if (disposable == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(3);
        }
        DiffContent content1 = (DiffContent)Side.LEFT.select(request.getContents());
        DiffContent content2 = (DiffContent)Side.RIGHT.select(request.getContents());
        DiffIgnoredRangeProvider ignoredRangeProvider = SmartTextDiffProvider.getIgnoredRangeProvider(project, content1, content2);
        DiffLangSpecificProvider diffProvider = DiffLangSpecificProvider.findApplicable(content1, content2);
        IgnorePolicy[] ignorePolicies = SmartTextDiffProvider.getIgnorePolicies();
        return new SmartTextDiffProvider(project, content1, content2, settings, rediff, disposable, ignoredRangeProvider, diffProvider, ignorePolicies);
    }

    @NotNull
    public static TwosideTextDiffProvider.NoIgnore createNoIgnore(@Nullable Project project, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        if (request == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(5);
        }
        if (rediff == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(6);
        }
        if (disposable == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(7);
        }
        DiffContent content1 = (DiffContent)Side.LEFT.select(request.getContents());
        DiffContent content2 = (DiffContent)Side.RIGHT.select(request.getContents());
        DiffIgnoredRangeProvider ignoredRangeProvider = SmartTextDiffProvider.getIgnoredRangeProvider(project, content1, content2);
        DiffLangSpecificProvider diffAdjuster = DiffLangSpecificProvider.findApplicable(content1, content2);
        return new NoIgnore(project, content1, content2, settings, rediff, disposable, ignoredRangeProvider, diffAdjuster);
    }

    private static IgnorePolicy @NotNull [] getIgnorePolicies() {
        if (Registry.is((String)"diff.semantic.highlighting", (boolean)false)) {
            IgnorePolicy[] ignorePolicyArray = (IgnorePolicy[])ArrayUtil.append((Object[])IGNORE_POLICIES, (Object)((Object)IgnorePolicy.IGNORE_LANGUAGE_SPECIFIC_CHANGES));
            if (ignorePolicyArray == null) {
                SmartTextDiffProvider.$$$reportNull$$$0(8);
            }
            return ignorePolicyArray;
        }
        if (IGNORE_POLICIES == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(9);
        }
        return IGNORE_POLICIES;
    }

    private SmartTextDiffProvider(@Nullable Project project, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @Nullable DiffIgnoredRangeProvider ignoredRangeProvider, @Nullable DiffLangSpecificProvider diffProvider, IgnorePolicy @NotNull [] ignorePolicies) {
        if (content1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(10);
        }
        if (content2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(11);
        }
        if (settings == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(12);
        }
        if (rediff == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(13);
        }
        if (disposable == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(14);
        }
        if (ignorePolicies == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(15);
        }
        this(project, content1, content2, settings, rediff, disposable, ignoredRangeProvider, diffProvider, ignorePolicies, HIGHLIGHT_POLICIES);
    }

    private SmartTextDiffProvider(@Nullable Project project, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @Nullable DiffIgnoredRangeProvider ignoredRangeProvider, @Nullable DiffLangSpecificProvider diffProvider, IgnorePolicy @NotNull [] ignorePolicies, HighlightPolicy @NotNull [] highlightPolicies) {
        if (content1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(16);
        }
        if (content2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(17);
        }
        if (settings == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(18);
        }
        if (rediff == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(19);
        }
        if (disposable == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(20);
        }
        if (ignorePolicies == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(21);
        }
        if (highlightPolicies == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(22);
        }
        super(settings, rediff, disposable, ignorePolicies, highlightPolicies);
        this.myProject = project;
        this.myContent1 = content1;
        this.myContent2 = content2;
        this.myProvider = ignoredRangeProvider;
        this.myDiffProvider = diffProvider;
    }

    @Override
    @Nullable
    protected String getText(@NotNull IgnorePolicy option) {
        if (option == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(23);
        }
        if (this.isFormattingPolicyApplicable(option)) {
            return Objects.requireNonNull(this.myProvider).getDescription();
        }
        if (this.isLanguageSpecificPolicyApplicable(option)) {
            return Objects.requireNonNull(this.myDiffProvider).getDescription();
        }
        return null;
    }

    @Override
    @NotNull
    protected List<List<LineFragment>> doCompare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @Nullable List<? extends Range> linesRanges, @NotNull IgnorePolicy ignorePolicy2, @NotNull HighlightPolicy highlightPolicy, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(24);
        }
        if (text2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(25);
        }
        if (lineOffsets1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(26);
        }
        if (lineOffsets2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(27);
        }
        if (ignorePolicy2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(28);
        }
        if (highlightPolicy == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(29);
        }
        if (indicator == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(30);
        }
        if (this.isFormattingPolicyApplicable(ignorePolicy2)) {
            return this.compareIgnoreFormatting(text1, text2, lineOffsets1, lineOffsets2, linesRanges, highlightPolicy, indicator);
        }
        if (this.isLanguageSpecificPolicyApplicable(ignorePolicy2)) {
            return this.compareIgnoreLanguageSpecificChanges(text1, text2, lineOffsets1, lineOffsets2, linesRanges, ignorePolicy2, highlightPolicy, indicator);
        }
        List<List<LineFragment>> list = SimpleTextDiffProvider.compareRange(null, text1, text2, lineOffsets1, lineOffsets2, linesRanges, ignorePolicy2, highlightPolicy, indicator);
        if (list == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    private List<List<LineFragment>> compareIgnoreLanguageSpecificChanges(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @Nullable List<? extends Range> linesRanges, @NotNull IgnorePolicy ignorePolicy2, @NotNull HighlightPolicy highlightPolicy, @NotNull ProgressIndicator indicator) {
        DiffLangSpecificProvider diffProvider;
        if (text1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(32);
        }
        if (text2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(33);
        }
        if (lineOffsets1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(34);
        }
        if (lineOffsets2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(35);
        }
        if (ignorePolicy2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(36);
        }
        if (highlightPolicy == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(37);
        }
        if (indicator == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(38);
        }
        if ((diffProvider = Objects.requireNonNull(this.myDiffProvider)).getShouldPrecalculateLineFragments()) {
            List<List<LineFragment>> fragmentList = SimpleTextDiffProvider.compareRange(null, text1, text2, lineOffsets1, lineOffsets2, linesRanges, ignorePolicy2, HighlightPolicy.BY_LINE, indicator);
            List<List<LineFragment>> list = diffProvider.getPatchedLineFragments(this.myProject, fragmentList, text1, text2, ignorePolicy2, highlightPolicy, indicator);
            if (list == null) {
                SmartTextDiffProvider.$$$reportNull$$$0(39);
            }
            return list;
        }
        List<List<LineFragment>> list = diffProvider.getLineFragments(this.myProject, text1, text2, ignorePolicy2, highlightPolicy, indicator);
        if (list == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(40);
        }
        return list;
    }

    @NotNull
    private List<List<LineFragment>> compareIgnoreFormatting(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @Nullable List<? extends Range> linesRanges, @NotNull HighlightPolicy highlightPolicy, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(41);
        }
        if (text2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(42);
        }
        if (lineOffsets1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(43);
        }
        if (lineOffsets2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(44);
        }
        if (highlightPolicy == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(45);
        }
        if (indicator == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(46);
        }
        InnerFragmentsPolicy fragmentsPolicy = highlightPolicy.getFragmentsPolicy();
        List<TextRange> ignoredRanges1 = Objects.requireNonNull(this.myProvider).getIgnoredRanges(this.myProject, text1, this.myContent1);
        List<TextRange> ignoredRanges2 = Objects.requireNonNull(this.myProvider).getIgnoredRanges(this.myProject, text2, this.myContent2);
        BitSet ignored1 = ComparisonManagerImpl.collectIgnoredRanges(ignoredRanges1);
        BitSet ignored2 = ComparisonManagerImpl.collectIgnoredRanges(ignoredRanges2);
        ComparisonManagerImpl comparisonManager = ComparisonManagerImpl.getInstanceImpl();
        if (linesRanges == null) {
            List<LineFragment> fragments = comparisonManager.compareLinesWithIgnoredRanges(text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2, fragmentsPolicy, indicator);
            List<List<LineFragment>> list = Collections.singletonList(fragments);
            if (list == null) {
                SmartTextDiffProvider.$$$reportNull$$$0(47);
            }
            return list;
        }
        ArrayList<List<LineFragment>> result = new ArrayList<List<LineFragment>>();
        for (Range range : linesRanges) {
            result.add(comparisonManager.compareLinesWithIgnoredRanges(range, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2, fragmentsPolicy, indicator));
        }
        ArrayList<List<LineFragment>> arrayList = result;
        if (arrayList == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    private boolean isFormattingPolicyApplicable(@NotNull IgnorePolicy ignorePolicy2) {
        if (ignorePolicy2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(49);
        }
        return ignorePolicy2 == IgnorePolicy.FORMATTING && this.myProvider != null;
    }

    private boolean isLanguageSpecificPolicyApplicable(@NotNull IgnorePolicy ignorePolicy2) {
        if (ignorePolicy2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(50);
        }
        return ignorePolicy2 == IgnorePolicy.IGNORE_LANGUAGE_SPECIFIC_CHANGES && this.myDiffProvider != null;
    }

    @Nullable
    private static DiffIgnoredRangeProvider getIgnoredRangeProvider(@Nullable Project project, @NotNull DiffContent content1, @NotNull DiffContent content2) {
        if (content1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(51);
        }
        if (content2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(52);
        }
        try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-339105, EA-832803");){
            for (DiffIgnoredRangeProvider provider : DiffIgnoredRangeProvider.EP_NAME.getExtensionList()) {
                if (!provider.accepts(project, content1) || !provider.accepts(project, content2)) continue;
                DiffIgnoredRangeProvider diffIgnoredRangeProvider = provider;
                return diffIgnoredRangeProvider;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 31, 39, 40, 47, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rediff";
                break;
            }
            case 3: 
            case 7: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 8: 
            case 9: 
            case 31: 
            case 39: 
            case 40: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/text/SmartTextDiffProvider";
                break;
            }
            case 10: 
            case 16: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content1";
                break;
            }
            case 11: 
            case 17: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content2";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignorePolicies";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightPolicies";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 24: 
            case 32: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 25: 
            case 33: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 26: 
            case 34: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets1";
                break;
            }
            case 27: 
            case 35: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets2";
                break;
            }
            case 28: 
            case 36: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignorePolicy";
                break;
            }
            case 29: 
            case 37: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightPolicy";
                break;
            }
            case 30: 
            case 38: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/text/SmartTextDiffProvider";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnorePolicies";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompare";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "compareIgnoreLanguageSpecificChanges";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "compareIgnoreFormatting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNoIgnore";
                break;
            }
            case 8: 
            case 9: 
            case 31: 
            case 39: 
            case 40: 
            case 47: 
            case 48: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doCompare";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "compareIgnoreLanguageSpecificChanges";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "compareIgnoreFormatting";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isFormattingPolicyApplicable";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageSpecificPolicyApplicable";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredRangeProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 31, 39, 40, 47, 48 -> new IllegalStateException(string);
        };
    }

    public static final class NoIgnore
    extends SmartTextDiffProvider
    implements TwosideTextDiffProvider.NoIgnore {
        private NoIgnore(@Nullable Project project, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @Nullable DiffIgnoredRangeProvider ignoredRangeProvider, @Nullable DiffLangSpecificProvider diffProvider) {
            if (content1 == null) {
                NoIgnore.$$$reportNull$$$0(0);
            }
            if (content2 == null) {
                NoIgnore.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                NoIgnore.$$$reportNull$$$0(2);
            }
            if (rediff == null) {
                NoIgnore.$$$reportNull$$$0(3);
            }
            if (disposable == null) {
                NoIgnore.$$$reportNull$$$0(4);
            }
            super(project, content1, content2, settings, rediff, disposable, ignoredRangeProvider, diffProvider, IGNORE_POLICIES, (HighlightPolicy[])ArrayUtil.remove((Object[])HIGHLIGHT_POLICIES, (Object)((Object)HighlightPolicy.DO_NOT_HIGHLIGHT)));
        }

        @Override
        @NotNull
        public List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
            if (text1 == null) {
                NoIgnore.$$$reportNull$$$0(5);
            }
            if (text2 == null) {
                NoIgnore.$$$reportNull$$$0(6);
            }
            if (indicator == null) {
                NoIgnore.$$$reportNull$$$0(7);
            }
            List<LineFragment> list = super.compare(text1, text2, indicator);
            if (list == null) {
                NoIgnore.$$$reportNull$$$0(8);
            }
            return list;
        }

        @Override
        @NotNull
        public List<List<LineFragment>> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<? extends Range> linesRanges, @NotNull ProgressIndicator indicator) {
            if (text1 == null) {
                NoIgnore.$$$reportNull$$$0(9);
            }
            if (text2 == null) {
                NoIgnore.$$$reportNull$$$0(10);
            }
            if (linesRanges == null) {
                NoIgnore.$$$reportNull$$$0(11);
            }
            if (indicator == null) {
                NoIgnore.$$$reportNull$$$0(12);
            }
            List<List<LineFragment>> list = super.compare(text1, text2, linesRanges, indicator);
            if (list == null) {
                NoIgnore.$$$reportNull$$$0(13);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rediff";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/text/SmartTextDiffProvider$NoIgnore";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linesRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/text/SmartTextDiffProvider$NoIgnore";
                    break;
                }
                case 8: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compare";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 8: 
                case 13: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 13 -> new IllegalStateException(string);
            };
        }
    }
}

