/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.LineStatusMarkerDrawUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.vcs.ex.LineStatusGutterMarkerRenderer;
import com.intellij.openapi.vcs.ex.Range;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fH$J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fH$J\b\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/ex/ActiveLineStatusGutterMarkerRenderer;", "Lcom/intellij/openapi/vcs/ex/LineStatusGutterMarkerRenderer;", "Lcom/intellij/openapi/editor/markup/ActiveGutterRenderer;", "<init>", "()V", "calcBounds", "Ljava/awt/Rectangle;", "editor", "Lcom/intellij/openapi/editor/Editor;", "lineNum", "", "preferredBounds", "canDoAction", "", "e", "Ljava/awt/event/MouseEvent;", "ranges", "", "Lcom/intellij/openapi/vcs/ex/Range;", "doAction", "", "getAccessibleName", "", "intellij.platform.diff.impl"})
@ApiStatus.Internal
public abstract class ActiveLineStatusGutterMarkerRenderer
extends LineStatusGutterMarkerRenderer
implements ActiveGutterRenderer {
    @Nullable
    public Rectangle calcBounds(@NotNull Editor editor, int lineNum, @NotNull Rectangle preferredBounds) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)preferredBounds, (String)"preferredBounds");
        List<Range> list = this.getPaintedRanges();
        if (list == null) {
            return null;
        }
        List<Range> ranges = list;
        return LineStatusMarkerDrawUtil.calcBounds(ranges, editor, lineNum);
    }

    public boolean canDoAction(@NotNull Editor editor, @NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List<Range> list = this.getPaintedRanges();
        if (list == null) {
            return false;
        }
        List<Range> ranges = list;
        List<Range> list2 = LineStatusMarkerDrawUtil.getSelectedRanges(ranges, editor, e.getY());
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getSelectedRanges(...)");
        List<Range> selectedRanges = list2;
        return !selectedRanges.isEmpty() && this.canDoAction(editor, selectedRanges, e);
    }

    protected abstract boolean canDoAction(@NotNull Editor var1, @NotNull List<? extends Range> var2, @NotNull MouseEvent var3);

    public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List<Range> list = this.getPaintedRanges();
        if (list == null) {
            return;
        }
        List<Range> ranges = list;
        List<Range> list2 = LineStatusMarkerDrawUtil.getSelectedRanges(ranges, editor, e.getY());
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getSelectedRanges(...)");
        List<Range> selectedRanges = list2;
        if (!selectedRanges.isEmpty()) {
            e.consume();
            this.doAction(editor, selectedRanges, e);
        }
    }

    protected abstract void doAction(@NotNull Editor var1, @NotNull List<? extends Range> var2, @NotNull MouseEvent var3);

    @NotNull
    public String getAccessibleName() {
        String string = DiffBundle.message((String)"vcs.marker.changed.line", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

