/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.util.DocumentUtil;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.ide.model.uiautomation.BeEditor;
import com.jetbrains.ide.model.uiautomation.BeEditorSettings;
import com.jetbrains.ide.model.uiautomation.BeIdeaEditorSettings;
import com.jetbrains.ide.model.uiautomation.ControlVisibility;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.RichAttributedStringModel;
import com.jetbrains.rd.ide.model.RichAttributedTextModel;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.daemon.TextAttributesRegistrationHost;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rd.ui.bedsl.extensions.UpdateFlag;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/EditorViewControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/ide/model/uiautomation/BeEditor;", "<init>", "()V", "reentrancyPreventer", "Lcom/jetbrains/rd/ui/bedsl/extensions/UpdateFlag;", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "doIgnoringReadOnly", "", "document", "Lcom/intellij/openapi/editor/Document;", "action", "Lkotlin/Function0;", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nEditorViewControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorViewControl.kt\ncom/jetbrains/rd/ui/bindable/views/EditorViewControl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1915#2,2:127\n*S KotlinDebug\n*F\n+ 1 EditorViewControl.kt\ncom/jetbrains/rd/ui/bindable/views/EditorViewControl\n*L\n87#1:127,2\n*E\n"})
public final class EditorViewControl
implements ViewBinder<BeEditor> {
    @NotNull
    private final UpdateFlag reentrancyPreventer = new UpdateFlag();

    @Override
    @NotNull
    public JComponent bind(@NotNull BeEditor viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        JComponent jComponent = this.getEditor(viewModel, lifetime).getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    public final EditorEx getEditor(@NotNull BeEditor viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
        Document document2 = document;
        document2.setReadOnly(((Boolean)viewModel.isReadonly().getValue()).booleanValue());
        RdProjectId rdProjectId = viewModel.getProjectId();
        Project project = rdProjectId != null ? ProjectUtilKt.toProject((RdProjectId)rdProjectId) : null;
        Editor editor = editorFactory.createEditor(document2, project);
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor2 = (EditorEx)editor;
        lifetime.onTermination(() -> EditorViewControl.getEditor$lambda$0(editor2));
        BeEditorSettings settings = (BeEditorSettings)viewModel.getSettings().getValue();
        if (settings instanceof BeIdeaEditorSettings) {
            editor2.getSettings().setAdditionalColumnsCount(((BeIdeaEditorSettings)settings).getAdditionalColumnsCount());
            editor2.getSettings().setAdditionalLinesCount(((BeIdeaEditorSettings)settings).getAdditionalLinesCount());
            editor2.getSettings().setRightMargin(((BeIdeaEditorSettings)settings).getRightMargin());
            editor2.getSettings().setLineCursorWidth(((BeIdeaEditorSettings)settings).getLineCursorWidth());
            editor2.getSettings().setCaretRowShown(((BeIdeaEditorSettings)settings).isCaretRowShown());
            editor2.getSettings().setFoldingOutlineShown(((BeIdeaEditorSettings)settings).isFoldingOutlineShown());
            editor2.getSettings().setIndentGuidesShown(((BeIdeaEditorSettings)settings).isIndentGuidesShown());
            editor2.getSettings().setLineMarkerAreaShown(((BeIdeaEditorSettings)settings).isLineMarkerAreaShown());
            editor2.getSettings().setLineNumbersShown(((BeIdeaEditorSettings)settings).isLineNumbersShown());
            editor2.getSettings().setUseSoftWraps(((BeIdeaEditorSettings)settings).isUseSoftWraps());
            editor2.getSettings().setWhitespacesShown(((BeIdeaEditorSettings)settings).isWhitespacesShown());
            editor2.getSettings().setShowingSpecialChars(((BeIdeaEditorSettings)settings).isShowingSpecialChars());
            editor2.setOneLineMode(((BeIdeaEditorSettings)settings).isOneLineMode());
            editor2.getSettings().setRightMarginShown(((BeIdeaEditorSettings)settings).isRightMarginShown());
            editor2.getSettings().setVirtualSpace(((BeIdeaEditorSettings)settings).isVirtualSpace());
            editor2.getSettings().setWheelFontChangeEnabled(((BeIdeaEditorSettings)settings).isWheelFontChangeEnabled());
            editor2.getSettings().setAdditionalPageAtBottom(((BeIdeaEditorSettings)settings).isAdditionalPageAtBottom());
            editor2.setHorizontalScrollbarVisible(((BeIdeaEditorSettings)settings).isHorizontalScrollBarVisible());
            editor2.setVerticalScrollbarVisible(((BeIdeaEditorSettings)settings).isVerticalScrollBarVisible());
        } else {
            editor2.setHorizontalScrollbarVisible(true);
            editor2.setVerticalScrollbarVisible(true);
        }
        editor2.getScrollPane().getVerticalScrollBar().setBackground(editor2.getBackgroundColor());
        editor2.getScrollPane().getHorizontalScrollBar().setBackground(editor2.getBackgroundColor());
        viewModel.getText().getText().advise(lifetime, arg_0 -> EditorViewControl.getEditor$lambda$1(this, document2, project, arg_0));
        viewModel.getEnabled().advise(lifetime, arg_0 -> EditorViewControl.getEditor$lambda$2(editor2, arg_0));
        viewModel.getVisible().advise(lifetime, arg_0 -> EditorViewControl.getEditor$lambda$3(editor2, arg_0));
        return editor2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doIgnoringReadOnly(Document document, Function0<Unit> action3) {
        if (document.isWritable()) {
            action3.invoke();
        } else {
            document.setReadOnly(false);
            try {
                action3.invoke();
            }
            finally {
                document.setReadOnly(true);
            }
        }
    }

    private static final CharSequence getEditor$lambda$1$0$0$0$0$0(RichAttributedStringModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }

    private static final Unit getEditor$lambda$1$0$0$0$0(Document $document, RichAttributedTextModel $it) {
        $document.setText((CharSequence)CollectionsKt.joinToString$default((Iterable)$it.getParts(), (CharSequence)"", null, null, (int)0, null, EditorViewControl::getEditor$lambda$1$0$0$0$0$0, (int)30, null));
        return Unit.INSTANCE;
    }

    private static final void getEditor$lambda$1$0$0$0(MarkupModelEx $markupModel, EditorViewControl this$0, Document $document, RichAttributedTextModel $it) {
        $markupModel.removeAllHighlighters();
        this$0.doIgnoringReadOnly($document, (Function0<Unit>)((Function0)() -> EditorViewControl.getEditor$lambda$1$0$0$0$0($document, $it)));
        int currentOffset = 0;
        Iterable $this$forEach$iv = $it.getParts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RichAttributedStringModel it = (RichAttributedStringModel)element$iv;
            boolean bl = false;
            String partText = it.getText();
            TextAttributesKeyModel textAttributesKey = it.getTextAttributesKey();
            if (textAttributesKey != null) {
                TextAttributesRegistrationHost host = TextAttributesRegistrationHost.Companion.getInstance();
                int n = currentOffset + partText.length();
                TextAttributes textAttributes = TextAttributesRegistrationHost.getTextAttributes$default((TextAttributesRegistrationHost)host, (TextAttributesKeyModel)textAttributesKey, null, (int)2, null);
                if (textAttributes == null) {
                    textAttributes = new TextAttributes();
                }
                $markupModel.addRangeHighlighter(currentOffset, n, 3000, textAttributes, HighlighterTargetArea.EXACT_RANGE);
            }
            currentOffset += partText.length();
        }
    }

    private static final void getEditor$lambda$1$0$0(MarkupModelEx $markupModel, EditorViewControl this$0, Document $document, RichAttributedTextModel $it) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> EditorViewControl.getEditor$lambda$1$0$0$0($markupModel, this$0, $document, $it));
    }

    private static final Unit getEditor$lambda$1$0(Document $document, Project $project, EditorViewControl this$0, RichAttributedTextModel $it) {
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)$document, (Project)$project, (boolean)true);
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx markupModel2 = (MarkupModelEx)markupModel;
        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> EditorViewControl.getEditor$lambda$1$0$0(markupModel2, this$0, $document, $it));
        return Unit.INSTANCE;
    }

    private static final Unit getEditor$lambda$0(EditorEx $editor) {
        if (!$editor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)$editor);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getEditor$lambda$1(EditorViewControl this$0, Document $document, Project $project, RichAttributedTextModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LocalChangeKt.ignoreOnReentrancy(this$0.reentrancyPreventer, (Function0<Unit>)((Function0)() -> EditorViewControl.getEditor$lambda$1$0($document, $project, this$0, it)));
        return Unit.INSTANCE;
    }

    private static final Unit getEditor$lambda$2(EditorEx $editor, boolean it) {
        $editor.getComponent().setEnabled(it);
        return Unit.INSTANCE;
    }

    private static final Unit getEditor$lambda$3(EditorEx $editor, ControlVisibility it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $editor.getComponent().setVisible(it == ControlVisibility.Visible);
        return Unit.INSTANCE;
    }
}

