/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.microservices.jvm.config.ConfigKeyParts;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.properties.MicroservicePropertiesDocument;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.application.properties.SpringBootPropertiesImportsKt;
import com.intellij.spring.boot.application.properties.SpringBootPropertiesScanner;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.ConfigurationValueSearchParams;
import com.intellij.spring.boot.model.SpringBootConfigImportStatement;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.SpringBootPropertiesFileUtil;
import com.intellij.spring.profiles.SpringProfilesFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SpringBootModelApplicationPropertiesConfigFileContributor
extends SpringBootModelConfigFileContributor {
    public SpringBootModelApplicationPropertiesConfigFileContributor() {
        super((FileType)PropertiesFileType.INSTANCE);
    }

    @NotNull
    public List<SpringBootConfigImportStatement> getImportStatements(@NotNull Project project, @NotNull VirtualFile configFile) {
        if (project == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(0);
        }
        if (configFile == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(1);
        }
        Map data = FileBasedIndex.getInstance().getFileData(SpringBootPropertiesImportsKt.PROPERTY_IMPORTS_INDEX_KEY, configFile, project);
        List list = ContainerUtil.map(data.keySet(), ix -> new SpringBootConfigImportStatement(ix.getFilePointerText(), ix.getDocumentId()));
        if (list == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<ConfigurationValueResult> findConfigurationValues(@NotNull PsiFile configFile, @NotNull ConfigurationValueSearchParams params) {
        if (configFile == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(3);
        }
        if (params == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(4);
        }
        VirtualFile virtualFile = configFile.getVirtualFile();
        params.getProcessedFiles().add(virtualFile);
        PropertiesFile propertiesFile = (PropertiesFile)ObjectUtils.tryCast((Object)configFile, PropertiesFile.class);
        if (propertiesFile == null) {
            List<ConfigurationValueResult> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(5);
            }
            return list;
        }
        String fileName = propertiesFile.getVirtualFile().getNameWithoutExtension();
        String profileSuffix = StringUtil.substringAfter((String)fileName, (String)"-");
        if (!SpringBootModelApplicationPropertiesConfigFileContributor.isProfileRelevant((ConfigurationValueSearchParams)params, (String)profileSuffix)) {
            List<ConfigurationValueResult> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(6);
            }
            return list;
        }
        MetaConfigKeyManager.ConfigKeyNameBinder keyNameBinder = SpringBootApplicationMetaConfigKeyManager.getInstance().getConfigKeyNameBinder(params.getModule());
        SpringBootPropertiesScanner scanner = new SpringBootPropertiesScanner(keyNameBinder);
        SmartList results = new SmartList();
        List documents = SpringBootPropertiesFileUtil.getInstance().getDocuments((PsiFile)propertiesFile, params.getModule());
        if (!documents.isEmpty()) {
            boolean processAllDocuments = params.isProcessAllProfiles();
            for (int documentId = documents.size() - 1; documentId >= 0; --documentId) {
                MicroservicePropertiesDocument document = (MicroservicePropertiesDocument)documents.get(documentId);
                String profileText = SpringBootModelApplicationPropertiesConfigFileContributor.getProfileText(document, profileSuffix, keyNameBinder);
                if (!processAllDocuments && !SpringBootModelApplicationPropertiesConfigFileContributor.isProfileRelevantDocument(params, profileText)) continue;
                SpringBootModelApplicationPropertiesConfigFileContributor.processImports((ConfigurationValueSearchParams)params, (VirtualFile)virtualFile, (List)results, (int)documentId);
                if (!scanner.processDocument(document, documentId, profileText, params, ((List)results)::add) && !processAllDocuments) break;
            }
        }
        SmartList smartList = results;
        if (smartList == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    @NotNull
    public List<? extends PsiElement> getDocumentAnchors(@NotNull PsiFile configFile, @Nullable Module module) {
        PropertiesFile propertiesFile;
        if (configFile == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(8);
        }
        if ((propertiesFile = (PropertiesFile)ObjectUtils.tryCast((Object)configFile, PropertiesFile.class)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<List<IProperty>> documents = SpringBootApplicationPropertiesUtil.getDocuments(propertiesFile, module);
        List list = ContainerUtil.mapNotNull(documents, document -> document.isEmpty() ? null : ((IProperty)document.getFirst()).getPsiElement());
        if (list == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(10);
        }
        return list;
    }

    public List<? extends PsiElement> getDocumentAnchors(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull Set<String> activeProfiles) {
        Module module;
        if (project == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(11);
        }
        if (virtualFile == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(12);
        }
        if (activeProfiles == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(13);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project)) == null) {
            return Collections.emptyList();
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiFile psiFile = psiManager.findFile(virtualFile);
        if (psiFile == null) {
            return Collections.emptyList();
        }
        PropertiesFile propertiesFile = (PropertiesFile)ObjectUtils.tryCast((Object)psiFile, PropertiesFile.class);
        if (propertiesFile == null) {
            return Collections.emptyList();
        }
        String fileName = propertiesFile.getVirtualFile().getNameWithoutExtension();
        String profileSuffix = StringUtil.substringAfter((String)fileName, (String)"-");
        MetaConfigKeyManager.ConfigKeyNameBinder keyNameBinder = SpringBootApplicationMetaConfigKeyManager.getInstance().getConfigKeyNameBinder(module);
        SmartList result = new SmartList();
        List documents = SpringBootPropertiesFileUtil.getInstance().getDocuments((PsiFile)propertiesFile, module);
        if (!documents.isEmpty()) {
            for (int documentId = documents.size() - 1; documentId >= 0; --documentId) {
                PropertyImpl firstProperty;
                MicroservicePropertiesDocument document = (MicroservicePropertiesDocument)documents.get(documentId);
                String profileText = SpringBootModelApplicationPropertiesConfigFileContributor.getProfileByKey("spring.config.activate.on-profile", document, profileSuffix, keyNameBinder);
                if (!SpringBootModelApplicationPropertiesConfigFileContributor.isProfileRelevantDocument(activeProfiles, profileText) || (firstProperty = (PropertyImpl)ObjectUtils.tryCast((Object)ContainerUtil.getFirstItem((List)document.getProperties()), PropertyImpl.class)) == null) continue;
                result.add(firstProperty);
            }
        }
        return result;
    }

    private static boolean isProfileRelevantDocument(ConfigurationValueSearchParams params, @Nullable String profileText) {
        Set activeProfiles = params.getActiveProfiles();
        if (ContainerUtil.isEmpty((Collection)activeProfiles) || profileText == null) {
            return true;
        }
        return SpringBootModelApplicationPropertiesConfigFileContributor.isProfileRelevantDocument(activeProfiles, profileText);
    }

    private static boolean isProfileRelevantDocument(Set<String> activeProfiles, @Nullable String profileText) {
        if (profileText == null) {
            return activeProfiles.isEmpty();
        }
        try {
            Predicate profiles = SpringProfilesFactory.getInstance().parseProfileExpressions((Collection)StringUtil.split((String)profileText, (String)","));
            return profiles.test(activeProfiles);
        }
        catch (SpringProfilesFactory.MalformedProfileExpressionException e) {
            return false;
        }
    }

    private static String getProfileText(MicroservicePropertiesDocument document, String fileProfile, MetaConfigKeyManager.ConfigKeyNameBinder keyNameBinder) {
        String profileText = SpringBootModelApplicationPropertiesConfigFileContributor.getProfileByKey("spring.profiles", document, null, keyNameBinder);
        if (profileText == null) {
            profileText = SpringBootModelApplicationPropertiesConfigFileContributor.getProfileByKey("spring.config.activate.on-profile", document, fileProfile, keyNameBinder);
        }
        return profileText;
    }

    private static String getProfileByKey(String key, MicroservicePropertiesDocument document, String fileProfile, MetaConfigKeyManager.ConfigKeyNameBinder binder) {
        ArrayList<String> profiles = new ArrayList<String>();
        for (IProperty property : ContainerUtil.reverse((List)document.getProperties())) {
            String name = property.getName();
            if (name == null || !binder.matchesPart(key, name)) continue;
            String value = property.getValue();
            ConfigKeyParts parts = ConfigKeyParts.splitToParts((String)key, (String)name, (boolean)false);
            if (parts == null || parts.getKeyIndex() == null) {
                return value;
            }
            profiles.add(value);
        }
        if (!profiles.isEmpty()) {
            return StringUtil.join(profiles, (String)",");
        }
        return fileProfile;
    }

    public boolean processAllKeys(@NotNull PsiFile configFile, Processor<Pair<PsiElement, PsiElement>> processor) {
        if (configFile == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(14);
        }
        if (!(configFile instanceof PropertiesFile)) {
            return true;
        }
        PropertiesFile propertiesFile = (PropertiesFile)configFile;
        for (IProperty property : ContainerUtil.reverse((List)propertiesFile.getProperties())) {
            PropertyValueImpl value;
            PropertyImpl propertyImpl = (PropertyImpl)property.getPsiElement();
            PropertyKeyImpl key = SpringBootApplicationPropertiesUtil.getPropertyKey(propertyImpl);
            if (key == null || processor.process((Object)Pair.create((Object)key, (Object)(value = SpringBootApplicationPropertiesUtil.getPropertyValue(propertyImpl))))) continue;
            return false;
        }
        return true;
    }

    public void addConfiguration(@NotNull VirtualFile vFile, @NotNull String key, @NotNull String value, @NotNull Project project) {
        PsiManager psiManager;
        PsiFile psiFile;
        if (vFile == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(15);
        }
        if (key == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(16);
        }
        if (value == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(17);
        }
        if (project == null) {
            SpringBootModelApplicationPropertiesConfigFileContributor.$$$reportNull$$$0(18);
        }
        if (!((psiFile = (psiManager = PsiManager.getInstance((Project)project)).findFile(vFile)) instanceof PropertiesFile)) {
            return;
        }
        PropertiesFile propertiesFile = (PropertiesFile)psiFile;
        List<? extends PsiElement> anchors = this.getDocumentAnchors(project, vFile, Collections.emptySet());
        if (anchors.isEmpty()) {
            IProperty firstProperty = (IProperty)ContainerUtil.getFirstItem((List)propertiesFile.getProperties());
            if (firstProperty != null) {
                propertiesFile.addPropertyAfter(key, value, firstProperty);
            } else {
                propertiesFile.addProperty(key, value);
            }
        } else if (anchors.size() == 1) {
            PsiElement documentAnchor = anchors.getFirst();
            if (!(documentAnchor instanceof PropertyImpl)) {
                return;
            }
            PropertyImpl propertyImpl = (PropertyImpl)documentAnchor;
            propertiesFile.addPropertyAfter(key, value, (IProperty)propertyImpl);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/properties/SpringBootModelApplicationPropertiesConfigFileContributor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootModelApplicationPropertiesConfigFileContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatements";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigurationValues";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentAnchors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getImportStatements";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurationValues";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentAnchors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 7, 9, 10 -> new IllegalStateException(string);
        };
    }
}

