/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.SpringAutodetectedFilesetsSearcher;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootApplicationFileSet;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.SpringBootModelConfigFileNameContributor;
import com.intellij.spring.boot.model.SpringBootModelExtender;
import com.intellij.spring.boot.model.SpringBootStarterFileSet;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassCollector;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContextBase;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.boot.spi.SpringBootImportsManager;
import com.intellij.spring.facet.SpringAutodetectedFileSet;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringBootAutodetectedFilesetsSearcher
implements SpringAutodetectedFilesetsSearcher {
    private static final ExtensionPointName<SpringBootModelExtender> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.boot.modelExtender");

    public SpringBootAutodetectedFilesetsSearcher() {
        EP_NAME.addChangeListener(SpringAutodetectedFileSet::refreshAutodetectedFileSets, null);
        SpringBootModelConfigFileContributor.EP_NAME.addChangeListener(SpringAutodetectedFileSet::refreshAutodetectedFileSets, null);
        SpringBootModelConfigFileNameContributor.EP_NAME.addChangeListener(SpringAutodetectedFileSet::refreshAutodetectedFileSets, null);
    }

    @NotNull
    public List<? extends SpringAutodetectedFileSet> getFilesets(@NotNull SpringFacet facet) {
        Module currentFacetModule;
        if (facet == null) {
            SpringBootAutodetectedFilesetsSearcher.$$$reportNull$$$0(0);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Module)(currentFacetModule = facet.getModule()))) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringBootAutodetectedFilesetsSearcher.$$$reportNull$$$0(1);
            }
            return list;
        }
        Project project = currentFacetModule.getProject();
        List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)facet, () -> {
            SpringAutodetectedFileSet bootFileSet;
            Module module = facet.getModule();
            List springApplications = SpringBootApplicationService.getInstance().getSpringApplications(module);
            if (springApplications.size() > 1) {
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            PsiClass applicationClass = (PsiClass)ContainerUtil.getFirstItem((List)springApplications);
            SpringAutodetectedFileSet springAutodetectedFileSet = bootFileSet = applicationClass == null || applicationClass.getQualifiedName() == null ? SpringBootAutodetectedFilesetsSearcher.getStarterFileSet(facet) : SpringBootAutodetectedFilesetsSearcher.getApplicationFileSet(applicationClass, facet);
            if (bootFileSet == null) {
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            SpringFacetConfiguration configuration = (SpringFacetConfiguration)facet.getConfiguration();
            configuration.registerAutodetectedFileSet((SpringFileSet)bootFileSet);
            SmartList fileSets = new SmartList((Object)bootFileSet);
            for (SpringBootModelExtender extender : (SpringBootModelExtender[])EP_NAME.getExtensions()) {
                fileSets.addAll(extender.getAdditionalFileSets((SpringFileSet)bootFileSet));
            }
            Object[] springOuterModelsTracker = SpringModificationTrackersManager.getInstance((Project)module.getProject()).getOuterModelsDependencies();
            return CachedValueProvider.Result.create((Object)fileSets, (Object[])ArrayUtil.append((Object[])springOuterModelsTracker, (Object)configuration.getSettingsModificationTracker()));
        });
        if (list == null) {
            SpringBootAutodetectedFilesetsSearcher.$$$reportNull$$$0(2);
        }
        return list;
    }

    public String getName() {
        return "Spring Boot";
    }

    private static SpringAutodetectedFileSet getApplicationFileSet(@NotNull PsiClass applicationClass, @NotNull SpringFacet facet) {
        if (applicationClass == null) {
            SpringBootAutodetectedFilesetsSearcher.$$$reportNull$$$0(3);
        }
        if (facet == null) {
            SpringBootAutodetectedFilesetsSearcher.$$$reportNull$$$0(4);
        }
        SpringBootApplicationFileSet bootFileSet = new SpringBootApplicationFileSet(applicationClass, facet);
        List configFiles = SpringBootConfigurationFileService.getInstance().findConfigFiles(facet.getModule(), false, contributor -> contributor.accept((SpringFileSet)bootFileSet));
        for (VirtualFile configFile : configFiles) {
            bootFileSet.addFile(configFile);
        }
        List imports = SpringBootConfigurationFileService.getInstance().collectImports(facet.getModule(), configFiles);
        for (VirtualFile importedFile : imports) {
            bootFileSet.addFile(importedFile);
        }
        return bootFileSet;
    }

    private static SpringAutodetectedFileSet getStarterFileSet(@NotNull SpringFacet facet) {
        if (facet == null) {
            SpringBootAutodetectedFilesetsSearcher.$$$reportNull$$$0(5);
        }
        if (!Registry.is((String)"spring.boot.starter.autodetected.fileset")) {
            return null;
        }
        Module module = facet.getModule();
        PsiClass contextClass = SpringBootAutodetectedFilesetsSearcher.findAutoConfiguration(module);
        if (contextClass == null) {
            return null;
        }
        ConditionalOnEvaluationContextBase context = new ConditionalOnEvaluationContextBase(contextClass, module, null, NotNullLazyValue.lazy(() -> Collections.emptyList()), null);
        List<PsiClass> autoConfigs = AutoConfigClassCollector.collectConfigurationClasses((EnableAutoConfiguration)null, (ConditionalOnEvaluationContext)context);
        SpringBootStarterFileSet bootFileSet = new SpringBootStarterFileSet(facet);
        autoConfigs.forEach(psiClass -> bootFileSet.addFile(psiClass.getContainingFile().getVirtualFile()));
        return bootFileSet;
    }

    public static PsiClass findAutoConfiguration(Module module) {
        GlobalSearchScope scope = module.getModuleScope(false);
        List autoConfigurationClasses = SpringBootImportsManager.Companion.getInstance().getAutoConfigurationClasses(scope, module);
        return (PsiClass)ContainerUtil.getFirstItem((List)autoConfigurationClasses);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/SpringBootAutodetectedFilesetsSearcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/SpringBootAutodetectedFilesetsSearcher";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesets";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationFileSet";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStarterFileSet";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

