/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions;

import com.intellij.openapi.module.Module;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionMessage;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalContributor;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.PooledDataSourceCondition;
import com.intellij.spring.model.utils.SpringCommonUtils;

class EmbeddedDatabaseCondition
extends ConditionalContributor {
    private final PooledDataSourceCondition myPooledDataSourceCondition = new PooledDataSourceCondition();

    EmbeddedDatabaseCondition() {
    }

    public ConditionOutcome matches(ConditionalOnEvaluationContext context) {
        if (this.myPooledDataSourceCondition.matches(context).isMatch()) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.found((String)"supported pooled data source", (String[])new String[0]));
        }
        for (EmbeddedDatabaseConnection connection : EmbeddedDatabaseConnection.values()) {
            if (SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)connection.getDriverClassName()) == null) continue;
            return ConditionOutcome.match((String)"Found embedded database");
        }
        return ConditionOutcome.noMatch((String)"Did not find embedded database");
    }

    static enum EmbeddedDatabaseConnection {
        H2("org.h2.Driver"),
        DERBY("org.apache.derby.jdbc.EmbeddedDriver"),
        HSQL("org.hsqldb.jdbcDriver");

        private final String myDriverClassName;

        private EmbeddedDatabaseConnection(String driverClassName) {
            this.myDriverClassName = driverClassName;
        }

        public String getDriverClassName() {
            return this.myDriverClassName;
        }
    }
}

