/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions.jam;

import com.intellij.jam.JamService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringModelSearchers;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConditionalOnBeanUtils {
    private ConditionalOnBeanUtils() {
    }

    static PsiClassType getContainerType(PsiClass container, PsiType psiType) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)container.getProject());
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY.put(container.getTypeParameters()[0], psiType);
        return facade.getElementFactory().createType(container, substitutor, PsiUtil.getLanguageLevel((PsiElement)container));
    }

    static List<SpringBeanPointer<?>> findBeansByType(CommonSpringModel springModel, PsiType psiType) {
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byType((PsiType)psiType).withInheritors().effectiveBeanTypes();
        return SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters);
    }

    @Nullable
    static PsiType getBeanType(@NotNull PsiMethod psiMethod) {
        ContextJavaBean bean;
        if (psiMethod == null) {
            ConditionalOnBeanUtils.$$$reportNull$$$0(0);
        }
        if ((bean = (ContextJavaBean)JamService.getJamService((Project)psiMethod.getProject()).getJamElement(ContextJavaBean.BEAN_JAM_KEY, (PsiElement)psiMethod)) == null) {
            return null;
        }
        PsiType psiType = psiMethod.getReturnType();
        return psiType instanceof PsiClassType ? psiType : null;
    }

    @Nullable
    static CommonSpringBean getSpringBean(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ConditionalOnBeanUtils.$$$reportNull$$$0(1);
        }
        return (CommonSpringBean)JamService.getJamService((Project)psiElement.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, psiElement);
    }

    @NotNull
    static ConditionOutcome getMissingModelOutcome() {
        ConditionOutcome conditionOutcome = ConditionOutcome.noMatch((String)"Evaluation context doesn't contain model to search in");
        if (conditionOutcome == null) {
            ConditionalOnBeanUtils.$$$reportNull$$$0(2);
        }
        return conditionOutcome;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/autoconfigure/conditions/jam/ConditionalOnBeanUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/autoconfigure/conditions/jam/ConditionalOnBeanUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingModelOutcome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBeanType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSpringBean";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

