/*
 * Decompiled with CFR 0.152.
 */
package training.learn.lesson.general;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.dsl.LessonContext;
import training.dsl.LessonSample;
import training.dsl.LessonUtil;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.dsl.TaskTestContext;
import training.learn.LessonsBundle;
import training.learn.course.KLesson;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Ltraining/learn/lesson/general/DuplicateLesson;", "Ltraining/learn/course/KLesson;", "sample", "Ltraining/dsl/LessonSample;", "helpUrl", "", "<init>", "(Ltraining/dsl/LessonSample;Ljava/lang/String;)V", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "multipleLinesSelected", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "helpLinks", "", "getHelpLinks", "()Ljava/util/Map;", "intellij.featuresTrainer"})
public final class DuplicateLesson
extends KLesson {
    @NotNull
    private final LessonSample sample;
    @NotNull
    private final String helpUrl;
    @NotNull
    private final Function1<LessonContext, Unit> lessonContent;

    public DuplicateLesson(@NotNull LessonSample sample, @NotNull String helpUrl) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        Intrinsics.checkNotNullParameter((Object)helpUrl, (String)"helpUrl");
        super("Duplicate", LessonsBundle.INSTANCE.message("duplicate.and.delete.lines.lesson.name", new Object[0]));
        this.sample = sample;
        this.helpUrl = helpUrl;
        this.lessonContent = arg_0 -> DuplicateLesson.lessonContent$lambda$0(this, arg_0);
    }

    public /* synthetic */ DuplicateLesson(LessonSample lessonSample, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "working-with-source-code.html#editor_lines_code_blocks";
        }
        this(lessonSample, string);
    }

    @Override
    @NotNull
    protected Function1<LessonContext, Unit> getLessonContent() {
        return this.lessonContent;
    }

    private final boolean multipleLinesSelected(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel model = selectionModel;
        VisualPosition visualPosition = model.getSelectionStartPosition();
        if (visualPosition == null) {
            return false;
        }
        VisualPosition start = visualPosition;
        VisualPosition visualPosition2 = model.getSelectionEndPosition();
        if (visualPosition2 == null) {
            return false;
        }
        VisualPosition end = visualPosition2;
        return start.column == end.column && Math.abs(start.line - end.line) >= 2;
    }

    @Override
    @NotNull
    public Map<String, String> getHelpLinks() {
        return MapsKt.mapOf((Pair)new Pair((Object)LessonsBundle.INSTANCE.message("help.code.duplicate", new Object[0]), (Object)LessonUtil.INSTANCE.getHelpLink(this.helpUrl)));
    }

    private static final Unit lessonContent$lambda$0$0$0(String $it, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        String[] stringArray = new String[]{$it};
        $this$test.actions(stringArray);
        return Unit.INSTANCE;
    }

    private static final boolean lessonContent$lambda$0$1$0(DuplicateLesson this$0, TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return this$0.multipleLinesSelected($this$stateCheck.getEditor());
    }

    private static final Unit lessonContent$lambda$0$1$1(String $it, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        String[] stringArray = new String[]{$it, $it};
        $this$test.actions(stringArray);
        return Unit.INSTANCE;
    }

    private static final boolean lessonContent$lambda$0$2$0(DuplicateLesson this$0, TaskRuntimeContext $this$triggerStart) {
        Intrinsics.checkNotNullParameter((Object)$this$triggerStart, (String)"$this$triggerStart");
        return this$0.multipleLinesSelected($this$triggerStart.getEditor());
    }

    private static final TaskContext.RestoreNotification lessonContent$lambda$0$2$1(DuplicateLesson this$0, TaskRuntimeContext $this$proposeRestore) {
        Intrinsics.checkNotNullParameter((Object)$this$proposeRestore, (String)"$this$proposeRestore");
        return !this$0.multipleLinesSelected($this$proposeRestore.getEditor()) ? LessonUtil.INSTANCE.sampleRestoreNotification($this$proposeRestore, LessonsBundle.INSTANCE.message("duplicate.and.delete.lines.unexpected.selection.restore", new Object[0]), $this$proposeRestore.getPrevious().getSample()) : null;
    }

    private static final Unit lessonContent$lambda$0$2$2(String $it, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        String[] stringArray = new String[]{$it};
        $this$test.actions(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$3$0(TaskRuntimeContext $this$before) {
        Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
        $this$before.getEditor().getSelectionModel().removeSelection();
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$3$1(String $it, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        String[] stringArray = new String[]{$it};
        $this$test.actions(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$0(DuplicateLesson this$0, TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{$this$task.action(it)};
        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("duplicate.and.delete.lines.duplicate.line", objectArray), null, 2, null);
        $this$task.trigger(it);
        LessonUtil.INSTANCE.restoreIfModifiedOrMoved($this$task, this$0.sample);
        TaskContext.test$default($this$task, false, arg_0 -> DuplicateLesson.lessonContent$lambda$0$0$0(it, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$1(DuplicateLesson this$0, TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{$this$task.action(it)};
        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("duplicate.and.delete.lines.select.several.lines", objectArray), null, 2, null);
        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)arg_0 -> DuplicateLesson.lessonContent$lambda$0$1$0(this$0, arg_0)));
        TaskContext.test$default($this$task, false, arg_0 -> DuplicateLesson.lessonContent$lambda$0$1$1(it, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$2(DuplicateLesson this$0, TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{$this$task.action(it)};
        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("duplicate.and.delete.lines.duplicate.several.lines", objectArray), null, 2, null);
        $this$task.triggerStart(it, (Function1<? super TaskRuntimeContext, Boolean>)((Function1)arg_0 -> DuplicateLesson.lessonContent$lambda$0$2$0(this$0, arg_0)));
        $this$task.proposeRestore((Function1<? super TaskRuntimeContext, TaskContext.RestoreNotification>)((Function1)arg_0 -> DuplicateLesson.lessonContent$lambda$0$2$1(this$0, arg_0)));
        TaskContext.test$default($this$task, false, arg_0 -> DuplicateLesson.lessonContent$lambda$0$2$2(it, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0$3(TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$task.before((Function1<? super TaskRuntimeContext, Unit>)((Function1)DuplicateLesson::lessonContent$lambda$0$3$0));
        Object[] objectArray = new Object[]{$this$task.action(it)};
        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("duplicate.and.delete.lines.delete.line", objectArray), null, 2, null);
        $this$task.trigger(it);
        TaskContext.test$default($this$task, false, arg_0 -> DuplicateLesson.lessonContent$lambda$0$3$1(it, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$0(DuplicateLesson this$0, LessonContext lessonContext) {
        Intrinsics.checkNotNullParameter((Object)lessonContext, (String)"<this>");
        LessonContext.prepareSample$default(lessonContext, this$0.sample, false, 2, null);
        lessonContext.task("EditorDuplicate", (Function2<? super TaskContext, ? super String, Unit>)((Function2)(arg_0, arg_1) -> DuplicateLesson.lessonContent$lambda$0$0(this$0, arg_0, arg_1)));
        lessonContext.task("EditorUpWithSelection", (Function2<? super TaskContext, ? super String, Unit>)((Function2)(arg_0, arg_1) -> DuplicateLesson.lessonContent$lambda$0$1(this$0, arg_0, arg_1)));
        lessonContext.task("EditorDuplicate", (Function2<? super TaskContext, ? super String, Unit>)((Function2)(arg_0, arg_1) -> DuplicateLesson.lessonContent$lambda$0$2(this$0, arg_0, arg_1)));
        lessonContext.task("EditorDeleteLine", (Function2<? super TaskContext, ? super String, Unit>)((Function2)DuplicateLesson::lessonContent$lambda$0$3));
        return Unit.INSTANCE;
    }
}

