/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.model.Pointer;
import com.intellij.navigation.NavigatableSymbol;
import com.intellij.navigation.SymbolNavigationService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\nH\u0016J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0017H$J\u0014\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0082\u0004J\n\u0010!\u001a\u00020\"H\u0096\u0080\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\u000b\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0012\u0010\r\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectSymbol;", "Lcom/intellij/navigation/NavigatableSymbol;", "Lcom/intellij/find/usages/api/SearchTarget;", "rootProjectPath", "", "<init>", "(Ljava/lang/String;)V", "getRootProjectPath", "()Ljava/lang/String;", "createPointer", "Lcom/intellij/model/Pointer;", "projectName", "getProjectName", "qualifiedName", "getQualifiedName", "getNavigationTargets", "", "Lcom/intellij/platform/backend/navigation/NavigationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "findBuildFile", "Lcom/intellij/psi/PsiFile;", "externalProject", "Lorg/jetbrains/plugins/gradle/model/ExternalProject;", "rootProject", "usageHandler", "Lcom/intellij/find/usages/api/UsageHandler;", "getUsageHandler", "()Lcom/intellij/find/usages/api/UsageHandler;", "equals", "", "other", "", "hashCode", "", "intellij.gradle.java"})
@ApiStatus.Internal
public abstract class GradleProjectSymbol
implements NavigatableSymbol,
SearchTarget {
    @NotNull
    private final String rootProjectPath;

    public GradleProjectSymbol(@NotNull String rootProjectPath) {
        Intrinsics.checkNotNullParameter((Object)rootProjectPath, (String)"rootProjectPath");
        this.rootProjectPath = rootProjectPath;
        if (!(!StringsKt.isBlank((CharSequence)this.rootProjectPath))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    protected final String getRootProjectPath() {
        return this.rootProjectPath;
    }

    @NotNull
    public Pointer<? extends GradleProjectSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
        return pointer;
    }

    @NotNull
    public abstract String getProjectName();

    @NotNull
    public abstract String getQualifiedName();

    @NotNull
    public final Collection<NavigationTarget> getNavigationTargets(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiFile psiFile = this.findBuildFile(project);
        if (psiFile == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile psiFile2 = psiFile;
        return CollectionsKt.listOf((Object)SymbolNavigationService.getInstance().psiFileNavigationTarget(psiFile2));
    }

    private final PsiFile findBuildFile(Project project) {
        ExternalProject externalProject = ExternalProjectDataCache.getInstance((Project)project).getRootExternalProject(this.rootProjectPath);
        if (externalProject == null) {
            return null;
        }
        ExternalProject rootProject = externalProject;
        Object object = this.externalProject(rootProject);
        if (object == null || (object = object.getBuildFile()) == null) {
            return null;
        }
        Object buildFile = object;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile((File)buildFile);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return PsiManager.getInstance((Project)project).findFile(virtualFile2);
    }

    @Nullable
    protected abstract ExternalProject externalProject(@NotNull ExternalProject var1);

    @NotNull
    public UsageHandler getUsageHandler() {
        UsageHandler usageHandler = UsageHandler.createEmptyUsageHandler((String)this.getProjectName());
        Intrinsics.checkNotNullExpressionValue((Object)usageHandler, (String)"createEmptyUsageHandler(...)");
        return usageHandler;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gradle.service.resolve.GradleProjectSymbol");
        GradleProjectSymbol cfr_ignored_0 = (GradleProjectSymbol)object2;
        return Intrinsics.areEqual((Object)this.rootProjectPath, (Object)((GradleProjectSymbol)other).rootProjectPath);
    }

    public int hashCode() {
        return this.rootProjectPath.hashCode();
    }
}

