/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.LocalFileSystemFileFinder;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.execution.JSLocalFilesMappingPanel;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.PortField;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.CollapsibleRow;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.SmartList;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.debugger.wip.BrowserChromeDebugProcess;
import com.jetbrains.debugger.wip.HttpInetSocketAddress;
import com.jetbrains.debugger.wip.JSRemoteDebugConfigurationKt;
import com.jetbrains.debugger.wip.WipWithExclusiveWebsocketChannelVmConnection;
import java.awt.BorderLayout;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebuggableRunConfiguration;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.wip.WipVm;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005:\u0001DB\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0*H\u0016J\u001a\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020+H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0002H\u0016J\u0010\u00106\u001a\u0002042\u0006\u00105\u001a\u00020\u0002H\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020-H\u0016J*\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u0002082\u0006\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u000201H\u0016J\"\u0010B\u001a\u00020C2\u0006\u0010<\u001a\u0002082\u0006\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010@H\u0002R*\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001e\"\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R,\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020%0$8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006E"}, d2={"Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lorg/jdom/Element;", "Lcom/intellij/execution/runners/RunConfigurationWithSuppressedDefaultRunAction;", "Lcom/intellij/javascript/JSRunProfileWithCompileBeforeLaunchOption;", "Lorg/jetbrains/debugger/DebuggableRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "value", "host", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "port", "", "getPort", "()I", "setPort", "(I)V", "isV8Legacy", "", "isV8Legacy$annotations", "()V", "()Z", "setV8Legacy", "(Z)V", "restartOnDisconnect", "getRestartOnDisconnect", "setRestartOnDisconnect", "", "Lcom/intellij/javascript/debugger/execution/RemoteUrlMappingBean;", "mappings", "getMappings", "()Ljava/util/List;", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "clone", "readExternal", "", "element", "writeExternal", "computeDebugAddress", "Ljava/net/InetSocketAddress;", "state", "createDebugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "socketAddress", "session", "Lcom/intellij/xdebugger/XDebugSession;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "environment", "createWipDebugProcess", "Lcom/jetbrains/debugger/wip/BrowserChromeDebugProcess;", "WipRemoteDebugConfigurationSettingsEditor", "intellij.javascript.debugger.backend"})
public final class JSRemoteDebugConfiguration
extends LocatableConfigurationBase<Element>
implements RunConfigurationWithSuppressedDefaultRunAction,
JSRunProfileWithCompileBeforeLaunchOption,
DebuggableRunConfiguration {
    @Attribute
    @Nullable
    private String host;
    @Attribute
    private int port;
    private boolean isV8Legacy;
    @Attribute
    private boolean restartOnDisconnect;
    @Property(surroundWithTag=false)
    @XCollection
    @NotNull
    private List<RemoteUrlMappingBean> mappings;

    public JSRemoteDebugConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(project, factory, name);
        this.port = 9229;
        this.mappings = (List)new SmartList();
    }

    @Nullable
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@Nullable String value) {
        this.host = StringUtil.isEmpty((String)value) || Intrinsics.areEqual((Object)value, (Object)"localhost") || Intrinsics.areEqual((Object)value, (Object)"127.0.0.1") ? null : value;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    public final boolean isV8Legacy() {
        return this.isV8Legacy;
    }

    public final void setV8Legacy(boolean bl) {
        this.isV8Legacy = bl;
    }

    @Deprecated(message="V8 protocol is deprecated, please use WIP", level=DeprecationLevel.ERROR)
    public static /* synthetic */ void isV8Legacy$annotations() {
    }

    public final boolean getRestartOnDisconnect() {
        return this.restartOnDisconnect;
    }

    public final void setRestartOnDisconnect(boolean bl) {
        this.restartOnDisconnect = bl;
    }

    @NotNull
    public final List<RemoteUrlMappingBean> getMappings() {
        return this.mappings;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new WipRemoteDebugConfigurationSettingsEditor();
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        return EmptyRunProfileState.INSTANCE;
    }

    @NotNull
    public RunConfiguration clone() {
        RunConfiguration runConfiguration = super.clone();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.debugger.wip.JSRemoteDebugConfiguration");
        JSRemoteDebugConfiguration configuration = (JSRemoteDebugConfiguration)runConfiguration;
        configuration.setHost(this.host);
        configuration.port = this.port;
        configuration.restartOnDisconnect = this.restartOnDisconnect;
        configuration.mappings = (List)new SmartList((Collection)this.mappings);
        return (RunConfiguration)configuration;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)((Object)this), (Element)element);
        if (this.port <= 0) {
            this.port = 9229;
        }
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)((Object)this), (Element)element, (SerializationFilter)((SerializationFilter)JSRemoteDebugConfigurationKt.access$getSERIALIZATION_FILTER$p()));
    }

    @NotNull
    public InetSocketAddress computeDebugAddress(@NotNull RunProfileState state) {
        InetSocketAddress inetSocketAddress;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String string = this.host;
        if (string != null) {
            String it = string;
            boolean bl = false;
            inetSocketAddress = new HttpInetSocketAddress(it, this.port);
        } else {
            InetAddress inetAddress = InetAddress.getLoopbackAddress();
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getLoopbackAddress(...)");
            inetSocketAddress = new HttpInetSocketAddress(inetAddress, this.port);
        }
        return inetSocketAddress;
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)socketAddress, (String)"socketAddress");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        JavaScriptDebugProcess debugProcess = this.createWipDebugProcess(socketAddress, session, executionResult);
        if (this.restartOnDisconnect) {
            debugProcess.getConnection().stateChanged(arg_0 -> JSRemoteDebugConfiguration.createDebugProcess$lambda$0(session, arg_0));
        }
        return debugProcess;
    }

    private final BrowserChromeDebugProcess createWipDebugProcess(InetSocketAddress socketAddress, XDebugSession session, ExecutionResult executionResult) {
        WipWithExclusiveWebsocketChannelVmConnection connection2 = new WipWithExclusiveWebsocketChannelVmConnection();
        RemoteDebuggingFileFinder finder = new RemoteDebuggingFileFinder(RemoteDebuggingFileFinderKt.createUrlToLocalMap(this.mappings), new LocalFileSystemFileFinder());
        BrowserChromeDebugProcess process = new BrowserChromeDebugProcess(session, (DebuggableFileFinder)finder, (VmConnection<? extends WipVm>)((VmConnection)connection2), executionResult);
        RemoteVmConnection.open$default((RemoteVmConnection)connection2, (InetSocketAddress)socketAddress, null, (int)2, null);
        return process;
    }

    private static final void createDebugProcess$lambda$0$0(XDebugSession $session) {
        ExecutionUtil.restart((RunContentDescriptor)$session.getRunContentDescriptor());
    }

    private static final Unit createDebugProcess$lambda$0(XDebugSession $session, ConnectionState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getStatus() == ConnectionStatus.DISCONNECTED && !Intrinsics.areEqual((Object)$session.getDebugProcess().getProcessHandler().getUserData(ProcessHandler.TERMINATION_REQUESTED), (Object)true)) {
            AppUIUtil.invokeOnEdt(() -> JSRemoteDebugConfiguration.createDebugProcess$lambda$0$0($session));
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration$WipRemoteDebugConfigurationSettingsEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration;", "<init>", "(Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration;)V", "hostField", "Ljavax/swing/JTextField;", "kotlin.jvm.PlatformType", "portField", "Lcom/intellij/ui/PortField;", "restartOnDisconnectCheckbox", "Lcom/intellij/ui/components/JBCheckBox;", "filesMappingPanel", "Lcom/intellij/javascript/debugger/execution/JSLocalFilesMappingPanel;", "resetEditorFrom", "", "configuration", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "intellij.javascript.debugger.backend"})
    private final class WipRemoteDebugConfigurationSettingsEditor
    extends SettingsEditor<JSRemoteDebugConfiguration> {
        private final JTextField hostField = GuiUtils.createUndoableTextField();
        @NotNull
        private final PortField portField = new PortField(9229, 1024);
        private JBCheckBox restartOnDisconnectCheckbox;
        @NotNull
        private final JSLocalFilesMappingPanel filesMappingPanel;

        public WipRemoteDebugConfigurationSettingsEditor() {
            Project project = JSRemoteDebugConfiguration.this.getProject();
            BorderLayout borderLayout = new BorderLayout();
            this.filesMappingPanel = new JSLocalFilesMappingPanel(project, borderLayout){
                {
                    Intrinsics.checkNotNull((Object)$super_call_param$1);
                    super($super_call_param$1, $super_call_param$2);
                }

                @Override
                public void initUI() {
                    this.add(this.getMappingTreePanel());
                    super.initUI();
                }

                @Override
                public String getBaseUrl() {
                    String string = hostField.getText();
                    if (string == null) {
                        return super.getBaseUrl();
                    }
                    String host = string;
                    int port = portField.getNumber();
                    return "http://" + host + ":" + port + "/";
                }
            };
        }

        protected void resetEditorFrom(@NotNull JSRemoteDebugConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            this.hostField.setText(StringUtil.notNullize((String)configuration.getHost(), (String)"localhost"));
            this.portField.setNumber(configuration.getPort());
            JBCheckBox jBCheckBox = this.restartOnDisconnectCheckbox;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"restartOnDisconnectCheckbox");
                jBCheckBox = null;
            }
            jBCheckBox.setSelected(configuration.getRestartOnDisconnect());
            this.filesMappingPanel.resetEditorFrom(configuration.getMappings(), true);
        }

        protected void applyEditorTo(@NotNull JSRemoteDebugConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            configuration.setHost(this.hostField.getText());
            configuration.setPort(this.portField.getNumber());
            JBCheckBox jBCheckBox = this.restartOnDisconnectCheckbox;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"restartOnDisconnectCheckbox");
                jBCheckBox = null;
            }
            configuration.setRestartOnDisconnect(jBCheckBox.isSelected());
            this.filesMappingPanel.applyEditorTo(JSRemoteDebugConfiguration.this.getMappings(), (RunConfiguration)configuration);
        }

        @NotNull
        protected JComponent createEditor() {
            this.filesMappingPanel.initUI();
            return (JComponent)BuilderKt.panel(arg_0 -> WipRemoteDebugConfigurationSettingsEditor.createEditor$lambda$0(this, arg_0));
        }

        private static final Unit createEditor$lambda$0$3$0(WipRemoteDebugConfigurationSettingsEditor this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell((JComponent)this$0.filesMappingPanel).align((Align)AlignX.FILL.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit createEditor$lambda$0$0(WipRemoteDebugConfigurationSettingsEditor this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            JTextField jTextField = this$0.hostField;
            Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"hostField");
            $this$row.cell((JComponent)jTextField).align((Align)AlignX.FILL.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit createEditor$lambda$0$1(WipRemoteDebugConfigurationSettingsEditor this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell((JComponent)this$0.portField);
            return Unit.INSTANCE;
        }

        private static final Unit createEditor$lambda$0$2(WipRemoteDebugConfigurationSettingsEditor this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            String string = JSDebuggerBundle.message("js.remote.debug.restart.on.disconnect", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this$0.restartOnDisconnectCheckbox = (JBCheckBox)$this$row.checkBox(string).getComponent();
            return Unit.INSTANCE;
        }

        private static final Unit createEditor$lambda$0$3(WipRemoteDebugConfigurationSettingsEditor this$0, Panel $this$collapsibleGroup) {
            Intrinsics.checkNotNullParameter((Object)$this$collapsibleGroup, (String)"$this$collapsibleGroup");
            Panel.row$default((Panel)$this$collapsibleGroup, null, arg_0 -> WipRemoteDebugConfigurationSettingsEditor.createEditor$lambda$0$3$0(this$0, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit createEditor$lambda$0(WipRemoteDebugConfigurationSettingsEditor this$0, Panel $this$panel) {
            CollapsibleRow collapsibleRow;
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            String string = JSDebuggerBundle.message("js.remote.debug.host", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$panel.row(string, arg_0 -> WipRemoteDebugConfigurationSettingsEditor.createEditor$lambda$0$0(this$0, arg_0));
            String string2 = JSDebuggerBundle.message("js.remote.debug.port", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            $this$panel.row(string2, arg_0 -> WipRemoteDebugConfigurationSettingsEditor.createEditor$lambda$0$1(this$0, arg_0));
            Panel.row$default((Panel)$this$panel, null, arg_0 -> WipRemoteDebugConfigurationSettingsEditor.createEditor$lambda$0$2(this$0, arg_0), (int)1, null);
            String string3 = JSDebuggerBundle.message("label.text.remote.urls.of.local.files", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            CollapsibleRow $this$createEditor_u24lambda_u240_u244 = collapsibleRow = Panel.collapsibleGroup$default((Panel)$this$panel, (String)string3, (boolean)false, arg_0 -> WipRemoteDebugConfigurationSettingsEditor.createEditor$lambda$0$3(this$0, arg_0), (int)2, null);
            boolean bl = false;
            $this$createEditor_u24lambda_u240_u244.setExpanded(true);
            return Unit.INSTANCE;
        }
    }
}

