/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.quic;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.platform.commercial.dependencies.QuicheDependencyDownloader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/split/connection/network/quic/QuicheBinariesLocator;", "", "<init>", "()V", "getLibrarySearchRoot", "Ljava/nio/file/Path;", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nBundledQuicheBinariesLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundledQuicheBinariesLocator.kt\ncom/intellij/platform/split/connection/network/quic/QuicheBinariesLocator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class QuicheBinariesLocator {
    @NotNull
    public static final QuicheBinariesLocator INSTANCE = new QuicheBinariesLocator();

    private QuicheBinariesLocator() {
    }

    @NotNull
    public final Path getLibrarySearchRoot() {
        if (PluginManagerCore.isRunningFromSources()) {
            Object communityRoot;
            try {
                Path path = Path.of(PathManager.getCommunityHomePath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                communityRoot = new BuildDependenciesCommunityRoot(path);
                communityRoot = (Path)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>((BuildDependenciesCommunityRoot)communityRoot, null){
                    int label;
                    final /* synthetic */ BuildDependenciesCommunityRoot $communityRoot;
                    {
                        this.$communityRoot = $communityRoot;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = QuicheDependencyDownloader.INSTANCE.downloadQuicheBin(this.$communityRoot, (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            catch (Throwable e) {
                throw new IllegalStateException("Failed to download Quiche", e);
            }
            Object quicheBinPath2 = communityRoot;
            Path quicheDebugBinaries = quicheBinPath2.resolve("debug");
            Path dll1 = quicheDebugBinaries.resolve("quiche.dll");
            Path dll2 = quicheDebugBinaries.resolve("win32-x86-64").resolve("quiche.dll");
            if (!(Files.exists(dll1, new LinkOption[0]) || Files.exists(dll2, new LinkOption[0]))) {
                boolean bl = false;
                String string = "Internal error: " + dll2 + " or " + dll1 + " are both missing after extracting quiche bin";
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNull((Object)quicheDebugBinaries);
            return quicheDebugBinaries;
        }
        PluginDescriptor plugin = PluginManager.getPluginByClass(this.getClass());
        if (plugin != null) {
            Path pluginPath = plugin.getPluginPath();
            if (pluginPath != null) {
                Path quichePath = pluginPath.resolve("quiche-native");
                Intrinsics.checkNotNull((Object)quichePath);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(quichePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return quichePath;
                }
                throw new IllegalStateException(("Unable to find Quiche native libraries at " + pluginPath).toString());
            }
            throw new IllegalStateException(("Unable to find plugin path by plugin " + plugin.getPluginId()).toString());
        }
        String[] quichePath = new String[]{"quiche-native"};
        Path nativePath = Paths.get(PathManager.getLibPath(), quichePath);
        String[] stringArray = new String[]{"cwm-plugin/quiche-native"};
        Path embeddedClientPath = Paths.get(PathManager.getPreInstalledPluginsPath(), stringArray);
        Intrinsics.checkNotNull((Object)nativePath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(nativePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return nativePath;
        }
        Intrinsics.checkNotNull((Object)embeddedClientPath);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.isDirectory(embeddedClientPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            return embeddedClientPath;
        }
        throw new IllegalStateException(("Unable to find Quiche native libraries at " + nativePath + " and " + embeddedClientPath).toString());
    }
}

