/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.channel;

import com.intellij.platform.split.connection.protocol.channel.BufferedByteChannelKt;
import com.intellij.platform.split.connection.protocol.transport.NamedTransportEntity;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.rd.platform.util.ByteBufferExKt;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.RdDefaultErrorLoggerHolder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channel;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import tlschannel.NeedsWriteException;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u00020\u00042\u00020\u0002B'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0012H\u0016J\u0014\u0010\"\u001a\u00020\u001c2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&H\u0002J\u001e\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00152\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120*H\u0002J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006,"}, d2={"Lcom/intellij/platform/split/connection/protocol/channel/BufferedByteChannel;", "T", "Ljava/nio/channels/ByteChannel;", "Ljava/nio/channels/GatheringByteChannel;", "Lcom/intellij/platform/split/connection/protocol/transport/NamedTransportEntity;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "id", "", "underlying", "mergingTimeSpan", "Lkotlin/time/Duration;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;Ljava/nio/channels/ByteChannel;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "Ljava/nio/channels/ByteChannel;", "J", "buffersQueue", "Ljava/util/concurrent/BlockingQueue;", "Ljava/nio/ByteBuffer;", "lastWriteException", "Ljava/util/concurrent/atomic/AtomicReference;", "", "name", "getName", "()Ljava/lang/String;", "isOpen", "", "close", "", "read", "", "dst", "write", "src", "completeBuffersQueue", "firstElement", "onTermination", "flushThread", "Ljava/lang/Thread;", "handleCloseException", "t", "buffers", "", "handleBrokenPipeException", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nBufferedByteChannel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferedByteChannel.kt\ncom/intellij/platform/split/connection/protocol/channel/BufferedByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n*L\n1#1,199:1\n67#2,4:200\n67#2,4:204\n67#2,4:208\n67#2,4:212\n67#2,4:219\n67#2,4:226\n67#2,4:233\n67#2,4:237\n60#2,5:241\n60#2,5:246\n1#3:216\n37#4,2:217\n1807#5,3:223\n1807#5,3:230\n137#6:251\n135#6:252\n117#6,7:253\n136#6:260\n*S KotlinDebug\n*F\n+ 1 BufferedByteChannel.kt\ncom/intellij/platform/split/connection/protocol/channel/BufferedByteChannel\n*L\n89#1:200,4\n98#1:204,4\n104#1:208,4\n112#1:212,4\n126#1:219,4\n158#1:226,4\n54#1:233,4\n59#1:237,4\n71#1:241,5\n77#1:246,5\n125#1:217,2\n130#1:223,3\n174#1:230,3\n160#1:251\n160#1:252\n160#1:253,7\n160#1:260\n*E\n"})
public final class BufferedByteChannel<T extends ByteChannel & GatheringByteChannel>
implements NamedTransportEntity,
ByteChannel {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final String id;
    @NotNull
    private final T underlying;
    private final long mergingTimeSpan;
    @NotNull
    private final BlockingQueue<ByteBuffer> buffersQueue;
    @NotNull
    private final AtomicReference<Throwable> lastWriteException;
    @NotNull
    private final String name;

    private BufferedByteChannel(Lifetime lifetime, String id, T underlying, long mergingTimeSpan) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(underlying, (String)"underlying");
        this.lifetime = lifetime;
        this.id = id;
        this.underlying = underlying;
        this.mergingTimeSpan = mergingTimeSpan;
        this.buffersQueue = new LinkedBlockingQueue();
        this.lastWriteException = new AtomicReference();
        this.name = "Buffered Channel (id: " + this.id + ")";
        Thread flushThread = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)("Flush:" + this.id), (int)10, () -> BufferedByteChannel._init_$lambda$0(this), (int)5, null);
        this.lifetime.onTerminationIfAlive(() -> BufferedByteChannel._init_$lambda$1(this, flushThread));
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isOpen() {
        T t = this.underlying;
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type java.nio.channels.ByteChannel");
        return t.isOpen();
    }

    @Override
    public void close() {
        com.intellij.openapi.diagnostic.Logger $this$trace$iv = BufferedByteChannelKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            com.intellij.openapi.diagnostic.Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Close channel");
        }
        ((Channel)this.underlying).close();
    }

    @Override
    public int read(@NotNull ByteBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        return ((ReadableByteChannel)this.underlying).read(dst);
    }

    @Override
    public int write(@NotNull ByteBuffer src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (!this.isOpen() || RLifetimeKt.isNotAlive((Lifetime)this.lifetime)) {
            com.intellij.openapi.diagnostic.Logger $this$trace$iv = BufferedByteChannelKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                com.intellij.openapi.diagnostic.Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace(this.getName() + " Write. before ClosedChannelException. is open: " + this.isOpen() + ", lifetime.isAlive: " + RLifetimeKt.isAlive((Lifetime)this.lifetime));
            }
            throw new ClosedChannelException();
        }
        Throwable throwable = this.lastWriteException.get();
        if (throwable != null) {
            com.intellij.openapi.diagnostic.Logger $this$trace$iv = BufferedByteChannelKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                com.intellij.openapi.diagnostic.Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace(this.getName() + " Last exception is set. Unable to write. Rethrow the last exception.");
            }
            throw throwable;
        }
        int remaining = src.remaining();
        if (remaining <= 0) {
            return 0;
        }
        this.buffersQueue.put(ByteBuffer.wrap(ByteBufferExKt.copyRemaining((ByteBuffer)src)));
        com.intellij.openapi.diagnostic.Logger $this$trace$iv = BufferedByteChannelKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            com.intellij.openapi.diagnostic.Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Queued " + remaining + " bytes");
        }
        return remaining;
    }

    /*
     * WARNING - void declaration
     */
    private final void completeBuffersQueue(ByteBuffer firstElement) {
        List buffers = new ArrayList();
        ByteBuffer byteBuffer = firstElement;
        if (byteBuffer != null) {
            ByteBuffer it = byteBuffer;
            boolean bl = false;
            buffers.add(it);
        }
        this.buffersQueue.drainTo(buffers);
        if (buffers.isEmpty()) {
            return;
        }
        try {
            Collection $this$toTypedArray$iv = buffers;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ByteBuffer[] buffersArray = thisCollection$iv.toArray(new ByteBuffer[0]);
            com.intellij.openapi.diagnostic.Logger $this$trace$iv = BufferedByteChannelKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                int n;
                com.intellij.openapi.diagnostic.Logger logger = $this$trace$iv;
                boolean bl = false;
                Iterable iterable = buffers;
                String string = this.getName();
                int n2 = 0;
                for (Object t : iterable) {
                    void it;
                    ByteBuffer byteBuffer2 = (ByteBuffer)t;
                    n = n2;
                    boolean bl2 = false;
                    int n3 = it.remaining();
                    n2 = n + n3;
                }
                n = n2;
                logger.trace(string + " Flushing " + n + " bytes");
            }
            while (true) {
                boolean bl;
                block15: {
                    Iterable $this$any$iv = buffers;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ByteBuffer it = (ByteBuffer)element$iv;
                            boolean bl3 = false;
                            if (!it.hasRemaining()) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    long l = ((GatheringByteChannel)this.underlying).write(buffersArray);
                    continue;
                }
                break;
            }
        }
        catch (ClosedByInterruptException e) {
            this.handleCloseException(e, buffers);
        }
        catch (InterruptedException e) {
            this.handleCloseException(e, buffers);
        }
        catch (ClosedChannelException e) {
            this.handleCloseException(e, buffers);
        }
        catch (NeedsWriteException e) {
            this.handleCloseException(e, buffers);
        }
        catch (Throwable t) {
            this.handleBrokenPipeException(t);
            this.handleCloseException(t, buffers);
        }
    }

    static /* synthetic */ void completeBuffersQueue$default(BufferedByteChannel bufferedByteChannel, ByteBuffer byteBuffer, int n, Object object) {
        if ((n & 1) != 0) {
            byteBuffer = null;
        }
        bufferedByteChannel.completeBuffersQueue(byteBuffer);
    }

    private final void onTermination(Thread flushThread) {
        com.intellij.openapi.diagnostic.Logger $this$trace$iv = BufferedByteChannelKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            com.intellij.openapi.diagnostic.Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Channel is going to be terminated.");
        }
        AppExecutorUtil.getAppExecutorService().execute(() -> BufferedByteChannel.onTermination$lambda$1(flushThread, this));
    }

    private final void handleCloseException(Throwable t, List<? extends ByteBuffer> buffers) {
        boolean bl;
        block5: {
            BufferedByteChannelKt.access$getLogger$p().warn(this.getName() + " going to close channel due to exception", t);
            Iterable $this$any$iv = buffers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ByteBuffer it = (ByteBuffer)element$iv;
                    boolean bl2 = false;
                    if (!it.hasRemaining()) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            BufferedByteChannelKt.access$getLogger$p().warn(this.getName() + " some data were not written to underlying channel since channel was closed");
        }
        if (this.isOpen()) {
            BufferedByteChannelKt.access$getLogger$p().info(this.getName() + " Closing the Byte Buffer channel.");
            this.close();
        }
    }

    private final void handleBrokenPipeException(Throwable t) {
        String string = t.getMessage();
        boolean bl = string != null ? StringsKt.contains((CharSequence)string, (CharSequence)"Broken pipe", (boolean)true) : false;
        if (bl) {
            BufferedByteChannelKt.access$getLogger$p().warn(this.getName() + " broken pipe exception detected. Is channel open: " + this.isOpen());
        } else {
            BufferedByteChannelKt.access$getLogger$p().warn(this.getName() + " error writing to underlying channel. Subsequent writes will fail", t);
            this.lastWriteException.set(t);
        }
    }

    private static final Unit _init_$lambda$0(BufferedByteChannel this$0) {
        com.intellij.openapi.diagnostic.Logger logger;
        BufferedByteChannelKt.access$getLogger$p().debug("Buffered Channel (id: " + this$0.id + ") FLUSH: thread start");
        try {
            while (this$0.lastWriteException.get() == null && !Thread.currentThread().isInterrupted()) {
                com.intellij.openapi.diagnostic.Logger $this$trace$iv = BufferedByteChannelKt.access$getLogger$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace(this$0.getName() + " FLUSH: poll");
                }
                ByteBuffer firstElement = this$0.buffersQueue.poll(1000L, TimeUnit.MILLISECONDS);
                com.intellij.openapi.diagnostic.Logger $this$trace$iv2 = BufferedByteChannelKt.access$getLogger$p();
                boolean $i$f$trace2 = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    logger = $this$trace$iv2;
                    boolean bl = false;
                    logger.trace(this$0.getName() + " FLUSH: awake, buffersQueue.size = " + this$0.buffersQueue.size());
                }
                Thread.sleep(Duration.toLong-impl((long)this$0.mergingTimeSpan, (DurationUnit)DurationUnit.MILLISECONDS));
                this$0.completeBuffersQueue(firstElement);
                while (!this$0.buffersQueue.isEmpty() && this$0.lastWriteException.get() == null) {
                    BufferedByteChannel.completeBuffersQueue$default(this$0, null, 1, null);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            com.intellij.openapi.diagnostic.Logger $this$debug_u24default$iv = BufferedByteChannelKt.access$getLogger$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug(this$0.getName() + " FLUSH: thread got interrupted", t$iv);
            }
        }
        catch (Throwable t) {
            BufferedByteChannelKt.access$getLogger$p().error(this$0.getName() + " Uncaught exception in BufferedByteChannel. FLUSH Thread: " + t.getMessage(), t);
        }
        com.intellij.openapi.diagnostic.Logger $this$debug_u24default$iv = BufferedByteChannelKt.access$getLogger$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug(this$0.getName() + " FLUSH: thread exit", t$iv);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(BufferedByteChannel this$0, Thread $flushThread) {
        this$0.onTermination($flushThread);
        return Unit.INSTANCE;
    }

    private static final void onTermination$lambda$1(Thread $flushThread, BufferedByteChannel this$0) {
        boolean $i$f$catch = false;
        Object comment$iv$iv = null;
        boolean $i$f$catch2 = false;
        Logger $this$catch$iv$iv$iv = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
        boolean $i$f$catch3 = false;
        try {
            boolean bl = false;
            $flushThread.join(500L);
            $flushThread.interrupt();
            $flushThread.join(500L);
            if ($flushThread.isAlive()) {
                BufferedByteChannelKt.access$getLogger$p().warn(this$0.getName() + " Flush Thread is still alive after lifetime termination");
            }
        }
        catch (Throwable e$iv$iv$iv) {
            String sfx$iv$iv$iv = e$iv$iv$iv.getClass().getName() + " " + e$iv$iv$iv.getMessage() + "";
            LoggerKt.error((Logger)$this$catch$iv$iv$iv, (String)("Catch " + sfx$iv$iv$iv), (Throwable)e$iv$iv$iv);
        }
    }

    public /* synthetic */ BufferedByteChannel(Lifetime lifetime, String id, ByteChannel underlying, long mergingTimeSpan, DefaultConstructorMarker $constructor_marker) {
        this(lifetime, id, underlying, mergingTimeSpan);
    }
}

