/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.wire;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.IPropertyViewWithFlow;
import com.intellij.platform.split.connection.protocol.ConnectionState;
import com.intellij.platform.split.connection.protocol.ConnectionStateProperty;
import com.intellij.platform.split.connection.protocol.ICodeWithMeWire;
import com.intellij.platform.split.connection.protocol.IPasswordAuthHandler;
import com.intellij.platform.split.connection.protocol.PeerVisibleErrorCode;
import com.intellij.platform.split.connection.protocol.ServiceMessageProcessor;
import com.intellij.platform.split.connection.protocol.WireConnectStatus;
import com.intellij.platform.split.connection.protocol.channel.frame.AcceptedFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.AcknowledgedFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.ForceTerminateWireFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.Frame;
import com.intellij.platform.split.connection.protocol.channel.frame.FrameFactory;
import com.intellij.platform.split.connection.protocol.channel.frame.JoinPinFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.MessageFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.PasswordRequiredFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.PingFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.SessionTokenFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.SystemFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.UnexpectedFrameException;
import com.intellij.platform.split.connection.protocol.transport.NamedTransportEntity;
import com.intellij.platform.split.connection.protocol.transport.WireTransportListener;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportInfo;
import com.intellij.platform.split.connection.protocol.transport.stats.TransportStatisticsData;
import com.intellij.platform.split.connection.protocol.wire.SecureWireOverStreamTransport;
import com.intellij.platform.split.connection.protocol.wire.SecureWireOverStreamTransportKt;
import com.intellij.platform.split.connection.protocol.wire.SecureWireWritable;
import com.intellij.platform.split.connection.protocol.wire.SessionTokenHandler;
import com.intellij.platform.split.connection.protocol.wire.WireStatsCounter;
import com.intellij.platform.split.connection.protocol.wire.WireStatsCounterImpl;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.AbstractBuffer;
import com.jetbrains.rd.framework.MessageBroker;
import com.jetbrains.rd.framework.RdId;
import com.jetbrains.rd.framework.SerializersKt;
import com.jetbrains.rd.framework.UnsafeBuffer;
import com.jetbrains.rd.framework.base.IRdWireable;
import com.jetbrains.rd.framework.impl.ProtocolContexts;
import com.jetbrains.rd.platform.protocol.EdtScheduler;
import com.jetbrains.rd.protocol.PermittedModalityProtocolEntities;
import com.jetbrains.rd.util.Maybe;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.LifetimeStatus;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.PropertyCombinatorsKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.coroutines.ISourceCoroutineUtilKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import java.lang.invoke.LambdaMetafactory;
import java.nio.channels.ClosedChannelException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00b6\u00012\u00020\u0001:\u0004\u00b5\u0001\u00b6\u0001B\u00ce\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00124\b\u0002\u0010\u000e\u001a.\u0012\u0004\u0012\u00020\u0000\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u000f\u00a2\u0006\u0002\b\u0016\u0012I\b\u0002\u0010\u0017\u001aC\u0012\u0004\u0012\u00020\u0000\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b0\u0018\u00a2\u0006\u0002\b\u0016\u0012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u0012\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0004\b \u0010!J\u0019\u0010w\u001a\u0004\u0018\u00010x2\u0006\u0010y\u001a\u00020zH\u0016\u00a2\u0006\u0004\b{\u0010|J\u0018\u0010}\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010~\u001a\u00020xH\u0016J\u0010\u0010\u007f\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0080\u0001\u001a\u00020\u001b2\u0007\u0010\u0081\u0001\u001a\u000200H\u0016J\t\u0010\u0082\u0001\u001a\u00020\u001bH\u0016J\t\u0010\u0083\u0001\u001a\u00020\u001bH\u0016J\t\u0010\u0084\u0001\u001a\u00020\u001bH\u0002J1\u0010\u0085\u0001\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020z2\u0015\u0010\u0086\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u0088\u0001\u0012\u0004\u0012\u00020\u001b0\u0087\u0001H\u0016\u00a2\u0006\u0006\b\u0089\u0001\u0010\u008a\u0001J\u000b\u0010\u008b\u0001\u001a\u00020\u0007H\u0096\u0080\u0004J\t\u0010\u008c\u0001\u001a\u00020\u001bH\u0002J\u0013\u0010\u008d\u0001\u001a\u00020\u001b2\b\u0010\u008e\u0001\u001a\u00030\u008f\u0001H\u0002J\u0013\u0010\u0090\u0001\u001a\u00020\u001b2\b\u0010\u008e\u0001\u001a\u00030\u0091\u0001H\u0002J\u0013\u0010\u0092\u0001\u001a\u00020\u001b2\b\u0010\u008e\u0001\u001a\u00030\u0093\u0001H\u0002J\u0012\u0010\u0094\u0001\u001a\u00020\u001b2\u0007\u0010\u0095\u0001\u001a\u00020SH\u0002J\u001d\u0010\u0096\u0001\u001a\u00020\u001b2\t\u0010\u0097\u0001\u001a\u0004\u0018\u00010S2\u0007\u0010\u0098\u0001\u001a\u00020SH\u0002J\u0011\u0010\u0099\u0001\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0011\u0010\u009a\u0001\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0011\u0010\u009b\u0001\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u009c\u0001\u001a\u00020\u001b2\t\u0010\u009d\u0001\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\u009e\u0001\u001a\u00020SH\u0082@\u00a2\u0006\u0003\u0010\u009f\u0001J\u0011\u0010\u00a0\u0001\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u00a1\u0001\u001a\u00020\r2\u0007\u0010\u0095\u0001\u001a\u00020SH\u0002J\u0018\u0010\u00a2\u0001\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0082@\u00a2\u0006\u0003\u0010\u00a3\u0001J'\u0010\u00a4\u0001\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\r\u0010\u00a5\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0082@\u00a2\u0006\u0003\u0010\u00a6\u0001J\u0010\u0010\u00a7\u0001\u001a\u00020\u001bH\u0082@\u00a2\u0006\u0003\u0010\u009f\u0001J\u0011\u0010\u00a8\u0001\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001f\u0010\u00a9\u0001\u001a\u00020\u001b2\r\u0010\u00a5\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0082@\u00a2\u0006\u0003\u0010\u00aa\u0001J\u001a\u0010\u00ab\u0001\u001a\u00020\u001b2\b\u0010\u008e\u0001\u001a\u00030\u0091\u0001H\u0082@\u00a2\u0006\u0003\u0010\u00ac\u0001J\t\u0010\u00ad\u0001\u001a\u00020\u001bH\u0002J\u0013\u0010\u00ae\u0001\u001a\u00020\u001b2\b\u0010\u00af\u0001\u001a\u00030\u00b0\u0001H\u0002J\u0018\u0010\u00b1\u0001\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0082@\u00a2\u0006\u0003\u0010\u00a3\u0001J\u0011\u0010\u00b2\u0001\u001a\u00030\u00b3\u0001H\u0082@\u00a2\u0006\u0003\u0010\u009f\u0001J\t\u0010\u00b4\u0001\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u000e\u001a.\u0012\u0004\u0012\u00020\u0000\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u000f\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000RO\u0010\u0017\u001aC\u0012\u0004\u0012\u00020\u0000\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b0\u0018\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010\u0013\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010'R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b06X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010=\u001a\b\u0012\u0004\u0012\u00020>06X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010A\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u0014\u0010F\u001a\u00020:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0014\u0010I\u001a\u00020J8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010NR\u0014\u0010O\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010NR\u001a\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0R8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010UR\u001a\u0010V\u001a\b\u0012\u0004\u0012\u00020\r0WX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010YR\u001a\u0010Z\u001a\u00020[X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R\u001a\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\ba\u0010bR\u001a\u0010c\u001a\b\u0012\u0004\u0012\u00020\r0d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\be\u0010fR\u0014\u0010g\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bh\u0010iR\u0014\u0010j\u001a\u00020k8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bl\u0010mR\u0014\u0010n\u001a\u00020k8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bo\u0010mR\u0014\u0010p\u001a\u00020[8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bq\u0010]R\u001c\u0010r\u001a\n t*\u0004\u0018\u00010s0s8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bu\u0010v\u00a8\u0006\u00b7\u0001"}, d2={"Lcom/intellij/platform/split/connection/protocol/wire/SecureWireOverStreamTransport;", "Lcom/intellij/platform/split/connection/protocol/ICodeWithMeWire;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "id", "", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "transportInfo", "Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;", "isServer", "", "checkBeforeProtocolTrusted", "Lkotlin/Function2;", "", "Ljava/security/cert/X509Certificate;", "Lkotlin/ParameterName;", "name", "chain", "Lcom/intellij/platform/split/connection/protocol/WireConnectStatus;", "Lkotlin/ExtensionFunctionType;", "pinHandler", "Lkotlin/Function3;", "", "pin", "", "passwordHandler", "Lcom/intellij/platform/split/connection/protocol/IPasswordAuthHandler;", "sessionTokenHandler", "Lcom/intellij/platform/split/connection/protocol/wire/SessionTokenHandler;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/reactive/IScheduler;Ljava/lang/String;Lcom/intellij/codeWithMe/ClientId;Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;ZLkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function3;Lcom/intellij/platform/split/connection/protocol/IPasswordAuthHandler;Lcom/intellij/platform/split/connection/protocol/wire/SessionTokenHandler;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getScheduler", "()Lcom/jetbrains/rd/util/reactive/IScheduler;", "getId", "()Ljava/lang/String;", "getClientId", "()Lcom/intellij/codeWithMe/ClientId;", "getSessionTokenHandler", "()Lcom/intellij/platform/split/connection/protocol/wire/SessionTokenHandler;", "getName", "wireTransportSubscriptionSequentialLifetime", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "contextsInternal", "Lcom/jetbrains/rd/framework/impl/ProtocolContexts;", "messageBroker", "Lcom/jetbrains/rd/framework/MessageBroker;", "myConnectionState", "Lcom/intellij/platform/split/connection/protocol/ConnectionStateProperty;", "myTransportInfo", "Ljava/util/concurrent/atomic/AtomicReference;", "permittedModalityEntities", "Lcom/jetbrains/rd/protocol/PermittedModalityProtocolEntities;", "myWireStat", "Lcom/intellij/platform/split/connection/protocol/wire/WireStatsCounter;", "serviceMessageProcessor", "Lcom/intellij/platform/split/connection/protocol/ServiceMessageProcessor;", "allowedToStartReceiving", "Lcom/intellij/platform/split/connection/protocol/wire/SecureWireOverStreamTransport$ReceivingState;", "lastReceivedFrameNanos", "Ljava/util/concurrent/atomic/AtomicLong;", "allowExpiredTokens", "getAllowExpiredTokens", "()Z", "setAllowExpiredTokens", "(Z)V", "wireStats", "getWireStats", "()Lcom/intellij/platform/split/connection/protocol/wire/WireStatsCounter;", "transportStats", "Lcom/intellij/platform/split/connection/protocol/transport/stats/TransportStatisticsData;", "getTransportStats", "()Lcom/intellij/platform/split/connection/protocol/transport/stats/TransportStatisticsData;", "getTransportInfo", "()Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;", "activeTransport", "getActiveTransport", "connectionState", "Lcom/intellij/openapi/rd/IPropertyViewWithFlow;", "Lcom/intellij/platform/split/connection/protocol/ConnectionState;", "getConnectionState", "()Lcom/intellij/openapi/rd/IPropertyViewWithFlow;", "heartbeatAlive", "Lcom/jetbrains/rd/util/reactive/Property;", "getHeartbeatAlive", "()Lcom/jetbrains/rd/util/reactive/Property;", "heartbeatIntervalMs", "", "getHeartbeatIntervalMs", "()J", "setHeartbeatIntervalMs", "(J)V", "counterPartCertificates", "getCounterPartCertificates", "()Ljava/util/List;", "connected", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "getConnected", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "contexts", "getContexts", "()Lcom/jetbrains/rd/framework/impl/ProtocolContexts;", "transmitCompressionRatio", "", "getTransmitCompressionRatio", "()I", "receiveCompressionRatio", "getReceiveCompressionRatio", "unconfirmedMessagesBufferSize", "getUnconfirmedMessagesBufferSize", "transportChangedListener", "Lcom/intellij/platform/split/connection/protocol/transport/WireTransportListener;", "kotlin.jvm.PlatformType", "getTransportChangedListener", "()Lcom/intellij/platform/split/connection/protocol/transport/WireTransportListener;", "tryGetById", "Lcom/jetbrains/rd/framework/base/IRdWireable;", "rdId", "Lcom/jetbrains/rd/framework/RdId;", "tryGetById-s1GeQ58", "(J)Lcom/jetbrains/rd/framework/base/IRdWireable;", "advise", "entity", "replaceTransport", "setupContexts", "newContexts", "startDeliveringMessages", "stopDeliveringMessages", "suspend", "send", "writer", "Lkotlin/Function1;", "Lcom/jetbrains/rd/framework/AbstractBuffer;", "send-311-pGg", "(JLkotlin/jvm/functions/Function1;)V", "toString", "onWireTerminated", "onFrameReceived", "frame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/Frame;", "onSystemFrameReceived", "Lcom/intellij/platform/split/connection/protocol/channel/frame/SystemFrame;", "onMessageFrameReceived", "Lcom/intellij/platform/split/connection/protocol/channel/frame/MessageFrame;", "onUnderlyingTransportConnectionStateChanged", "state", "onWireConnectionStateChanged", "fromState", "toState", "subscribeOnNewTransport", "subscribeWireOnNewTransport", "subscribeWireTransportListenersOnNewTransport", "resetCurrentTransport", "newTransportInfo", "waitUnderlyingTransportState", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runConnectionFlow", "ensureConnectionEstablished", "handleTokensExchange", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handlePin", "certificates", "(ZLjava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handlePassword", "handleAcceptance", "checkProtocolTrusted", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkPasswordRequest", "(Lcom/intellij/platform/split/connection/protocol/channel/frame/SystemFrame;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setClosedState", "setFaultedState", "throwable", "", "handleTokenFrames", "waitSessionTokenFrame", "Lcom/intellij/platform/split/connection/protocol/channel/frame/SessionTokenFrame;", "dumpStackTrace", "ReceivingState", "Companion", "intellij.platform.split.connection"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSecureWireOverStreamTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecureWireOverStreamTransport.kt\ncom/intellij/platform/split/connection/protocol/wire/SecureWireOverStreamTransport\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 FrameFactory.kt\ncom/intellij/platform/split/connection/protocol/channel/frame/FrameFactory\n+ 6 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime\n*L\n1#1,876:1\n60#2,5:877\n67#2,4:883\n67#2,4:887\n67#2,4:891\n67#2,4:895\n67#2,4:899\n67#2,4:903\n67#2,4:907\n67#2,4:911\n60#2,5:915\n67#2,4:920\n67#2,4:924\n60#2,5:928\n67#2,4:933\n67#2,4:937\n67#2,4:941\n60#2,5:945\n67#2,4:950\n60#2,5:954\n60#2,5:961\n67#2,4:966\n60#2,5:971\n60#2,5:976\n60#2,5:981\n60#2,5:986\n60#2,5:991\n67#2,4:996\n1#3:882\n13036#4,2:959\n126#5:970\n126#5:1006\n155#6,6:1000\n*S KotlinDebug\n*F\n+ 1 SecureWireOverStreamTransport.kt\ncom/intellij/platform/split/connection/protocol/wire/SecureWireOverStreamTransport\n*L\n168#1:877,5\n189#1:883,4\n192#1:887,4\n195#1:891,4\n198#1:895,4\n201#1:899,4\n245#1:903,4\n248#1:907,4\n251#1:911,4\n261#1:915,5\n265#1:920,4\n348#1:924,4\n380#1:928,5\n410#1:933,4\n441#1:937,4\n622#1:941,4\n633#1:945,5\n641#1:950,4\n645#1:954,5\n659#1:961,5\n662#1:966,4\n678#1:971,5\n685#1:976,5\n693#1:981,5\n712#1:986,5\n719#1:991,5\n745#1:996,4\n652#1:959,2\n670#1:970\n788#1:1006\n778#1:1000,6\n*E\n"})
public final class SecureWireOverStreamTransport
implements ICodeWithMeWire {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final IScheduler scheduler;
    @NotNull
    private final String id;
    @NotNull
    private final ClientId clientId;
    private final boolean isServer;
    @NotNull
    private final Function2<SecureWireOverStreamTransport, List<? extends X509Certificate>, WireConnectStatus> checkBeforeProtocolTrusted;
    @NotNull
    private final Function3<SecureWireOverStreamTransport, List<? extends X509Certificate>, byte[], Unit> pinHandler;
    @Nullable
    private final IPasswordAuthHandler passwordHandler;
    @Nullable
    private final SessionTokenHandler sessionTokenHandler;
    @NotNull
    private final String name;
    @NotNull
    private final SequentialLifetimes wireTransportSubscriptionSequentialLifetime;
    private ProtocolContexts contextsInternal;
    @NotNull
    private final MessageBroker messageBroker;
    @NotNull
    private final ConnectionStateProperty myConnectionState;
    @NotNull
    private final AtomicReference<TransportInfo> myTransportInfo;
    @Nullable
    private final PermittedModalityProtocolEntities permittedModalityEntities;
    @NotNull
    private final WireStatsCounter myWireStat;
    @NotNull
    private final ServiceMessageProcessor serviceMessageProcessor;
    @NotNull
    private final AtomicReference<ReceivingState> allowedToStartReceiving;
    @NotNull
    private final AtomicLong lastReceivedFrameNanos;
    @TestOnly
    private boolean allowExpiredTokens;
    @NotNull
    private final Property<Boolean> heartbeatAlive;
    private long heartbeatIntervalMs;
    private static final ThreadLocal<UnsafeBuffer> threadLocalWriteBuffers = ThreadLocal.withInitial(SecureWireOverStreamTransport::threadLocalWriteBuffers$lambda$0);
    private static final int PIN_VALUE_BUFFER_SIZE = 4;

    public SecureWireOverStreamTransport(@NotNull Lifetime lifetime, @NotNull IScheduler scheduler, @NotNull String id, @NotNull ClientId clientId, @NotNull TransportInfo transportInfo, boolean isServer, @NotNull Function2<? super SecureWireOverStreamTransport, ? super List<? extends X509Certificate>, ? extends WireConnectStatus> checkBeforeProtocolTrusted, @NotNull Function3<? super SecureWireOverStreamTransport, ? super List<? extends X509Certificate>, ? super byte[], Unit> pinHandler, @Nullable IPasswordAuthHandler passwordHandler, @Nullable SessionTokenHandler sessionTokenHandler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)transportInfo, (String)"transportInfo");
        Intrinsics.checkNotNullParameter(checkBeforeProtocolTrusted, (String)"checkBeforeProtocolTrusted");
        Intrinsics.checkNotNullParameter(pinHandler, (String)"pinHandler");
        this.lifetime = lifetime;
        this.scheduler = scheduler;
        this.id = id;
        this.clientId = clientId;
        this.isServer = isServer;
        this.checkBeforeProtocolTrusted = checkBeforeProtocolTrusted;
        this.pinHandler = pinHandler;
        this.passwordHandler = passwordHandler;
        this.sessionTokenHandler = sessionTokenHandler;
        this.name = "Wire (id: " + this.getId() + ")";
        this.wireTransportSubscriptionSequentialLifetime = new SequentialLifetimes(this.lifetime);
        this.messageBroker = new MessageBroker(false, 1, null);
        this.myConnectionState = new ConnectionStateProperty();
        this.myTransportInfo = new AtomicReference<Object>(null);
        this.permittedModalityEntities = PermittedModalityProtocolEntities.Companion.getInstanceIfApplicationExists();
        this.myWireStat = new WireStatsCounterImpl(this.lifetime, this);
        this.allowedToStartReceiving = new AtomicReference<ReceivingState.NotAllowed>(ReceivingState.NotAllowed.INSTANCE);
        this.lastReceivedFrameNanos = new AtomicLong(System.nanoTime());
        this.heartbeatAlive = new Property((Object)true);
        this.heartbeatIntervalMs = Long.MAX_VALUE;
        SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Start initializing a new wire instance");
        SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Initializing a service message processor");
        this.serviceMessageProcessor = new ServiceMessageProcessor(this.lifetime, this.getId(), this.isServer);
        this.lifetime.onTermination(() -> SecureWireOverStreamTransport._init_$lambda$2(this));
        SourceExKt.adviseWithPrev((ISource)((ISource)this.myConnectionState), (Lifetime)this.lifetime, (arg_0, arg_1) -> SecureWireOverStreamTransport._init_$lambda$3(this, arg_0, arg_1));
        Logger $this$debug_u24default$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug(this.getName() + " Wire set a transport: " + transportInfo.getName(), t$iv);
        }
        this.replaceTransport(transportInfo);
    }

    public /* synthetic */ SecureWireOverStreamTransport(Lifetime lifetime, IScheduler iScheduler, String string, ClientId clientId, TransportInfo transportInfo, boolean bl, Function2 function2, Function3 function3, IPasswordAuthHandler iPasswordAuthHandler, SessionTokenHandler sessionTokenHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            function2 = SecureWireOverStreamTransport::_init_$lambda$0;
        }
        if ((n & 0x80) != 0) {
            function3 = SecureWireOverStreamTransport::_init_$lambda$1;
        }
        if ((n & 0x100) != 0) {
            iPasswordAuthHandler = null;
        }
        this(lifetime, iScheduler, string, clientId, transportInfo, bl, (Function2<? super SecureWireOverStreamTransport, ? super List<? extends X509Certificate>, ? extends WireConnectStatus>)function2, (Function3<? super SecureWireOverStreamTransport, ? super List<? extends X509Certificate>, ? super byte[], Unit>)function3, iPasswordAuthHandler, sessionTokenHandler);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @Override
    @NotNull
    public IScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public ClientId getClientId() {
        return this.clientId;
    }

    @Nullable
    public final SessionTokenHandler getSessionTokenHandler() {
        return this.sessionTokenHandler;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public final boolean getAllowExpiredTokens() {
        return this.allowExpiredTokens;
    }

    public final void setAllowExpiredTokens(boolean bl) {
        this.allowExpiredTokens = bl;
    }

    @Override
    @NotNull
    public WireStatsCounter getWireStats() {
        return this.myWireStat;
    }

    @Override
    @NotNull
    public TransportStatisticsData getTransportStats() {
        NamedTransportEntity namedTransportEntity = this.getTransportInfo();
        TransportStatisticsData transportStatisticsData = namedTransportEntity != null && (namedTransportEntity = ((TransportInfo)namedTransportEntity).getTransport()) != null ? namedTransportEntity.getStats() : null;
        if (transportStatisticsData == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return transportStatisticsData;
    }

    @Override
    @Nullable
    public TransportInfo getTransportInfo() {
        return this.myTransportInfo.get();
    }

    private final TransportInfo getActiveTransport() {
        TransportInfo transportInfo = this.myTransportInfo.get();
        if (transportInfo == null) {
            boolean bl = false;
            String string = this.getName() + " No active transport is set";
            throw new IllegalStateException(string.toString());
        }
        return transportInfo;
    }

    @Override
    @NotNull
    public IPropertyViewWithFlow<ConnectionState> getConnectionState() {
        return this.myConnectionState;
    }

    @NotNull
    public Property<Boolean> getHeartbeatAlive() {
        return this.heartbeatAlive;
    }

    public long getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setHeartbeatIntervalMs(long l) {
        this.heartbeatIntervalMs = l;
    }

    @Override
    @NotNull
    public List<X509Certificate> getCounterPartCertificates() {
        Object object = this.getTransportInfo();
        if (object == null || (object = ((TransportInfo)object).getTransport()) == null || (object = object.getCounterPartCertificates()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public IPropertyView<Boolean> getConnected() {
        return PropertyCombinatorsKt.map((IPropertyView)((IPropertyView)this.getConnectionState()), SecureWireOverStreamTransport::_get_connected_$lambda$0);
    }

    @NotNull
    public ProtocolContexts getContexts() {
        ProtocolContexts protocolContexts = this.contextsInternal;
        if (protocolContexts == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contextsInternal");
            protocolContexts = null;
        }
        return protocolContexts;
    }

    @Override
    public int getTransmitCompressionRatio() {
        return this.getActiveTransport().getTransport().calculateTransmitCompressionRatio();
    }

    @Override
    public int getReceiveCompressionRatio() {
        return this.getActiveTransport().getTransport().calculateReceiveCompressionRatio();
    }

    @Override
    public long getUnconfirmedMessagesBufferSize() {
        return this.serviceMessageProcessor.getUnconfirmedFramesBufferSize();
    }

    private final WireTransportListener getTransportChangedListener() {
        return (WireTransportListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(WireTransportListener.TOPIC);
    }

    @Nullable
    public IRdWireable tryGetById-s1GeQ58(long rdId) {
        return this.messageBroker.tryGetById-s1GeQ58(rdId);
    }

    public void advise(@NotNull Lifetime lifetime, @NotNull IRdWireable entity) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        SecureWireWritable wrapper = new SecureWireWritable(this.getClientId(), entity, this.permittedModalityEntities);
        this.messageBroker.adviseOn(lifetime, (IRdWireable)wrapper);
        this.myWireStat.onAdvise(lifetime, (IRdWireable)wrapper);
    }

    @Override
    public void replaceTransport(@NotNull TransportInfo transportInfo) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)transportInfo, (String)"transportInfo");
        TransportInfo transportInfo2 = this.getTransportInfo();
        SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Replace current wire transport (name: " + (transportInfo2 != null ? transportInfo2.getName() : null) + ") with a new transport: " + transportInfo.getName());
        Logger $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Attach transport to Service Message Processor");
        }
        this.serviceMessageProcessor.attachTransport(transportInfo);
        $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Subscribe wire on new transport");
        }
        this.subscribeOnNewTransport(transportInfo);
        $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Reset current wire transport");
        }
        this.resetCurrentTransport(transportInfo);
        $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Notify listeners about new transport");
        }
        this.getTransportChangedListener().transportConnected(this.getClientId(), transportInfo);
        $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Run connection flow on a new transport");
        }
        this.runConnectionFlow(transportInfo);
    }

    public void setupContexts(@NotNull ProtocolContexts newContexts) {
        Intrinsics.checkNotNullParameter((Object)newContexts, (String)"newContexts");
        SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Setup protocol context");
        if (!(this.contextsInternal == null)) {
            boolean bl = false;
            String string = "Can't replace ProtocolContexts in IWire";
            throw new IllegalArgumentException(string.toString());
        }
        this.contextsInternal = newContexts;
    }

    @Override
    public void startDeliveringMessages() {
        ReceivingState currentAllowed;
        SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Start delivering messages");
        if (!ConnectionState.Companion.isAlive((ConnectionState)this.getConnectionState().getValue())) {
            boolean bl = false;
            String string = "Wire must be alive before start delivering messages";
            throw new IllegalStateException(string.toString());
        }
        do {
            if (Intrinsics.areEqual((Object)(currentAllowed = this.allowedToStartReceiving.get()), (Object)ReceivingState.Allowed.INSTANCE)) {
                return;
            }
            if (!(currentAllowed instanceof ReceivingState.Armed)) continue;
            ((ReceivingState.Armed)currentAllowed).getTransport().getTransport().startProcessingCollectedEntries();
        } while (!Intrinsics.areEqual((Object)this.allowedToStartReceiving.compareAndExchange(currentAllowed, ReceivingState.Allowed.INSTANCE), (Object)currentAllowed));
    }

    @Override
    public void stopDeliveringMessages() {
        SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Stop delivering messages");
    }

    private final void suspend() {
        Logger logger;
        SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Suspending wire...");
        Logger $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Reset wire connection state");
        }
        this.myConnectionState.reset();
        $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Remove transport");
        }
        this.resetCurrentTransport(null);
        $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Reset service message processor");
        }
        this.serviceMessageProcessor.reset();
        SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Wire is suspended");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send-311-pGg(long id, @NotNull Function1<? super AbstractBuffer, Unit> writer) {
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        if (!(!RdId.isNull-impl((long)id))) {
            boolean $i$a$-require-SecureWireOverStreamTransport$send$22 = false;
            String $i$a$-require-SecureWireOverStreamTransport$send$22 = this.getName() + " RdId mustn't be null";
            throw new IllegalArgumentException($i$a$-require-SecureWireOverStreamTransport$send$22.toString());
        }
        if (this.lifetime.getStatus() == LifetimeStatus.Terminated) {
            Logger $this$debug_u24default$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug(this.getName() + " Lifetime is not alive, send() will drop data silently for rd id " + RdId.toString-impl((long)id), t$iv);
            }
            return;
        }
        Logger $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Send data through wire. Current connection state: " + this.myConnectionState.getValue());
        }
        if (this.myConnectionState.getValue() instanceof ConnectionState.DECLINED) {
            SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Current connection state is declined. No need to send data. Return.");
            return;
        }
        UnsafeBuffer unsafeBuffer = threadLocalWriteBuffers.get();
        int initialPosition = unsafeBuffer.getPosition();
        try {
            Intrinsics.checkNotNull((Object)unsafeBuffer);
            RdId.write-impl((long)id, (AbstractBuffer)((AbstractBuffer)unsafeBuffer));
            this.getContexts().writeCurrentMessageContext((AbstractBuffer)unsafeBuffer);
            writer.invoke((Object)unsafeBuffer);
            int len = unsafeBuffer.getPosition() - initialPosition;
            this.myWireStat.onSend-311-pGg(id, len);
            byte[] bytes = unsafeBuffer.getArray();
            byte[] message = ArraysKt.copyOfRange((byte[])bytes, (int)initialPosition, (int)(initialPosition + len));
            this.serviceMessageProcessor.sendMessage(message);
        }
        catch (ClosedChannelException ex) {
            SecureWireOverStreamTransportKt.access$getLogger$p().warn(this.getName() + " Channel got closed during send(), data dropped for rd id " + RdId.toString-impl((long)id), new Throwable());
            this.setFaultedState(ex);
        }
        finally {
            if (initialPosition == 0) {
                unsafeBuffer.reset();
            } else {
                unsafeBuffer.setPosition(initialPosition);
            }
        }
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getId() + ")";
    }

    private final void onWireTerminated() {
        SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Wire Lifetime is been terminated.");
        this.setClosedState();
        this.resetCurrentTransport(null);
        this.dumpStackTrace();
    }

    private final void onFrameReceived(Frame frame) {
        this.lastReceivedFrameNanos.set(System.nanoTime());
        Frame frame2 = frame;
        if (frame2 instanceof SystemFrame) {
            this.onSystemFrameReceived((SystemFrame)frame);
        } else if (frame2 instanceof MessageFrame) {
            this.onMessageFrameReceived((MessageFrame)frame);
        } else {
            throw new UnexpectedFrameException(AcknowledgedFrame.class, frame);
        }
    }

    private final void onSystemFrameReceived(SystemFrame frame) {
        if (frame instanceof ForceTerminateWireFrame) {
            EdtScheduler.INSTANCE.queue(() -> SecureWireOverStreamTransport.onSystemFrameReceived$lambda$0(this, frame));
        }
    }

    private final void onMessageFrameReceived(MessageFrame frame) {
        boolean shouldProcessFrame = this.serviceMessageProcessor.processIncomingFrame(frame);
        if (!shouldProcessFrame) {
            Logger $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace(this.getName() + " Ignore frame dispatching: <" + frame + ">");
            }
            return;
        }
        UnsafeBuffer reader = new UnsafeBuffer(frame.getData());
        long id = SerializersKt.readRdId((AbstractBuffer)((AbstractBuffer)reader));
        this.myWireStat.onReceive-311-pGg(id, frame.getData().length);
        this.messageBroker.dispatch-GyorWp8(id, (AbstractBuffer)reader, null);
    }

    private final void onUnderlyingTransportConnectionStateChanged(ConnectionState state) {
        SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Received a new connection state from transport: <" + this.myConnectionState.getValue() + "> -> <" + state + ">");
        ConnectionState connectionState = state;
        if (connectionState instanceof ConnectionState.FAULTED || connectionState instanceof ConnectionState.CLOSED) {
            this.myConnectionState.setIfNotTerminal(state);
        } else if (connectionState instanceof ConnectionState.CONNECTED) {
            SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Underlying transport connection is established.");
        } else {
            Logger $this$debug_u24default$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug(this.getName() + " Ignore stream transport connection state update to: <" + state + ">", t$iv);
            }
        }
    }

    private final void onWireConnectionStateChanged(ConnectionState fromState, ConnectionState toState) {
        SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Wire connection state changed: <" + fromState + "> -> <" + toState + ">");
        if (!ConnectionState.Companion.isAlive(toState)) {
            this.suspend();
        }
    }

    private final void subscribeOnNewTransport(TransportInfo transportInfo) {
        this.subscribeWireOnNewTransport(transportInfo);
        this.subscribeWireTransportListenersOnNewTransport(transportInfo);
    }

    private final void subscribeWireOnNewTransport(TransportInfo transportInfo) {
        Logger $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Subscribe wire on new transport events");
        }
        Lifetime subscriptionLifetime = RLifetimeKt.intersect((Lifetime)transportInfo.getTransportConnectionLifetime(), (Lifetime)((Lifetime)this.wireTransportSubscriptionSequentialLifetime.next()));
        transportInfo.getTransport().onFrameReceived(subscriptionLifetime, (Function1<? super Frame, Boolean>)((Function1)SecureWireOverStreamTransport::subscribeWireOnNewTransport$lambda$1), (Function1<? super Frame, Unit>)((Function1)arg_0 -> SecureWireOverStreamTransport.subscribeWireOnNewTransport$lambda$2(this, arg_0)));
        transportInfo.getTransport().onErrorReceived(subscriptionLifetime, (Function1<? super Throwable, Unit>)((Function1)arg_0 -> SecureWireOverStreamTransport.subscribeWireOnNewTransport$lambda$3(transportInfo, this, arg_0)));
        transportInfo.getTransport().getConnected().advise(subscriptionLifetime, arg_0 -> SecureWireOverStreamTransport.subscribeWireOnNewTransport$lambda$4(this, transportInfo, arg_0));
    }

    private final void subscribeWireTransportListenersOnNewTransport(TransportInfo transportInfo) {
        Logger $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Subscribe wire transport listeners on new transport state change events");
        }
        transportInfo.getTransport().getConnected().advise(transportInfo.getTransportConnectionLifetime(), arg_0 -> SecureWireOverStreamTransport.subscribeWireTransportListenersOnNewTransport$lambda$1(this, transportInfo, arg_0));
        transportInfo.getTransport().getConnected().advise(transportInfo.getTransportConnectionLifetime(), arg_0 -> SecureWireOverStreamTransport.subscribeWireTransportListenersOnNewTransport$lambda$2(this, transportInfo, arg_0));
    }

    private final void resetCurrentTransport(TransportInfo newTransportInfo) {
        TransportInfo currentTransport = this.getTransportInfo();
        TransportInfo transportInfo = currentTransport;
        TransportInfo transportInfo2 = newTransportInfo;
        SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Update current active transport <" + (transportInfo != null ? transportInfo.getName() : null) + "> with new transport <" + (transportInfo2 != null ? transportInfo2.getName() : null) + ">");
        if (currentTransport != null) {
            SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Terminate old wire transport: " + currentTransport.getName());
            currentTransport.getTransport().terminateTransport();
        }
        this.myTransportInfo.set(newTransportInfo);
    }

    /*
     * Unable to fully structure code
     */
    private final Object waitUnderlyingTransportState(Continuation<? super ConnectionState> $completion) {
        if (!($completion instanceof waitUnderlyingTransportState.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SecureWireOverStreamTransport this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SecureWireOverStreamTransport.access$waitUnderlyingTransportState(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getTransportInfo();
                if (v0 == null) {
                    $i$a$-checkNotNull-SecureWireOverStreamTransport$waitUnderlyingTransportState$currentTransport$1 = false;
                    var4_6 = "Wire transport is undefined";
                    throw new IllegalStateException(var4_6.toString());
                }
                currentTransport = v0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)currentTransport);
                $continuation.label = 1;
                v1 = ISourceCoroutineUtilKt.nextValue((ISource)((ISource)currentTransport.getTransport().getConnected()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, waitUnderlyingTransportState$lambda$1(com.intellij.platform.split.connection.protocol.ConnectionState ), (Lcom/intellij/platform/split/connection/protocol/ConnectionState;)Ljava/lang/Boolean;)(), (Continuation)$continuation);
                if (v1 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                currentTransport = (TransportInfo)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                state = (ConnectionState)v1;
                SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Received a new wire transport state: <" + state + ">");
                return state;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void runConnectionFlow(TransportInfo transportInfo) {
        LifetimeCoroutineUtilKt.launch$default((Lifetime)transportInfo.getTransport().getTransportLifetime(), (CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)ClientIdKt.asContextElement((ClientId)this.getClientId())), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, transportInfo, null){
            Object L$0;
            Object L$1;
            boolean Z$0;
            int label;
            final /* synthetic */ SecureWireOverStreamTransport this$0;
            final /* synthetic */ TransportInfo $transportInfo;
            {
                this.this$0 = $receiver;
                this.$transportInfo = $transportInfo;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object $result) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [26[CATCHBLOCK]], but top level block is 9[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final boolean ensureConnectionEstablished(ConnectionState state) {
        ConnectionState connectionState = state;
        if (Intrinsics.areEqual((Object)connectionState, (Object)ConnectionState.CLOSED.INSTANCE)) {
            SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Transport closed, aborting connection flow");
            return false;
        }
        if (connectionState instanceof ConnectionState.DECLINED) {
            throw new PeerVisibleErrorCode(WireConnectStatus.DECLINED, "Non-user declined by other side", null, 4, null);
        }
        if (connectionState instanceof ConnectionState.FAULTED) {
            throw ((ConnectionState.FAULTED)state).getThrowable();
        }
        if (Intrinsics.areEqual((Object)connectionState, (Object)ConnectionState.CONNECTED.INSTANCE)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)connectionState, (Object)ConnectionState.NOT_CONNECTED.INSTANCE)) {
            throw new IllegalStateException("Wire in not connected state despite explicit wait for connected state".toString());
        }
        throw new NoWhenBranchMatchedException();
    }

    private final Object handleTokensExchange(boolean isServer, Continuation<? super Unit> $completion) {
        Logger $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Handle session tokens exchange");
        }
        Object object = this.handleTokenFrames(isServer, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object handlePin(boolean isServer, List<? extends X509Certificate> certificates, Continuation<? super Unit> $completion) {
        if (!($completion instanceof handlePin.1)) ** GOTO lbl-1000
        var15_4 = $completion;
        if ((var15_4.label & -2147483648) != 0) {
            var15_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                boolean Z$0;
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SecureWireOverStreamTransport this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SecureWireOverStreamTransport.access$handlePin(this.this$0, false, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var16_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!isServer) break;
                $this$debug_u24default$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    var13_18 = $this$debug_u24default$iv;
                    $i$a$-debug$default-SecureWireOverStreamTransport$handlePin$2 = false;
                    var13_18.debug(this.getName() + " Handle PIN. Send PIN message to client", t$iv);
                }
                pinBytes = new byte[4];
                this.pinHandler.invoke((Object)this, (Object)certificates, (Object)pinBytes);
                this.serviceMessageProcessor.sendFrame(new JoinPinFrame(pinBytes));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)certificates);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)pinBytes);
                $continuation.Z$0 = isServer;
                $continuation.label = 1;
                v0 = this.checkProtocolTrusted(certificates, (Continuation<? super Unit>)$continuation);
                if (v0 == var16_6) {
                    return var16_6;
                }
                ** GOTO lbl39
            }
            case 1: {
                isServer = $continuation.Z$0;
                pinBytes = (byte[])$continuation.L$1;
                certificates = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl39:
                // 2 sources

                $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var13_18 = $this$trace$iv;
                    $i$a$-trace-SecureWireOverStreamTransport$handlePin$3 = false;
                    var13_18.trace(this.getName() + " Connection flow achieved acceptance");
                }
                this.serviceMessageProcessor.sendFrame(new AcceptedFrame());
                ** GOTO lbl96
            }
        }
        $this$debug_u24default$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        t$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            var13_19 = $this$debug_u24default$iv;
            $i$a$-debug$default-SecureWireOverStreamTransport$handlePin$4 = false;
            var13_19.debug(this.getName() + " Handle PIN. Wait for a PIN message from Server", t$iv);
        }
        $continuation.L$0 = certificates;
        $continuation.Z$0 = isServer;
        $continuation.label = 2;
        v1 = this.serviceMessageProcessor.readNextSystemFrame((Continuation<? super SystemFrame>)$continuation);
        if (v1 == var16_6) {
            return var16_6;
        }
        ** GOTO lbl68
        {
            case 2: {
                isServer = $continuation.Z$0;
                certificates = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl68:
                // 2 sources

                if (!((frame = (SystemFrame)v1) instanceof JoinPinFrame)) {
                    $i$a$-check-SecureWireOverStreamTransport$handlePin$5 = false;
                    $i$a$-check-SecureWireOverStreamTransport$handlePin$5 = "Remote expected PIN message, but received: " + frame;
                    throw new IllegalStateException($i$a$-check-SecureWireOverStreamTransport$handlePin$5.toString());
                }
                if (!(frame.getData().length == 0 == false)) {
                    $i$a$-check-SecureWireOverStreamTransport$handlePin$6 = false;
                    $i$a$-check-SecureWireOverStreamTransport$handlePin$6 = "Remote replied with frame with undefined data bytes: " + frame;
                    throw new IllegalStateException($i$a$-check-SecureWireOverStreamTransport$handlePin$6.toString());
                }
                if (!(frame.getData().length == 4)) {
                    $i$a$-check-SecureWireOverStreamTransport$handlePin$7 = false;
                    $i$a$-check-SecureWireOverStreamTransport$handlePin$7 = "Remote PIN was of wrong length. Expected <4> bytes, but received <" + frame.getData().length + ">";
                    throw new IllegalStateException($i$a$-check-SecureWireOverStreamTransport$handlePin$7.toString());
                }
                $this$all$iv = frame.getData();
                $i$f$all = false;
                for (byte element$iv : $this$all$iv) {
                    byte = element$iv;
                    $i$a$-all-SecureWireOverStreamTransport$handlePin$8 = false;
                    var12_26 = byte;
                    if (0 <= var12_26 ? var12_26 < 10 : false) continue;
                    v2 = false;
                    ** GOTO lbl90
                }
                v2 = true;
lbl90:
                // 2 sources

                if (!v2) {
                    $i$a$-check-SecureWireOverStreamTransport$handlePin$9 = false;
                    var6_17 = "Remote's PIN was out of range";
                    throw new IllegalStateException(var6_17.toString());
                }
                this.pinHandler.invoke((Object)this, (Object)certificates, (Object)frame.getData());
lbl96:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handlePassword(Continuation<? super Unit> $completion) {
        if (!($completion instanceof handlePassword.1)) ** GOTO lbl-1000
        var10_2 = $completion;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SecureWireOverStreamTransport this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SecureWireOverStreamTransport.access$handlePassword(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$debug_u24default$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    var8_9 = $this$debug_u24default$iv;
                    $i$a$-debug$default-SecureWireOverStreamTransport$handlePassword$2 = false;
                    var8_9.debug(this.getName() + " Connection flow. Framed. Password. Read next system frame.", t$iv);
                }
                $continuation.label = 1;
                v0 = this.serviceMessageProcessor.readNextSystemFrame((Continuation<? super SystemFrame>)$continuation);
                if (v0 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                frame = (SystemFrame)v0;
                $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var8_9 = $this$trace$iv;
                    $i$a$-trace-SecureWireOverStreamTransport$handlePassword$3 = false;
                    var8_9.trace(this.getName() + " Remote responded with frame: " + frame);
                }
                if (WhenMappings.$EnumSwitchMapping$0[frame.getConnectStatus().ordinal()] != 1) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)frame);
                $continuation.label = 2;
                v1 = this.checkPasswordRequest(frame, (Continuation<? super Unit>)$continuation);
                if (v1 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl47
            }
            case 2: {
                frame = (SystemFrame)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl47:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        SecureWireOverStreamTransportKt.access$getLogger$p().info("Current status does not match password request. Skip password request processing.");
        $i$a$-trace-SecureWireOverStreamTransport$handlePassword$3 = FrameFactory.INSTANCE;
        $this$isFrameOfType$iv = frame;
        $i$f$isFrameOfType = false;
        if (!($this$isFrameOfType$iv instanceof AcceptedFrame)) {
            throw new PeerVisibleErrorCode(frame.getConnectStatus(), null, null, 6, null);
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void handleAcceptance(boolean isServer) {
        Logger logger;
        Logger $this$debug_u24default$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug(this.getName() + " Acceptance. Handle acceptance", t$iv);
        }
        if (isServer) {
            return;
        }
        $this$debug_u24default$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
        t$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug(this.getName() + " Connection flow achieved acceptance", t$iv);
        }
        this.serviceMessageProcessor.sendFrame(new AcceptedFrame());
    }

    /*
     * Unable to fully structure code
     */
    private final Object checkProtocolTrusted(List<? extends X509Certificate> certificates, Continuation<? super Unit> $completion) {
        block29: {
            if (!($completion instanceof checkProtocolTrusted.1)) ** GOTO lbl-1000
            var15_3 = $completion;
            if ((var15_3.label & -2147483648) != 0) {
                var15_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ SecureWireOverStreamTransport this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return SecureWireOverStreamTransport.access$checkProtocolTrusted(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$debug_u24default$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
                    t$iv = null;
                    $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        var13_14 = $this$debug_u24default$iv;
                        $i$a$-debug$default-SecureWireOverStreamTransport$checkProtocolTrusted$2 = false;
                        var13_14.debug(this.getName() + " Check before protocol trusted", t$iv);
                    }
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)certificates);
                    $continuation.label = 1;
                    v0 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends WireConnectStatus, ? extends Deferred>>, Object>(this, (List<? extends X509Certificate>)certificates, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ SecureWireOverStreamTransport this$0;
                        final /* synthetic */ List<X509Certificate> $certificates;
                        {
                            this.this$0 = $receiver;
                            this.$certificates = $certificates;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * WARNING - void declaration
                         */
                        public final Object invokeSuspend(Object $result) {
                            CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    WireConnectStatus wireConnectStatus;
                                    void $this$coroutineScope;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Deferred readerJob2 = BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<?>, Object>(this.this$0, null){
                                        int label;
                                        final /* synthetic */ SecureWireOverStreamTransport this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        public final Object invokeSuspend(Object $result) {
                                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    this.label = 1;
                                                    v0 = SecureWireOverStreamTransport.access$getServiceMessageProcessor$p(this.this$0).readNextSystemFrame((Continuation<? super SystemFrame>)((Continuation)this));
                                                    if (v0 == var3_2) {
                                                        return var3_2;
                                                    }
                                                    ** GOTO lbl13
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v0 = $result;
lbl13:
                                                    // 2 sources

                                                    frame = (SystemFrame)v0;
                                                    throw new IllegalStateException(("Successful frame read unexpected, got: <" + frame + ">").toString());
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<?> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                    try {
                                        wireConnectStatus = (WireConnectStatus)((Object)SecureWireOverStreamTransport.access$getCheckBeforeProtocolTrusted$p(this.this$0).invoke((Object)this.this$0, this.$certificates));
                                    }
                                    finally {
                                        Job.DefaultImpls.cancel$default((Job)((Job)readerJob2), null, (int)1, null);
                                    }
                                    WireConnectStatus judgement = wireConnectStatus;
                                    return TuplesKt.to((Object)((Object)judgement), (Object)readerJob2);
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Pair<? extends WireConnectStatus, ? extends Deferred>> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var16_5) {
                        return var16_5;
                    }
                    ** GOTO lbl30
                }
                case 1: {
                    certificates = (List)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    var3_6 = (Pair)v0;
                    judgement = (WireConnectStatus)var3_6.component1();
                    readerJob = (Deferred)var3_6.component2();
                    $this$debug_u24default$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
                    t$iv = null;
                    $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        var13_14 = $this$debug_u24default$iv;
                        $i$a$-debug$default-SecureWireOverStreamTransport$checkProtocolTrusted$4 = false;
                        var13_14.debug(this.getName() + " Connect status after protocol security check: " + judgement, t$iv);
                    }
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)certificates);
                    $continuation.L$1 = judgement;
                    $continuation.L$2 = readerJob;
                    $continuation.label = 2;
                    v1 = readerJob.join((Continuation)$continuation);
                    if (v1 == var16_5) {
                        return var16_5;
                    }
                    ** GOTO lbl55
                }
                case 2: {
                    readerJob = (Deferred)$continuation.L$2;
                    judgement = (WireConnectStatus)$continuation.L$1;
                    certificates = (List)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl55:
                    // 2 sources

                    if (readerJob.isCancelled()) break;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)certificates);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)judgement);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)readerJob);
                    $continuation.label = 3;
                    v2 = readerJob.await((Continuation)$continuation);
                    if (v2 == var16_5) {
                        return var16_5;
                    }
                    ** GOTO lbl70
                }
                case 3: {
                    readerJob = (Deferred)$continuation.L$2;
                    judgement = (WireConnectStatus)$continuation.L$1;
                    certificates = (List)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl70:
                    // 2 sources

                    throw new KotlinNothingValueException();
                }
            }
            $this$debug_u24default$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                var13_14 = $this$debug_u24default$iv;
                $i$a$-debug$default-SecureWireOverStreamTransport$checkProtocolTrusted$5 = false;
                var13_14.debug(this.getName() + " Received judgment: <" + judgement + ">", t$iv);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[judgement.ordinal()]) {
                case 2: {
                    SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Got wire connection accepted state.");
                    return Unit.INSTANCE;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    throw new PeerVisibleErrorCode(judgement, null, null, 6, null);
                }
                case 8: {
                    throw new IllegalStateException((this.getName() + " Client sent illegal pin message").toString());
                }
                case 1: {
                    if (!this.isServer) {
                        $i$a$-require-SecureWireOverStreamTransport$checkProtocolTrusted$6 = false;
                        $i$a$-require-SecureWireOverStreamTransport$checkProtocolTrusted$6 = "Only server end can request passwords";
                        throw new IllegalArgumentException($i$a$-require-SecureWireOverStreamTransport$checkProtocolTrusted$6.toString());
                    }
                    if (!(this.passwordHandler != null)) {
                        $i$a$-require-SecureWireOverStreamTransport$checkProtocolTrusted$7 = false;
                        $i$a$-require-SecureWireOverStreamTransport$checkProtocolTrusted$7 = "Password handler must be set in order to request passwords";
                        throw new IllegalArgumentException($i$a$-require-SecureWireOverStreamTransport$checkProtocolTrusted$7.toString());
                    }
                    SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Requesting password from client");
                    passwordRequest = this.passwordHandler.getPasswordRequestBytes();
                    this.serviceMessageProcessor.sendFrame(new PasswordRequiredFrame(passwordRequest));
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)certificates);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)judgement);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)readerJob);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)passwordRequest);
                    $continuation.label = 4;
                    v3 = this.serviceMessageProcessor.readNextSystemFrame((Continuation<? super SystemFrame>)$continuation);
                    if (v3 == var16_5) {
                        return var16_5;
                    }
                    ** GOTO lbl115
                }
                {
                    case 4: {
                        passwordRequest = (byte[])$continuation.L$3;
                        readerJob = (Deferred)$continuation.L$2;
                        judgement = (WireConnectStatus)$continuation.L$1;
                        certificates = (List)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl115:
                        // 2 sources

                        frame = (SystemFrame)v3;
                        $this$trace$iv = SecureWireOverStreamTransportKt.access$getLogger$p();
                        $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            var13_14 = $this$trace$iv;
                            $i$a$-trace-SecureWireOverStreamTransport$checkProtocolTrusted$8 = false;
                            var13_14.trace(this.getName() + " Client replied: " + frame);
                        }
                        if (!(frame instanceof PasswordRequiredFrame)) {
                            $i$a$-check-SecureWireOverStreamTransport$checkProtocolTrusted$9 = false;
                            var11_28 = "Remote did not reply with password response when one was expected";
                            throw new IllegalStateException(var11_28.toString());
                        }
                        clientPassword = frame.getData();
                        if (!(clientPassword.length == 0 == false)) {
                            $i$a$-check-SecureWireOverStreamTransport$checkProtocolTrusted$10 = false;
                            var12_30 = "Remote replied with frame that has no password data";
                            throw new IllegalStateException(var12_30.toString());
                        }
                        if (!this.passwordHandler.checkPasswordFromClient(clientPassword)) {
                            SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Client password was wrong.");
                            throw new PeerVisibleErrorCode(WireConnectStatus.DECLINED, "Wrong password", null, 4, null);
                        }
                        SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Client password was correct");
                        break block29;
                    }
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    throw new IllegalStateException((this.getName() + " Received illegal message for PIN request. Expected: <" + WireConnectStatus.ACCEPTED.getClass().getSimpleName() + ">, but got: <" + judgement.getClass().getSimpleName() + ">").toString());
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        it = Unit.INSTANCE;
        $i$a$-let-SecureWireOverStreamTransport$checkProtocolTrusted$11 = false;
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object checkPasswordRequest(SystemFrame frame, Continuation<? super Unit> $completion) {
        if (!($completion instanceof checkPasswordRequest.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ SecureWireOverStreamTransport this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SecureWireOverStreamTransport.access$checkPasswordRequest(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!(this.isServer == false)) {
                    $i$a$-require-SecureWireOverStreamTransport$checkPasswordRequest$2 = false;
                    $i$a$-require-SecureWireOverStreamTransport$checkPasswordRequest$2 = "Only client end can receive password requests";
                    throw new IllegalArgumentException($i$a$-require-SecureWireOverStreamTransport$checkPasswordRequest$2.toString());
                }
                if (!(this.passwordHandler != null)) {
                    $i$a$-require-SecureWireOverStreamTransport$checkPasswordRequest$3 = false;
                    $i$a$-require-SecureWireOverStreamTransport$checkPasswordRequest$3 = "Password handler was not set, but remote requested a password";
                    throw new IllegalArgumentException($i$a$-require-SecureWireOverStreamTransport$checkPasswordRequest$3.toString());
                }
                if (!(frame instanceof PasswordRequiredFrame)) {
                    $i$a$-require-SecureWireOverStreamTransport$checkPasswordRequest$3 = "Failed requirement.";
                    throw new IllegalArgumentException($i$a$-require-SecureWireOverStreamTransport$checkPasswordRequest$3.toString());
                }
                SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Host is asking user for password input");
                this_$iv = this.lifetime;
                $i$f$usingNested = 0;
                nested$iv = this_$iv.createNested();
                passwordRequestLifetime = nested$iv.getLifetime();
                $i$a$-usingNested-SecureWireOverStreamTransport$checkPasswordRequest$password$1 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)frame);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                $continuation.L$2 = nested$iv;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)passwordRequestLifetime);
                $continuation.I$0 = $i$f$usingNested;
                $continuation.I$1 = $i$a$-usingNested-SecureWireOverStreamTransport$checkPasswordRequest$password$1;
                $continuation.label = 1;
                v0 = FutureKt.await((CompletionStage)this.passwordHandler.askForPassword(passwordRequestLifetime, frame.getData()), (Continuation)$continuation);
                ** if (v0 != var12_5) goto lbl41
lbl40:
                // 1 sources

                return var12_5;
lbl41:
                // 1 sources

                ** GOTO lbl53
            }
            case 1: {
                $i$a$-usingNested-SecureWireOverStreamTransport$checkPasswordRequest$password$1 = $continuation.I$1;
                $i$f$usingNested = $continuation.I$0;
                passwordRequestLifetime = (Lifetime)$continuation.L$3;
                nested$iv = (LifetimeDefinition)$continuation.L$2;
                this_$iv = (Lifetime)$continuation.L$1;
                frame = (SystemFrame)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl53:
                    // 2 sources

                    var9_24 = (byte[])v0;
                }
                catch (Throwable passwordRequestLifetime) {
                    throw passwordRequestLifetime;
                }
                finally {
                    LifetimeDefinition.terminate$default((LifetimeDefinition)nested$iv, (boolean)false, (int)1, null);
                }
                v1 = password = var9_24;
                if (password == null) {
                    $i$a$-checkNotNull-SecureWireOverStreamTransport$checkPasswordRequest$4 = false;
                    $i$a$-checkNotNull-SecureWireOverStreamTransport$checkPasswordRequest$4 = this.getName() + " Got invalid password value to request from a client";
                    throw new IllegalStateException($i$a$-checkNotNull-SecureWireOverStreamTransport$checkPasswordRequest$4.toString());
                }
                SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Sending password to server");
                this.serviceMessageProcessor.sendFrame(new PasswordRequiredFrame(password));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)frame);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)password);
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 2;
                v2 = this.serviceMessageProcessor.readNextSystemFrame((Continuation<? super SystemFrame>)$continuation);
                if (v2 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl82
            }
            case 2: {
                password = (byte[])$continuation.L$1;
                frame = (SystemFrame)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl82:
                // 2 sources

                responseFrame = (SystemFrame)v2;
                $i$f$usingNested = FrameFactory.INSTANCE;
                $this$isFrameOfType$iv = responseFrame;
                $i$f$isFrameOfType = false;
                if (!($this$isFrameOfType$iv instanceof AcceptedFrame)) {
                    throw new PeerVisibleErrorCode(responseFrame.getConnectStatus(), null, null, 6, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void setClosedState() {
        SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Set <CLOSED> state for wire");
        this.myConnectionState.setIfNotTerminal(ConnectionState.CLOSED.INSTANCE);
    }

    private final void setFaultedState(Throwable throwable) {
        SecureWireOverStreamTransportKt.access$getLogger$p().warn(this.getName() + " Switch to <FAULTED> state due to error: " + throwable.getMessage(), throwable);
        this.myConnectionState.setIfNotTerminal(new ConnectionState.FAULTED(throwable));
    }

    /*
     * Exception decompiling
     */
    private final Object handleTokenFrames(boolean isServer, Continuation<? super Unit> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE], 3[SWITCH]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private final Object waitSessionTokenFrame(Continuation<? super SessionTokenFrame> $completion) {
        if (!($completion instanceof waitSessionTokenFrame.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ SecureWireOverStreamTransport this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SecureWireOverStreamTransport.access$waitSessionTokenFrame(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                SecureWireOverStreamTransportKt.access$getLogger$p().info(this.getName() + " Start waiting for a counterpart session token system message");
                $continuation.label = 1;
                v0 = this.serviceMessageProcessor.readNextSystemFrame((Continuation<? super SystemFrame>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                if (!((receivedFrame = (SystemFrame)v0) instanceof SessionTokenFrame)) {
                    throw new IllegalStateException("Expected to get frame: <" + SessionTokenFrame.class.getSimpleName() + ">, but received: <" + receivedFrame + ">");
                }
                return receivedFrame;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void dumpStackTrace() {
        try {
            if (SecureWireOverStreamTransportKt.access$getLogger$p().isTraceEnabled()) {
                Thread.dumpStack();
            }
        }
        catch (Exception e) {
            SecureWireOverStreamTransportKt.access$getLogger$p().warn("Exception on dump thread stack trace on wire termination: " + e.getMessage(), (Throwable)e);
        }
    }

    private static final WireConnectStatus _init_$lambda$0(SecureWireOverStreamTransport secureWireOverStreamTransport, List list) {
        Intrinsics.checkNotNullParameter((Object)secureWireOverStreamTransport, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
        throw new UnsupportedOperationException();
    }

    private static final Unit _init_$lambda$1(SecureWireOverStreamTransport secureWireOverStreamTransport, List list, byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)secureWireOverStreamTransport, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final boolean _get_connected_$lambda$0(ConnectionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state instanceof ConnectionState.CONNECTED;
    }

    private static final Unit _init_$lambda$2(SecureWireOverStreamTransport this$0) {
        this$0.onWireTerminated();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(SecureWireOverStreamTransport this$0, Maybe previous, ConnectionState state) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this$0.onWireConnectionStateChanged((ConnectionState)previous.getAsNullable(), state);
        return Unit.INSTANCE;
    }

    private static final Unit onSystemFrameReceived$lambda$0(SecureWireOverStreamTransport this$0, SystemFrame $frame) {
        this$0.myConnectionState.setIfNotTerminal(new ConnectionState.DECLINED(((ForceTerminateWireFrame)$frame).getReason()));
        return Unit.INSTANCE;
    }

    private static final Unit subscribeWireOnNewTransport$lambda$3$0(SecureWireOverStreamTransport this$0, Throwable $throwable) {
        this$0.setFaultedState($throwable);
        return Unit.INSTANCE;
    }

    private static final Unit subscribeWireOnNewTransport$lambda$4$0(SecureWireOverStreamTransport this$0, ConnectionState $state) {
        this$0.onUnderlyingTransportConnectionStateChanged($state);
        return Unit.INSTANCE;
    }

    private static final boolean subscribeWireOnNewTransport$lambda$1(Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return !(frame instanceof PingFrame);
    }

    private static final Unit subscribeWireOnNewTransport$lambda$2(SecureWireOverStreamTransport this$0, Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this$0.onFrameReceived(frame);
        return Unit.INSTANCE;
    }

    private static final Unit subscribeWireOnNewTransport$lambda$3(TransportInfo $transportInfo, SecureWireOverStreamTransport this$0, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (Intrinsics.areEqual((Object)$transportInfo, (Object)this$0.getTransportInfo())) {
            ClientId.Companion.withClientId(this$0.getClientId(), () -> SecureWireOverStreamTransport.subscribeWireOnNewTransport$lambda$3$0(this$0, throwable));
        }
        return Unit.INSTANCE;
    }

    private static final Unit subscribeWireOnNewTransport$lambda$4(SecureWireOverStreamTransport this$0, TransportInfo $transportInfo, ConnectionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        SecureWireOverStreamTransportKt.access$getLogger$p().info(this$0.getName() + " Underlying transport changed state to: <" + state + "> (transport: " + $transportInfo.getName() + ")");
        ClientId.Companion.withClientId(this$0.getClientId(), () -> SecureWireOverStreamTransport.subscribeWireOnNewTransport$lambda$4$0(this$0, state));
        return Unit.INSTANCE;
    }

    private static final Unit subscribeWireTransportListenersOnNewTransport$lambda$1(SecureWireOverStreamTransport this$0, TransportInfo $transportInfo, ConnectionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this$0.getTransportChangedListener().transportConnectionStateChanged(this$0.getClientId(), $transportInfo, state);
        return Unit.INSTANCE;
    }

    private static final Unit subscribeWireTransportListenersOnNewTransport$lambda$2(SecureWireOverStreamTransport this$0, TransportInfo $transportInfo, ConnectionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!ConnectionState.Companion.isAlive(state)) {
            this$0.getTransportChangedListener().transportDisconnected(this$0.getClientId(), $transportInfo);
        }
        return Unit.INSTANCE;
    }

    private static final boolean waitUnderlyingTransportState$lambda$1(ConnectionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return !Intrinsics.areEqual((Object)state, (Object)ConnectionState.NOT_CONNECTED.INSTANCE);
    }

    private static final UnsafeBuffer threadLocalWriteBuffers$lambda$0() {
        return new UnsafeBuffer(new byte[16384]);
    }

    public static final /* synthetic */ Object access$waitUnderlyingTransportState(SecureWireOverStreamTransport $this, Continuation $completion) {
        return $this.waitUnderlyingTransportState((Continuation<? super ConnectionState>)$completion);
    }

    public static final /* synthetic */ boolean access$ensureConnectionEstablished(SecureWireOverStreamTransport $this, ConnectionState state) {
        return $this.ensureConnectionEstablished(state);
    }

    public static final /* synthetic */ Object access$handleTokensExchange(SecureWireOverStreamTransport $this, boolean isServer, Continuation $completion) {
        return $this.handleTokensExchange(isServer, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ boolean access$isServer$p(SecureWireOverStreamTransport $this) {
        return $this.isServer;
    }

    public static final /* synthetic */ Object access$handlePin(SecureWireOverStreamTransport $this, boolean isServer, List certificates, Continuation $completion) {
        return $this.handlePin(isServer, certificates, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handlePassword(SecureWireOverStreamTransport $this, Continuation $completion) {
        return $this.handlePassword((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$handleAcceptance(SecureWireOverStreamTransport $this, boolean isServer) {
        $this.handleAcceptance(isServer);
    }

    public static final /* synthetic */ ConnectionStateProperty access$getMyConnectionState$p(SecureWireOverStreamTransport $this) {
        return $this.myConnectionState;
    }

    public static final /* synthetic */ ServiceMessageProcessor access$getServiceMessageProcessor$p(SecureWireOverStreamTransport $this) {
        return $this.serviceMessageProcessor;
    }

    public static final /* synthetic */ AtomicReference access$getAllowedToStartReceiving$p(SecureWireOverStreamTransport $this) {
        return $this.allowedToStartReceiving;
    }

    public static final /* synthetic */ void access$setFaultedState(SecureWireOverStreamTransport $this, Throwable throwable) {
        $this.setFaultedState(throwable);
    }

    public static final /* synthetic */ void access$setClosedState(SecureWireOverStreamTransport $this) {
        $this.setClosedState();
    }

    public static final /* synthetic */ Object access$checkProtocolTrusted(SecureWireOverStreamTransport $this, List certificates, Continuation $completion) {
        return $this.checkProtocolTrusted(certificates, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Function2 access$getCheckBeforeProtocolTrusted$p(SecureWireOverStreamTransport $this) {
        return $this.checkBeforeProtocolTrusted;
    }

    public static final /* synthetic */ Object access$checkPasswordRequest(SecureWireOverStreamTransport $this, SystemFrame frame, Continuation $completion) {
        return $this.checkPasswordRequest(frame, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleTokenFrames(SecureWireOverStreamTransport $this, boolean isServer, Continuation $completion) {
        return $this.handleTokenFrames(isServer, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$waitSessionTokenFrame(SecureWireOverStreamTransport $this, Continuation $completion) {
        return $this.waitSessionTokenFrame((Continuation<? super SessionTokenFrame>)$completion);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/split/connection/protocol/wire/SecureWireOverStreamTransport$Companion;", "", "<init>", "()V", "threadLocalWriteBuffers", "Ljava/lang/ThreadLocal;", "Lcom/jetbrains/rd/framework/UnsafeBuffer;", "kotlin.jvm.PlatformType", "PIN_VALUE_BUFFER_SIZE", "", "intellij.platform.split.connection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/split/connection/protocol/wire/SecureWireOverStreamTransport$ReceivingState;", "", "NotAllowed", "Armed", "Allowed", "Lcom/intellij/platform/split/connection/protocol/wire/SecureWireOverStreamTransport$ReceivingState$Allowed;", "Lcom/intellij/platform/split/connection/protocol/wire/SecureWireOverStreamTransport$ReceivingState$Armed;", "Lcom/intellij/platform/split/connection/protocol/wire/SecureWireOverStreamTransport$ReceivingState$NotAllowed;", "intellij.platform.split.connection"})
    private static sealed interface ReceivingState {

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/split/connection/protocol/wire/SecureWireOverStreamTransport$ReceivingState$Allowed;", "Lcom/intellij/platform/split/connection/protocol/wire/SecureWireOverStreamTransport$ReceivingState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.split.connection"})
        public static final class Allowed
        implements ReceivingState {
            @NotNull
            public static final Allowed INSTANCE = new Allowed();

            private Allowed() {
            }

            @NotNull
            public String toString() {
                return "Allowed";
            }

            public int hashCode() {
                return -1728521922;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Allowed)) {
                    return false;
                }
                Allowed cfr_ignored_0 = (Allowed)other;
                return true;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/split/connection/protocol/wire/SecureWireOverStreamTransport$ReceivingState$Armed;", "Lcom/intellij/platform/split/connection/protocol/wire/SecureWireOverStreamTransport$ReceivingState;", "transport", "Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;", "<init>", "(Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;)V", "getTransport", "()Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;", "intellij.platform.split.connection"})
        public static final class Armed
        implements ReceivingState {
            @NotNull
            private final TransportInfo transport;

            public Armed(@NotNull TransportInfo transport) {
                Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
                this.transport = transport;
            }

            @NotNull
            public final TransportInfo getTransport() {
                return this.transport;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/split/connection/protocol/wire/SecureWireOverStreamTransport$ReceivingState$NotAllowed;", "Lcom/intellij/platform/split/connection/protocol/wire/SecureWireOverStreamTransport$ReceivingState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.split.connection"})
        public static final class NotAllowed
        implements ReceivingState {
            @NotNull
            public static final NotAllowed INSTANCE = new NotAllowed();

            private NotAllowed() {
            }

            @NotNull
            public String toString() {
                return "NotAllowed";
            }

            public int hashCode() {
                return 1453302783;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NotAllowed)) {
                    return false;
                }
                NotAllowed cfr_ignored_0 = (NotAllowed)other;
                return true;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WireConnectStatus.values().length];
            try {
                nArray[WireConnectStatus.PASSWORD_REQUIRED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.ACCEPTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.USER_DECLINED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.DECLINED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.INTERNAL_ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.GUEST_LIMIT_REACHED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.FORCE_TERMINATE_WIRE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.JOIN_PIN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.SESSION_TOKEN.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.WIRE_EXIST.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.CURRENT_CONFIRMED_FRAME_ACK.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.TRANSPORT_ACCEPTANCE.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WireConnectStatus.TRANSPORT_INDEX.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

