/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.connection.backend.statistics;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.connection.backend.CwmConnectionManagerHolder;
import com.intellij.cwm.connection.backend.CwmConnectionManagerImpl;
import com.intellij.cwm.connection.backend.join.RdServerJoinLinkManager;
import com.intellij.cwm.connection.backend.statistics.CwmGuestsConnectionStatisticsManager;
import com.intellij.cwm.connection.backend.statistics.CwmSessionStatisticsManager;
import com.intellij.cwm.connection.lobby.LobbyServerSessionClient;
import com.intellij.cwm.connection.lobby.SessionTokenUtilKt;
import com.intellij.cwm.plugin.following.FollowMeManager;
import com.intellij.cwm.plugin.join.BackendJoinLinkManager;
import com.intellij.cwm.plugin.join.JoinLinkData;
import com.intellij.cwm.plugin.join.UtilKt;
import com.intellij.cwm.plugin.permissions.CwmSharedPermissionManager;
import com.intellij.cwm.plugin.permissions.CwmSharedPermissionManagerKt;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.platform.split.connection.TransportType;
import com.intellij.platform.split.connection.protocol.ConnectionState;
import com.intellij.platform.split.connection.protocol.ICodeWithMeWire;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportInfo;
import com.intellij.platform.split.connection.protocol.wire.SecureWireOverStreamTransport;
import com.intellij.platform.split.connection.protocol.wire.storage.WireStorageEntry;
import com.jetbrains.codeWithMe.lobby.CodeWithMeTransport;
import com.jetbrains.codeWithMe.lobby.SessionToken;
import com.jetbrains.codeWithMe.model.RdUserModel;
import com.jetbrains.rd.platform.codeWithMe.statistics.CodeWithMeLifecycleUsagesCollector;
import com.jetbrains.rd.platform.codeWithMe.statistics.PermissionStatisticsData;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rdserver.permissions.PermissionModel;
import com.jetbrains.rdserver.startup.RdServerConnectionManager;
import com.jetbrains.rdserver.startup.SecureClientData;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 22\u00020\u0001:\u00012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J&\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0082@\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u0015H\u0002J(\u0010\"\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J2\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00112\b\u0010+\u001a\u0004\u0018\u00010\u00112\b\u0010,\u001a\u0004\u0018\u00010\u0011H\u0082@\u00a2\u0006\u0002\u0010-JB\u0010.\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00182\b\u0010/\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001d\u001a\u00020\u00112\b\u00100\u001a\u0004\u0018\u00010\u0011H\u0082@\u00a2\u0006\u0002\u00101R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/cwm/connection/backend/statistics/CwmGuestsConnectionStatisticsManager;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "projectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;Lkotlinx/coroutines/CoroutineScope;)V", "wire", "Lcom/intellij/platform/split/connection/protocol/ICodeWithMeWire;", "lastTransportInfo", "Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;", "getLastTransportInfo", "()Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;", "setLastTransportInfo", "(Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;)V", "sessionId", "", "sessionClient", "Lcom/intellij/cwm/connection/lobby/LobbyServerSessionClient;", "onGuestConnected", "", "onGuestDisconnected", "guestConnectedTimestamp", "", "reportGuestDisconnectedLobby", "connectionManager", "Lcom/jetbrains/rdserver/startup/RdServerConnectionManager;", "clientConnectionDurationInMillis", "disconnectReason", "(Lcom/jetbrains/rdserver/startup/RdServerConnectionManager;JLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reportGuestConnectedLobby", "(Lcom/jetbrains/rdserver/startup/RdServerConnectionManager;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reportGuestConnectedFus", "reportGuestDisconnectedFus", "currentGuests", "", "user", "Lcom/jetbrains/codeWithMe/model/RdUserModel;", "onClientConnectedLobby", "transportType", "Lcom/intellij/platform/split/connection/TransportType;", "clientAnonymizedInstallId", "connectedClientMoniker", "connectedUserSubject", "(Lcom/intellij/platform/split/connection/TransportType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onClientDisconnectedLobby", "disconnectedClientMoniker", "disconnectedUserSubject", "(Lcom/intellij/platform/split/connection/TransportType;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.cwm.connection.backend"})
@SourceDebugExtension(value={"SMAP\nCwmGuestsConnectionStatisticsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CwmGuestsConnectionStatisticsManager.kt\ncom/intellij/cwm/connection/backend/statistics/CwmGuestsConnectionStatisticsManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,252:1\n30#2,2:253\n13#3:255\n*S KotlinDebug\n*F\n+ 1 CwmGuestsConnectionStatisticsManager.kt\ncom/intellij/cwm/connection/backend/statistics/CwmGuestsConnectionStatisticsManager\n*L\n74#1:253,2\n240#1:255\n*E\n"})
public final class CwmGuestsConnectionStatisticsManager
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession projectSession;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private ICodeWithMeWire wire;
    @Nullable
    private TransportInfo lastTransportInfo;
    @Nullable
    private String sessionId;
    @Nullable
    private LobbyServerSessionClient sessionClient;
    private long guestConnectedTimestamp;
    @NotNull
    private static final Logger logger;

    public CwmGuestsConnectionStatisticsManager(@NotNull ClientProjectSession projectSession, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)projectSession, (String)"projectSession");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.projectSession = projectSession;
        this.coroutineScope = coroutineScope;
        this.guestConnectedTimestamp = System.currentTimeMillis();
    }

    @Nullable
    public final TransportInfo getLastTransportInfo() {
        return this.lastTransportInfo;
    }

    public final void setLastTransportInfo(@Nullable TransportInfo transportInfo2) {
        this.lastTransportInfo = transportInfo2;
    }

    public final void onGuestConnected() {
        CwmConnectionManagerImpl connectionManager = CwmConnectionManagerHolder.Companion.getInstance(this.projectSession.getProject()).getConnectionManager();
        WireStorageEntry wireDesc = connectionManager.getWireStorage().getWire(this.projectSession.getClientId());
        BackendJoinLinkManager joinLinkManager = BackendJoinLinkManager.Companion.getInstance(this.projectSession.getProject());
        this.sessionId = joinLinkManager.getCurrentSessionId();
        ICodeWithMeWire iCodeWithMeWire = this.wire = wireDesc.getWireInfo().getWire();
        this.lastTransportInfo = iCodeWithMeWire != null ? iCodeWithMeWire.getTransportInfo() : null;
        JoinLinkData joinLinkData = joinLinkManager.getJoinLinkData();
        RdServerJoinLinkManager.JoinLinkDataImpl joinLinkDataImpl = joinLinkData instanceof RdServerJoinLinkManager.JoinLinkDataImpl ? (RdServerJoinLinkManager.JoinLinkDataImpl)joinLinkData : null;
        LobbyServerSessionClient lobbyServerSessionClient = joinLinkDataImpl != null && (joinLinkDataImpl = joinLinkDataImpl.getLobbyServerSession()) != null ? joinLinkDataImpl.getSessionClient() : (this.sessionClient = null);
        if (this.sessionClient == null && !PluginManagerCore.isRunningFromSources() && !ApplicationManagerEx.isInIntegrationTest()) {
            logger.error("Failed to get Lobby server session client");
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, connectionManager, null){
            int label;
            final /* synthetic */ CwmGuestsConnectionStatisticsManager this$0;
            final /* synthetic */ CwmConnectionManagerImpl $connectionManager;
            {
                this.this$0 = $receiver;
                this.$connectionManager = $connectionManager;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CwmGuestsConnectionStatisticsManager.access$reportGuestConnectedFus(this.this$0);
                        this.label = 1;
                        v0 = CwmGuestsConnectionStatisticsManager.access$reportGuestConnectedLobby(this.this$0, this.$connectionManager, (Continuation)this);
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        CwmGuestsConnectionStatisticsManager.access$setGuestConnectedTimestamp$p(this.this$0, System.currentTimeMillis());
                        $this$service$iv = (ComponentManager)CwmGuestsConnectionStatisticsManager.access$getProjectSession$p(this.this$0).getProject();
                        $i$f$service = false;
                        serviceClass$iv = CwmSessionStatisticsManager.class;
                        v1 = $this$service$iv.getService(serviceClass$iv);
                        if (v1 == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        ((CwmSessionStatisticsManager)v1).guestConnected();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void onGuestDisconnected() {
        CwmConnectionManagerImpl connectionManager = CwmConnectionManagerHolder.Companion.getInstance(this.projectSession.getProject()).getConnectionManager();
        ICodeWithMeWire iCodeWithMeWire = this.wire;
        Intrinsics.checkNotNull((Object)iCodeWithMeWire);
        ConnectionState state = (ConnectionState)iCodeWithMeWire.getConnectionState().getValue();
        boolean connectionFailed = state instanceof ConnectionState.FAULTED;
        String disconnectReason = connectionFailed ? "Connection Failed" : "Manual disconnect";
        long clientConnectionDurationInMillis = System.currentTimeMillis() - this.guestConnectedTimestamp;
        ComponentManager $this$service$iv = (ComponentManager)this.projectSession.getProject();
        boolean $i$f$service = false;
        Class<CwmSessionStatisticsManager> serviceClass$iv = CwmSessionStatisticsManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        int currentGuests = ((CwmSessionStatisticsManager)((Object)object)).getCurrentGuestsCount();
        RdUserModel user = FollowMeManager.Companion.getInstance(this.projectSession.getProject()).getUser(this.projectSession.getClientId());
        String sessionId = this.sessionId;
        if (sessionId == null) {
            logger.error("sessionId is null upon disconnection of Code With Me guest. Impossibru");
            return;
        }
        RdCoroutinesUtilKt.launchChildBackground$default((CoroutineScope)this.coroutineScope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, connectionManager, clientConnectionDurationInMillis, disconnectReason, currentGuests, user, sessionId, null){
            int label;
            final /* synthetic */ CwmGuestsConnectionStatisticsManager this$0;
            final /* synthetic */ CwmConnectionManagerImpl $connectionManager;
            final /* synthetic */ long $clientConnectionDurationInMillis;
            final /* synthetic */ String $disconnectReason;
            final /* synthetic */ int $currentGuests;
            final /* synthetic */ RdUserModel $user;
            final /* synthetic */ String $sessionId;
            {
                this.this$0 = $receiver;
                this.$connectionManager = $connectionManager;
                this.$clientConnectionDurationInMillis = $clientConnectionDurationInMillis;
                this.$disconnectReason = $disconnectReason;
                this.$currentGuests = $currentGuests;
                this.$user = $user;
                this.$sessionId = $sessionId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = CwmGuestsConnectionStatisticsManager.access$reportGuestDisconnectedLobby(this.this$0, this.$connectionManager, this.$clientConnectionDurationInMillis, this.$disconnectReason, (Continuation)this);
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        CwmGuestsConnectionStatisticsManager.access$reportGuestDisconnectedFus(this.this$0, this.$clientConnectionDurationInMillis, this.$currentGuests, this.$user, this.$sessionId);
                        $this$service$iv = (ComponentManager)CwmGuestsConnectionStatisticsManager.access$getProjectSession$p(this.this$0).getProject();
                        $i$f$service = false;
                        serviceClass$iv = CwmSessionStatisticsManager.class;
                        v1 = $this$service$iv.getService(serviceClass$iv);
                        if (v1 == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        ((CwmSessionStatisticsManager)v1).guestDisconnected();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object reportGuestDisconnectedLobby(RdServerConnectionManager connectionManager, long clientConnectionDurationInMillis, String disconnectReason, Continuation<? super Unit> $completion) {
        if (!($completion instanceof reportGuestDisconnectedLobby.1)) ** GOTO lbl-1000
        var12_5 = $completion;
        if ((var12_5.label & -2147483648) != 0) {
            var12_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ CwmGuestsConnectionStatisticsManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return CwmGuestsConnectionStatisticsManager.access$reportGuestDisconnectedLobby(this.this$0, null, 0L, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                transportInfo = this.lastTransportInfo;
                if (transportInfo == null) {
                    CwmGuestsConnectionStatisticsManager.logger.error("transportInfo is null when user disconnected");
                    return Unit.INSTANCE;
                }
                var10_11 = this.wire;
                v0 = var10_11 instanceof SecureWireOverStreamTransport != false ? (SecureWireOverStreamTransport)var10_11 : null;
                var8_13 = v0 != null && (v0 = v0.getSessionTokenHandler()) != null ? v0.getRemoteToken() : null;
                v1 = counterpartSessionToken = var8_13 instanceof SessionToken != false ? (SessionToken)var8_13 : null;
                disconnectedUserMoniker = v1 != null ? SessionTokenUtilKt.getUserMoniker((SessionToken)v1) : null;
                v2 = counterpartSessionToken;
                disconnectedUserSubject = v2 != null ? v2.getSubject() : null;
                clientData = connectionManager.getClientDataFromTransport(transportInfo);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)connectionManager);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)disconnectReason);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)transportInfo);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)counterpartSessionToken);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)disconnectedUserMoniker);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)disconnectedUserSubject);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)clientData);
                $continuation.J$0 = clientConnectionDurationInMillis;
                $continuation.label = 1;
                v3 = this.onClientDisconnectedLobby(transportInfo.getTransportType(), clientData.getClientAnonymizedInstallId(), clientConnectionDurationInMillis, disconnectedUserMoniker, disconnectReason, disconnectedUserSubject, (Continuation<? super Unit>)$continuation);
                ** if (v3 != var13_7) goto lbl38
lbl37:
                // 1 sources

                return var13_7;
lbl38:
                // 1 sources

                ** GOTO lbl55
            }
            case 1: {
                clientConnectionDurationInMillis = $continuation.J$0;
                clientData = (SecureClientData)$continuation.L$6;
                disconnectedUserSubject = (String)$continuation.L$5;
                disconnectedUserMoniker = (String)$continuation.L$4;
                counterpartSessionToken = (SessionToken)$continuation.L$3;
                transportInfo = (TransportInfo)$continuation.L$2;
                disconnectReason = (String)$continuation.L$1;
                connectionManager = (RdServerConnectionManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
                }
                catch (Throwable t) {
                    CwmGuestsConnectionStatisticsManager.logger.warn("Failed to send Lobby client connected statistics due to exception: " + t.getMessage(), t);
                }
lbl55:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object reportGuestConnectedLobby(RdServerConnectionManager connectionManager, Continuation<? super Unit> $completion) {
        if (!($completion instanceof reportGuestConnectedLobby.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                /* synthetic */ Object result;
                final /* synthetic */ CwmGuestsConnectionStatisticsManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return CwmGuestsConnectionStatisticsManager.access$reportGuestConnectedLobby(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                wireDesc = connectionManager.getWireStorage().getWire(this.projectSession.getClientId());
                wire = wireDesc.getWireInfo().getWire();
                transportInfo = wire.getTransportInfo();
                if (transportInfo == null) {
                    CwmGuestsConnectionStatisticsManager.logger.error("transportInfo is null when user connected");
                    return Unit.INSTANCE;
                }
                v0 = wire instanceof SecureWireOverStreamTransport != false ? (SecureWireOverStreamTransport)wire : null;
                var7_13 = v0 != null && (v0 = v0.getSessionTokenHandler()) != null ? v0.getRemoteToken() : null;
                v1 = counterpartSessionToken = var7_13 instanceof SessionToken != false ? (SessionToken)var7_13 : null;
                connectedUserMoniker = v1 != null ? SessionTokenUtilKt.getUserMoniker((SessionToken)v1) : null;
                v2 = counterpartSessionToken;
                connectedUserSubject = v2 != null ? v2.getSubject() : null;
                clientData = connectionManager.getClientDataFromTransport(transportInfo);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)connectionManager);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)wireDesc);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)wire);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)transportInfo);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)counterpartSessionToken);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)connectedUserMoniker);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)connectedUserSubject);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)clientData);
                $continuation.label = 1;
                v3 = this.onClientConnectedLobby(transportInfo.getTransportType(), clientData.getClientAnonymizedInstallId(), connectedUserMoniker, connectedUserSubject, (Continuation<? super Unit>)$continuation);
                ** if (v3 != var12_5) goto lbl39
lbl38:
                // 1 sources

                return var12_5;
lbl39:
                // 1 sources

                ** GOTO lbl56
            }
            case 1: {
                clientData = (SecureClientData)$continuation.L$7;
                connectedUserSubject = (String)$continuation.L$6;
                connectedUserMoniker = (String)$continuation.L$5;
                counterpartSessionToken = (SessionToken)$continuation.L$4;
                transportInfo = (TransportInfo)$continuation.L$3;
                wire = (ICodeWithMeWire)$continuation.L$2;
                wireDesc = (WireStorageEntry)$continuation.L$1;
                connectionManager = (RdServerConnectionManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
                }
                catch (Throwable t) {
                    CwmGuestsConnectionStatisticsManager.logger.warn("Failed to send Lobby client connected statistics due to exception: " + t.getMessage(), t);
                }
lbl56:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void reportGuestConnectedFus() {
        try {
            int guestsCount = ClientSessionsManager.Companion.getProjectSessions(this.projectSession.getProject(), ClientKind.GUEST).size();
            CwmSharedPermissionManager sharedPermissionManager = CwmSharedPermissionManager.Companion.getInstance(this.projectSession.getProject());
            PermissionModel permissions = sharedPermissionManager.getClientPermissionModel(this.projectSession);
            String string = BackendJoinLinkManager.Companion.getInstance(this.projectSession.getProject()).getCurrentSessionId();
            Intrinsics.checkNotNull((Object)string);
            String sessionId = string;
            ClientId clientId = this.projectSession.getClientId();
            PermissionStatisticsData permissionStatisticsData = CwmSharedPermissionManagerKt.toStatisticsData((PermissionModel)permissions);
            TransportInfo transportInfo2 = this.lastTransportInfo;
            Intrinsics.checkNotNull((Object)transportInfo2);
            CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.onCwmGuestConnected(sessionId, clientId, guestsCount, permissionStatisticsData, transportInfo2.getTransportType(), AppMode.isRemoteDevHost());
        }
        catch (Throwable t) {
            logger.warn("Failed to send FUS client connected statistics due to exception: " + t.getMessage(), t);
        }
    }

    private final void reportGuestDisconnectedFus(long clientConnectionDurationInMillis, int currentGuests, RdUserModel user, String sessionId) {
        try {
            int clientConnectionDurationInMinutes = (int)(clientConnectionDurationInMillis / (long)1000 / (long)60);
            CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.onCwmGuestDisconnected(sessionId, new ClientId(user.getUserId().getClientIdValue()), currentGuests, clientConnectionDurationInMinutes);
        }
        catch (Throwable t) {
            logger.warn("Failed to send FUS client connected statistics due to exception: " + t.getMessage(), t);
        }
    }

    private final Object onClientConnectedLobby(TransportType transportType, String clientAnonymizedInstallId, String connectedClientMoniker, String connectedUserSubject, Continuation<? super Unit> $completion) {
        if (this.sessionClient == null) {
            if (!PluginManagerCore.isRunningFromSources() && !ApplicationManagerEx.isInIntegrationTest()) {
                logger.error("Cannot report onClientConnected lobby statistics. sessionClient is null");
            }
            return Unit.INSTANCE;
        }
        Object object = UtilKt.withExponentialRetry$default((double)2.0, (int)3, null, () -> CwmGuestsConnectionStatisticsManager.onClientConnectedLobby$lambda$0(this, transportType, clientAnonymizedInstallId, connectedClientMoniker, connectedUserSubject), $completion, (int)4, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object onClientDisconnectedLobby(TransportType transportType, String clientAnonymizedInstallId, long clientConnectionDurationInMillis, String disconnectedClientMoniker, String disconnectReason, String disconnectedUserSubject, Continuation<? super Unit> $completion) {
        if (this.sessionClient == null) {
            if (!PluginManagerCore.isRunningFromSources() && !ApplicationManagerEx.isInIntegrationTest()) {
                logger.error("Cannot report onClientConnected lobby statistics. sessionClient is null");
            }
            return Unit.INSTANCE;
        }
        Object object = UtilKt.withExponentialRetry$default((double)2.0, (int)3, null, () -> CwmGuestsConnectionStatisticsManager.onClientDisconnectedLobby$lambda$0(this, transportType, clientConnectionDurationInMillis, disconnectReason, clientAnonymizedInstallId, disconnectedClientMoniker, disconnectedUserSubject), $completion, (int)4, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Unit onClientConnectedLobby$lambda$0(CwmGuestsConnectionStatisticsManager this$0, TransportType $transportType, String $clientAnonymizedInstallId, String $connectedClientMoniker, String $connectedUserSubject) {
        LobbyServerSessionClient lobbyServerSessionClient = this$0.sessionClient;
        Intrinsics.checkNotNull((Object)lobbyServerSessionClient);
        lobbyServerSessionClient.clientConnected(CwmGuestsConnectionStatisticsManager.Companion.toCodeWithMeTransport($transportType), $clientAnonymizedInstallId, $connectedClientMoniker, $connectedUserSubject);
        return Unit.INSTANCE;
    }

    private static final Unit onClientDisconnectedLobby$lambda$0(CwmGuestsConnectionStatisticsManager this$0, TransportType $transportType, long $clientConnectionDurationInMillis, String $disconnectReason, String $clientAnonymizedInstallId, String $disconnectedClientMoniker, String $disconnectedUserSubject) {
        LobbyServerSessionClient lobbyServerSessionClient = this$0.sessionClient;
        Intrinsics.checkNotNull((Object)lobbyServerSessionClient);
        lobbyServerSessionClient.clientDisconnected(CwmGuestsConnectionStatisticsManager.Companion.toCodeWithMeTransport($transportType), $clientConnectionDurationInMillis, $disconnectReason, $clientAnonymizedInstallId, $disconnectedClientMoniker, $disconnectedUserSubject);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$reportGuestConnectedFus(CwmGuestsConnectionStatisticsManager $this) {
        $this.reportGuestConnectedFus();
    }

    public static final /* synthetic */ Object access$reportGuestConnectedLobby(CwmGuestsConnectionStatisticsManager $this, RdServerConnectionManager connectionManager, Continuation $completion) {
        return $this.reportGuestConnectedLobby(connectionManager, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$setGuestConnectedTimestamp$p(CwmGuestsConnectionStatisticsManager $this, long l) {
        $this.guestConnectedTimestamp = l;
    }

    public static final /* synthetic */ ClientProjectSession access$getProjectSession$p(CwmGuestsConnectionStatisticsManager $this) {
        return $this.projectSession;
    }

    public static final /* synthetic */ Object access$reportGuestDisconnectedLobby(CwmGuestsConnectionStatisticsManager $this, RdServerConnectionManager connectionManager, long clientConnectionDurationInMillis, String disconnectReason, Continuation $completion) {
        return $this.reportGuestDisconnectedLobby(connectionManager, clientConnectionDurationInMillis, disconnectReason, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$reportGuestDisconnectedFus(CwmGuestsConnectionStatisticsManager $this, long clientConnectionDurationInMillis, int currentGuests, RdUserModel user, String sessionId) {
        $this.reportGuestDisconnectedFus(clientConnectionDurationInMillis, currentGuests, user, sessionId);
    }

    public static final /* synthetic */ Object access$onClientConnectedLobby(CwmGuestsConnectionStatisticsManager $this, TransportType transportType, String clientAnonymizedInstallId, String connectedClientMoniker, String connectedUserSubject, Continuation $completion) {
        return $this.onClientConnectedLobby(transportType, clientAnonymizedInstallId, connectedClientMoniker, connectedUserSubject, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$onClientDisconnectedLobby(CwmGuestsConnectionStatisticsManager $this, TransportType transportType, String clientAnonymizedInstallId, long clientConnectionDurationInMillis, String disconnectedClientMoniker, String disconnectReason, String disconnectedUserSubject, Continuation $completion) {
        return $this.onClientDisconnectedLobby(transportType, clientAnonymizedInstallId, clientConnectionDurationInMillis, disconnectedClientMoniker, disconnectReason, disconnectedUserSubject, (Continuation<? super Unit>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CwmGuestsConnectionStatisticsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CwmGuestsConnectionStatisticsManager.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/cwm/connection/backend/statistics/CwmGuestsConnectionStatisticsManager$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "toCodeWithMeTransport", "Lcom/jetbrains/codeWithMe/lobby/CodeWithMeTransport;", "Lcom/intellij/platform/split/connection/TransportType;", "intellij.cwm.connection.backend"})
    public static final class Companion {
        private Companion() {
        }

        private final CodeWithMeTransport toCodeWithMeTransport(TransportType $this$toCodeWithMeTransport) {
            return switch (WhenMappings.$EnumSwitchMapping$0[$this$toCodeWithMeTransport.ordinal()]) {
                case 1 -> CodeWithMeTransport.WsRelay;
                case 2 -> CodeWithMeTransport.TurnRelayQuic;
                case 3 -> CodeWithMeTransport.Peer2PeerQuic;
                case 4 -> CodeWithMeTransport.DirectTcp;
                case 5 -> CodeWithMeTransport.Unknown;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TransportType.values().length];
                try {
                    nArray[TransportType.WsRelay.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransportType.TurnRelayQuic.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransportType.Peer2PeerQuic.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransportType.DirectTcp.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransportType.Unknown.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

