/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.frontend.split;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DefaultFlagsProvider;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.LineStatusMarkerDrawUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.ex.ChangesBlock;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupPanel;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupService;
import com.intellij.openapi.vcs.ex.VisibleRangeMerger;
import com.intellij.platform.vcs.frontend.split.FrontendVcsGutterMarkersHostKt;
import com.intellij.platform.vcs.frontend.split.VcsGutterMarkerInfo;
import com.intellij.platform.vcs.frontend.split.VcsLineRange;
import com.intellij.ui.EditorTextField;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.VcsGutterMarkersModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0001@B)\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0017H\u0016J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0017H\u0016J \u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\"2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010)\u001a\u00020*H\u0016J\"\u0010,\u001a\u0004\u0018\u00010&2\u0006\u0010!\u001a\u00020\"2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020&H\u0016J\b\u00100\u001a\u000201H\u0016J\f\u00102\u001a\b\u0012\u0004\u0012\u00020403J\u001c\u00105\u001a\u0004\u0018\u0001042\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000109H\u0002J \u0010:\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010;\u001a\u0002042\u0006\u0010)\u001a\u00020*H\u0002J \u0010<\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010;\u001a\u0002042\b\u0010=\u001a\u0004\u0018\u00010>J,\u0010<\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010;\u001a\u0002042\b\u0010?\u001a\u0004\u0018\u0001012\b\u0010=\u001a\u0004\u0018\u00010>H\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0015\u001a2\u0012\u000e\u0012\f0\u0017\u00a2\u0006\u0002\b\u0018\u00a2\u0006\u0002\b\u0019 \u001b*\u0017\u0012\u000e\u0012\f0\u0017\u00a2\u0006\u0002\b\u0018\u00a2\u0006\u0002\b\u00190\u001a\u00a2\u0006\u0002\b\u00180\u0016\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/platform/vcs/frontend/split/FrontendVcsGutterMarkRenderer;", "Lcom/intellij/openapi/editor/markup/ActiveGutterRenderer;", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "document", "Lcom/intellij/openapi/editor/Document;", "vcsGutterMarkersModel", "Lcom/jetbrains/rd/ide/model/VcsGutterMarkersModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Document;Lcom/jetbrains/rd/ide/model/VcsGutterMarkersModel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "disposable", "Lcom/intellij/openapi/Disposable;", "vcsMarkerRenderers", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "afterAdded", "", "highlighter", "afterRemoved", "paint", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "canDoAction", "", "e", "Ljava/awt/event/MouseEvent;", "doAction", "calcBounds", "lineNum", "", "preferredBounds", "getAccessibleName", "", "getRanges", "", "Lcom/intellij/platform/vcs/frontend/split/VcsLineRange;", "createLstRange", "rangeMarker", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "markerData", "Lcom/intellij/platform/vcs/frontend/split/VcsGutterMarkerInfo;", "showHint", "range", "showHintAt", "mousePosition", "Ljava/awt/Point;", "baseContent", "Companion", "intellij.platform.vcs.frontend.split"})
@SourceDebugExtension(value={"SMAP\nFrontendVcsGutterMarkersHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendVcsGutterMarkersHost.kt\ncom/intellij/platform/vcs/frontend/split/FrontendVcsGutterMarkRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,399:1\n1642#2,10:400\n1915#2:410\n1916#2:412\n1652#2:413\n1068#2:414\n1#3:411\n13#4:415\n*S KotlinDebug\n*F\n+ 1 FrontendVcsGutterMarkersHost.kt\ncom/intellij/platform/vcs/frontend/split/FrontendVcsGutterMarkRenderer\n*L\n216#1:400,10\n216#1:410\n216#1:412\n216#1:413\n219#1:414\n216#1:411\n253#1:415\n*E\n"})
public final class FrontendVcsGutterMarkRenderer
implements ActiveGutterRenderer,
MarkupModelListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Document document;
    @NotNull
    private final VcsGutterMarkersModel vcsGutterMarkersModel;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final Set<RangeHighlighterEx> vcsMarkerRenderers;
    @NotNull
    private static final Key<FrontendVcsGutterMarkRenderer> KEY;

    public FrontendVcsGutterMarkRenderer(@Nullable Project project, @NotNull Lifetime lifetime, @NotNull Document document, @NotNull VcsGutterMarkersModel vcsGutterMarkersModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)vcsGutterMarkersModel, (String)"vcsGutterMarkersModel");
        this.project = project;
        this.lifetime = lifetime;
        this.document = document;
        this.vcsGutterMarkersModel = vcsGutterMarkersModel;
        this.disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null);
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.vcsMarkerRenderers = set;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        if (VcsGutterMarkerInfo.Companion.getVcsMarkerInfo((RangeHighlighter)highlighter) != null) {
            this.vcsMarkerRenderers.add(highlighter);
        }
    }

    public void afterRemoved(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        if (VcsGutterMarkerInfo.Companion.getVcsMarkerInfo((RangeHighlighter)highlighter) != null) {
            this.vcsMarkerRenderers.remove(highlighter);
        }
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        List blocks = VisibleRangeMerger.merge((Editor)editor, this.getRanges(), (VisibleRangeMerger.FlagsProvider)DefaultFlagsProvider.DEFAULT, (Rectangle)g.getClipBounds());
        EditorGutterComponentEx editorGutterComponentEx = ((EditorEx)editor).getGutterComponentEx();
        Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
        EditorGutterComponentEx gutterComponentEx = editorGutterComponentEx;
        LineStatusMarkerDrawUtil.GroupedBlocks groupedBlocks = LineStatusMarkerDrawUtil.groupBlocks((Editor)editor, (EditorGutterComponentEx)gutterComponentEx, (List)blocks);
        Intrinsics.checkNotNullExpressionValue((Object)groupedBlocks, (String)"groupBlocks(...)");
        LineStatusMarkerDrawUtil.GroupedBlocks groupedBlocks2 = groupedBlocks;
        for (ChangesBlock block : groupedBlocks2.unhoveredBlocks()) {
            LineStatusMarkerDrawUtil.paintChangedLines((Graphics2D)((Graphics2D)g), (Editor)editor, (List)block.changes, (int)0, (boolean)false);
        }
        for (ChangesBlock block : groupedBlocks2.hoveredBlocks()) {
            LineStatusMarkerDrawUtil.paintChangedLines((Graphics2D)((Graphics2D)g), (Editor)editor, (List)block.changes, (int)0, (boolean)true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canDoAction(@NotNull Editor editor, @NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!LineStatusMarkerDrawUtil.isInsideMarkerArea((MouseEvent)e)) {
            return false;
        }
        List list = LineStatusMarkerDrawUtil.getSelectedRanges(this.getRanges(), (Editor)editor, (int)e.getY());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedRanges(...)");
        List ranges = list;
        if (((Collection)ranges).isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        Object e2 = ranges.get(0);
        Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type com.intellij.platform.vcs.frontend.split.VcsLineRange");
        if (((VcsLineRange)((Object)e2)).getId() == -1L) return false;
        return true;
    }

    public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List list = LineStatusMarkerDrawUtil.getSelectedRanges(this.getRanges(), (Editor)editor, (int)e.getY());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedRanges(...)");
        List ranges = list;
        if (!((Collection)ranges).isEmpty()) {
            Object e2 = ranges.get(0);
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type com.intellij.platform.vcs.frontend.split.VcsLineRange");
            this.showHint(editor, (VcsLineRange)((Object)e2), e);
        }
    }

    @Nullable
    public Rectangle calcBounds(@NotNull Editor editor, int lineNum, @NotNull Rectangle preferredBounds) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)preferredBounds, (String)"preferredBounds");
        return LineStatusMarkerDrawUtil.calcBounds(this.getRanges(), (Editor)editor, (int)lineNum);
    }

    @NotNull
    public String getAccessibleName() {
        String string = DiffBundle.message((String)"vcs.marker.changed.line", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VcsLineRange> getRanges() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.vcsMarkerRenderers;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VcsLineRange it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RangeHighlighterEx it = (RangeHighlighterEx)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (this.createLstRange((RangeHighlighter)it, VcsGutterMarkerInfo.Companion.getVcsMarkerInfo((RangeHighlighter)it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List ranges = (List)destination$iv$iv;
        List mergedRanges = new ArrayList();
        Iterable $this$sortedBy$iv = ranges;
        boolean $i$f$sortedBy = false;
        for (VcsLineRange range : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                VcsLineRange it = (VcsLineRange)((Object)a);
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getLine1());
                it = (VcsLineRange)((Object)b);
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getLine1()));
            }
        })) {
            VcsLineRange lastRange = (VcsLineRange)((Object)CollectionsKt.lastOrNull((List)mergedRanges));
            if (lastRange == null || lastRange.getLine2() < range.getLine1()) {
                mergedRanges.add(range);
                continue;
            }
            VcsLineRange merged = new VcsLineRange(-1L, lastRange.getLine1(), range.getLine2(), 0, 1);
            mergedRanges.set(CollectionsKt.getLastIndex((List)mergedRanges), merged);
        }
        return mergedRanges;
    }

    private final VcsLineRange createLstRange(RangeHighlighter rangeMarker, VcsGutterMarkerInfo markerData) {
        if (markerData == null || !rangeMarker.isValid()) {
            return null;
        }
        int line1 = this.document.getLineNumber(rangeMarker.getStartOffset());
        int line2 = markerData.getType() == 3 ? line1 : this.document.getLineNumber(rangeMarker.getEndOffset()) + 1;
        return new VcsLineRange(markerData.getId(), line1, line2, 0, markerData.getType() == 2 ? 0 : 1);
    }

    private final void showHint(Editor editor, VcsLineRange range, MouseEvent e) {
        Component component = e.getComponent();
        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent comp = (JComponent)component;
        JLayeredPane layeredPane = comp.getRootPane().getLayeredPane();
        Component component2 = comp;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        Point point = SwingUtilities.convertPoint(component2, ((EditorEx)editor).getGutterComponentEx().getWidth(), e.getY(), layeredPane);
        this.showHintAt(editor, range, point);
        e.consume();
    }

    public final void showHintAt(@NotNull Editor editor, @NotNull VcsLineRange range, @Nullable Point mousePosition) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)range), (String)"range");
        if (range.hasVcsLines()) {
            SourceExKt.adviseOnce((ISource)this.vcsGutterMarkersModel.getGetOldContent().start((Object)range.getId()).getResult().getChange(), (Lifetime)this.lifetime, arg_0 -> FrontendVcsGutterMarkRenderer.showHintAt$lambda$0(this, editor, range, mousePosition, arg_0));
        } else {
            this.showHintAt(editor, range, null, mousePosition);
        }
    }

    private final void showHintAt(Editor editor, VcsLineRange range, String baseContent, Point mousePosition) {
        LineStatusMarkerPopupService.Companion.getInstance().buildAndShowPopup(this.disposable, editor, mousePosition, arg_0 -> FrontendVcsGutterMarkRenderer.showHintAt$lambda$1(editor, baseContent, this, range, arg_0));
    }

    private static final Unit showHintAt$lambda$0(FrontendVcsGutterMarkRenderer this$0, Editor $editor, VcsLineRange $range, Point $mousePosition, RdTaskResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof RdTaskResult.Cancelled) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FrontendVcsGutterMarkRenderer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Host cancelled popup request");
        } else {
            this$0.showHintAt($editor, $range, (String)it.unwrap(), $mousePosition);
        }
        return Unit.INSTANCE;
    }

    private static final LineStatusMarkerPopupPanel showHintAt$lambda$1(Editor $editor, String $baseContent, FrontendVcsGutterMarkRenderer this$0, VcsLineRange $range, Disposable popupDisposable) {
        Intrinsics.checkNotNullParameter((Object)popupDisposable, (String)"popupDisposable");
        ActionManager actionManager = ActionManager.getInstance();
        Object[] objectArray = new AnAction[]{actionManager.getAction("VcsShowPrevChangeMarker"), actionManager.getAction("VcsShowNextChangeMarker"), actionManager.getAction("Vcs.RollbackChangedLines"), actionManager.getAction("Vcs.ShowDiffChangedLines")};
        List actions = CollectionsKt.listOf((Object[])objectArray);
        ActionToolbar actionToolbar = LineStatusMarkerPopupPanel.buildToolbar((Editor)$editor, (List)actions, (Disposable)popupDisposable);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"buildToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        JComponent editorComponent = null;
        if ($baseContent != null) {
            EditorTextField editorTextField = LineStatusMarkerPopupPanel.createTextField((Editor)$editor, (String)$baseContent);
            Intrinsics.checkNotNullExpressionValue((Object)editorTextField, (String)"createTextField(...)");
            EditorTextField baseContentField = editorTextField;
            editorComponent = LineStatusMarkerPopupPanel.createEditorComponent((Editor)$editor, (JComponent)((JComponent)baseContentField));
        }
        DataProvider dataProvider2 = new DataProvider(this$0, $editor, $range){
            final /* synthetic */ FrontendVcsGutterMarkRenderer this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ VcsLineRange $range;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$range = $range;
            }

            public Object getData(String dataId) {
                Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                if (CommonDataKeys.PROJECT.is(dataId)) {
                    return this.this$0.getProject();
                }
                if (CommonDataKeys.EDITOR.is(dataId)) {
                    return this.$editor;
                }
                if (FrontendVcsGutterMarkersHostKt.access$getVCS_EDITOR_KEY$p().is(dataId)) {
                    return this.$editor;
                }
                if (FrontendVcsGutterMarkersHostKt.access$getVCS_RANGE_KEY$p().is(dataId)) {
                    return this.$range;
                }
                return null;
            }
        };
        LineStatusMarkerPopupPanel lineStatusMarkerPopupPanel = LineStatusMarkerPopupPanel.create((Editor)$editor, (ActionToolbar)toolbar, (JComponent)editorComponent, null);
        Intrinsics.checkNotNullExpressionValue((Object)lineStatusMarkerPopupPanel, (String)"create(...)");
        LineStatusMarkerPopupPanel popupPanel = lineStatusMarkerPopupPanel;
        DataManager.registerDataProvider((JComponent)((JComponent)popupPanel), (DataProvider)dataProvider2);
        return popupPanel;
    }

    static {
        Key key = Key.create((String)"MyGutterRenderer");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/vcs/frontend/split/FrontendVcsGutterMarkRenderer$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/platform/vcs/frontend/split/FrontendVcsGutterMarkRenderer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getKEY", "()Lcom/intellij/openapi/util/Key;", "intellij.platform.vcs.frontend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<FrontendVcsGutterMarkRenderer> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

