/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.textMatching;

import com.intellij.internal.ml.WordsSplitter;
import com.intellij.util.text.EditDistance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/textMatching/WholeTextMatchUtil;", "", "<init>", "()V", "wordsSplitter", "Lcom/intellij/internal/ml/WordsSplitter;", "baseName", "", "calculateFeatures", "", "elementText", "queryText", "intellij.platform.ml.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWholeTextMatchUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WholeTextMatchUtil.kt\ncom/intellij/textMatching/WholeTextMatchUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1586#2:44\n1661#2,3:45\n1586#2:48\n1661#2,3:49\n1834#2,4:52\n*S KotlinDebug\n*F\n+ 1 WholeTextMatchUtil.kt\ncom/intellij/textMatching/WholeTextMatchUtil\n*L\n31#1:44\n31#1:45,3\n32#1:48\n32#1:49,3\n33#1:52,4\n*E\n"})
public final class WholeTextMatchUtil {
    @NotNull
    public static final WholeTextMatchUtil INSTANCE = new WholeTextMatchUtil();
    @NotNull
    private static final WordsSplitter wordsSplitter = new WordsSplitter.Builder().build();
    @NotNull
    public static final String baseName = "wholeText";

    private WholeTextMatchUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> calculateFeatures(@NotNull String elementText, @NotNull String queryText) {
        int n;
        void $this$mapTo$iv$iv;
        Pair it;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)elementText, (String)"elementText");
        Intrinsics.checkNotNullParameter((Object)queryText, (String)"queryText");
        double levenshteinDistance = (double)EditDistance.levenshtein((CharSequence)elementText, (CharSequence)queryText, (boolean)true) / (double)queryText.length();
        double levenshteinDistanceCaseInsensitive = (double)EditDistance.levenshtein((CharSequence)elementText, (CharSequence)queryText, (boolean)false) / (double)queryText.length();
        Iterable $this$map$iv = wordsSplitter.split(queryText);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            collection.add(string2);
        }
        List queryWords = (List)destination$iv$iv;
        Iterable $this$map$iv2 = wordsSplitter.split(elementText);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string = it2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            collection.add(string);
        }
        List elementWords = (List)destination$iv$iv2;
        Iterable $this$count$iv = CollectionsKt.zip((Iterable)queryWords, (Iterable)elementWords);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Pair)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)it.getSecond()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int matchingWordsCount = n;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"levenshtein_distance", (Object)levenshteinDistance), TuplesKt.to((Object)"levenshtein_distance_case_insensitive", (Object)levenshteinDistanceCaseInsensitive), TuplesKt.to((Object)"words_in_query", (Object)queryWords.size()), TuplesKt.to((Object)"words_in_element", (Object)elementWords.size()), TuplesKt.to((Object)"exactly_matched_words", (Object)matchingWordsCount)};
        return MapsKt.mapOf((Pair[])pairArray);
    }
}

