/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.kubernetes.api.KubePlugin;
import com.intellij.kubernetes.api.KubectlException;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.KubernetesApiProviderInterface;
import com.intellij.kubernetes.api.KubernetesApiProviderKt;
import com.intellij.kubernetes.api.KubernetesKubeConfigParsingException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.InterruptibleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0005H\u0002\u001a\u001a\u0010\u0006\u001a\u00020\u00072\u0010\u0010\b\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\tH\u0002\u001a\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0000\u001a\u0016\u0010\u0010\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0011*\u00070\u0003\u00a2\u0006\u0002\b\u0011\u001a\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\tH\u0086@\u00a2\u0006\u0002\u0010\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "ALL_NAMESPACES_TOKEN", "", "throwIfErrorState", "Lcom/intellij/kubernetes/api/KubernetesApiProviderInterface$KubeconfigState;", "logExceptions", "", "exceptions", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "detectNotInstalledAuthPluginsInConfig", "Lcom/intellij/kubernetes/api/KubePlugin;", "users", "", "toPath", "Lorg/jetbrains/annotations/NonNls;", "extractNamespaceFromFiles", "filesPaths", "Ljava/nio/file/Path;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesApiProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesApiProvider.kt\ncom/intellij/kubernetes/api/KubernetesApiProviderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,528:1\n1#2:529\n13#3:530\n*S KotlinDebug\n*F\n+ 1 KubernetesApiProvider.kt\ncom/intellij/kubernetes/api/KubernetesApiProviderKt\n*L\n38#1:530\n*E\n"})
public final class KubernetesApiProviderKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String ALL_NAMESPACES_TOKEN = "Kubernetes.All.Namespaces.Label";

    private static final KubernetesApiProviderInterface.KubeconfigState throwIfErrorState(KubernetesApiProviderInterface.KubeconfigState $this$throwIfErrorState) {
        if ($this$throwIfErrorState.getErrorMessage() != null) {
            throw new KubectlException($this$throwIfErrorState.getErrorMessage(), null);
        }
        return $this$throwIfErrorState;
    }

    private static final void logExceptions(List<? extends Exception> exceptions) {
        for (Exception exception : exceptions) {
            if (exception instanceof KubernetesKubeConfigParsingException) {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.error((Throwable)exception);
                    continue;
                }
                LOG.warn(exception.getMessage());
                continue;
            }
            LOG.warnWithDebug("Configuration not loaded: " + exception.getMessage(), (Throwable)exception);
        }
    }

    @NotNull
    public static final List<KubePlugin> detectNotInstalledAuthPluginsInConfig(@NotNull List<? extends Object> users) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        Object[] objectArray = new KubePlugin[5];
        objectArray[0] = new KubePlugin("aws-iam-authenticator", "aws-iam-authenticator", CollectionsKt.emptyList(), null, "aws-iam-authenticator", 8, null);
        Object object = new String[]{"auth", "print-access-token"};
        objectArray[1] = new KubePlugin("gcloud", "gcloud", CollectionsKt.listOf((Object[])object), null, "google-cloud-sdk", 8, null);
        object = new String[]{"account", "get-access-token"};
        objectArray[2] = new KubePlugin("az", "az", CollectionsKt.listOf((Object[])object), null, "az", 8, null);
        object = new String[]{"oidc-login", "get-token"};
        objectArray[3] = new KubePlugin("kubelogin", "kubectl", CollectionsKt.listOf((Object[])object), null, "kubectl-oidc_login", 8, null);
        objectArray[4] = new KubePlugin("dex-k8s-authenticator", "dex-k8s-authenticator", CollectionsKt.emptyList(), null, "dex-k8s-authenticator", 8, null);
        List knownPlugins = CollectionsKt.listOf((Object[])objectArray);
        List installedPlugins = new ArrayList();
        for (Object e : users) {
            List args;
            String command2;
            Map exec;
            Object object2;
            Map map2 = e instanceof Map ? (Map)e : null;
            if (map2 == null) continue;
            Map userMap = map2;
            Object v = userMap.get("user");
            Map map3 = v instanceof Map ? (Map)v : null;
            if (map3 == null) continue;
            Map userExec = map3;
            Object v2 = userExec.get("exec");
            Map v4 = v2 instanceof Map ? (Map)v2 : null;
            if (v4 == null || ((object2 = (exec = v4).get("command")) instanceof String ? (String)object2 : null) == null) continue;
            command2 = command2;
            Object v3 = exec.get("args");
            if ((v3 instanceof List ? (List)v3 : null) == null) continue;
            args = args;
            object2 = knownPlugins.iterator();
            while (object2.hasNext()) {
                KubePlugin plugin = (KubePlugin)object2.next();
                if (!Intrinsics.areEqual((Object)command2, (Object)plugin.getCommand()) || !args.containsAll((Collection)plugin.getArgs())) continue;
                installedPlugins.add(plugin);
            }
        }
        return installedPlugins;
    }

    @Nullable
    public static final String toPath(@NotNull String $this$toPath) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"<this>");
        try {
            CharSequence charSequence2;
            charSequence = new URL($this$toPath).getPath();
            if (StringsKt.isBlank((CharSequence)charSequence)) {
                boolean bl = false;
                charSequence2 = null;
            } else {
                charSequence2 = charSequence;
            }
            charSequence = (String)charSequence2;
        }
        catch (MalformedURLException e) {
            LOG.warnWithDebug("Unable to parse cluster server URL: " + $this$toPath, (Throwable)e);
            charSequence = null;
        }
        return charSequence;
    }

    @Nullable
    public static final Object extractNamespaceFromFiles(@NotNull List<? extends Path> filesPaths, @NotNull Continuation<? super String> $completion) {
        Yaml yaml = new Yaml();
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(filesPaths, yaml, null){
            int label;
            final /* synthetic */ List<Path> $filesPaths;
            final /* synthetic */ Yaml $yaml;
            {
                this.$filesPaths = $filesPaths;
                this.$yaml = $yaml;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = InterruptibleKt.runInterruptible$default(null, () -> extractNamespaceFromFiles.2.invokeSuspend$lambda$0(this.$filesPaths, this.$yaml), (Continuation)((Continuation)this), (int)1, null);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$0$0(Path path) {
                return Files.readString(path);
            }

            private static final Iterable invokeSuspend$lambda$0$1(Yaml $yaml, String content2) {
                Iterable iterable = $yaml.loadAll(content2);
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"loadAll(...)");
                return iterable;
            }

            private static final Map invokeSuspend$lambda$0$2(Object it) {
                Object $this$asSafely$iv = it;
                boolean $i$f$asSafely = false;
                Object object = $this$asSafely$iv;
                if (!(object instanceof Map)) {
                    object = null;
                }
                return (Map)object;
            }

            private static final Map invokeSuspend$lambda$0$3(Map kubernetesObject) {
                V v = kubernetesObject.get("metadata");
                return v instanceof Map ? (Map)v : null;
            }

            private static final String invokeSuspend$lambda$0$4(Map metadata) {
                Map map2 = metadata;
                V v = map2 != null ? map2.get("namespace") : null;
                return v instanceof String ? (String)v : null;
            }

            private static final String invokeSuspend$lambda$0(List $filesPaths, Yaml $yaml) {
                Set namespaces = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$filesPaths), extractNamespaceFromFiles.2::invokeSuspend$lambda$0$0), arg_0 -> extractNamespaceFromFiles.2.invokeSuspend$lambda$0$1($yaml, arg_0)), extractNamespaceFromFiles.2::invokeSuspend$lambda$0$2), extractNamespaceFromFiles.2::invokeSuspend$lambda$0$3), extractNamespaceFromFiles.2::invokeSuspend$lambda$0$4));
                if (namespaces.size() > 1) {
                    return null;
                }
                String string = (String)CollectionsKt.singleOrNull((Iterable)namespaces);
                if (string == null) {
                    string = "default";
                }
                return string;
            }
        }), $completion);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ KubernetesApiProviderInterface.KubeconfigState access$throwIfErrorState(KubernetesApiProviderInterface.KubeconfigState $receiver) {
        return KubernetesApiProviderKt.throwIfErrorState($receiver);
    }

    public static final /* synthetic */ void access$logExceptions(List exceptions) {
        KubernetesApiProviderKt.logExceptions(exceptions);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesApiProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

