/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.nodes.workloads;

import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.logs.ILogSource;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObjectImpl;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesEphemeralContainerObjectImpl;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesEventContainerObject;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesObjectSerializer;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=KubernetesObjectSerializer.class)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 -2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u00022\u00020\u0003:\u0001-B\t\b\u0004\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010(\u001a\u00020\u00112\b\u0010)\u001a\u0004\u0018\u00010*H\u0096\u0082\u0004J\u0012\u0010+\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u0001H\u0096\u0082\u0004J\n\u0010,\u001a\u00020\u0019H\u0096\u0080\u0004R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0012\u0010\u0015\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u0004\u0018\u00010!X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u0004\u0018\u00010%X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u0082\u0001\u0003./0\u00a8\u00061"}, d2={"Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "Lio/kubernetes/client/common/KubernetesObject;", "", "Lcom/intellij/kubernetes/logs/ILogSource;", "<init>", "()V", "context", "Lcom/intellij/kubernetes/api/Context;", "getContext", "()Lcom/intellij/kubernetes/api/Context;", "name", "", "getName", "()Ljava/lang/String;", "image", "getImage", "isReady", "", "()Z", "started", "getStarted", "isRunning", "containerId", "getContainerId", "restartCount", "", "getRestartCount", "()I", "parentPod", "Lio/kubernetes/client/openapi/models/V1Pod;", "getParentPod", "()Lio/kubernetes/client/openapi/models/V1Pod;", "containerSpec", "Lio/kubernetes/client/openapi/models/V1Container;", "getContainerSpec", "()Lio/kubernetes/client/openapi/models/V1Container;", "containerStatus", "Lio/kubernetes/client/openapi/models/V1ContainerStatus;", "getContainerStatus", "()Lio/kubernetes/client/openapi/models/V1ContainerStatus;", "equals", "other", "", "compareTo", "hashCode", "Companion", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObjectImpl;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesEphemeralContainerObjectImpl;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesEventContainerObject;", "intellij.clouds.kubernetes"})
public abstract sealed class KubernetesContainerObject
implements KubernetesObject,
Comparable<KubernetesObject>,
ILogSource
permits KubernetesContainerObjectImpl, KubernetesEphemeralContainerObjectImpl, KubernetesEventContainerObject {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private KubernetesContainerObject() {
    }

    @NotNull
    public abstract Context getContext();

    @NotNull
    public abstract String getName();

    @Nullable
    public abstract String getImage();

    public abstract boolean isReady();

    public abstract boolean getStarted();

    public abstract boolean isRunning();

    @Nullable
    public abstract String getContainerId();

    public abstract int getRestartCount();

    @NotNull
    public abstract V1Pod getParentPod();

    @Nullable
    public abstract V1Container getContainerSpec();

    @Nullable
    public abstract V1ContainerStatus getContainerStatus();

    @Override
    public boolean equals(@Nullable Object other) {
        KubernetesObject kubernetesObject = other instanceof KubernetesObject ? (KubernetesObject)other : null;
        if (kubernetesObject == null) {
            return false;
        }
        return this.compareTo(kubernetesObject) == 0;
    }

    @Override
    public int compareTo(@NotNull KubernetesObject other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this == other) {
            return 0;
        }
        if (!(other instanceof KubernetesContainerObject)) {
            return -1;
        }
        Function1[] function1Array = new Function1[]{KubernetesContainerObject::compareTo$lambda$0, KubernetesContainerObject::compareTo$lambda$1, KubernetesContainerObject::compareTo$lambda$2, KubernetesContainerObject::compareTo$lambda$3};
        return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
    }

    @Override
    public int hashCode() {
        int result = this.getName().hashCode();
        Object object = this.getParentPod().getMetadata();
        result = 31 * result + (object != null && (object = object.getUid()) != null ? ((String)object).hashCode() : 0);
        Object object2 = this.getParentPod().getMetadata();
        result = 31 * result + (object2 != null && (object2 = object2.getName()) != null ? ((String)object2).hashCode() : 0);
        result = 31 * result + (this.getContext().getName() + this.getContext().getKubeConfigUrl()).hashCode();
        return result;
    }

    private static final Comparable compareTo$lambda$0(KubernetesContainerObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getName());
    }

    private static final Comparable compareTo$lambda$1(KubernetesContainerObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        V1ObjectMeta v1ObjectMeta = it.getParentPod().getMetadata();
        return (Comparable)((Object)(v1ObjectMeta != null ? v1ObjectMeta.getName() : null));
    }

    private static final Comparable compareTo$lambda$2(KubernetesContainerObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        V1ObjectMeta v1ObjectMeta = it.getParentPod().getMetadata();
        return (Comparable)((Object)(v1ObjectMeta != null ? v1ObjectMeta.getUid() : null));
    }

    private static final Comparable compareTo$lambda$3(KubernetesContainerObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)(it.getContext().getName() + it.getContext().getKubeConfigUrl()));
    }

    public /* synthetic */ KubernetesContainerObject(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<KubernetesContainerObject> serializer() {
            return new KubernetesObjectSerializer();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

