/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.claude.hooks;

import com.intellij.code.provenance.core.claude.ProvenanceClaudeBundle;
import com.intellij.code.provenance.core.claude.hooks.ClaudeHooksInstaller;
import com.intellij.code.provenance.core.claude.hooks.ClaudeJsonUtil;
import com.intellij.code.provenance.core.claude.hooks.PathsUtil;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.util.ApplicationKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0003\u001a\u001b\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/code/provenance/core/claude/hooks/ClaudeHooksInstaller;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "installMutex", "Lkotlinx/coroutines/sync/Mutex;", "evaluateState", "Lcom/intellij/code/provenance/core/claude/hooks/ClaudeHooksInstaller$InstallState;", "install", "Lcom/intellij/code/provenance/core/claude/hooks/ClaudeHooksInstaller$InstallResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isClaudeCodeDetected", "", "isPython3Available", "areHooksInstalled", "hooksDir", "Ljava/nio/file/Path;", "settingsFile", "hookFileExist", "hasExistingHooksConfiguration", "hasValidHooksConfiguration", "copyHookScripts", "rollbackHookFiles", "", "Companion", "InstallState", "InstallResult", "intellij.code.provenance.core.claude"})
@SourceDebugExtension(value={"SMAP\nClaudeHooksInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaudeHooksInstaller.kt\ncom/intellij/code/provenance/core/claude/hooks/ClaudeHooksInstaller\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,207:1\n116#2,10:208\n*S KotlinDebug\n*F\n+ 1 ClaudeHooksInstaller.kt\ncom/intellij/code/provenance/core/claude/hooks/ClaudeHooksInstaller\n*L\n99#1:208,10\n*E\n"})
public final class ClaudeHooksInstaller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Mutex installMutex;

    public ClaudeHooksInstaller(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.installMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    @NotNull
    public final InstallState evaluateState() {
        try {
            Path settingsFile;
            Path hooksDir;
            if (!ApplicationKt.getApplication().isUnitTestMode()) {
                if (!this.isClaudeCodeDetected()) {
                    return InstallState.INELIGIBLE_CLAUDE_NOT_FOUND;
                }
                if (!this.isPython3Available()) {
                    return InstallState.INELIGIBLE_PYTHON3_NOT_FOUND;
                }
            }
            if (this.areHooksInstalled(hooksDir = PathsUtil.INSTANCE.getHooksDir(this.project), settingsFile = PathsUtil.INSTANCE.getSettingsFile(this.project))) {
                return InstallState.INSTALLED;
            }
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(settingsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && this.hasExistingHooksConfiguration(settingsFile)) {
                if (this.hookFileExist(hooksDir)) {
                    return InstallState.INELIGIBLE_HOOKS_ALREADY_INSTALLED;
                }
                return InstallState.INELIGIBLE_POST_ALREADY_DEFINED;
            }
            return InstallState.ELIGIBLE;
        }
        catch (Exception exception) {
            return InstallState.ERROR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object install(@NotNull Continuation<? super InstallResult> $completion) {
        if (!($completion instanceof install.1)) ** GOTO lbl-1000
        var13_2 = $completion;
        if ((var13_2.label & -2147483648) != 0) {
            var13_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ ClaudeHooksInstaller this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.install((Continuation<? super InstallResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.installMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var14_4) {
                    return var14_4;
                }
                ** GOTO lbl29
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 3 sources

                $i$a$-withLock$default-ClaudeHooksInstaller$install$2 = 0;
                state = this.evaluateState();
                if (state == InstallState.ELIGIBLE) ** GOTO lbl40
                var7_11 = new Object[]{state.getMessage()};
                v1 = ProvenanceClaudeBundle.message("claude.hooks.install.cannot.install", var7_11);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"message(...)");
                var11_13 = new InstallResult(false, v1, null, 4, null);
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var11_13;
lbl40:
                // 2 sources

                claudeDir = PathsUtil.INSTANCE.getClaudeDir(this.project);
                hooksDir = PathsUtil.INSTANCE.getHooksDir(this.project);
                settingsFile = PathsUtil.INSTANCE.getSettingsFile(this.project);
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)state);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)hooksDir);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)claudeDir);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)settingsFile);
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-ClaudeHooksInstaller$install$2;
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super InstallResult>, Object>(claudeDir, hooksDir, this, settingsFile, null){
                    int label;
                    final /* synthetic */ Path $claudeDir;
                    final /* synthetic */ Path $hooksDir;
                    final /* synthetic */ ClaudeHooksInstaller this$0;
                    final /* synthetic */ Path $settingsFile;
                    {
                        this.$claudeDir = $claudeDir;
                        this.$hooksDir = $hooksDir;
                        this.this$0 = $receiver;
                        this.$settingsFile = $settingsFile;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                InstallResult installResult;
                                ResultKt.throwOnFailure((Object)$result);
                                try {
                                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(this.$claudeDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                                    FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
                                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(this.$hooksDir, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"createDirectories(...)");
                                    boolean hooksCopied = this.this$0.copyHookScripts(this.$hooksDir);
                                    if (!hooksCopied) {
                                        String string = ProvenanceClaudeBundle.message("claude.hooks.install.failed.copy.scripts", new Object[0]);
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                        return new InstallResult(false, string, null, 4, null);
                                    }
                                    try {
                                        ClaudeJsonUtil.INSTANCE.updateSettingsWithHooks(this.$settingsFile);
                                    }
                                    catch (Exception e) {
                                        ClaudeHooksInstaller.access$rollbackHookFiles(this.this$0, this.$hooksDir);
                                        Object[] objectArray = new Object[1];
                                        String string = e.getMessage();
                                        if (string == null) {
                                            string = "";
                                        }
                                        objectArray[0] = string;
                                        String string2 = ProvenanceClaudeBundle.message("claude.hooks.install.failed.update.settings", objectArray);
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                                        return new InstallResult(false, string2, null, 4, null);
                                    }
                                    String string = ProvenanceClaudeBundle.message("claude.hooks.install.success", new Object[0]);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                    installResult = new InstallResult(true, string, null, 4, null);
                                }
                                catch (Exception e) {
                                    ClaudeHooksInstaller.access$rollbackHookFiles(this.this$0, this.$hooksDir);
                                    Object[] objectArray = new Object[1];
                                    String string = e.getMessage();
                                    if (string == null) {
                                        string = "";
                                    }
                                    objectArray[0] = string;
                                    String string3 = ProvenanceClaudeBundle.message("claude.hooks.install.failed", objectArray);
                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                                    installResult = new InstallResult(false, string3, e.toString());
                                }
                                return installResult;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super InstallResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v2 != var14_4) goto lbl54
lbl53:
                // 1 sources

                return var14_4;
lbl54:
                // 1 sources

                ** GOTO lbl68
            }
            case 2: {
                $i$a$-withLock$default-ClaudeHooksInstaller$install$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                settingsFile = (Path)$continuation.L$4;
                claudeDir = (Path)$continuation.L$3;
                hooksDir = (Path)$continuation.L$2;
                state = (InstallState)$continuation.L$1;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl68:
                    // 2 sources

                    var10_16 = v2;
                    return var10_16;
                }
                catch (Throwable var5_9) {
                    throw var5_9;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isClaudeCodeDetected() {
        String string;
        if (SystemInfo.isMac) {
            string = "~/.claude.json";
        } else if (SystemInfo.isWindows) {
            string = "~/.claude.json";
        } else {
            if (!SystemInfo.isLinux) return false;
            string = "~/.claude.json";
        }
        String configPath = string;
        if (configPath == null) {
            return false;
        }
        String string2 = OSAgnosticPathUtil.expandUserHome((String)configPath);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"expandUserHome(...)");
        Path path = Paths.get(string2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) return false;
        return true;
    }

    private final boolean isPython3Available() {
        try {
            String[] stringArray = new String[]{"python3", "--version"};
            Process python3Result = new ProcessBuilder(stringArray).redirectErrorStream(true).start();
            python3Result.waitFor();
            return python3Result.exitValue() == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean areHooksInstalled(Path hooksDir, Path settingsFile) {
        if (!this.hookFileExist(hooksDir)) return false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(settingsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        if (!this.hasValidHooksConfiguration(settingsFile)) return false;
        return true;
    }

    private final boolean hookFileExist(Path hooksDir) {
        Path postHook = hooksDir.resolve("post-tool-call.py");
        Intrinsics.checkNotNull((Object)postHook);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(postHook, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private final boolean hasExistingHooksConfiguration(Path settingsFile) {
        return ClaudeJsonUtil.INSTANCE.hasPostToolUse(settingsFile);
    }

    private final boolean hasValidHooksConfiguration(Path settingsFile) {
        return ClaudeJsonUtil.INSTANCE.hasValidHooksConfiguration(settingsFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean copyHookScripts(@NotNull Path hooksDir) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)hooksDir, (String)"hooksDir");
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/claude/post-tool-call.py");
            if (inputStream == null) {
                return false;
            }
            InputStream postHookResource = inputStream;
            Path postHookFile = hooksDir.resolve("post-tool-call.py");
            Closeable closeable = postHookResource;
            Throwable throwable = null;
            try {
                long l;
                InputStream input = (InputStream)closeable;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)postHookFile);
                OpenOption[] openOptionArray = new OpenOption[]{};
                OutputStream outputStream = Files.newOutputStream(postHookFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                Closeable closeable2 = outputStream;
                Throwable throwable2 = null;
                try {
                    OutputStream output = (OutputStream)closeable2;
                    boolean bl3 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    private final void rollbackHookFiles(Path hooksDir) {
        try {
            Path path = hooksDir.resolve("post-tool-call.py");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Files.deleteIfExists(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final /* synthetic */ void access$rollbackHookFiles(ClaudeHooksInstaller $this, Path hooksDir) {
        $this.rollbackHookFiles(hooksDir);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/code/provenance/core/claude/hooks/ClaudeHooksInstaller$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/code/provenance/core/claude/hooks/ClaudeHooksInstaller;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.code.provenance.core.claude"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClaudeHooksInstaller getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ClaudeHooksInstaller.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ClaudeHooksInstaller)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J.\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\r\b\u0002\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004J\n\u0010\u0017\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/code/provenance/core/claude/hooks/ClaudeHooksInstaller$InstallResult;", "", "success", "", "message", "", "Lorg/jetbrains/annotations/Nls;", "error", "<init>", "(ZLjava/lang/String;Ljava/lang/String;)V", "getSuccess", "()Z", "getMessage", "()Ljava/lang/String;", "getError", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.code.provenance.core.claude"})
    public static final class InstallResult {
        private final boolean success;
        @NotNull
        private final String message;
        @Nullable
        private final String error;

        public InstallResult(boolean success, @NotNull String message, @Nullable String error) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.success = success;
            this.message = message;
            this.error = error;
        }

        public /* synthetic */ InstallResult(boolean bl, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(bl, string, string2);
        }

        public final boolean getSuccess() {
            return this.success;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        public final boolean component1() {
            return this.success;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @Nullable
        public final String component3() {
            return this.error;
        }

        @NotNull
        public final InstallResult copy(boolean success, @NotNull String message, @Nullable String error) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new InstallResult(success, message, error);
        }

        public static /* synthetic */ InstallResult copy$default(InstallResult installResult, boolean bl, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = installResult.success;
            }
            if ((n & 2) != 0) {
                string = installResult.message;
            }
            if ((n & 4) != 0) {
                string2 = installResult.error;
            }
            return installResult.copy(bl, string, string2);
        }

        @NotNull
        public String toString() {
            return "InstallResult(success=" + this.success + ", message=" + this.message + ", error=" + this.error + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.success);
            result2 = result2 * 31 + this.message.hashCode();
            result2 = result2 * 31 + (this.error == null ? 0 : this.error.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InstallResult)) {
                return false;
            }
            InstallResult installResult = (InstallResult)other;
            if (this.success != installResult.success) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)installResult.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error, (Object)installResult.error);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0011"}, d2={"Lcom/intellij/code/provenance/core/claude/hooks/ClaudeHooksInstaller$InstallState;", "", "messageKey", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getMessageKey", "()Ljava/lang/String;", "INSTALLED", "ELIGIBLE", "INELIGIBLE_CLAUDE_NOT_FOUND", "INELIGIBLE_PYTHON3_NOT_FOUND", "INELIGIBLE_HOOKS_ALREADY_INSTALLED", "INELIGIBLE_POST_ALREADY_DEFINED", "ERROR", "message", "getMessage", "intellij.code.provenance.core.claude"})
    public static final class InstallState
    extends Enum<InstallState> {
        @NotNull
        private final String messageKey;
        public static final /* enum */ InstallState INSTALLED = new InstallState("claude.hooks.state.installed");
        public static final /* enum */ InstallState ELIGIBLE = new InstallState("claude.hooks.state.eligible");
        public static final /* enum */ InstallState INELIGIBLE_CLAUDE_NOT_FOUND = new InstallState("claude.hooks.state.ineligible.claude.not.found");
        public static final /* enum */ InstallState INELIGIBLE_PYTHON3_NOT_FOUND = new InstallState("claude.hooks.state.ineligible.python3.not.found");
        public static final /* enum */ InstallState INELIGIBLE_HOOKS_ALREADY_INSTALLED = new InstallState("claude.hooks.state.ineligible.hooks.already.installed");
        public static final /* enum */ InstallState INELIGIBLE_POST_ALREADY_DEFINED = new InstallState("claude.hooks.state.ineligible.post.already.defined");
        public static final /* enum */ InstallState ERROR = new InstallState("claude.hooks.state.error");
        private static final /* synthetic */ InstallState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private InstallState(String messageKey) {
            this.messageKey = messageKey;
        }

        @NotNull
        public final String getMessageKey() {
            return this.messageKey;
        }

        @NotNull
        public final String getMessage() {
            String string = ProvenanceClaudeBundle.message(this.messageKey, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public static InstallState[] values() {
            return (InstallState[])$VALUES.clone();
        }

        public static InstallState valueOf(String value) {
            return Enum.valueOf(InstallState.class, value);
        }

        @NotNull
        public static EnumEntries<InstallState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = installStateArray = new InstallState[]{InstallState.INSTALLED, InstallState.ELIGIBLE, InstallState.INELIGIBLE_CLAUDE_NOT_FOUND, InstallState.INELIGIBLE_PYTHON3_NOT_FOUND, InstallState.INELIGIBLE_HOOKS_ALREADY_INSTALLED, InstallState.INELIGIBLE_POST_ALREADY_DEFINED, InstallState.ERROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

