/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.split.backend;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.metadata.JupyterTag;
import com.intellij.jupyter.core.jupyter.nbformat.tags.JupyterTagsService;
import com.intellij.jupyter.core.remote.RemoteMetadataUpdaterApi;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorId;
import com.intellij.openapi.editor.impl.EditorIdKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ&\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ.\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0012J&\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/split/backend/RemoteMetadataUpdaterImpl;", "Lcom/intellij/jupyter/core/remote/RemoteMetadataUpdaterApi;", "<init>", "()V", "addTag", "", "editorId", "Lcom/intellij/openapi/editor/impl/EditorId;", "cellOrdinal", "", "tag", "Lcom/intellij/jupyter/core/jupyter/nbformat/metadata/JupyterTag;", "(Lcom/intellij/openapi/editor/impl/EditorId;ILcom/intellij/jupyter/core/jupyter/nbformat/metadata/JupyterTag;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeTag", "setMetadata", "key", "", "jsonStringValue", "(Lcom/intellij/openapi/editor/impl/EditorId;ILjava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeMetadata", "(Lcom/intellij/openapi/editor/impl/EditorId;ILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.jupyter.split.backend"})
public final class RemoteMetadataUpdaterImpl
implements RemoteMetadataUpdaterApi {
    @NotNull
    public static final RemoteMetadataUpdaterImpl INSTANCE = new RemoteMetadataUpdaterImpl();

    private RemoteMetadataUpdaterImpl() {
    }

    @Nullable
    public Object addTag(@NotNull EditorId editorId, int cellOrdinal, @NotNull JupyterTag tag, @NotNull Continuation<? super Unit> $completion) {
        Editor editor = EditorIdKt.findEditorOrNull((EditorId)editorId);
        if (editor == null) {
            return Unit.INSTANCE;
        }
        Editor editor2 = editor;
        JupyterTagsService.Companion.getInstance().addTagToCell(editor2, cellOrdinal, tag);
        return Unit.INSTANCE;
    }

    @Nullable
    public Object removeTag(@NotNull EditorId editorId, int cellOrdinal, @NotNull JupyterTag tag, @NotNull Continuation<? super Unit> $completion) {
        Editor editor = EditorIdKt.findEditorOrNull((EditorId)editorId);
        if (editor == null) {
            return Unit.INSTANCE;
        }
        Editor editor2 = editor;
        JupyterTagsService.Companion.getInstance().removeTagFromCell(editor2, cellOrdinal, tag);
        return Unit.INSTANCE;
    }

    @Nullable
    public Object setMetadata(@NotNull EditorId editorId, int cellOrdinal, @NotNull String key, @NotNull String jsonStringValue, @NotNull Continuation<? super Unit> $completion) {
        block1: {
            Editor editor = EditorIdKt.findEditorOrNull((EditorId)editorId);
            if (editor == null) {
                return Unit.INSTANCE;
            }
            Editor editor2 = editor;
            JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull((Editor)editor2);
            if (jupyterNotebook == null || (jupyterNotebook = jupyterNotebook.getCell(cellOrdinal)) == null) break block1;
            Object object = JupyterJsonKt.getJackson().readValue(jsonStringValue, ObjectNode.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            jupyterNotebook.setMetadata(key, object);
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object removeMetadata(@NotNull EditorId editorId, int cellOrdinal, @NotNull String key, @NotNull Continuation<? super Unit> $completion) {
        block1: {
            Editor editor = EditorIdKt.findEditorOrNull((EditorId)editorId);
            if (editor == null) {
                return Unit.INSTANCE;
            }
            Editor editor2 = editor;
            JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull((Editor)editor2);
            if (jupyterNotebook == null || (jupyterNotebook = jupyterNotebook.getCell(cellOrdinal)) == null || (jupyterNotebook = jupyterNotebook.getMetadata()) == null) break block1;
            jupyterNotebook.remove(key);
        }
        return Unit.INSTANCE;
    }
}

