/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.util;

import com.intellij.frontend.FrontendApplicationInfo;
import com.intellij.frontend.FrontendType;
import com.intellij.platform.debugger.impl.rpc.XBreakpointId;
import com.intellij.platform.debugger.impl.rpc.XDebugSessionId;
import com.intellij.platform.debugger.impl.rpc.XValueId;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.rpc.models.BackendXValueModel;
import com.intellij.xdebugger.impl.rpc.models.XBreakpointValueIdKt;
import com.intellij.xdebugger.impl.rpc.models.XDebugSessionValueIdTypeKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u0010\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/xdebugger/impl/util/XDebugMonolithUtils;", "", "<init>", "()V", "isMonolithOrBackend", "", "findSessionById", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "sessionId", "Lcom/intellij/platform/debugger/impl/rpc/XDebugSessionId;", "findXValueById", "Lcom/intellij/xdebugger/frame/XValue;", "xValueId", "Lcom/intellij/platform/debugger/impl/rpc/XValueId;", "findBreakpointTypeById", "Lcom/intellij/xdebugger/breakpoints/XBreakpointType;", "id", "", "findBreakpointById", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointBase;", "breakpointId", "Lcom/intellij/platform/debugger/impl/rpc/XBreakpointId;", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
public final class XDebugMonolithUtils {
    @NotNull
    public static final XDebugMonolithUtils INSTANCE = new XDebugMonolithUtils();

    private XDebugMonolithUtils() {
    }

    private final boolean isMonolithOrBackend() {
        return FrontendApplicationInfo.INSTANCE.getFrontendType() instanceof FrontendType.Monolith;
    }

    @JvmStatic
    @Nullable
    public static final XDebugSessionImpl findSessionById(@NotNull XDebugSessionId sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        if (!INSTANCE.isMonolithOrBackend()) {
            return null;
        }
        return XDebugSessionValueIdTypeKt.findValue(sessionId);
    }

    @Nullable
    public final XValue findXValueById(@NotNull XValueId xValueId) {
        Intrinsics.checkNotNullParameter((Object)xValueId, (String)"xValueId");
        if (!this.isMonolithOrBackend()) {
            return null;
        }
        BackendXValueModel backendXValueModel = BackendXValueModel.Companion.findById(xValueId);
        return backendXValueModel != null ? backendXValueModel.getXValue() : null;
    }

    @Nullable
    public final XBreakpointType<?, ?> findBreakpointTypeById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (!this.isMonolithOrBackend()) {
            return null;
        }
        return XBreakpointUtil.findType(id);
    }

    @JvmStatic
    @Nullable
    public static final XBreakpointBase<?, ?, ?> findBreakpointById(@NotNull XBreakpointId breakpointId) {
        Intrinsics.checkNotNullParameter((Object)breakpointId, (String)"breakpointId");
        if (!INSTANCE.isMonolithOrBackend()) {
            return null;
        }
        return XBreakpointValueIdKt.findValue(breakpointId);
    }
}

