/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.io.URLUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CopyUrlAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CopyUrlAction.$$$reportNull$$$0(0);
        }
        String url = CopyUrlAction.findUrlAtCaret(e);
        assert (url != null);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(url));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CopyUrlAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(CopyUrlAction.findUrlAtCaret(e) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CopyUrlAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    @Nullable
    private static String findUrlAtCaret(@NotNull AnActionEvent e) {
        Editor editor2;
        if (e == null) {
            CopyUrlAction.$$$reportNull$$$0(3);
        }
        if ((editor2 = (Editor)e.getData(CommonDataKeys.EDITOR)) == null) {
            return null;
        }
        int offset = editor2.getCaretModel().getOffset();
        String url = CopyUrlAction.findUrl(editor2, offset);
        if (url != null) {
            return url;
        }
        int expectedCaretOffset = ((EditorEx)editor2).getExpectedCaretOffset();
        return expectedCaretOffset == offset ? null : CopyUrlAction.findUrl(editor2, expectedCaretOffset);
    }

    private static String findUrl(Editor editor2, int offset) {
        CharSequence chars = editor2.getDocument().getCharsSequence();
        while (offset > 0 && CopyUrlAction.seemsUrlPart(chars.charAt(offset - 1))) {
            --offset;
        }
        Matcher matcher = URLUtil.URL_PATTERN.matcher(chars.subSequence(offset, chars.length()));
        if (matcher.lookingAt()) {
            return matcher.group();
        }
        return null;
    }

    private static boolean seemsUrlPart(char c) {
        return !Character.isWhitespace(c) && c != '(' && c != '[' && c != '<' && c != '{' && c != ',';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CopyUrlAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CopyUrlAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findUrlAtCaret";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

