/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.NamedLayoutListBasedCache;
import com.intellij.ide.actions.RestoreNamedLayoutActionGroupKt;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.toolWindow.ToolWindowDefaultLayoutManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/actions/RestoreNamedLayoutActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "childrenCache", "Lcom/intellij/ide/actions/NamedLayoutListBasedCache;", "Lcom/intellij/openapi/actionSystem/AnAction;", "getChildren", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "RestoreNamedLayoutAction", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class RestoreNamedLayoutActionGroup
extends ActionGroup
implements DumbAware {
    @NotNull
    private final NamedLayoutListBasedCache<AnAction> childrenCache = new NamedLayoutListBasedCache(CollectionsKt.listOf((Object)((Object)new RestoreNamedLayoutAction(""))), 1, RestoreNamedLayoutActionGroup::childrenCache$lambda$0);

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return this.childrenCache.getCachedOrUpdatedArray((AnAction[])((Object[])AnAction.EMPTY_ARRAY));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final AnAction childrenCache$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (AnAction)new RestoreNamedLayoutAction(it);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/actions/RestoreNamedLayoutActionGroup$RestoreNamedLayoutAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "layoutName", "", "<init>", "(Ljava/lang/String;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.ide.impl"})
    public static final class RestoreNamedLayoutAction
    extends DumbAwareAction {
        @NotNull
        private final String layoutName;

        public RestoreNamedLayoutAction(@NlsSafe @NotNull String layoutName) {
            Intrinsics.checkNotNullParameter((Object)layoutName, (String)"layoutName");
            this.layoutName = layoutName;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            Project project3 = project2;
            ToolWindowDefaultLayoutManager layoutManager = ToolWindowDefaultLayoutManager.Companion.getInstance();
            layoutManager.setActiveLayoutName(this.layoutName);
            ToolWindowManagerEx.Companion.getInstanceEx(project3).setLayout(layoutManager.getLayoutCopy());
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            e.getPresentation().setEnabled(e.getProject() != null);
            if (Intrinsics.areEqual((Object)this.layoutName, (Object)"")) {
                AnAction restoreFactoryDefaultLayoutAction = ActionManager.getInstance().getAction("RestoreFactoryDefaultLayout");
                e.getPresentation().setText(restoreFactoryDefaultLayoutAction.getTemplatePresentation().getTextWithMnemonic());
                e.getPresentation().setDescription(restoreFactoryDefaultLayoutAction.getTemplatePresentation().getDescription());
            } else {
                e.getPresentation().setText(() -> RestoreNamedLayoutAction.update$lambda$0(this), false);
                Object[] objectArray = new Object[]{this.layoutName};
                e.getPresentation().setDescription(ActionsBundle.message((String)"action.RestoreNamedLayout.description", (Object[])objectArray));
            }
            e.getPresentation().setIcon(Intrinsics.areEqual((Object)ToolWindowDefaultLayoutManager.Companion.getInstance().getActiveLayoutName(), (Object)this.layoutName) ? RestoreNamedLayoutActionGroupKt.access$getCurrentIcon$p() : RestoreNamedLayoutActionGroupKt.access$getEmptyIcon$p());
        }

        private static final String update$lambda$0(RestoreNamedLayoutAction this$0) {
            return this$0.layoutName;
        }
    }
}

