/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WindowAction
extends AnAction
implements ActionRemoteBehaviorSpecification.Frontend,
DumbAware {
    private static final String NO_WINDOW_ACTIONS = "no.window.actions";
    private static JLabel ourSizeHelper;

    public static void setEnabledFor(@Nullable Window window, boolean enabled2) {
        JRootPane root = WindowAction.getRootPane(window);
        if (root != null) {
            root.putClientProperty(NO_WINDOW_ACTIONS, !enabled2);
        }
    }

    @ApiStatus.Internal
    protected WindowAction() {
        this.setEnabledInModalContext(true);
    }

    @ApiStatus.Internal
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            WindowAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @ApiStatus.Internal
    public final void update(@NotNull AnActionEvent event) {
        Component component2;
        Window window;
        boolean enabled2;
        if (event == null) {
            WindowAction.$$$reportNull$$$0(1);
        }
        if ((enabled2 = WindowAction.isEnabledFor(window = ComponentUtil.getWindow((Component)(component2 = (Component)event.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT))))) && Registry.is((String)"no.window.actions.in.editor")) {
            Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
            enabled2 = editor2 == null || !editor2.getContentComponent().hasFocus();
        }
        event.getPresentation().setEnabled(enabled2);
        event.getPresentation().setVisible(this.isVisibleFor(window));
        event.getPresentation().setIcon(this.getIconFor(window));
    }

    @ApiStatus.Internal
    @Nullable
    protected Icon getIconFor(@Nullable Window window) {
        return null;
    }

    @ApiStatus.Internal
    protected boolean isVisibleFor(@Nullable Window window) {
        return true;
    }

    private static boolean isEnabledFor(@Nullable Window window) {
        if (window == null || window instanceof IdeFrame) {
            return false;
        }
        if (window instanceof Dialog && !((Dialog)window).isResizable()) {
            return false;
        }
        JRootPane root = WindowAction.getRootPane(window);
        if (root == null) {
            return true;
        }
        Object property = root.getClientProperty(NO_WINDOW_ACTIONS);
        return property == null || !property.toString().equals("true");
    }

    @Nullable
    private static JRootPane getRootPane(@Nullable Window window) {
        if (window instanceof RootPaneContainer) {
            RootPaneContainer container = (RootPaneContainer)((Object)window);
            return container.getRootPane();
        }
        return null;
    }

    private static void performSizeAction(@NotNull AnActionEvent e, boolean horizontal, boolean positive) {
        Component component2;
        Window window;
        if (e == null) {
            WindowAction.$$$reportNull$$$0(2);
        }
        if ((window = ComponentUtil.getWindow((Component)(component2 = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)))) == null) {
            return;
        }
        Dimension size2 = WindowAction.getPreferredDelta();
        int baseValue = horizontal ? size2.width : size2.height;
        int inc = baseValue * Registry.intValue((String)(horizontal ? "ide.windowSystem.hScrollChars" : "ide.windowSystem.vScrollChars"));
        if (!positive) {
            inc = -inc;
        }
        Rectangle bounds = window.getBounds();
        if (horizontal) {
            bounds.width += inc;
        } else {
            bounds.height += inc;
        }
        window.setBounds(bounds);
    }

    @NotNull
    static Dimension getPreferredDelta() {
        if (ourSizeHelper == null) {
            ourSizeHelper = new JLabel("W");
        }
        Dimension dimension = ourSizeHelper.getPreferredSize();
        if (dimension == null) {
            WindowAction.$$$reportNull$$$0(3);
        }
        return dimension;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/WindowAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/WindowAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredDelta";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performSizeAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    @ApiStatus.Internal
    public static final class DecrementHeight
    extends WindowAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DecrementHeight.$$$reportNull$$$0(0);
            }
            WindowAction.performSizeAction(e, false, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/WindowAction$DecrementHeight", "actionPerformed"));
        }
    }

    @ApiStatus.Internal
    public static final class IncrementHeight
    extends WindowAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                IncrementHeight.$$$reportNull$$$0(0);
            }
            WindowAction.performSizeAction(e, false, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/WindowAction$IncrementHeight", "actionPerformed"));
        }
    }

    @ApiStatus.Internal
    public static final class DecrementWidth
    extends WindowAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DecrementWidth.$$$reportNull$$$0(0);
            }
            WindowAction.performSizeAction(e, true, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/WindowAction$DecrementWidth", "actionPerformed"));
        }
    }

    @ApiStatus.Internal
    public static final class IncrementWidth
    extends WindowAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                IncrementWidth.$$$reportNull$$$0(0);
            }
            WindowAction.performSizeAction(e, true, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/WindowAction$IncrementWidth", "actionPerformed"));
        }
    }
}

