/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenInRightSplitAction;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.OpenInBrowserRequestKt;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.WebBrowserXmlService;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserAction;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserActionKt;
import com.intellij.ide.browsers.actions.WebPreviewVirtualFile;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtilKt;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.BitUtil;
import com.intellij.util.Url;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

final class OpenHtmlInEmbeddedBrowserAction
extends DumbAwareAction {
    OpenHtmlInEmbeddedBrowserAction() {
        super(IdeBundle.messagePointer((String)"action.open.web.preview.text", (Object[])new Object[0]), null, (Supplier)new SynchronizedClearableLazy(() -> AppUIUtilKt.loadSmallApplicationIcon(ScaleContext.create(), 16, true)));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project2;
        if (event == null) {
            OpenHtmlInEmbeddedBrowserAction.$$$reportNull$$$0(0);
        }
        if ((project2 = (Project)event.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        VirtualFile virtualFile2 = psiFile.getVirtualFile();
        boolean preferLocalFileUrl = BitUtil.isSet((int)event.getModifiers(), (int)1);
        try {
            OpenInBrowserRequest browserRequest = OpenInBrowserRequestKt.createOpenInBrowserRequest((PsiElement)psiFile, (boolean)false);
            if (browserRequest == null) {
                return;
            }
            browserRequest.setReloadMode(WebBrowserManager.getInstance().getWebPreviewReloadMode());
            Collection urls = WebBrowserService.getInstance().getUrlsToOpen(browserRequest, preferLocalFileUrl);
            if (!urls.isEmpty()) {
                BaseOpenInBrowserActionKt.chooseUrl(urls).onSuccess(url -> {
                    WebPreviewVirtualFile file2 = new WebPreviewVirtualFile(virtualFile2, (Url)url);
                    if (!FileEditorManager.getInstance((Project)project2).isFileOpen((VirtualFile)file2)) {
                        OpenInRightSplitAction.Companion.openInRightSplit(project2, (VirtualFile)file2, null, false);
                    } else {
                        FileEditorManagerEx.getInstanceEx(project2).openFile((VirtualFile)file2, null, new FileEditorOpenOptions().withReuseOpen());
                    }
                });
            }
        }
        catch (WebBrowserUrlProvider.BrowserException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)IdeBundle.message((String)"browser.error", (Object[])new Object[0]));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenHtmlInEmbeddedBrowserAction.$$$reportNull$$$0(1);
        }
        OpenInBrowserRequest request = BaseOpenInBrowserAction.Handler.doUpdate(e);
        Project project2 = e.getProject();
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        boolean enabled2 = project2 != null && psiFile != null && request != null && psiFile.getVirtualFile() != null;
        e.getPresentation().setEnabledAndVisible(enabled2);
        if (!enabled2) {
            return;
        }
        if (WebBrowserXmlService.getInstance().isHtmlFile((PsiElement)request.getFile()) && "ContextToolbar".equals(e.getPlace())) {
            Object text2 = this.getTemplateText();
            text2 = (String)text2 + " (" + IdeBundle.message((String)"browser.shortcut", (Object[])new Object[0]) + ")";
            e.getPresentation().setText((String)text2);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OpenHtmlInEmbeddedBrowserAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/browsers/actions/OpenHtmlInEmbeddedBrowserAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/browsers/actions/OpenHtmlInEmbeddedBrowserAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

