/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightEditorInfoImpl
implements LightEditorInfo {
    private final FileEditorProvider myProvider;
    private final FileEditor myFileEditor;
    private final VirtualFile myFile;
    @Nullable
    private Path myPreferredSavePath;

    LightEditorInfoImpl(@NotNull FileEditorProvider provider, @NotNull FileEditor fileEditor, @NotNull VirtualFile file2) {
        if (provider == null) {
            LightEditorInfoImpl.$$$reportNull$$$0(0);
        }
        if (fileEditor == null) {
            LightEditorInfoImpl.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            LightEditorInfoImpl.$$$reportNull$$$0(2);
        }
        this.myProvider = provider;
        this.myFileEditor = fileEditor;
        this.myFile = file2;
    }

    @NotNull
    public FileEditor getFileEditor() {
        FileEditor fileEditor = this.myFileEditor;
        if (fileEditor == null) {
            LightEditorInfoImpl.$$$reportNull$$$0(3);
        }
        return fileEditor;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            LightEditorInfoImpl.$$$reportNull$$$0(4);
        }
        return virtualFile2;
    }

    public boolean isUnsaved() {
        if (this.isNew()) {
            return true;
        }
        return FileDocumentManager.getInstance().isFileModified(this.myFile);
    }

    public boolean isNew() {
        return this.myFile instanceof LightVirtualFile;
    }

    public void disposeEditor() {
        this.myProvider.disposeEditor(this.myFileEditor);
    }

    @Nullable
    public static Editor getEditor(@Nullable LightEditorInfo editorInfo) {
        return LightEditorInfoImpl.getEditor(editorInfo != null ? editorInfo.getFileEditor() : null);
    }

    @Nullable
    public static Editor getEditor(@Nullable FileEditor fileEditor) {
        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        return textEditor == null ? null : textEditor.getEditor();
    }

    @NotNull
    public FileEditorProvider getProvider() {
        FileEditorProvider fileEditorProvider = this.myProvider;
        if (fileEditorProvider == null) {
            LightEditorInfoImpl.$$$reportNull$$$0(5);
        }
        return fileEditorProvider;
    }

    public boolean isSaveRequired() {
        return this.isUnsaved() && (!this.isNew() || this.myFileEditor instanceof TextEditor && ((TextEditor)this.myFileEditor).getEditor().getDocument().getTextLength() > 0);
    }

    @Nullable
    public Path getPreferredSavePath() {
        return this.myPreferredSavePath;
    }

    public void setPreferredSavePath(@Nullable Path preferredSavePath) {
        this.myPreferredSavePath = preferredSavePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/LightEditorInfoImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/LightEditorInfoImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

