/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BaselinePanel
extends NonOpaquePanel {
    private Component myBaseComponent;
    private final List<Component> myButtonComponents = new ArrayList<Component>();
    private boolean[] myButtonEnableStates;
    private Component myProgressComponent;
    private JComponent myProgressDisabledButton;
    private int myYOffset;
    private final JBValue myOffset = new JBValue.Float(8.0f);
    private final JBValue myBeforeButtonOffset;
    private final JBValue myButtonOffset = new JBValue.Float(6.0f);
    private final boolean myLeftOrder;
    private EventHandler myEventHandler;

    public BaselinePanel() {
        this(40, true);
    }

    public BaselinePanel(int beforeButtonOffset, final boolean leftOrder) {
        this.myBeforeButtonOffset = new JBValue.Float((float)beforeButtonOffset);
        this.myLeftOrder = leftOrder;
        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)6, (int)0));
        this.setLayout((LayoutManager)new AbstractLayoutManager(){

            public Dimension preferredLayoutSize(Container parent) {
                Dimension baseSize = BaselinePanel.this.myBaseComponent.getPreferredSize();
                int width = baseSize.width;
                if (BaselinePanel.this.myProgressComponent == null) {
                    int size2 = BaselinePanel.this.myButtonComponents.size();
                    if (size2 > 0) {
                        int visibleCount = 0;
                        for (Component component2 : BaselinePanel.this.myButtonComponents) {
                            if (!component2.isVisible()) continue;
                            width += component2.getPreferredSize().width;
                            ++visibleCount;
                        }
                        if (visibleCount > 0) {
                            width += BaselinePanel.this.myBeforeButtonOffset.get();
                            width += (visibleCount - 1) * BaselinePanel.this.myButtonOffset.get();
                        }
                    }
                } else {
                    width = leftOrder || BaselinePanel.this.myProgressDisabledButton == null ? (width += BaselinePanel.this.myOffset.get() + BaselinePanel.this.myProgressComponent.getPreferredSize().width) : BaselinePanel.this.myProgressDisabledButton.getPreferredSize().width + BaselinePanel.this.myOffset.get() + BaselinePanel.this.myProgressComponent.getPreferredSize().width;
                }
                Insets insets = parent.getInsets();
                return new Dimension(width, Math.max(insets.top + baseSize.height + insets.bottom, this.getMinButtonsHeight()));
            }

            private int calculateBaseWidth(@NotNull Container parent) {
                if (parent == null) {
                    1.$$$reportNull$$$0(0);
                }
                int parentWidth = parent.getWidth();
                if (BaselinePanel.this.myProgressComponent != null) {
                    return parentWidth - BaselinePanel.this.myProgressComponent.getPreferredSize().width - BaselinePanel.this.myOffset.get();
                }
                int visibleCount = 0;
                for (Component component2 : BaselinePanel.this.myButtonComponents) {
                    if (!component2.isVisible()) continue;
                    parentWidth -= component2.getPreferredSize().width;
                    ++visibleCount;
                }
                parentWidth -= BaselinePanel.this.myButtonOffset.get() * (visibleCount - 1);
                if (visibleCount > 0) {
                    parentWidth -= BaselinePanel.this.myOffset.get();
                }
                return parentWidth;
            }

            public void layoutContainer(Container parent) {
                Dimension baseSize = BaselinePanel.this.myBaseComponent.getPreferredSize();
                int baseComponentBaseline = BaselinePanel.this.myBaseComponent.getBaseline(baseSize.width, baseSize.height);
                int top = parent.getInsets().top;
                int y = Math.max(top + baseComponentBaseline, this.getMinButtonsBaseline());
                if (!leftOrder) {
                    this.layoutRightOrderContainer(parent, y, baseComponentBaseline);
                    return;
                }
                int x = 0;
                int calcBaseWidth = this.calculateBaseWidth(parent);
                Component component2 = BaselinePanel.this.myBaseComponent;
                if (component2 instanceof JLabel) {
                    JLabel label2 = (JLabel)component2;
                    label2.setToolTipText(calcBaseWidth < baseSize.width ? label2.getText() : null);
                }
                baseSize.width = Math.min(baseSize.width, calcBaseWidth);
                BaselinePanel.this.myBaseComponent.setBounds(x, y - baseComponentBaseline, baseSize.width, baseSize.height);
                if (BaselinePanel.this.myProgressComponent != null) {
                    Dimension size2 = BaselinePanel.this.myProgressComponent.getPreferredSize();
                    this.setBaselineBounds(parent.getWidth() - size2.width, y, BaselinePanel.this.myProgressComponent, size2);
                    return;
                }
                int lastX = parent.getWidth();
                for (Component component3 : BaselinePanel.this.myButtonComponents.reversed()) {
                    if (!component3.isVisible()) continue;
                    Dimension size3 = component3.getPreferredSize();
                    this.setBaselineBounds(lastX -= size3.width, y - BaselinePanel.this.myYOffset, component3, size3);
                    lastX -= BaselinePanel.this.myButtonOffset.get();
                }
            }

            private int getMinButtonsHeight() {
                return BaselinePanel.this.myButtonComponents.stream().filter(component2 -> component2.isVisible()).mapToInt(component2 -> component2.getPreferredSize().height).max().orElse(0);
            }

            private int getMinButtonsBaseline() {
                return BaselinePanel.this.myButtonComponents.stream().filter(component2 -> component2.isVisible()).mapToInt(component2 -> component2.getBaseline(Math.max(0, BaselinePanel.this.getWidth()), Math.max(0, BaselinePanel.this.getHeight()))).max().orElse(-1);
            }

            private void layoutRightOrderContainer(Container parent, int y, int baseComponentBaseline) {
                if (BaselinePanel.this.myProgressComponent != null) {
                    Dimension size2 = BaselinePanel.this.myProgressComponent.getPreferredSize();
                    if (BaselinePanel.this.myProgressDisabledButton == null) {
                        BaselinePanel.this.myProgressComponent.setBounds(0, (parent.getHeight() - size2.height) / 2, parent.getWidth(), size2.height);
                    } else {
                        Dimension buttonSize = BaselinePanel.this.myProgressDisabledButton.getPreferredSize();
                        int x = 0;
                        this.setBaselineBounds(x, y, BaselinePanel.this.myProgressDisabledButton, buttonSize);
                        this.setBaselineBounds(x += buttonSize.width + BaselinePanel.this.myOffset.get(), y, BaselinePanel.this.myProgressComponent, size2, parent.getWidth() - x, size2.height);
                    }
                    return;
                }
                int x = 0;
                boolean buttons = false;
                for (Component component2 : BaselinePanel.this.myButtonComponents) {
                    if (!component2.isVisible()) continue;
                    Dimension size3 = component2.getPreferredSize();
                    this.setBaselineBounds(x, y, component2, size3);
                    x += size3.width + BaselinePanel.this.myButtonOffset.get();
                    buttons = true;
                }
                int width = parent.getWidth();
                if (buttons) {
                    x -= BaselinePanel.this.myButtonOffset.get();
                    width -= (x += BaselinePanel.this.myBeforeButtonOffset.get());
                }
                Dimension baseSize = BaselinePanel.this.myBaseComponent.getPreferredSize();
                BaselinePanel.this.myBaseComponent.setBounds(x, y - baseComponentBaseline, width, baseSize.height);
                Component component3 = BaselinePanel.this.myBaseComponent;
                if (component3 instanceof JLabel) {
                    JLabel label2 = (JLabel)component3;
                    label2.setToolTipText(width < baseSize.width ? label2.getText() : null);
                }
            }

            private void setBaselineBounds(int x, int y, @NotNull Component component2, @NotNull Dimension size2) {
                if (component2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (size2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.setBaselineBounds(x, y, component2, size2, size2.width, size2.height);
            }

            private void setBaselineBounds(int x, int y, @NotNull Component component2, @NotNull Dimension prefSize, int width, int height) {
                if (component2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (prefSize == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (component2 instanceof ActionToolbar) {
                    component2.setBounds(x, BaselinePanel.this.getInsets().top - JBUI.scale((int)1), width, height);
                } else {
                    component2.setBounds(x, y - component2.getBaseline(prefSize.width, prefSize.height), width, height);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "size";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "prefSize";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/plugins/newui/BaselinePanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "calculateBaseWidth";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setBaselineBounds";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void setListeners(@NotNull EventHandler eventHandler) {
        if (eventHandler == null) {
            BaselinePanel.$$$reportNull$$$0(0);
        }
        this.myEventHandler = eventHandler;
    }

    public void setYOffset(int YOffset) {
        this.myYOffset = YOffset;
    }

    public Component add(Component component2) {
        assert (this.myBaseComponent == null);
        this.myBaseComponent = component2;
        return super.add(component2);
    }

    @NotNull
    public List<Component> getButtonComponents() {
        List<Component> list2 = this.myButtonComponents;
        if (list2 == null) {
            BaselinePanel.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public void addButtonComponent(@NotNull JComponent component2) {
        if (component2 == null) {
            BaselinePanel.$$$reportNull$$$0(2);
        }
        this.myButtonComponents.add(component2);
        this.add(component2, null);
    }

    public void removeButtons() {
        ArrayList<Component> buttons = new ArrayList<Component>(this.myButtonComponents);
        this.myButtonComponents.clear();
        this.myButtonEnableStates = null;
        for (Component button2 : buttons) {
            this.remove(button2);
        }
    }

    public void setProgressDisabledButton(@NotNull JComponent component2) {
        if (component2 == null) {
            BaselinePanel.$$$reportNull$$$0(3);
        }
        this.myProgressDisabledButton = component2;
    }

    public void setProgressComponent(@Nullable ListPluginComponent pluginComponent, @NotNull JComponent progressComponent) {
        if (progressComponent == null) {
            BaselinePanel.$$$reportNull$$$0(4);
        }
        assert (this.myProgressComponent == null);
        this.myProgressComponent = progressComponent;
        this.add(progressComponent, null);
        if (this.myEventHandler != null && pluginComponent != null) {
            this.myEventHandler.addAll(progressComponent);
            this.myEventHandler.updateHover(pluginComponent);
        }
        this.setVisibleOther(false);
        this.doLayout();
    }

    public void removeProgressComponent() {
        if (this.myProgressComponent == null) {
            return;
        }
        this.remove(this.myProgressComponent);
        this.myProgressComponent = null;
        this.setVisibleOther(true);
        this.doLayout();
    }

    private void setVisibleOther(boolean value) {
        if (this.myButtonComponents.isEmpty()) {
            return;
        }
        if (value) {
            assert (this.myButtonEnableStates != null && this.myButtonEnableStates.length == this.myButtonComponents.size());
            if (!this.myLeftOrder) {
                this.myBaseComponent.setVisible(true);
            }
            if (this.myProgressDisabledButton != null) {
                this.myProgressDisabledButton.setEnabled(true);
            }
            int size2 = this.myButtonComponents.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                this.myButtonComponents.get(i2).setVisible(this.myButtonEnableStates[i2]);
            }
            this.myButtonEnableStates = null;
        } else {
            assert (this.myButtonEnableStates == null);
            this.myButtonEnableStates = new boolean[this.myButtonComponents.size()];
            if (!this.myLeftOrder) {
                this.myBaseComponent.setVisible(false);
            }
            int size3 = this.myButtonComponents.size();
            for (int i3 = 0; i3 < size3; ++i3) {
                Component component2 = this.myButtonComponents.get(i3);
                if (component2 == this.myProgressDisabledButton) {
                    this.myButtonEnableStates[i3] = true;
                    component2.setEnabled(false);
                    continue;
                }
                this.myButtonEnableStates[i3] = component2.isVisible();
                component2.setVisible(false);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/BaselinePanel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/BaselinePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getButtonComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setListeners";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addButtonComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setProgressDisabledButton";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setProgressComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

