/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class ComboBoxButtonUI
extends DarculaButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new ComboBoxButtonUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (!(c instanceof ComboBoxAction.ComboBoxButton)) {
            return;
        }
        ComboBoxAction.ComboBoxButton button2 = (ComboBoxAction.ComboBoxButton)c;
        if (!button2.isArrowVisible()) {
            return;
        }
        if (UIUtil.isUnderWin10LookAndFeel()) {
            Icon icon2 = ComboBoxAction.getArrowIcon((boolean)button2.isEnabled());
            int x = button2.getWidth() - icon2.getIconWidth() - button2.getInsets().right - button2.getMargin().right - JBUIScale.scale((int)3) + button2.getArrowGap();
            int y = (button2.getHeight() - icon2.getIconHeight()) / 2;
            icon2.paintIcon(null, g, x, y);
        } else {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                int iconSize = JBUIScale.scale((int)16);
                int x = button2.getWidth() - iconSize - button2.getInsets().right - button2.getMargin().right + button2.getArrowGap();
                int y = (button2.getHeight() - iconSize) / 2;
                g2.translate(x, y);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                g2.setColor(JBUI.CurrentTheme.Arrow.foregroundColor((boolean)button2.isEnabled()));
                Path2D.Float arrow = new Path2D.Float(0);
                ((Path2D)arrow).moveTo(JBUIScale.scale((float)3.5f), JBUIScale.scale((float)6.0f));
                ((Path2D)arrow).lineTo(JBUIScale.scale((float)12.5f), JBUIScale.scale((float)6.0f));
                ((Path2D)arrow).lineTo(JBUIScale.scale((float)8.0f), JBUIScale.scale((float)11.0f));
                arrow.closePath();
                g2.fill(arrow);
            }
            finally {
                g2.dispose();
            }
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(super.getMinimumSize((JComponent)c).width, this.getPreferredSize((JComponent)c).height);
    }

    @Override
    protected Dimension getDarculaButtonSize(JComponent c, Dimension prefSize) {
        if (!(c instanceof ComboBoxAction.ComboBoxButton)) {
            return prefSize;
        }
        ComboBoxAction.ComboBoxButton button2 = (ComboBoxAction.ComboBoxButton)c;
        Dimension buttonSize = super.getDarculaButtonSize(c, prefSize);
        Insets i2 = button2.getInsets();
        int width = buttonSize.width + (StringUtil.isNotEmpty((String)button2.getText()) ? button2.getIconTextGap() : 0) + (!button2.isArrowVisible() ? 0 : JBUIScale.scale((int)16));
        int height = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.height + i2.top + i2.bottom;
        if (!button2.isSmallVariant()) {
            height = Math.max(height, buttonSize.height);
        }
        Dimension size2 = new Dimension(width, height);
        JBInsets.addTo((Dimension)size2, (Insets)button2.getMargin());
        return size2;
    }
}

