/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.text.parts;

import com.intellij.ide.ui.text.ActionKeyPopupKt;
import com.intellij.ide.ui.text.ShortcutsRenderingUtil;
import com.intellij.ide.ui.text.StyledTextPaneUtils;
import com.intellij.ide.ui.text.parts.RegularTextPart;
import com.intellij.ide.ui.text.parts.TextPart;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J(\u0010&\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)H\u0002J\u001a\u0010*\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0,0+H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R=\u0010\u001d\u001a+\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001f\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020#\u0018\u00010\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006."}, d2={"Lcom/intellij/ide/ui/text/parts/ShortcutTextPart;", "Lcom/intellij/ide/ui/text/parts/TextPart;", "text", "", "isRaw", "", "<init>", "(Ljava/lang/String;Z)V", "()Z", "backgroundColor", "Ljava/awt/Color;", "getBackgroundColor", "()Ljava/awt/Color;", "setBackgroundColor", "(Ljava/awt/Color;)V", "delimiter", "getDelimiter", "()Lcom/intellij/ide/ui/text/parts/TextPart;", "setDelimiter", "(Lcom/intellij/ide/ui/text/parts/TextPart;)V", "separatorAttributes", "Ljavax/swing/text/SimpleAttributeSet;", "getSeparatorAttributes", "()Ljavax/swing/text/SimpleAttributeSet;", "insertToTextPane", "", "textPane", "Ljavax/swing/JTextPane;", "startOffset", "onClickAction", "Lkotlin/Function3;", "Ljava/awt/Point;", "Lkotlin/ParameterName;", "name", "height", "", "getOnClickAction", "()Lkotlin/jvm/functions/Function3;", "insertText", "insertOffset", "attributes", "Ljavax/swing/text/AttributeSet;", "getShortcutData", "Lkotlin/Pair;", "", "Lkotlin/ranges/IntRange;", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nShortcutTextPart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShortcutTextPart.kt\ncom/intellij/ide/ui/text/parts/ShortcutTextPart\n+ 2 TextPart.kt\ncom/intellij/ide/ui/text/parts/TextPart\n*L\n1#1,107:1\n34#2,2:108\n*S KotlinDebug\n*F\n+ 1 ShortcutTextPart.kt\ncom/intellij/ide/ui/text/parts/ShortcutTextPart\n*L\n37#1:108,2\n*E\n"})
public class ShortcutTextPart
extends TextPart {
    private final boolean isRaw;
    @NotNull
    private Color backgroundColor;
    @NotNull
    private TextPart delimiter;

    public ShortcutTextPart(@NotNull String text2, boolean isRaw) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2);
        this.isRaw = isRaw;
        JBColor jBColor = JBColor.namedColor((String)"Lesson.shortcutBackground", (int)15134455, (int)0x333638);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        this.backgroundColor = (Color)jBColor;
        this.delimiter = new RegularTextPart("", false, 2, null);
        TextPart this_$iv = this;
        boolean $i$f$editAttributes = false;
        SimpleAttributeSet $this$_init__u24lambda_u240 = this_$iv.getAttributes();
        boolean bl = false;
        StyleConstants.setForeground($this$_init__u24lambda_u240, JBUI.CurrentTheme.Label.foreground());
        StyleConstants.setBold($this$_init__u24lambda_u240, true);
    }

    public final boolean isRaw() {
        return this.isRaw;
    }

    @NotNull
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setBackgroundColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.backgroundColor = color;
    }

    @NotNull
    public final TextPart getDelimiter() {
        return this.delimiter;
    }

    public final void setDelimiter(@NotNull TextPart textPart) {
        Intrinsics.checkNotNullParameter((Object)textPart, (String)"<set-?>");
        this.delimiter = textPart;
    }

    private final SimpleAttributeSet getSeparatorAttributes() {
        SimpleAttributeSet simpleAttributeSet;
        SimpleAttributeSet $this$_get_separatorAttributes__u24lambda_u240 = simpleAttributeSet = new SimpleAttributeSet();
        boolean bl = false;
        Font font = (Font)this.getFontGetter().invoke();
        StyleConstants.setFontFamily($this$_get_separatorAttributes__u24lambda_u240, font.getName());
        StyleConstants.setFontSize($this$_get_separatorAttributes__u24lambda_u240, font.getSize());
        StyleConstants.setForeground($this$_get_separatorAttributes__u24lambda_u240, UIUtil.getLabelInfoForeground());
        return simpleAttributeSet;
    }

    @Override
    public int insertToTextPane(@NotNull JTextPane textPane, int startOffset) {
        Intrinsics.checkNotNullParameter((Object)textPane, (String)"textPane");
        Pair<String, List<IntRange>> pair = this.getShortcutData();
        String shortcut = (String)pair.component1();
        List split = (List)pair.component2();
        int curOffset = startOffset;
        int start2 = 0;
        SimpleAttributeSet shortcutAttributes = this.getAttributes();
        SimpleAttributeSet sepAttributes = this.getSeparatorAttributes();
        curOffset = this.delimiter.insertToTextPane(textPane, curOffset);
        for (IntRange part : split) {
            String string = shortcut.substring(start2, part.getFirst());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            int partStart = curOffset = this.insertText(textPane, string, curOffset, sepAttributes);
            String string2 = shortcut.substring(part.getFirst(), part.getLast() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            int partEnd = curOffset = this.insertText(textPane, string2, curOffset, shortcutAttributes);
            textPane.getHighlighter().addHighlight(partStart, partEnd, (arg_0, arg_1, arg_2, arg_3, arg_4) -> ShortcutTextPart.insertToTextPane$lambda$0(partStart, partEnd, this, arg_0, arg_1, arg_2, arg_3, arg_4));
            start2 = part.getLast() + 1;
        }
        String string = shortcut.substring(start2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        curOffset = this.insertText(textPane, string, curOffset, sepAttributes);
        curOffset = this.delimiter.insertToTextPane(textPane, curOffset);
        return curOffset;
    }

    @Override
    @Nullable
    public Function3<JTextPane, Point, Integer, Unit> getOnClickAction() {
        return !this.isRaw ? (arg_0, arg_1, arg_2) -> ShortcutTextPart._get_onClickAction_$lambda$0(this, arg_0, arg_1, arg_2) : null;
    }

    private final int insertText(JTextPane textPane, String text2, int insertOffset, AttributeSet attributes) {
        textPane.getDocument().insertString(insertOffset, text2, attributes);
        return insertOffset + text2.length();
    }

    private final Pair<String, List<IntRange>> getShortcutData() {
        KeyStroke keyStroke;
        String actionId;
        KeyboardShortcut shortcut;
        Pair pair = !this.isRaw ? ((shortcut = ShortcutsRenderingUtil.INSTANCE.getShortcutByActionId(actionId = this.getText())) != null ? ShortcutsRenderingUtil.INSTANCE.getKeyboardShortcutData(shortcut) : ShortcutsRenderingUtil.INSTANCE.getGotoActionData(actionId, true)) : ((keyStroke = KeyStroke.getKeyStroke(this.getText())) != null ? ShortcutsRenderingUtil.INSTANCE.getKeyStrokeData(keyStroke) : ShortcutsRenderingUtil.INSTANCE.getRawShortcutData(this.getText()));
        return pair;
    }

    private static final void insertToTextPane$lambda$0(int $partStart, int $partEnd, ShortcutTextPart this$0, Graphics g, int n, int n2, Shape shape, JTextComponent c) {
        Intrinsics.checkNotNull((Object)c);
        Intrinsics.checkNotNull((Object)g);
        StyledTextPaneUtils.INSTANCE.drawRectangleAroundText(c, $partStart, $partEnd, g, this$0.backgroundColor, (Font)this$0.getFontGetter().invoke(), (Font)this$0.getFontGetter().invoke(), false, 0.5f);
    }

    private static final Unit _get_onClickAction_$lambda$0(ShortcutTextPart this$0, JTextPane textPane, Point point, int height) {
        Intrinsics.checkNotNullParameter((Object)textPane, (String)"textPane");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        ActionKeyPopupKt.showActionKeyPopup$default(textPane, point, height, this$0.getText(), null, 16, null);
        return Unit.INSTANCE;
    }
}

