/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionMenuItemKt;
import com.intellij.openapi.actionSystem.impl.ActionPresentationDecorator;
import com.intellij.openapi.actionSystem.impl.PoppedIcon;
import com.intellij.openapi.actionSystem.impl.UtilsKt;
import com.intellij.openapi.actionSystem.impl.actionholder.ActionRef;
import com.intellij.openapi.actionSystem.impl.actionholder.ActionRefKt;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBCheckBoxMenuItem;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.ui.mac.MacMenuSettings;
import com.intellij.ui.mac.screenmenu.Menu;
import com.intellij.ui.mac.screenmenu.MenuItem;
import com.intellij.ui.plaf.beg.BegMenuItemUI;
import com.intellij.util.ui.EmptyIcon;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001BA\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020(H\u0002J\u000e\u0010,\u001a\u00020(2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020(2\u0006\u00101\u001a\u00020/H\u0016J\u001b\u00102\u001a\u00020(2\f\u00103\u001a\b\u0012\u0004\u0012\u00020504H\u0002\u00a2\u0006\u0002\u00106J\b\u00107\u001a\u00020(H\u0016J\u0010\u00108\u001a\u00020(2\u0006\u00109\u001a\u00020\u000bH\u0016J\u0010\u0010A\u001a\u00020(2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010B\u001a\u0004\u0018\u00010!2\b\u0010C\u001a\u0004\u0018\u00010!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010D\u001a\u00020(2\b\u0010C\u001a\u0004\u0018\u00010!H\u0016J\b\u0010E\u001a\u00020\u000bH\u0016J\u0010\u0010F\u001a\u00020(2\u0006\u0010G\u001a\u00020/H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00188\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0015\u0010:\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010<\u001a\u00070\u0007\u00a2\u0006\u0002\b;8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0016\u0010?\u001a\u00070\u0007\u00a2\u0006\u0002\b;8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010>\u00a8\u0006H"}, d2={"Lcom/intellij/openapi/actionSystem/impl/ActionMenuItem;", "Lcom/intellij/ui/components/JBCheckBoxMenuItem;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "place", "", "uiKind", "Lcom/intellij/openapi/actionSystem/ActionUiKind$Popup;", "enableMnemonics", "", "insideCheckedGroup", "useDarkIcons", "<init>", "(Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/actionSystem/DataContext;Ljava/lang/String;Lcom/intellij/openapi/actionSystem/ActionUiKind$Popup;ZZZ)V", "actionRef", "Lcom/intellij/openapi/actionSystem/impl/actionholder/ActionRef;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "Lorg/jetbrains/annotations/NotNull;", "isToggleable", "()Z", "screenMenuItemPeer", "Lcom/intellij/ui/mac/screenmenu/MenuItem;", "description", "isToggled", "value", "Lcom/intellij/openapi/actionSystem/KeepPopupOnPerform;", "keepPopupOnPerform", "getKeepPopupOnPerform", "()Lcom/intellij/openapi/actionSystem/KeepPopupOnPerform;", "secondaryIcon", "Ljavax/swing/Icon;", "getSecondaryIcon", "()Ljavax/swing/Icon;", "anAction", "getAnAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "fireActionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "updateAccelerator", "updateFromPresentation", "setDisplayedMnemonicIndex", "index", "", "setMnemonic", "mnemonic", "setAcceleratorFromShortcuts", "shortcuts", "", "Lcom/intellij/openapi/actionSystem/Shortcut;", "([Lcom/intellij/openapi/actionSystem/Shortcut;)V", "updateUI", "menuSelectionChanged", "isIncluded", "firstShortcutTextFromPresentation", "Lcom/intellij/openapi/util/NlsSafe;", "defaultFirstShortcutText", "getDefaultFirstShortcutText", "()Ljava/lang/String;", "firstShortcutText", "getFirstShortcutText", "updateIcon", "adjustIcon", "icon", "setIcon", "isSelected", "performAction", "modifiers", "intellij.platform.ide.impl"})
public final class ActionMenuItem
extends JBCheckBoxMenuItem {
    @NotNull
    private final DataContext context;
    @JvmField
    @NotNull
    public final String place;
    @NotNull
    private final ActionUiKind.Popup uiKind;
    private final boolean enableMnemonics;
    private final boolean insideCheckedGroup;
    private final boolean useDarkIcons;
    @NotNull
    private final ActionRef<AnAction> actionRef;
    @NotNull
    private final Presentation presentation;
    private final boolean isToggleable;
    @JvmField
    @Nullable
    public final MenuItem screenMenuItemPeer;
    @NlsSafe
    @Nullable
    private String description;
    private boolean isToggled;
    @NotNull
    private KeepPopupOnPerform keepPopupOnPerform;
    @Nullable
    private String firstShortcutTextFromPresentation;

    public ActionMenuItem(@NotNull AnAction action2, @NotNull DataContext context2, @NotNull String place, @NotNull ActionUiKind.Popup uiKind, boolean enableMnemonics, boolean insideCheckedGroup, boolean useDarkIcons) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)uiKind, (String)"uiKind");
        this.context = context2;
        this.place = place;
        this.uiKind = uiKind;
        this.enableMnemonics = enableMnemonics;
        this.insideCheckedGroup = insideCheckedGroup;
        this.useDarkIcons = useDarkIcons;
        this.actionRef = ActionRefKt.createActionRef(action2);
        Presentation presentation2 = Presentation.newTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"newTemplatePresentation(...)");
        this.presentation = presentation2;
        this.isToggleable = action2 instanceof Toggleable;
        this.keepPopupOnPerform = KeepPopupOnPerform.Never;
        this.addActionListener(arg_0 -> ActionMenuItem._init_$lambda$0(this, arg_0));
        this.setBorderPainted(false);
        if (Menu.isJbScreenMenuEnabled() && Intrinsics.areEqual((Object)"MainMenu", (Object)this.place)) {
            this.screenMenuItemPeer = new MenuItem();
            this.screenMenuItemPeer.setActionDelegate(() -> ActionMenuItem._init_$lambda$1(this));
        } else {
            this.screenMenuItemPeer = null;
        }
        this.updateUI();
        this.updateAccelerator();
    }

    public final boolean isToggleable() {
        return this.isToggleable;
    }

    @NotNull
    public final KeepPopupOnPerform getKeepPopupOnPerform() {
        return this.keepPopupOnPerform;
    }

    @Nullable
    public final Icon getSecondaryIcon() {
        return UISettings.Companion.getInstance().getShowIconsInMenus() ? (Icon)this.presentation.getClientProperty(ActionUtil.SECONDARY_ICON) : null;
    }

    @NotNull
    public final AnAction getAnAction() {
        return this.actionRef.getAction();
    }

    public void fireActionPerformed(@NotNull ActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TransactionGuard transactionGuard = TransactionGuard.getInstance();
        Intrinsics.checkNotNull((Object)transactionGuard, (String)"null cannot be cast to non-null type com.intellij.openapi.application.TransactionGuardImpl");
        ((TransactionGuardImpl)transactionGuard).performUserActivity(() -> ActionMenuItem.fireActionPerformed$lambda$0(this, event));
    }

    private final void updateAccelerator() {
        AnAction action2 = this.actionRef.getAction();
        String id2 = ActionManager.getInstance().getId(action2);
        if (id2 != null) {
            Shortcut[] shortcutArray = KeymapUtil.getActiveKeymapShortcuts((String)id2).getShortcuts();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            this.setAcceleratorFromShortcuts(shortcutArray);
        } else {
            ShortcutSet shortcutSet = action2.getShortcutSet();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutSet, (String)"getShortcutSet(...)");
            ShortcutSet shortcutSet2 = shortcutSet;
            Shortcut[] shortcutArray = shortcutSet2.getShortcuts();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            this.setAcceleratorFromShortcuts(shortcutArray);
        }
    }

    public final void updateFromPresentation(@NotNull Presentation presentation2) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        this.presentation.copyFrom(presentation2, null, true);
        this.setEnabled(presentation2.isEnabled());
        String text2 = ActionPresentationDecorator.decorateTextIfNeeded(this.actionRef.getAction(), presentation2.getText(this.enableMnemonics));
        this.setText(text2);
        this.setMnemonic(presentation2.getMnemonic());
        this.setDisplayedMnemonicIndex(presentation2.getDisplayedMnemonicIndex());
        this.updateIcon(presentation2);
        this.description = presentation2.getDescription();
        KeepPopupOnPerform keepPopupOnPerform = presentation2.getKeepPopupOnPerform();
        Intrinsics.checkNotNullExpressionValue((Object)keepPopupOnPerform, (String)"getKeepPopupOnPerform(...)");
        this.keepPopupOnPerform = keepPopupOnPerform;
        if (this.screenMenuItemPeer != null) {
            this.screenMenuItemPeer.setLabel(text2, this.getAccelerator());
            this.screenMenuItemPeer.setEnabled(this.isEnabled());
        }
        String shortcutSuffix = (String)presentation2.getClientProperty(ActionUtil.KEYBOARD_SHORTCUT_SUFFIX);
        String shortcut = this.getDefaultFirstShortcutText();
        this.firstShortcutTextFromPresentation = ((CharSequence)shortcut).length() > 0 && !((charSequence = (CharSequence)shortcutSuffix) == null || charSequence.length() == 0) ? shortcut + shortcutSuffix : null;
    }

    public void setDisplayedMnemonicIndex(int index) throws IllegalArgumentException {
        super.setDisplayedMnemonicIndex(this.enableMnemonics ? index : -1);
    }

    public void setMnemonic(int mnemonic) {
        super.setMnemonic(this.enableMnemonics ? mnemonic : 0);
    }

    private final void setAcceleratorFromShortcuts(Shortcut[] shortcuts) {
        int n = shortcuts.length;
        for (int j = 0; j < n; ++j) {
            Shortcut shortcut = shortcuts[j];
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyStroke keyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getFirstKeyStroke(...)");
            KeyStroke firstKeyStroke = keyStroke;
            if (ActionMenuItemKt.isEnterKeyStroke(firstKeyStroke)) break;
            this.setAccelerator(firstKeyStroke);
            MenuItem menuItem = this.screenMenuItemPeer;
            if (menuItem != null) {
                menuItem.setLabel(this.getText(), firstKeyStroke);
            }
            if (!KeymapUtil.isSimplifiedMacShortcuts()) break;
            String string = KeymapUtil.getPreferredShortcutText((Shortcut[])shortcuts);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPreferredShortcutText(...)");
            String shortcutText = string;
            this.putClientProperty("accelerator.text", shortcutText);
            MenuItem menuItem2 = this.screenMenuItemPeer;
            if (menuItem2 == null) break;
            menuItem2.setAcceleratorText(shortcutText);
            break;
        }
    }

    public void updateUI() {
        this.setUI(BegMenuItemUI.createUI((JComponent)((Object)this)));
    }

    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
        ActionMenu.Companion.showDescriptionInStatusBar(isIncluded, (Component)((Object)this), this.description);
    }

    private final String getDefaultFirstShortcutText() {
        String string = KeymapUtil.getShortcutText((ShortcutSet)this.actionRef.getAction().getShortcutSet());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortcutText(...)");
        return string;
    }

    @NotNull
    public final String getFirstShortcutText() {
        String string = this.firstShortcutTextFromPresentation;
        if (string == null) {
            string = this.getDefaultFirstShortcutText();
        }
        return string;
    }

    private final void updateIcon(Presentation presentation2) {
        boolean bl = this.isToggled = this.isToggleable && Toggleable.isSelected((Presentation)presentation2);
        if (this.isToggleable && (presentation2.getIcon() == null || this.insideCheckedGroup || !UISettings.Companion.getInstance().getShowIconsInMenus())) {
            Icon adjustedIcon;
            if (Intrinsics.areEqual((Object)"MainMenu", (Object)this.place) && MacMenuSettings.isSystemMenu) {
                this.setState(this.isToggled);
                MenuItem menuItem = this.screenMenuItemPeer;
                if (menuItem != null) {
                    menuItem.setState(this.isToggled);
                }
            }
            if ((adjustedIcon = this.adjustIcon(presentation2.getIcon(), presentation2)) != null) {
                this.setIcon(adjustedIcon);
            } else if (this.isToggled) {
                ActionMenuItemKt.setToggledIcon((JMenuItem)((Object)this));
            } else {
                this.setIcon(EmptyIcon.ICON_16);
                this.setSelectedIcon(EmptyIcon.ICON_16);
                this.setDisabledIcon(EmptyIcon.ICON_16);
            }
        } else if (UISettings.Companion.getInstance().getShowIconsInMenus()) {
            Icon selected;
            Icon disabled;
            Icon icon2 = presentation2.getIcon();
            if (this.isToggleable && this.isToggled && icon2 != null) {
                icon2 = new PoppedIcon(icon2, 16, 16);
            }
            if ((disabled = presentation2.getDisabledIcon()) == null) {
                Icon icon3 = icon2;
                Icon icon4 = disabled = icon3 == null ? null : IconLoader.getDisabledIcon((Icon)icon3);
            }
            if ((selected = presentation2.getSelectedIcon()) == null) {
                selected = icon2;
            }
            this.setIcon(this.adjustIcon(presentation2.isEnabled() ? icon2 : disabled, presentation2));
            this.setSelectedIcon(this.adjustIcon(selected, presentation2));
            this.setDisabledIcon(this.adjustIcon(disabled, presentation2));
        }
    }

    private final Icon adjustIcon(Icon icon2, Presentation presentation2) {
        Icon icon3;
        boolean isMainMenu = Intrinsics.areEqual((Object)"MainMenu", (Object)this.place);
        if (isMainMenu && ActionMenu.Companion.isShowNoIcons(this.actionRef.getAction(), presentation2)) {
            icon3 = null;
        } else {
            if (!ActionMenu.Companion.isAligned() || !ActionMenu.Companion.isAlignedInGroup()) {
                return icon2;
            }
            icon3 = isMainMenu && icon2 == null && MacMenuSettings.isSystemMenu ? UtilsKt.getEMPTY_MENU_ACTION_ICON() : icon2;
        }
        return icon3;
    }

    public void setIcon(@Nullable Icon icon2) {
        block4: {
            Icon effectiveIcon = icon2;
            if (effectiveIcon != null) {
                if (MacMenuSettings.isSystemMenu && Intrinsics.areEqual((Object)"MainMenu", (Object)this.place)) {
                    effectiveIcon = IconUtilKt.getMenuBarIcon((Icon)effectiveIcon, (boolean)this.useDarkIcons);
                } else if (ActionMenu.Companion.shouldConvertIconToDarkVariant()) {
                    effectiveIcon = IconLoader.getDarkIcon((Icon)effectiveIcon, (boolean)true);
                }
            }
            super.setIcon(effectiveIcon);
            MenuItem menuItem = this.screenMenuItemPeer;
            if (menuItem == null) break block4;
            menuItem.setIcon(effectiveIcon);
        }
    }

    public boolean isSelected() {
        return this.isToggled;
    }

    private final void performAction(int modifiers) {
        String id2 = ActionManager.getInstance().getId(this.actionRef.getAction());
        if (id2 != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("context.menu.click.stats." + StringsKt.replace$default((String)id2, (char)' ', (char)'.', (boolean)false, (int)4, null));
        }
        IdeFocusManager.findInstanceByContext((DataContext)this.context).runOnOwnContext(this.context, () -> ActionMenuItem.performAction$lambda$0(this, modifiers));
    }

    private static final void lambda$1$0$0(ActionMenuItem this$0) {
        this$0.performAction(0);
    }

    private static final void lambda$1$0(ActionMenuItem this$0) {
        if (this$0.presentation.isEnabledInModalContext() || !Intrinsics.areEqual((Object)this$0.context.getData(PlatformCoreDataKeys.IS_MODAL_CONTEXT), (Object)true)) {
            TransactionGuard transactionGuard = TransactionGuard.getInstance();
            Intrinsics.checkNotNull((Object)transactionGuard, (String)"null cannot be cast to non-null type com.intellij.openapi.application.TransactionGuardImpl");
            ((TransactionGuardImpl)transactionGuard).performUserActivity(() -> ActionMenuItem.lambda$1$0$0(this$0));
        }
    }

    private static final void _init_$lambda$0(ActionMenuItem this$0, ActionEvent e) {
        this$0.performAction(e.getModifiers());
    }

    private static final void _init_$lambda$1(ActionMenuItem this$0) {
        if (this$0.isToggleable) {
            this$0.isToggled = !this$0.isToggled;
            this$0.screenMenuItemPeer.setState(this$0.isToggled);
        }
        SwingUtilities.invokeLater(() -> ActionMenuItem.lambda$1$0(this$0));
    }

    private static final void fireActionPerformed$lambda$0(ActionMenuItem this$0, ActionEvent $event) {
        super.fireActionPerformed($event);
    }

    private static final void performAction$lambda$0(ActionMenuItem this$0, int $modifiers) {
        AnAction action2 = this$0.actionRef.getAction();
        AWTEvent currentEvent = IdeEventQueue.Companion.getInstance().getTrueCurrentEvent();
        AnActionEvent event = new AnActionEvent(this$0.context, this$0.presentation.clone(), this$0.place, (ActionUiKind)this$0.uiKind, currentEvent instanceof InputEvent ? (InputEvent)currentEvent : null, $modifiers, ActionManager.getInstance());
        ActionUtil.performAction((AnAction)action2, (AnActionEvent)event);
    }
}

