/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EntryData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0003\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0004\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0005\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0006\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"PROVIDER_ELEMENT", "", "Lorg/jetbrains/annotations/NonNls;", "EDITOR_TYPE_ID_ATTRIBUTE", "SELECTED_ATTRIBUTE_VALUE", "STATE_ELEMENT", "PREVIEW_ATTRIBUTE", "EMPTY_ELEMENT", "Lorg/jdom/Element;", "parseEntry", "Lcom/intellij/openapi/fileEditor/impl/EntryData;", "project", "Lcom/intellij/openapi/project/Project;", "element", "fileEditorProviderManager", "Lcom/intellij/openapi/fileEditor/ex/FileEditorProviderManager;", "intellij.platform.ide.impl"})
public final class HistoryEntryKt {
    @NotNull
    public static final String PROVIDER_ELEMENT = "provider";
    @NotNull
    public static final String EDITOR_TYPE_ID_ATTRIBUTE = "editor-type-id";
    @NotNull
    public static final String SELECTED_ATTRIBUTE_VALUE = "selected";
    @NotNull
    public static final String STATE_ELEMENT = "state";
    @NotNull
    public static final String PREVIEW_ATTRIBUTE = "preview";
    @NotNull
    private static final Element EMPTY_ELEMENT = new Element("state");

    private static final EntryData parseEntry(Project project2, Element element, FileEditorProviderManager fileEditorProviderManager) {
        if (!Intrinsics.areEqual((Object)element.getName(), (Object)"entry")) {
            throw new IllegalArgumentException("unexpected tag: " + element);
        }
        String url = element.getAttributeValue("file");
        PersistentList providerStates = ExtensionsKt.persistentListOf();
        FileEditorProvider selectedProvider = null;
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
        for (Element providerElement : element.getChildren(PROVIDER_ELEMENT)) {
            FileEditorState state2;
            FileEditorProvider provider;
            String typeId = providerElement.getAttributeValue(EDITOR_TYPE_ID_ATTRIBUTE);
            Intrinsics.checkNotNull((Object)typeId);
            if (fileEditorProviderManager.getProvider(typeId) == null) continue;
            if (Boolean.parseBoolean(providerElement.getAttributeValue(SELECTED_ATTRIBUTE_VALUE))) {
                selectedProvider = provider;
            }
            if (file2 == null) continue;
            Element stateElement = providerElement.getChild(STATE_ELEMENT);
            Element element2 = stateElement;
            if (element2 == null) {
                element2 = EMPTY_ELEMENT;
            }
            Intrinsics.checkNotNullExpressionValue((Object)provider.readState(element2, project2, file2), (String)"readState(...)");
            providerStates = providerStates.add((Object)TuplesKt.to((Object)provider, (Object)state2));
        }
        Intrinsics.checkNotNull((Object)url);
        return new EntryData(url, (List)providerStates, selectedProvider, element.getAttributeBooleanValue(PREVIEW_ATTRIBUTE));
    }

    public static final /* synthetic */ EntryData access$parseEntry(Project project2, Element element, FileEditorProviderManager fileEditorProviderManager) {
        return HistoryEntryKt.parseEntry(project2, element, fileEditorProviderManager);
    }
}

