/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.ui.Gray;
import com.intellij.ui.ShadowJava2DPainter;
import com.intellij.util.ui.ImageUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.graphics.ShadowRenderer;
import org.jetbrains.annotations.ApiStatus;

public final class ShadowBorderPainter {
    private ShadowBorderPainter() {
    }

    private static BufferedImage createJava2dShadow(JComponent component2, int width, int height) {
        BufferedImage image2 = component2.getGraphicsConfiguration().createCompatibleImage(width, height, 3);
        ShadowJava2DPainter painter = new ShadowJava2DPainter(ShadowJava2DPainter.Type.IDE, 0, Gray.x00.withAlpha(30));
        Graphics2D g = image2.createGraphics();
        painter.paintShadow(g, 0, 0, width, height);
        g.dispose();
        return image2;
    }

    @ApiStatus.Internal
    public static BufferedImage createShadow(JComponent c, int width, int height) {
        return ShadowBorderPainter.createJava2dShadow(c, width, height);
    }

    public static Shadow createShadow(Image source, int x, int y, boolean paintSource, int shadowSize) {
        source = ImageUtil.toBufferedImage((Image)source);
        float w = source.getWidth(null);
        float h = source.getHeight(null);
        float ratio = w / h;
        float deltaX = shadowSize;
        float deltaY = (float)shadowSize / ratio;
        Image scaled = source.getScaledInstance((int)(w + deltaX), (int)(h + deltaY), 2);
        BufferedImage s = GraphicsUtilities.createCompatibleTranslucentImage((int)scaled.getWidth(null), (int)scaled.getHeight(null));
        Graphics2D graphics = (Graphics2D)s.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.drawImage(scaled, 0, 0, null);
        BufferedImage shadow = new ShadowRenderer(shadowSize, 0.2f, (Color)Gray.x00).createShadow(s);
        if (paintSource) {
            Graphics imgG = shadow.getGraphics();
            double d = (double)shadowSize * 0.5;
            imgG.drawImage(source, (int)((double)shadowSize + d), (int)((double)shadowSize + d / (double)ratio), null);
        }
        return new Shadow(shadow, x - shadowSize - 5, y - shadowSize + 2);
    }

    public static final class Shadow {
        int x;
        int y;
        Image image;

        public Shadow(Image image2, int x, int y) {
            this.x = x;
            this.y = y;
            this.image = image2;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Image getImage() {
            return this.image;
        }
    }
}

