/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.impl.ShadowPainterKt;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextAware;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ\u0012\u0010\u001e\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\u0014H\u0002J8\u0010 \u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/ui/impl/ShadowPainter;", "", "top", "Ljavax/swing/Icon;", "topRight", "right", "bottomRight", "bottom", "bottomLeft", "left", "topLeft", "<init>", "(Ljavax/swing/Icon;Ljavax/swing/Icon;Ljavax/swing/Icon;Ljavax/swing/Icon;Ljavax/swing/Icon;Ljavax/swing/Icon;Ljavax/swing/Icon;Ljavax/swing/Icon;)V", "croppedTop", "croppedRight", "croppedBottom", "croppedLeft", "borderColor", "Ljava/awt/Color;", "cachedScaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "setBorderColor", "", "createShadow", "Ljava/awt/image/BufferedImage;", "c", "Ljavax/swing/JComponent;", "width", "", "height", "updateIcons", "scaleContext", "paintShadow", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics2D;", "x", "y", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nShadowPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShadowPainter.kt\ncom/intellij/openapi/ui/impl/ShadowPainter\n+ 2 ShadowPainter.kt\ncom/intellij/openapi/ui/impl/ShadowPainterKt\n*L\n1#1,190:1\n148#2,5:191\n148#2,5:196\n148#2,5:201\n148#2,5:206\n148#2,5:211\n148#2,5:216\n148#2,5:221\n148#2,5:226\n*S KotlinDebug\n*F\n+ 1 ShadowPainter.kt\ncom/intellij/openapi/ui/impl/ShadowPainter\n*L\n59#1:191,5\n60#1:196,5\n61#1:201,5\n62#1:206,5\n63#1:211,5\n64#1:216,5\n65#1:221,5\n66#1:226,5\n*E\n"})
public final class ShadowPainter {
    @NotNull
    private final Icon top;
    @NotNull
    private final Icon topRight;
    @NotNull
    private final Icon right;
    @NotNull
    private final Icon bottomRight;
    @NotNull
    private final Icon bottom;
    @NotNull
    private final Icon bottomLeft;
    @NotNull
    private final Icon left;
    @NotNull
    private final Icon topLeft;
    @Nullable
    private Icon croppedTop;
    @Nullable
    private Icon croppedRight;
    @Nullable
    private Icon croppedBottom;
    @Nullable
    private Icon croppedLeft;
    @Nullable
    private Color borderColor;
    @Nullable
    private ScaleContext cachedScaleContext;

    public ShadowPainter(@NotNull Icon top, @NotNull Icon topRight, @NotNull Icon right, @NotNull Icon bottomRight, @NotNull Icon bottom, @NotNull Icon bottomLeft, @NotNull Icon left, @NotNull Icon topLeft) {
        Intrinsics.checkNotNullParameter((Object)top, (String)"top");
        Intrinsics.checkNotNullParameter((Object)topRight, (String)"topRight");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkNotNullParameter((Object)bottom, (String)"bottom");
        Intrinsics.checkNotNullParameter((Object)bottomLeft, (String)"bottomLeft");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)topLeft, (String)"topLeft");
        this.top = top;
        this.topRight = topRight;
        this.right = right;
        this.bottomRight = bottomRight;
        this.bottom = bottom;
        this.bottomLeft = bottomLeft;
        this.left = left;
        this.topLeft = topLeft;
        this.updateIcons(null);
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> ShadowPainter._init_$lambda$0(this, arg_0));
    }

    public final void setBorderColor(@Nullable Color borderColor) {
        this.borderColor = borderColor;
    }

    @NotNull
    public final BufferedImage createShadow(@NotNull JComponent c, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        BufferedImage image2 = c.getGraphicsConfiguration().createCompatibleImage(width, height, 3);
        Graphics2D g = image2.createGraphics();
        Component component2 = c;
        Intrinsics.checkNotNull((Object)g);
        this.paintShadow(component2, g, 0, 0, width, height);
        g.dispose();
        Intrinsics.checkNotNull((Object)image2);
        return image2;
    }

    private final void updateIcons(ScaleContext scaleContext) {
        Icon icon$iv;
        Icon icon2 = this.top;
        ScaleContext scaleContext$iv = scaleContext;
        boolean $i$f$updateIcon = false;
        if (icon$iv instanceof ScaleContextAware) {
            ((ScaleContextAware)icon$iv).updateScaleContext((UserScaleContext)scaleContext$iv);
        }
        boolean bl = false;
        this.croppedTop = IconUtil.cropIcon((Icon)this.top, (int)1, (int)Integer.MAX_VALUE);
        icon$iv = this.topRight;
        scaleContext$iv = scaleContext;
        $i$f$updateIcon = false;
        if (icon$iv instanceof ScaleContextAware) {
            ((ScaleContextAware)icon$iv).updateScaleContext((UserScaleContext)scaleContext$iv);
        }
        boolean bl2 = false;
        icon$iv = this.right;
        scaleContext$iv = scaleContext;
        $i$f$updateIcon = false;
        if (icon$iv instanceof ScaleContextAware) {
            ((ScaleContextAware)icon$iv).updateScaleContext((UserScaleContext)scaleContext$iv);
        }
        boolean bl3 = false;
        this.croppedRight = IconUtil.cropIcon((Icon)this.right, (int)Integer.MAX_VALUE, (int)1);
        icon$iv = this.bottomRight;
        scaleContext$iv = scaleContext;
        $i$f$updateIcon = false;
        if (icon$iv instanceof ScaleContextAware) {
            ((ScaleContextAware)icon$iv).updateScaleContext((UserScaleContext)scaleContext$iv);
        }
        boolean bl4 = false;
        icon$iv = this.bottom;
        scaleContext$iv = scaleContext;
        $i$f$updateIcon = false;
        if (icon$iv instanceof ScaleContextAware) {
            ((ScaleContextAware)icon$iv).updateScaleContext((UserScaleContext)scaleContext$iv);
        }
        boolean bl5 = false;
        this.croppedBottom = IconUtil.cropIcon((Icon)this.bottom, (int)1, (int)Integer.MAX_VALUE);
        icon$iv = this.bottomLeft;
        scaleContext$iv = scaleContext;
        $i$f$updateIcon = false;
        if (icon$iv instanceof ScaleContextAware) {
            ((ScaleContextAware)icon$iv).updateScaleContext((UserScaleContext)scaleContext$iv);
        }
        boolean bl6 = false;
        icon$iv = this.left;
        scaleContext$iv = scaleContext;
        $i$f$updateIcon = false;
        if (icon$iv instanceof ScaleContextAware) {
            ((ScaleContextAware)icon$iv).updateScaleContext((UserScaleContext)scaleContext$iv);
        }
        boolean bl7 = false;
        this.croppedLeft = IconUtil.cropIcon((Icon)this.left, (int)Integer.MAX_VALUE, (int)1);
        icon$iv = this.topLeft;
        scaleContext$iv = scaleContext;
        $i$f$updateIcon = false;
        if (icon$iv instanceof ScaleContextAware) {
            ((ScaleContextAware)icon$iv).updateScaleContext((UserScaleContext)scaleContext$iv);
        }
        boolean bl8 = false;
    }

    public final void paintShadow(@Nullable Component c, @NotNull Graphics2D g, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        ScaleContext newScaleContext = ScaleContext.Companion.create(g);
        if (this.cachedScaleContext == null) {
            this.cachedScaleContext = newScaleContext;
            this.updateIcons(null);
        } else {
            ScaleContext scaleContext = this.cachedScaleContext;
            Intrinsics.checkNotNull((Object)scaleContext);
            if (scaleContext.update((UserScaleContext)newScaleContext)) {
                this.updateIcons(this.cachedScaleContext);
            }
        }
        Icon icon2 = this.croppedLeft;
        Intrinsics.checkNotNull((Object)icon2);
        int leftSize = icon2.getIconWidth();
        Icon icon3 = this.croppedRight;
        Intrinsics.checkNotNull((Object)icon3);
        int rightSize = icon3.getIconWidth();
        Icon icon4 = this.croppedBottom;
        Intrinsics.checkNotNull((Object)icon4);
        int bottomSize = icon4.getIconHeight();
        Icon icon5 = this.croppedTop;
        Intrinsics.checkNotNull((Object)icon5);
        int topSize = icon5.getIconHeight();
        int delta = this.topLeft.getIconHeight() + this.bottomLeft.getIconHeight() - height;
        if (delta > 0) {
            Shape clip = g.getClip();
            int topHeight = this.topLeft.getIconHeight() - delta / 2;
            Area top = new Area(new Rectangle2D.Float(x, y, width, topHeight));
            if (clip != null) {
                top.intersect(new Area(clip));
            }
            g.setClip(top);
            this.topLeft.paintIcon(c, g, x, y);
            this.topRight.paintIcon(c, g, x + width - this.topRight.getIconWidth(), y);
            int bottomHeight = this.bottomLeft.getIconHeight() - delta + delta / 2;
            Area bottom = new Area(new Rectangle2D.Float(x, y + topHeight, width, bottomHeight));
            if (clip != null) {
                bottom.intersect(new Area(clip));
            }
            g.setClip(bottom);
            this.bottomLeft.paintIcon(c, g, x, y + height - this.bottomLeft.getIconHeight());
            this.bottomRight.paintIcon(c, g, x + width - this.bottomRight.getIconWidth(), y + height - this.bottomRight.getIconHeight());
            g.setClip(clip);
        } else {
            this.topLeft.paintIcon(c, g, x, y);
            this.topRight.paintIcon(c, g, x + width - this.topRight.getIconWidth(), y);
            this.bottomLeft.paintIcon(c, g, x, y + height - this.bottomLeft.getIconHeight());
            this.bottomRight.paintIcon(c, g, x + width - this.bottomRight.getIconWidth(), y + height - this.bottomRight.getIconHeight());
        }
        Graphics graphics = g;
        Icon icon6 = this.croppedTop;
        Intrinsics.checkNotNull((Object)icon6);
        ShadowPainterKt.access$fill(graphics, icon6, x, y, this.topLeft.getIconWidth(), width - this.topRight.getIconWidth(), true);
        Graphics graphics2 = g;
        Icon icon7 = this.croppedBottom;
        Intrinsics.checkNotNull((Object)icon7);
        ShadowPainterKt.access$fill(graphics2, icon7, x, y + height - bottomSize, this.bottomLeft.getIconWidth(), width - this.bottomRight.getIconWidth(), true);
        Graphics graphics3 = g;
        Icon icon8 = this.croppedLeft;
        Intrinsics.checkNotNull((Object)icon8);
        ShadowPainterKt.access$fill(graphics3, icon8, x, y, this.topLeft.getIconHeight(), height - this.bottomLeft.getIconHeight(), false);
        Graphics graphics4 = g;
        Icon icon9 = this.croppedRight;
        Intrinsics.checkNotNull((Object)icon9);
        ShadowPainterKt.access$fill(graphics4, icon9, x + width - rightSize, y, this.topRight.getIconHeight(), height - this.bottomRight.getIconHeight(), false);
        if (this.borderColor != null) {
            g.setColor(this.borderColor);
            g.drawRect(x + leftSize - 1, y + topSize - 1, width - leftSize - rightSize + 1, height - topSize - bottomSize + 1);
        }
    }

    private static final void _init_$lambda$0(ShadowPainter this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateIcons(null);
    }
}

