/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import com.intellij.openapi.vfs.newvfs.persistent.ListResult;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSAttributeAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSTreeAccessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class PersistentFSTreeRawAccessor
extends PersistentFSTreeAccessor {
    @VisibleForTesting
    public PersistentFSTreeRawAccessor(@NotNull PersistentFSAttributeAccessor attributeAccessor, @NotNull PersistentFSRecordAccessor recordAccessor, @NotNull PersistentFSConnection connection) {
        if (attributeAccessor == null) {
            PersistentFSTreeRawAccessor.$$$reportNull$$$0(0);
        }
        if (recordAccessor == null) {
            PersistentFSTreeRawAccessor.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            PersistentFSTreeRawAccessor.$$$reportNull$$$0(2);
        }
        super(attributeAccessor, recordAccessor, connection);
        if (!this.attributeAccessor.supportsRawAccess()) {
            throw new IllegalArgumentException("attributesAccessor must .supportsRawAccess(): " + String.valueOf(attributeAccessor));
        }
    }

    @Override
    @NotNull
    public ListResult doLoadChildren(int parentId) throws IOException {
        PersistentFSConnection.ensureIdIsValid(parentId);
        if (parentId == 1) {
            throw new AssertionError((Object)"Incorrect call .doLoadChildren() with a super-root record id(=1). Super-root is a special file record for internal use, it MUST NOT be used directly");
        }
        PersistentFSRecordsStorage records = this.connection.records();
        int parentModCount = records.getModCount(parentId);
        int flags = records.getFlags(parentId);
        List childrenList = (List)this.attributeAccessor.readAttributeRaw(parentId, CHILDREN_ATTR, buffer2 -> {
            int count = DataInputOutputUtil.readINT((ByteBuffer)buffer2);
            if (count == 0) {
                return Collections.emptyList();
            }
            ArrayList<ChildInfoImpl> children2 = new ArrayList<ChildInfoImpl>(count);
            int maxID = records.maxAllocatedID();
            int prevId = parentId;
            for (int i2 = 0; i2 < count; ++i2) {
                int childId = DataInputOutputUtil.readINT((ByteBuffer)buffer2) + prevId;
                this.checkChildIdValid(parentId, childId, i2, maxID);
                prevId = childId;
                int nameId = records.getNameId(childId);
                this.checkNameIdValid(nameId, parentId, childId);
                ChildInfoImpl child = new ChildInfoImpl(childId, nameId, null, null, null);
                children2.add(child);
            }
            return children2;
        });
        if (childrenList == null) {
            childrenList = Collections.emptyList();
        }
        if (FSRecordsImpl.areAllChildrenCached(flags)) {
            ListResult listResult = ListResult.allCached(parentModCount, childrenList, parentId);
            if (listResult == null) {
                PersistentFSTreeRawAccessor.$$$reportNull$$$0(3);
            }
            return listResult;
        }
        ListResult listResult = ListResult.notAllCached(parentModCount, childrenList, parentId);
        if (listResult == null) {
            PersistentFSTreeRawAccessor.$$$reportNull$$$0(4);
        }
        return listResult;
    }

    @Override
    public boolean forEachChild(int fileId, @NotNull IntPredicate childConsumer) throws IOException {
        if (childConsumer == null) {
            PersistentFSTreeRawAccessor.$$$reportNull$$$0(5);
        }
        PersistentFSConnection.ensureIdIsValid(fileId);
        if (fileId == 1) {
            throw new AssertionError((Object)"Incorrect call .listIds() with is a super-root record id(=1) -- use .listRoots() instead");
        }
        Boolean stoppedEarly = (Boolean)this.attributeAccessor.readAttributeRaw(fileId, CHILDREN_ATTR, buffer2 -> {
            int count = DataInputOutputUtil.readINT((ByteBuffer)buffer2);
            if (count == 0) {
                return false;
            }
            int prevId = fileId;
            int maxID = this.connection.records().maxAllocatedID();
            for (int i2 = 0; i2 < count; ++i2) {
                int childId = DataInputOutputUtil.readINT((ByteBuffer)buffer2) + prevId;
                if (childConsumer.test(childId)) {
                    return true;
                }
                prevId = childId;
                this.checkChildIdValid(fileId, prevId, i2, maxID);
            }
            return false;
        });
        if (stoppedEarly == null) {
            return false;
        }
        return stoppedEarly;
    }

    @Override
    boolean maybeHaveChildren(int fileId) throws IOException {
        PersistentFSConnection.ensureIdIsValid(fileId);
        if (fileId == 1) {
            throw new AssertionError((Object)"Incorrect call .mayHaveChildren() with is a super-root record id(=1)Super-root is a special file record for internal use, it MUST NOT be used directly");
        }
        Boolean hasChildren = (Boolean)this.attributeAccessor.readAttributeRaw(fileId, CHILDREN_ATTR, buffer2 -> {
            int count = DataInputOutputUtil.readINT((ByteBuffer)buffer2);
            return count != 0;
        });
        if (hasChildren == null) {
            return true;
        }
        return hasChildren;
    }

    @Override
    protected void cacheRoots() throws IOException {
        int maxAllocatedID = this.connection.records().maxAllocatedID();
        this.attributeAccessor.readAttributeRaw(1, CHILDREN_ATTR, recordBuffer -> {
            int rootsCount = DataInputOutputUtil.readINT((ByteBuffer)recordBuffer);
            if (rootsCount < 0) {
                throw new IOException("SUPER_ROOT.CHILDREN attribute is corrupted: roots count(=" + rootsCount + ") must be >=0");
            }
            int[] rootsUrlIds = ArrayUtil.newIntArray((int)rootsCount);
            int[] rootsIds = ArrayUtil.newIntArray((int)rootsCount);
            int prevUrlId = 0;
            int prevRootId = 0;
            for (int i2 = 0; i2 < rootsCount; ++i2) {
                int diffUrlId = DataInputOutputUtil.readINT((ByteBuffer)recordBuffer);
                int diffRootId = DataInputOutputUtil.readINT((ByteBuffer)recordBuffer);
                if (diffUrlId <= 0) {
                    throw new IOException("SUPER_ROOT.CHILDREN attribute is corrupted: diffUrlId[" + i2 + "](=" + diffUrlId + ") must be >0");
                }
                int urlId = diffUrlId + prevUrlId;
                int rootId = diffRootId + prevRootId;
                this.checkChildIdValid(1, rootId, i2, maxAllocatedID);
                rootsUrlIds[i2] = urlId;
                rootsIds[i2] = rootId;
                prevUrlId = urlId;
                prevRootId = rootId;
            }
            this.rootsIds = rootsIds;
            this.rootsUrlIds = rootsUrlIds;
            return null;
        });
        if (this.rootsIds == null) {
            this.rootsIds = ArrayUtil.EMPTY_INT_ARRAY;
            this.rootsUrlIds = ArrayUtil.EMPTY_INT_ARRAY;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeAccessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordAccessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSTreeRawAccessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSTreeRawAccessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forEachChild";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

