/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.content.AdditionalIcon;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.openapi.wm.impl.content.tabActions.ContentTabAction;
import com.intellij.openapi.wm.impl.content.tabActions.ContentTabActionProvider;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.content.Content;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ContentLabel
extends BaseLabel {
    private static final Logger LOG = Logger.getInstance(ContentLabel.class);
    private static final int DEFAULT_HORIZONTAL_INSET = 12;
    protected static final int ICONS_GAP = 3;
    private final List<AdditionalIcon> myAdditionalIcons;
    protected int myIconWithInsetsWidth;
    private CurrentTooltip currentIconTooltip;
    @NotNull
    protected final ContentLabelBorder myBorder;
    private final BaseButtonBehavior behavior;

    public ContentLabel(@NotNull ToolWindowContentUi ui, boolean bold) {
        if (ui == null) {
            ContentLabel.$$$reportNull$$$0(0);
        }
        super(ui, bold);
        this.myAdditionalIcons = new SmartList();
        this.myBorder = new ContentLabelBorder();
        this.behavior = new BaseButtonBehavior(this, null){

            protected void execute(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ContentLabel.this.handleMouseClick(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/content/ContentLabel$1", "execute"));
            }
        };
        this.behavior.setupListeners();
        this.behavior.setActionTrigger(-1);
        this.behavior.setMouseDeadzone(TimedDeadzone.NULL);
        this.setBorder(this.myBorder);
    }

    @Override
    public void setBorder(Border border) {
        if (this.myBorder != null && border != this.myBorder) {
            LOG.error(new Throwable("ContentLabel doesn't support custom borders"));
            return;
        }
        super.setBorder(border);
    }

    protected abstract void handleMouseClick(@NotNull MouseEvent var1);

    @NlsContexts.Label
    @Nullable
    protected abstract String getOriginalText();

    private void showTooltip(AdditionalIcon icon2) {
        if (icon2 != null) {
            String toolText;
            if (this.currentIconTooltip != null) {
                if (this.currentIconTooltip.icon == icon2) {
                    IdeTooltipManager.getInstance().show(this.currentIconTooltip.currentTooltip, false, false);
                    return;
                }
                this.hideCurrentTooltip();
            }
            if ((toolText = icon2.getTooltip()) != null && !toolText.isEmpty()) {
                IdeTooltip tooltip = new IdeTooltip(this, icon2.getCenterPoint(), new JLabel(toolText), new Object[0]);
                this.currentIconTooltip = new CurrentTooltip(IdeTooltipManager.getInstance().show(tooltip, false, false), icon2);
                return;
            }
        }
        this.hideCurrentTooltip();
        String originalText = this.getOriginalText();
        if (originalText != null && !originalText.equals(this.getText())) {
            IdeTooltip tooltip = new IdeTooltip(this, this.getMousePosition(), new JLabel(originalText), new Object[0]);
            this.currentIconTooltip = new CurrentTooltip(IdeTooltipManager.getInstance().show(tooltip, false, false), null);
        }
    }

    private void hideCurrentTooltip() {
        if (this.currentIconTooltip == null) {
            return;
        }
        this.currentIconTooltip.currentTooltip.hide();
        this.currentIconTooltip = null;
    }

    protected boolean handleActionsClick(@NotNull MouseEvent e) {
        if (e == null) {
            ContentLabel.$$$reportNull$$$0(1);
        }
        for (AdditionalIcon icon2 : this.myAdditionalIcons) {
            if (!this.mouseOverIcon(e, icon2)) continue;
            icon2.runAction();
            e.consume();
            return true;
        }
        return false;
    }

    final boolean mouseOverIcon(AdditionalIcon icon2) {
        return this.mouseOverIcon(null, icon2);
    }

    final boolean mouseOverIcon(@Nullable MouseEvent e, AdditionalIcon icon2) {
        if (!this.isHovered() || !icon2.getAvailable()) {
            return false;
        }
        Point point = null;
        if (e != null) {
            point = e.getLocationOnScreen();
        } else {
            PointerInfo info = MouseInfo.getPointerInfo();
            if (info != null) {
                point = info.getLocation();
            } else {
                AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
                if (event instanceof MouseEvent) {
                    point = ((MouseEvent)event).getLocationOnScreen();
                }
            }
        }
        if (point == null) {
            return false;
        }
        SwingUtilities.convertPointFromScreen(point, this);
        return icon2.contains(point);
    }

    protected void updateAdditionalActions() {
        this.myAdditionalIcons.clear();
        ArrayList objects = new ArrayList();
        this.fillActions(objects);
        this.myAdditionalIcons.addAll(ContainerUtil.map(objects, this::createIcon));
    }

    protected void fillActions(@NotNull List<? super ContentTabAction> actions) {
        Content content2;
        if (actions == null) {
            ContentLabel.$$$reportNull$$$0(2);
        }
        if ((content2 = this.getContent()) != null) {
            ContentTabActionProvider.EP_NAME.forEachExtensionSafe(provider -> actions.addAll(provider.createTabActions(content2)));
        }
    }

    @NotNull
    protected AdditionalIcon createIcon(@NotNull ContentTabAction action2) {
        if (action2 == null) {
            ContentLabel.$$$reportNull$$$0(3);
        }
        return new ContentAdditionalIcon(action2);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent event) {
        super.processMouseMotionEvent(event);
        boolean hovered = this.isHovered();
        if (hovered) {
            AdditionalIcon first;
            if (this.hasActiveIcons()) {
                this.repaint();
            }
            if ((first = this.findHoveredIcon()) != null) {
                this.showTooltip(first);
                return;
            }
        }
        this.showTooltip(null);
    }

    @Nullable
    protected AdditionalIcon findHoveredIcon() {
        return (AdditionalIcon)ContainerUtil.find(this.myAdditionalIcons, icon2 -> this.mouseOverIcon((AdditionalIcon)icon2));
    }

    boolean hasActiveIcons() {
        return this.myAdditionalIcons.stream().anyMatch(icon2 -> icon2.getAvailable());
    }

    @Override
    public Dimension getPreferredSize() {
        int left;
        Dimension size2 = super.getPreferredSize();
        HashMap<Boolean, List> map2 = new HashMap<Boolean, List>();
        for (AdditionalIcon myAdditionalIcon : this.myAdditionalIcons) {
            if (!myAdditionalIcon.getAvailable()) continue;
            map2.computeIfAbsent(myAdditionalIcon.getAfterText(), k -> new SmartList()).add(myAdditionalIcon);
        }
        boolean additionalIconsOnly = StringUtil.isEmptyOrSpaces((String)this.getText()) && this.getIcon() == null;
        int right = left = JBUI.scale((int)12);
        int iconsGap = JBUI.scale((int)3);
        if (additionalIconsOnly) {
            left = iconsGap;
            right = iconsGap;
        }
        if (map2.get(false) != null) {
            int iconWidth = iconsGap;
            for (AdditionalIcon icon2 : (List)map2.get(false)) {
                icon2.setX(iconWidth);
                iconWidth += icon2.getIconWidth() + iconsGap;
            }
            left = iconWidth;
        }
        int rightIconWidth = 0;
        if (map2.get(true) != null) {
            if (additionalIconsOnly) {
                for (AdditionalIcon icon2 : (List)map2.get(true)) {
                    icon2.setX(left + rightIconWidth);
                    rightIconWidth += icon2.getIconWidth() + iconsGap;
                }
                rightIconWidth -= iconsGap;
            } else {
                right = iconsGap + JBUIScale.scale((int)4);
                int offset = size2.width - JBUIScale.scale((int)4);
                for (AdditionalIcon icon3 : (List)map2.get(true)) {
                    icon3.setX(offset + rightIconWidth);
                    rightIconWidth += icon3.getIconWidth() + iconsGap;
                }
            }
        }
        this.myBorder.setBorderInsets(0, left, 0, right);
        this.myIconWithInsetsWidth = rightIconWidth + right + left;
        if (ExperimentalUI.isNewUI()) {
            JBInsets insets = JBUI.CurrentTheme.ToolWindow.headerTabLeftRightInsets();
            insets.left = Math.max(left, insets.left);
            this.myBorder.setBorderInsets((Insets)insets);
            this.myIconWithInsetsWidth = rightIconWidth + right + left;
        }
        return new Dimension(rightIconWidth + size2.width, size2.height);
    }

    private void paintIcons(@NotNull Graphics g) {
        if (g == null) {
            ContentLabel.$$$reportNull$$$0(4);
        }
        for (AdditionalIcon icon2 : this.myAdditionalIcons) {
            if (!icon2.getAvailable()) continue;
            icon2.paintIcon(this, g);
        }
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        if (g == null) {
            ContentLabel.$$$reportNull$$$0(5);
        }
        super.paintComponent(g);
        this.paintIcons(g);
    }

    public boolean isHovered() {
        return this.behavior.isHovered();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/content/ContentLabel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleActionsClick";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fillActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "paintIcons";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "paintComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class ContentLabelBorder
    extends EmptyBorder {
        ContentLabelBorder() {
            super(0, 0, 0, 0);
        }

        protected void setBorderInsets(@NotNull Insets insets) {
            if (insets == null) {
                ContentLabelBorder.$$$reportNull$$$0(0);
            }
            this.setBorderInsets(insets.top, insets.left, insets.bottom, insets.right);
        }

        protected void setBorderInsets(int top, int left, int bottom, int right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insets", "com/intellij/openapi/wm/impl/content/ContentLabel$ContentLabelBorder", "setBorderInsets"));
        }
    }

    private static final class CurrentTooltip {
        final IdeTooltip currentTooltip;
        final AdditionalIcon icon;

        CurrentTooltip(IdeTooltip currentTooltip, AdditionalIcon icon2) {
            this.currentTooltip = currentTooltip;
            this.icon = icon2;
        }
    }

    protected class ContentAdditionalIcon
    extends AdditionalIcon {
        public ContentAdditionalIcon(ContentTabAction action2) {
            if (action2 == null) {
                ContentAdditionalIcon.$$$reportNull$$$0(0);
            }
            super(action2);
        }

        @Override
        public boolean getActive() {
            return ContentLabel.this.mouseOverIcon(this);
        }

        @Override
        public int getHeight() {
            return ContentLabel.this.getHeight();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/wm/impl/content/ContentLabel$ContentAdditionalIcon", "<init>"));
        }
    }
}

