/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.presentationAssistant;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.platform.ide.impl.presentationAssistant.ActionInfoPopupGroup;
import com.intellij.platform.ide.impl.presentationAssistant.PresentationAssistantQuickSettingsGroup;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.IconUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001%B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0015\u001a\u00020\nJ\b\u0010\u0016\u001a\u00020\nH\u0002J\u000e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001f\u001a\u00020\nJ\b\u0010 \u001a\u00020\nH\u0002J\b\u0010!\u001a\u00020\nH\u0002J\u0006\u0010\"\u001a\u00020\nJ\b\u0010#\u001a\u00020\nH\u0016J\b\u0010$\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0017\u001a\u00020\u0018*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lcom/intellij/platform/ide/impl/presentationAssistant/PresentationAssistantQuickSettingsButton;", "Lcom/intellij/ui/components/JBLabel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "appearance", "Lcom/intellij/platform/ide/impl/presentationAssistant/ActionInfoPopupGroup$Appearance;", "shownStateRequestCountChanged", "Lkotlin/Function1;", "", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/ide/impl/presentationAssistant/ActionInfoPopupGroup$Appearance;Lkotlin/jvm/functions/Function1;)V", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "hideAlarm", "Lcom/intellij/util/Alarm;", "value", "shownStateRequestCount", "setShownStateRequestCount", "(I)V", "updatePreferredSize", "showSettingsPopup", "asHtml", "", "getAsHtml", "(Ljava/lang/String;)Ljava/lang/String;", "acquireShownStateRequest", "point", "Lcom/intellij/ui/awt/RelativePoint;", "showPopup", "releaseShownStateRequest", "scheduleHide", "cancelHideAlarm", "hidePopup", "dispose", "createSettingsButtonPopup", "AlarmFactory", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nPresentationAssistantQuickSettingsButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PresentationAssistantQuickSettingsButton.kt\ncom/intellij/platform/ide/impl/presentationAssistant/PresentationAssistantQuickSettingsButton\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,153:1\n30#2,2:154\n*S KotlinDebug\n*F\n+ 1 PresentationAssistantQuickSettingsButton.kt\ncom/intellij/platform/ide/impl/presentationAssistant/PresentationAssistantQuickSettingsButton\n*L\n40#1:154,2\n*E\n"})
public final class PresentationAssistantQuickSettingsButton
extends JBLabel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ActionInfoPopupGroup.Appearance appearance;
    @NotNull
    private final Function1<Integer, Unit> shownStateRequestCountChanged;
    @Nullable
    private JBPopup popup;
    @NotNull
    private Alarm hideAlarm;
    private int shownStateRequestCount;

    public PresentationAssistantQuickSettingsButton(@NotNull Project project2, @NotNull ActionInfoPopupGroup.Appearance appearance, @NotNull Function1<? super Integer, Unit> shownStateRequestCountChanged) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)appearance, (String)"appearance");
        Intrinsics.checkNotNullParameter(shownStateRequestCountChanged, (String)"shownStateRequestCountChanged");
        Icon icon2 = AllIcons.Actions.PresentationAssistantSettings;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"PresentationAssistantSettings");
        super(IconUtil.colorize$default((Icon)icon2, (Color)appearance.getTheme().getKeymapLabel(), (boolean)false, (boolean)false, (int)12, null));
        this.project = project2;
        this.appearance = appearance;
        this.shownStateRequestCountChanged = shownStateRequestCountChanged;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<AlarmFactory> serviceClass$iv = AlarmFactory.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.hideAlarm = ((AlarmFactory)object).createAlarm();
        this.setBackground(this.appearance.getTheme().getBackground());
        this.setOpaque(true);
        this.updatePreferredSize();
        RevertOnDisposeUtilKt.addMouseListener((Component)((Component)((Object)this)), (Disposable)this, (MouseListener)new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showSettingsPopup();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                int n = shownStateRequestCount;
                this.setShownStateRequestCount(n + 1);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.releaseShownStateRequest();
            }
        });
    }

    private final void setShownStateRequestCount(int value) {
        int oldValue = this.shownStateRequestCount;
        this.shownStateRequestCount = value;
        if (oldValue != this.shownStateRequestCount) {
            if (this.shownStateRequestCount > 0) {
                this.cancelHideAlarm();
            } else {
                this.scheduleHide();
            }
        }
        this.shownStateRequestCountChanged.invoke((Object)this.shownStateRequestCount);
    }

    public final void updatePreferredSize() {
        int width = JBUIScale.scale((int)this.appearance.getSettingsButtonWidth());
        this.setPreferredSize(new Dimension(width, width));
    }

    private final void showSettingsPopup() {
        int n = this.shownStateRequestCount;
        this.setShownStateRequestCount(n + 1);
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup("", (ActionGroup)new PresentationAssistantQuickSettingsGroup(), SimpleDataContext.getSimpleContext((DataKey)CommonDataKeys.PROJECT, (Object)this.project, null), null, false, () -> PresentationAssistantQuickSettingsButton.showSettingsPopup$lambda$0(this), Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        ListPopup popup2 = listPopup;
        popup2.setShowSubmenuOnHover(true);
        String string = IdeBundle.message((String)"presentation.assistant.quick.settings.ad", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        popup2.setAdText(this.getAsHtml(string), 2);
        popup2.showInBestPositionFor(SimpleDataContext.builder().add(PlatformDataKeys.CONTEXT_COMPONENT, (Object)this).add(PlatformDataKeys.CONTEXT_MENU_POINT, (Object)new Point(0, this.getHeight() + this.appearance.getSpaceBetweenPopups())).build());
    }

    private final String getAsHtml(String $this$asHtml) {
        return "<html>" + StringsKt.replace$default((String)$this$asHtml, (String)"\n", (String)"<br>", (boolean)false, (int)4, null) + "</html>";
    }

    public final void acquireShownStateRequest(@NotNull RelativePoint point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        int n = this.shownStateRequestCount;
        this.setShownStateRequestCount(n + 1);
        if (this.shownStateRequestCount > 0 && this.popup == null) {
            this.showPopup(point);
        }
    }

    private final void showPopup(RelativePoint point) {
        block0: {
            this.hidePopup();
            JBPopup jBPopup = this.popup = this.createSettingsButtonPopup();
            if (jBPopup == null) break block0;
            jBPopup.show(point);
        }
    }

    public final void releaseShownStateRequest() {
        if (this.shownStateRequestCount > 0) {
            int n = this.shownStateRequestCount;
            this.setShownStateRequestCount(n + -1);
        }
    }

    private final void scheduleHide() {
        this.cancelHideAlarm();
        this.hideAlarm.addRequest(() -> PresentationAssistantQuickSettingsButton.scheduleHide$lambda$0(this), 2000);
    }

    private final void cancelHideAlarm() {
        this.hideAlarm.cancelAllRequests();
    }

    public final void hidePopup() {
        if (this.popup == null) {
            return;
        }
        JBPopup jBPopup = this.popup;
        if (jBPopup != null) {
            jBPopup.cancel();
        }
        this.popup = null;
        this.cancelHideAlarm();
        this.setShownStateRequestCount(0);
    }

    public void dispose() {
        this.hidePopup();
    }

    private final JBPopup createSettingsButtonPopup() {
        ComponentPopupBuilder $this$createSettingsButtonPopup_u24lambda_u240 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)this), (JComponent)((Object)this));
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$createSettingsButtonPopup_u24lambda_u240);
        ActionInfoPopupGroup.Companion.setBorderColorIfNeeded($this$createSettingsButtonPopup_u24lambda_u240, this.appearance.getTheme());
        $this$createSettingsButtonPopup_u24lambda_u240.setFocusable(true);
        $this$createSettingsButtonPopup_u24lambda_u240.setBelongsToGlobalPopupStack(false);
        $this$createSettingsButtonPopup_u24lambda_u240.setCancelKeyEnabled(false);
        JBPopup jBPopup = $this$createSettingsButtonPopup_u24lambda_u240.createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"with(...)");
        JBPopup popup2 = jBPopup;
        return popup2;
    }

    private static final void showSettingsPopup$lambda$0(PresentationAssistantQuickSettingsButton this$0) {
        this$0.releaseShownStateRequest();
    }

    private static final void scheduleHide$lambda$0(PresentationAssistantQuickSettingsButton this$0) {
        this$0.hidePopup();
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/ide/impl/presentationAssistant/PresentationAssistantQuickSettingsButton$AlarmFactory;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "createAlarm", "Lcom/intellij/util/Alarm;", "intellij.platform.ide.impl"})
    private static final class AlarmFactory {
        @NotNull
        private final CoroutineScope coroutineScope;

        public AlarmFactory(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.coroutineScope = coroutineScope;
        }

        @NotNull
        public final Alarm createAlarm() {
            return new Alarm(this.coroutineScope, Alarm.ThreadToUse.SWING_THREAD);
        }
    }
}

