/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.jbr;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.jbr.DefDisplayModeEx;
import com.intellij.platform.jbr.DefInputEventEx;
import com.intellij.platform.jbr.DisplayModeEx;
import com.intellij.platform.jbr.InputEventEx;
import com.intellij.platform.jbr.JBDisplayModeEx;
import com.intellij.platform.jbr.JBInputEventEx;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.MethodInvocator;
import java.awt.Color;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdkEx {
    private static final Logger LOG = Logger.getInstance(JdkEx.class);
    private static MethodInvocator mySetTabbingMode;

    @NotNull
    public static InputEventEx getInputEventEx() {
        if (SystemInfo.isJetBrainsJvm) {
            return new JBInputEventEx();
        }
        return new DefInputEventEx();
    }

    public static DisplayModeEx getDisplayModeEx() {
        if (SystemInfo.isJetBrainsJvm) {
            return new JBDisplayModeEx();
        }
        return new DefDisplayModeEx();
    }

    public static void setTransparent(@NotNull JWindow window) {
        JComponent contentPane;
        JRootPane rootPane;
        if (window == null) {
            JdkEx.$$$reportNull$$$0(0);
        }
        if ((rootPane = window.getRootPane()) != null) {
            ((JComponent)rootPane).setDoubleBuffered(false);
        }
        if ((contentPane = (JComponent)window.getContentPane()) != null) {
            contentPane.setDoubleBuffered(false);
        }
        window.setBackground(new Color(1, 1, 1, 0));
    }

    public static void setIgnoreMouseEvents(@NotNull Window window, boolean ignoreMouseEvents) {
        if (window == null) {
            JdkEx.$$$reportNull$$$0(1);
        }
        if (SystemInfo.isJetBrainsJvm && (SystemInfo.isMac || SystemInfo.isWindows)) {
            window.setEnabled(false);
            try {
                MethodInvocator invocator = new MethodInvocator(false, Class.forName("java.awt.Window"), "setIgnoreMouseEvents", new Class[]{Boolean.TYPE});
                if (invocator.isAvailable()) {
                    invocator.invoke((Object)window, new Object[]{ignoreMouseEvents});
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Nullable
    private static MethodInvocator getTabbingModeInvocator() {
        if (ExperimentalUI.isNewUI() && !Registry.is((String)"ide.mac.os.wintabs.version2", (boolean)true) || !SystemInfo.isJetBrainsJvm || !SystemInfo.isMacOSBigSur || !Registry.is((String)"ide.mac.bigsur.window.with.tabs.enabled", (boolean)true)) {
            if (SystemInfoRt.isMac) {
                LOG.info("=== TabbingMode: disabled (" + SystemInfo.isJetBrainsJvm + "," + SystemInfo.isMacOSBigSur + "," + Registry.is((String)"ide.mac.bigsur.window.with.tabs.enabled") + "," + ExperimentalUI.isNewUI() + Registry.is((String)"ide.mac.os.wintabs.version2") + ") ===");
            }
            return null;
        }
        if (mySetTabbingMode == null) {
            try {
                mySetTabbingMode = new MethodInvocator(false, Class.forName("java.awt.Window"), "setTabbingMode", new Class[0]);
                if (mySetTabbingMode.isAvailable()) {
                    LOG.info("=== TabbingMode: available ===");
                    return mySetTabbingMode;
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error((Throwable)e);
            }
            LOG.info("=== TabbingMode: not available ===");
            return null;
        }
        return mySetTabbingMode.isAvailable() ? mySetTabbingMode : null;
    }

    public static boolean isTabbingModeAvailable() {
        return JdkEx.getTabbingModeInvocator() != null;
    }

    public static boolean setTabbingMode(@NotNull Window window, @NotNull String windowId, @Nullable Runnable moveTabToNewWindowCallback) {
        MethodInvocator invocator;
        if (window == null) {
            JdkEx.$$$reportNull$$$0(2);
        }
        if (windowId == null) {
            JdkEx.$$$reportNull$$$0(3);
        }
        if ((invocator = JdkEx.getTabbingModeInvocator()) != null) {
            invocator.invoke((Object)window, new Object[0]);
            ((RootPaneContainer)((Object)window)).getRootPane().putClientProperty("JavaWindowTabbingIdentifier", windowId);
            if (moveTabToNewWindowCallback != null) {
                try {
                    new MethodInvocator(false, Class.forName("java.awt.Window"), "setMoveTabToNewWindowCallback", new Class[]{Runnable.class}).invoke((Object)window, new Object[]{moveTabToNewWindowCallback});
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Throwable)e);
                }
            }
            LOG.info("=== TabbingMode: on ===");
            return true;
        }
        LOG.info("=== TabbingMode: off ===");
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/jbr/JdkEx";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setTransparent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setIgnoreMouseEvents";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setTabbingMode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyMethod {
        private static final MyMethod EMPTY_INSTANCE = new MyMethod(null);
        @Nullable
        MethodInvocator myInvocator;

        public static MyMethod create(@NotNull String className, @NotNull String methodName, Class<?> ... parameterTypes) {
            if (className == null) {
                MyMethod.$$$reportNull$$$0(0);
            }
            if (methodName == null) {
                MyMethod.$$$reportNull$$$0(1);
            }
            try {
                return MyMethod.create(Class.forName(className), methodName, parameterTypes);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return EMPTY_INSTANCE;
            }
        }

        public static MyMethod create(@NotNull Class<?> cls, @NotNull String methodName, Class<?> ... parameterTypes) {
            if (cls == null) {
                MyMethod.$$$reportNull$$$0(2);
            }
            if (methodName == null) {
                MyMethod.$$$reportNull$$$0(3);
            }
            return new MyMethod(new MethodInvocator(false, cls, methodName, (Class[])parameterTypes));
        }

        private MyMethod(@Nullable MethodInvocator invocator) {
            this.myInvocator = invocator;
        }

        public boolean isAvailable() {
            return this.myInvocator != null && this.myInvocator.isAvailable();
        }

        @Nullable
        public Object invoke(Object object, Object ... arguments) {
            if (this.isAvailable()) {
                return this.myInvocator.invoke(object, arguments);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "methodName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cls";
                    break;
                }
            }
            objectArray[1] = "com/intellij/platform/jbr/JdkEx$MyMethod";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

