/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.impl.source.tree.LeafElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class CompositeWhiteSpaceFormattingStrategy
implements WhiteSpaceFormattingStrategy {
    private final List<WhiteSpaceFormattingStrategy> myStrategies;
    private final boolean myReplaceDefaultStrategy;

    public CompositeWhiteSpaceFormattingStrategy(boolean replaceDefaultStrategy, @NotNull Collection<? extends WhiteSpaceFormattingStrategy> strategies) {
        if (strategies == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(0);
        }
        this.myStrategies = List.copyOf(strategies);
        this.myReplaceDefaultStrategy = replaceDefaultStrategy;
    }

    public CompositeWhiteSpaceFormattingStrategy(@NotNull Collection<? extends WhiteSpaceFormattingStrategy> strategies) {
        if (strategies == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(1);
        }
        this(false, strategies);
    }

    @Override
    public int check(@NotNull CharSequence text2, int start2, int end) {
        if (text2 == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(2);
        }
        int offset = start2;
        while (offset < end) {
            WhiteSpaceFormattingStrategy strategy;
            int oldOffset = offset;
            Iterator<WhiteSpaceFormattingStrategy> iterator2 = this.myStrategies.iterator();
            while (iterator2.hasNext() && (offset = (strategy = iterator2.next()).check(text2, offset, end)) <= oldOffset) {
            }
            if (offset != oldOffset) continue;
            return offset;
        }
        return offset;
    }

    @Override
    public boolean replaceDefaultStrategy() {
        return this.myReplaceDefaultStrategy;
    }

    @Override
    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull CharSequence text2, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings, ASTNode nodeAfter) {
        if (whiteSpaceText == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(4);
        }
        CharSequence result2 = whiteSpaceText;
        for (WhiteSpaceFormattingStrategy strategy : this.myStrategies) {
            result2 = strategy.adjustWhiteSpaceIfNecessary(result2, text2, startOffset, endOffset, codeStyleSettings, nodeAfter);
        }
        CharSequence charSequence = result2;
        if (charSequence == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    @Override
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull PsiElement startElement, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings) {
        if (whiteSpaceText == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(7);
        }
        CharSequence result2 = whiteSpaceText;
        for (WhiteSpaceFormattingStrategy strategy : this.myStrategies) {
            result2 = strategy.adjustWhiteSpaceIfNecessary(result2, startElement, startOffset, endOffset, codeStyleSettings);
        }
        return result2;
    }

    @Override
    public boolean containsWhitespacesOnly(@NotNull ASTNode node) {
        if (node == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(8);
        }
        for (WhiteSpaceFormattingStrategy strategy : this.myStrategies) {
            if (!strategy.containsWhitespacesOnly(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addWhitespace(@NotNull ASTNode treePrev, @NotNull LeafElement whiteSpaceElement) {
        if (treePrev == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(9);
        }
        if (whiteSpaceElement == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(10);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategies";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaceText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/CompositeWhiteSpaceFormattingStrategy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePrev";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/CompositeWhiteSpaceFormattingStrategy";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustWhiteSpaceIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustWhiteSpaceIfNecessary";
                break;
            }
            case 5: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "containsWhitespacesOnly";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addWhitespace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

