/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.source.codeStyle.ContextFormattingRangesExtender;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

final class LineFormattingRangesExtender {
    private static final Logger LOG = Logger.getInstance(ContextFormattingRangesExtender.class);
    private final Document myDocument;

    LineFormattingRangesExtender(@NotNull Document document2) {
        if (document2 == null) {
            LineFormattingRangesExtender.$$$reportNull$$$0(0);
        }
        this.myDocument = document2;
    }

    public @Unmodifiable List<TextRange> getExtendedRanges(@NotNull List<? extends TextRange> ranges) {
        if (ranges == null) {
            LineFormattingRangesExtender.$$$reportNull$$$0(1);
        }
        return ContainerUtil.map(ranges, range -> this.processRange((TextRange)range));
    }

    private TextRange processRange(@NotNull TextRange originalRange) {
        TextRange validRange;
        if (originalRange == null) {
            LineFormattingRangesExtender.$$$reportNull$$$0(2);
        }
        if (!(validRange = this.ensureRangeIsValid(originalRange)).isEmpty()) {
            return this.expandToLines(validRange);
        }
        return validRange;
    }

    private TextRange expandToLines(@NotNull TextRange original) {
        if (original == null) {
            LineFormattingRangesExtender.$$$reportNull$$$0(3);
        }
        int startLine = this.myDocument.getLineNumber(original.getStartOffset());
        int endLine = this.myDocument.getLineNumber(original.getEndOffset() - 1);
        int rangeStart = this.myDocument.getLineStartOffset(startLine);
        int rangeEnd = this.myDocument.getLineEndOffset(endLine);
        if (rangeStart > 0 && this.myDocument.getCharsSequence().charAt(rangeStart - 1) == '\n') {
            --rangeStart;
        }
        return new TextRange(rangeStart, rangeEnd);
    }

    private TextRange ensureRangeIsValid(@NotNull TextRange range) {
        int docLength;
        if (range == null) {
            LineFormattingRangesExtender.$$$reportNull$$$0(4);
        }
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        if (endOffset > (docLength = this.myDocument.getTextLength())) {
            LOG.warn("The given range " + endOffset + " exceeds the document length " + docLength);
            return new TextRange(Math.min(startOffset, docLength), docLength);
        }
        return range;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/LineFormattingRangesExtender";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getExtendedRanges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "expandToLines";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureRangeIsValid";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

