/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.TextRange;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FilteringTree;
import com.intellij.ui.LightColors;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class FilteringSpeedSearch<T extends DefaultMutableTreeNode, U>
extends SpeedSearch
implements FilteringTree.FilteringTreeUserObjectMatcher<U> {
    private final JTextComponent myField;
    private final FilteringTree<T, U> myFilteringTree;

    protected FilteringSpeedSearch(@NotNull FilteringTree<T, U> filteringTree, @NotNull SearchTextField field) {
        if (filteringTree == null) {
            FilteringSpeedSearch.$$$reportNull$$$0(0);
        }
        if (field == null) {
            FilteringSpeedSearch.$$$reportNull$$$0(1);
        }
        this.myFilteringTree = filteringTree;
        this.myField = field.getTextEditor();
        this.myField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                String text2 = FilteringSpeedSearch.this.myField.getText();
                FilteringSpeedSearch.this.updatePattern(text2);
                FilteringSpeedSearch.this.onSearchPatternUpdated(text2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/FilteringSpeedSearch$1", "textChanged"));
            }
        });
        this.setEnabled(true);
        this.getTreeComponent().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (FilteringSpeedSearch.this.selectTargetElement(e.getKeyCode())) {
                    e.consume();
                }
            }
        });
        this.getTreeComponent().addKeyListener((KeyListener)((Object)this));
        this.installSupplyTo((JComponent)this.getTreeComponent());
    }

    public void select(@NotNull T node) {
        if (node == null) {
            FilteringSpeedSearch.$$$reportNull$$$0(2);
        }
        TreeUtil.selectInTree(node, (boolean)false, (JTree)this.getTreeComponent());
    }

    @NotNull
    public FilteringTree.Matching checkMatching(@NotNull T node) {
        U userObject;
        if (node == null) {
            FilteringSpeedSearch.$$$reportNull$$$0(3);
        }
        if ((userObject = this.myFilteringTree.getUserObject((TreeNode)node)) == null) {
            FilteringTree.Matching matching = FilteringTree.Matching.NONE;
            if (matching == null) {
                FilteringSpeedSearch.$$$reportNull$$$0(4);
            }
            return matching;
        }
        String text2 = this.myFilteringTree.getText(userObject);
        if (text2 == null) {
            FilteringTree.Matching matching = FilteringTree.Matching.NONE;
            if (matching == null) {
                FilteringSpeedSearch.$$$reportNull$$$0(5);
            }
            return matching;
        }
        Iterable matchingFragments = this.matchingFragments(text2);
        return this.checkMatching(userObject, matchingFragments);
    }

    @Override
    @NotNull
    public final FilteringTree.Matching checkMatching(@NotNull U userObject, @Nullable Iterable<TextRange> matchingFragments) {
        TextRange onlyFragment;
        if (userObject == null) {
            FilteringSpeedSearch.$$$reportNull$$$0(6);
        }
        FilteringTree.Matching result2 = matchingFragments == null ? FilteringTree.Matching.NONE : ((onlyFragment = FilteringSpeedSearch.getOnlyElement(matchingFragments)) != null && onlyFragment.getStartOffset() == 0 ? FilteringTree.Matching.FULL : FilteringTree.Matching.PARTIAL);
        this.onMatchingChecked(userObject, matchingFragments, result2);
        FilteringTree.Matching matching = result2;
        if (matching == null) {
            FilteringSpeedSearch.$$$reportNull$$$0(7);
        }
        return matching;
    }

    protected void onMatchingChecked(@NotNull U userObject, @Nullable Iterable<TextRange> matchingFragments, @NotNull FilteringTree.Matching result2) {
        if (userObject == null) {
            FilteringSpeedSearch.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            FilteringSpeedSearch.$$$reportNull$$$0(9);
        }
    }

    public void update() {
        String filter2 = this.getFilter();
        this.myField.setText(filter2);
    }

    protected void onSearchPatternUpdated(@Nullable String pattern) {
        this.refilter(pattern);
    }

    @VisibleForTesting
    public void refilter(@Nullable String pattern) {
        TreePath[] paths = this.getTreeComponent().getSelectionModel().getSelectionPaths();
        this.myFilteringTree.getSearchModel().refilter();
        this.myFilteringTree.expandTreeOnSearchUpdateComplete(pattern);
        this.getTreeComponent().getSelectionModel().setSelectionPaths(paths);
        this.myFilteringTree.onSpeedSearchUpdateComplete(pattern);
        this.updateSelection();
    }

    public void noHits() {
        this.myField.setBackground(LightColors.RED);
    }

    public void updateSelection() {
        T partialMatch;
        FilteringTree.Matching currentMatching;
        T selection = this.getSelection();
        FilteringTree.Matching matching = currentMatching = selection != null ? this.checkMatching(selection) : FilteringTree.Matching.NONE;
        if (currentMatching == FilteringTree.Matching.FULL) {
            return;
        }
        T fullMatch = this.findNextMatchingNode(selection, true);
        if (fullMatch != null) {
            this.select(fullMatch);
        } else if (currentMatching == FilteringTree.Matching.NONE && (partialMatch = this.findNextMatchingNode(selection, false)) != null) {
            this.select(partialMatch);
        }
    }

    private T findNextMatchingNode(T selection, boolean fullMatch) {
        JBIterator allNodeIterator = JBIterator.from(this.iterate(selection, true, true));
        JBIterator fullMatches = this.filterMatchingNodes(allNodeIterator, fullMatch).filter(item -> item != selection);
        if (fullMatches.advance()) {
            return (T)((DefaultMutableTreeNode)fullMatches.current());
        }
        return null;
    }

    @NotNull
    private JBIterator<T> filterMatchingNodes(JBIterator<T> nodes, boolean fullMatch) {
        JBIterator jBIterator = nodes.filter(item -> {
            FilteringTree.Matching matching = this.checkMatching(item);
            return fullMatch ? matching == FilteringTree.Matching.FULL : matching != FilteringTree.Matching.NONE;
        });
        if (jBIterator == null) {
            FilteringSpeedSearch.$$$reportNull$$$0(10);
        }
        return jBIterator;
    }

    @NotNull
    public Iterator<T> iterate(T start2, boolean fwd, boolean wrap2) {
        if (!wrap2 || start2 == null) {
            Iterator<T> iterator2 = this.iterate(start2, fwd);
            if (iterator2 == null) {
                FilteringSpeedSearch.$$$reportNull$$$0(11);
            }
            return iterator2;
        }
        return new JBIterator<T>((DefaultMutableTreeNode)start2, fwd){
            boolean wrapped = false;
            Iterator<T> it = FilteringSpeedSearch.this.iterate(this.val$start, this.val$fwd);
            final /* synthetic */ DefaultMutableTreeNode val$start;
            final /* synthetic */ boolean val$fwd;
            {
                this.val$start = defaultMutableTreeNode;
                this.val$fwd = bl;
            }

            protected T nextImpl() {
                if (this.it.hasNext()) {
                    return (DefaultMutableTreeNode)this.it.next();
                }
                if (this.wrapped) {
                    return (DefaultMutableTreeNode)this.stop();
                }
                this.wrapped = true;
                this.it = 3.from(FilteringSpeedSearch.this.iterate(null, this.val$fwd)).takeWhile(item -> item != this.val$start);
                return this.it.hasNext() ? (DefaultMutableTreeNode)this.it.next() : (DefaultMutableTreeNode)this.stop();
            }
        };
    }

    private boolean selectTargetElement(int keyCode) {
        Iterator<Object> it;
        if (!this.isPopupActive()) {
            return false;
        }
        if (keyCode == 38) {
            it = this.iterate(this.getSelection(), false, TreeUtil.isCyclicScrollingAllowed());
        } else if (keyCode == 40) {
            it = this.iterate(this.getSelection(), true, TreeUtil.isCyclicScrollingAllowed());
        } else if (keyCode == 36) {
            it = this.iterate(null, true);
        } else if (keyCode == 35) {
            it = this.iterate(null, false);
        } else {
            return false;
        }
        it = this.filterMatchingNodes(JBIterator.from(it), false);
        if (it.hasNext()) {
            this.select((DefaultMutableTreeNode)it.next());
        }
        return true;
    }

    @Nullable
    private static <T> T getOnlyElement(@NotNull Iterable<T> iterable) {
        Iterator<T> it;
        if (iterable == null) {
            FilteringSpeedSearch.$$$reportNull$$$0(12);
        }
        if (!(it = iterable.iterator()).hasNext()) {
            return null;
        }
        T firstValue = it.next();
        return it.hasNext() ? null : (T)firstValue;
    }

    @Nullable
    public T getSelection() {
        return (T)((DefaultMutableTreeNode)ArrayUtil.getFirstElement((Object[])((DefaultMutableTreeNode[])this.getTreeComponent().getSelectedNodes(this.myFilteringTree.getNodeClass(), null))));
    }

    @NotNull
    public Iterator<T> iterate(@Nullable T start2, boolean fwd) {
        Set rootPath = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)HashingStrategy.identity());
        for (Object node = start2; node != null; node = node.getParent()) {
            rootPath.add(node);
        }
        JBTreeTraverser traverser = JBTreeTraverser.from(n -> {
            boolean onRootPath = rootPath.contains(n);
            int count = n.getChildCount();
            ArrayList<DefaultMutableTreeNode> children2 = new ArrayList<DefaultMutableTreeNode>(count);
            boolean skip = onRootPath && n != start2;
            for (int i2 = 0; i2 < count; ++i2) {
                DefaultMutableTreeNode c = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)n.getChildAt(fwd ? i2 : count - i2 - 1), this.myFilteringTree.getNodeClass());
                if (skip && rootPath.contains(c)) {
                    skip = false;
                }
                if (c == null || skip) continue;
                children2.add(c);
            }
            return children2;
        });
        traverser = (JBTreeTraverser)traverser.withRoots((Object[])new DefaultMutableTreeNode[]{this.myFilteringTree.getRoot()});
        if (start2 == null) {
            Iterator iterator2 = traverser.preOrderDfsTraversal().iterator();
            if (iterator2 == null) {
                FilteringSpeedSearch.$$$reportNull$$$0(13);
            }
            return iterator2;
        }
        if (!fwd) {
            Iterator iterator3 = traverser.postOrderDfsTraversal().skipWhile(n -> n != start2).skip(1).iterator();
            if (iterator3 == null) {
                FilteringSpeedSearch.$$$reportNull$$$0(14);
            }
            return iterator3;
        }
        Iterator iterator4 = traverser.preOrderDfsTraversal().skipWhile(n -> n != start2).skip(1).iterator();
        if (iterator4 == null) {
            FilteringSpeedSearch.$$$reportNull$$$0(15);
        }
        return iterator4;
    }

    @NotNull
    private Tree getTreeComponent() {
        Tree tree2 = this.myFilteringTree.getTree();
        if (tree2 == null) {
            FilteringSpeedSearch.$$$reportNull$$$0(16);
        }
        return tree2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 10, 11, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filteringTree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/FilteringSpeedSearch";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/FilteringSpeedSearch";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "checkMatching";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMatchingNodes";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "iterate";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkMatching";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onMatchingChecked";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOnlyElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 10, 11, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

