/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.ui.mac.touchbar.TBItemScrubber;
import com.intellij.ui.mac.touchbar.TBPanel;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.ui.popup.list.ListPopupImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CtxPopup {
    private static final boolean DISABLED = Boolean.getBoolean("touchbar.popups.disable");

    CtxPopup() {
    }

    @Nullable
    static Disposable showPopupItems(@NotNull JBPopup popup2, @NotNull JComponent popupComponent) {
        if (popup2 == null) {
            CtxPopup.$$$reportNull$$$0(0);
        }
        if (popupComponent == null) {
            CtxPopup.$$$reportNull$$$0(1);
        }
        if (DISABLED || !(popup2 instanceof ListPopupImpl)) {
            return null;
        }
        @NotNull ListPopupImpl listPopup = (ListPopupImpl)popup2;
        TBPanel tb = CtxPopup.createScrubberBarFromPopup(listPopup);
        TouchBarsManager.registerAndShow(popupComponent, tb);
        return () -> TouchBarsManager.unregister(popupComponent);
    }

    private static TBPanel createScrubberBarFromPopup(@NotNull ListPopupImpl listPopup) {
        if (listPopup == null) {
            CtxPopup.$$$reportNull$$$0(2);
        }
        TBPanel result2 = new TBPanel("popup_scrubber_bar_" + listPopup.hashCode(), new TBPanel.CrossEscInfo(true, false), false);
        ModalityStateEx ms = LaterInvocator.getCurrentModalityState();
        final TBItemScrubber scrub = result2.addScrubber();
        @NotNull ListPopupStep<Object> listPopupStep = listPopup.getListStep();
        @NotNull List stepValues = listPopupStep.getValues();
        ArrayList<Integer> disabledItems = new ArrayList<Integer>();
        int currIndex = 0;
        final HashMap obj2index = new HashMap();
        for (Object obj2 : stepValues) {
            Icon ic2 = listPopupStep.getIconFor(obj2);
            Object txt = listPopupStep.getTextFor(obj2);
            if (listPopupStep.isMnemonicsNavigationEnabled()) {
                int pos;
                MnemonicNavigationFilter filter2 = listPopupStep.getMnemonicNavigationFilter();
                int n = pos = filter2 == null ? -1 : filter2.getMnemonicPos(obj2);
                if (pos != -1) {
                    txt = ((String)txt).substring(0, pos) + ((String)txt).substring(pos + 1);
                }
            }
            Runnable edtAction = () -> {
                if (obj2 != null) {
                    listPopup.getList().setSelectedValue(obj2, false);
                } else {
                    listPopup.getList().setSelectedIndex(stepValues.indexOf(null));
                }
                listPopup.handleSelect(true);
            };
            Runnable action2 = () -> CtxPopup.lambda$createScrubberBarFromPopup$2(edtAction, (ModalityState)ms);
            scrub.addItem(ic2, (String)txt, action2);
            if (!listPopupStep.isSelectable(obj2)) {
                disabledItems.add(currIndex);
            }
            obj2index.put(obj2, currIndex);
            ++currIndex;
        }
        final ListModel model2 = listPopup.getList().getModel();
        model2.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ArrayList<Integer> visibleIndices = new ArrayList<Integer>();
                for (int c = 0; c < model2.getSize(); ++c) {
                    Object visibleItem = model2.getElementAt(c);
                    Integer itemId = (Integer)obj2index.get(visibleItem);
                    if (itemId == null) continue;
                    visibleIndices.add(itemId);
                }
                scrub.showItems(visibleIndices, true, true);
            }
        });
        result2.selectVisibleItemsToShow();
        scrub.enableItems(disabledItems, false);
        return result2;
    }

    private static /* synthetic */ void lambda$createScrubberBarFromPopup$2(Runnable edtAction, ModalityState ms) {
        ApplicationManager.getApplication().invokeLater(edtAction, ms);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listPopup";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/mac/touchbar/CtxPopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showPopupItems";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createScrubberBarFromPopup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

