/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.diff.model;

import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.diff.SwDiffResult;
import com.intellij.swagger.core.diff.SwDiffUtilsKt;
import com.intellij.swagger.core.diff.SwModificationType;
import com.intellij.swagger.core.diff.model.SwModifiedElement;
import com.intellij.swagger.core.diff.model.SwModifiedPrimitive;
import com.intellij.swagger.core.diff.model.SwModifiedProperty;
import com.intellij.swagger.core.diff.model.SwModifiedRootElement;
import com.intellij.swagger.core.model.api.SwObjectSchema;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0%H\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0016\u0010\u0012R!\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0014\u001a\u0004\b\u0019\u0010\u0012R!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0014\u001a\u0004\b\u001d\u0010\u0012R!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0014\u001a\u0004\b!\u0010\"\u00a8\u0006&"}, d2={"Lcom/intellij/swagger/core/diff/model/SwModifiedProperty;", "Lcom/intellij/swagger/core/diff/model/SwModifiedElement;", "Lcom/intellij/swagger/core/model/api/SwObjectSchema;", "original", "modified", "root", "Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;", "<init>", "(Lcom/intellij/swagger/core/model/api/SwObjectSchema;Lcom/intellij/swagger/core/model/api/SwObjectSchema;Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;)V", "getOriginal", "()Lcom/intellij/swagger/core/model/api/SwObjectSchema;", "getModified", "getRoot", "()Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;", "myNameModified", "Lcom/intellij/swagger/core/diff/model/SwModifiedPrimitive;", "", "getMyNameModified", "()Lcom/intellij/swagger/core/diff/model/SwModifiedPrimitive;", "myNameModified$delegate", "Lkotlin/Lazy;", "myTypeModified", "getMyTypeModified", "myTypeModified$delegate", "myFormatModified", "getMyFormatModified", "myFormatModified$delegate", "myRequiredModified", "", "getMyRequiredModified", "myRequiredModified$delegate", "myPropertiesDiff", "Lcom/intellij/swagger/core/diff/SwDiffResult;", "getMyPropertiesDiff", "()Lcom/intellij/swagger/core/diff/SwDiffResult;", "myPropertiesDiff$delegate", "computeChildrenDiffs", "", "intellij.swagger.core"})
public final class SwModifiedProperty
implements SwModifiedElement<SwObjectSchema> {
    @NotNull
    private final SwObjectSchema original;
    @NotNull
    private final SwObjectSchema modified;
    @NotNull
    private final SwModifiedRootElement root;
    @NotNull
    private final Lazy myNameModified$delegate;
    @NotNull
    private final Lazy myTypeModified$delegate;
    @NotNull
    private final Lazy myFormatModified$delegate;
    @NotNull
    private final Lazy myRequiredModified$delegate;
    @NotNull
    private final Lazy myPropertiesDiff$delegate;

    public SwModifiedProperty(@NotNull SwObjectSchema original, @NotNull SwObjectSchema modified, @NotNull SwModifiedRootElement root) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)modified, (String)"modified");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.original = original;
        this.modified = modified;
        this.root = root;
        this.myNameModified$delegate = LazyKt.lazy(() -> SwModifiedProperty.myNameModified_delegate$lambda$0(this));
        this.myTypeModified$delegate = LazyKt.lazy(() -> SwModifiedProperty.myTypeModified_delegate$lambda$0(this));
        this.myFormatModified$delegate = LazyKt.lazy(() -> SwModifiedProperty.myFormatModified_delegate$lambda$0(this));
        this.myRequiredModified$delegate = LazyKt.lazy(() -> SwModifiedProperty.myRequiredModified_delegate$lambda$0(this));
        this.myPropertiesDiff$delegate = LazyKt.lazy(() -> SwModifiedProperty.myPropertiesDiff_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public SwObjectSchema getOriginal() {
        return this.original;
    }

    @Override
    @NotNull
    public SwObjectSchema getModified() {
        return this.modified;
    }

    @Override
    @NotNull
    public SwModifiedRootElement getRoot() {
        return this.root;
    }

    private final SwModifiedPrimitive<String> getMyNameModified() {
        Lazy lazy = this.myNameModified$delegate;
        return (SwModifiedPrimitive)lazy.getValue();
    }

    private final SwModifiedPrimitive<String> getMyTypeModified() {
        Lazy lazy = this.myTypeModified$delegate;
        return (SwModifiedPrimitive)lazy.getValue();
    }

    private final SwModifiedPrimitive<String> getMyFormatModified() {
        Lazy lazy = this.myFormatModified$delegate;
        return (SwModifiedPrimitive)lazy.getValue();
    }

    private final SwModifiedPrimitive<Boolean> getMyRequiredModified() {
        Lazy lazy = this.myRequiredModified$delegate;
        return (SwModifiedPrimitive)lazy.getValue();
    }

    private final SwDiffResult<SwObjectSchema> getMyPropertiesDiff() {
        Lazy lazy = this.myPropertiesDiff$delegate;
        return (SwDiffResult)lazy.getValue();
    }

    @Override
    @NotNull
    public Collection<SwDiffResult<?>> computeChildrenDiffs() {
        Object[] objectArray = new SwDiffResult[2];
        SwModifiedElement[] swModifiedElementArray = new SwModifiedElement[]{this.getMyNameModified(), this.getMyTypeModified(), this.getMyFormatModified(), this.getMyRequiredModified()};
        objectArray[0] = SwDiffResult.Companion.fromModifications(swModifiedElementArray);
        objectArray[1] = this.getMyPropertiesDiff();
        return SetsKt.setOf((Object[])objectArray);
    }

    private static final SwModifiedPrimitive myNameModified_delegate$lambda$0(SwModifiedProperty this$0) {
        return new SwModifiedPrimitive(SwaggerBundle.message("diff.fields.name.title", new Object[0]), this$0.getOriginal().getName().getValue(), this$0.getModified().getName().getValue(), this$0.getRoot(), null, 16, null);
    }

    private static final SwModifiedPrimitive myTypeModified_delegate$lambda$0(SwModifiedProperty this$0) {
        return new SwModifiedPrimitive(SwaggerBundle.message("diff.fields.type.title", new Object[0]), this$0.getOriginal().getType().getValue(), this$0.getModified().getType().getValue(), this$0.getRoot(), null, 16, null);
    }

    private static final SwModifiedPrimitive myFormatModified_delegate$lambda$0(SwModifiedProperty this$0) {
        return new SwModifiedPrimitive(SwaggerBundle.message("diff.fields.format.title", new Object[0]), this$0.getOriginal().getFormat().getValue(), this$0.getModified().getFormat().getValue(), this$0.getRoot(), null, 16, null);
    }

    private static final SwModificationType myRequiredModified_delegate$lambda$0$0(SwModifiedPrimitive $this$SwModifiedPrimitive) {
        Intrinsics.checkNotNullParameter((Object)$this$SwModifiedPrimitive, (String)"$this$SwModifiedPrimitive");
        return (Boolean)$this$SwModifiedPrimitive.getOriginal() == false && (Boolean)$this$SwModifiedPrimitive.getModified() != false ? SwModificationType.BACKWARD_INCOMPATIBLE : (((Boolean)$this$SwModifiedPrimitive.getOriginal()).booleanValue() == ((Boolean)$this$SwModifiedPrimitive.getModified()).booleanValue() ? SwModificationType.NO_CHANGES : SwModificationType.BACKWARD_COMPATIBLE);
    }

    private static final SwModifiedPrimitive myRequiredModified_delegate$lambda$0(SwModifiedProperty this$0) {
        return new SwModifiedPrimitive<Boolean>(SwaggerBundle.message("diff.fields.required.title", new Object[0]), this$0.getOriginal().isRequired().getValue(), this$0.getModified().isRequired().getValue(), this$0.getRoot(), SwModifiedProperty::myRequiredModified_delegate$lambda$0$0);
    }

    private static final SwModifiedElement myPropertiesDiff_delegate$lambda$0$0(SwModifiedProperty this$0, SwObjectSchema before, SwObjectSchema after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        return new SwModifiedProperty(before, after, this$0.getRoot());
    }

    private static final SwDiffResult myPropertiesDiff_delegate$lambda$0(SwModifiedProperty this$0) {
        return SwDiffUtilsKt.calculateDiffBetween(this$0.getOriginal().getChildrenProperties(), this$0.getModified().getChildrenProperties(), (Function1)myPropertiesDiff.2.1.INSTANCE, (arg_0, arg_1) -> SwModifiedProperty.myPropertiesDiff_delegate$lambda$0$0(this$0, arg_0, arg_1));
    }
}

