/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui.browser.strategy;

import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.ui.SwPreviewType;
import com.intellij.swagger.core.ui.browser.strategy.RedocProviderStrategy;
import com.intellij.swagger.core.ui.browser.strategy.SwPreviewCustomization;
import com.intellij.swagger.core.ui.browser.strategy.SwPreviewProviderStrategy;
import com.intellij.swagger.core.ui.jcefHandler.SwCefCorsRequestHandler;
import com.intellij.swagger.core.ui.jcefHandler.SwCefResourceRequestHandler;
import com.intellij.swagger.core.ui.jcefHandler.SwRequestMetadataEnricher;
import com.intellij.swagger.core.ui.utils.RedocJsUtilsKt;
import com.intellij.swagger.core.ui.utils.SwCommonJsUtilsKt;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefJSQuery;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefRequestHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/swagger/core/ui/browser/strategy/RedocProviderStrategy;", "Lcom/intellij/swagger/core/ui/browser/strategy/SwPreviewProviderStrategy;", "<init>", "()V", "installOn", "Lcom/intellij/swagger/core/ui/browser/strategy/SwPreviewCustomization;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "cefBrowser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "RedocPreviewCustomization", "intellij.swagger.core"})
public final class RedocProviderStrategy
implements SwPreviewProviderStrategy {
    @NotNull
    public static final RedocProviderStrategy INSTANCE = new RedocProviderStrategy();

    private RedocProviderStrategy() {
    }

    @Override
    @NotNull
    public SwPreviewCustomization installOn(@NotNull TextEditor textEditor, @NotNull JBCefBrowser cefBrowser, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
        Intrinsics.checkNotNullParameter((Object)cefBrowser, (String)"cefBrowser");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SwCefCorsRequestHandler corsHandler = new SwCefCorsRequestHandler();
        SwRequestMetadataEnricher requestMetadataEnricher = new SwRequestMetadataEnricher(SwPreviewType.REDOC);
        SwCefResourceRequestHandler[] swCefResourceRequestHandlerArray = new SwCefResourceRequestHandler[]{corsHandler, requestMetadataEnricher};
        CefRequestHandler requestHandler = SwCommonJsUtilsKt.setupSwaggerResourcesRequestHandlerChain(cefBrowser, swCefResourceRequestHandlerArray);
        JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)cefBrowser));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
        JBCefJSQuery statisticsQuery = jBCefJSQuery;
        CefLoadHandlerAdapter statisticsHandler2 = SwCommonJsUtilsKt.setupCefLoadHandler(statisticsQuery, cefBrowser, (Function2<? super JBCefJSQuery, ? super JBCefBrowser, Unit>)((Function2)installOn.statisticsHandler.1.INSTANCE));
        Function1<String, JBCefJSQuery.Response> jsStatisticsHandler = RedocJsUtilsKt.setupRedocJsStatisticsHandler(statisticsQuery, project);
        CefLifeSpanHandler browseUrlHandler = SwCommonJsUtilsKt.setupBrowseUrlHandler(cefBrowser);
        return new RedocPreviewCustomization(requestHandler, statisticsQuery, (CefLoadHandler)statisticsHandler2, jsStatisticsHandler, browseUrlHandler);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001f\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lcom/intellij/swagger/core/ui/browser/strategy/RedocProviderStrategy$RedocPreviewCustomization;", "Lcom/intellij/swagger/core/ui/browser/strategy/SwPreviewCustomization;", "requestHandler", "Lorg/cef/handler/CefRequestHandler;", "myStatisticsQuery", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "myStatisticsHandler", "Lorg/cef/handler/CefLoadHandler;", "myJsStatisticsHandler", "Lkotlin/Function1;", "", "Lcom/intellij/ui/jcef/JBCefJSQuery$Response;", "myLifeSpanHandler", "Lorg/cef/handler/CefLifeSpanHandler;", "<init>", "(Lorg/cef/handler/CefRequestHandler;Lcom/intellij/ui/jcef/JBCefJSQuery;Lorg/cef/handler/CefLoadHandler;Lkotlin/jvm/functions/Function1;Lorg/cef/handler/CefLifeSpanHandler;)V", "getRequestHandler", "()Lorg/cef/handler/CefRequestHandler;", "getMyStatisticsQuery", "()Lcom/intellij/ui/jcef/JBCefJSQuery;", "getMyStatisticsHandler", "()Lorg/cef/handler/CefLoadHandler;", "getMyJsStatisticsHandler", "()Lkotlin/jvm/functions/Function1;", "getMyLifeSpanHandler", "()Lorg/cef/handler/CefLifeSpanHandler;", "previewType", "Lcom/intellij/swagger/core/ui/SwPreviewType;", "getPreviewType", "()Lcom/intellij/swagger/core/ui/SwPreviewType;", "removeFrom", "", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "cefBrowser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "intellij.swagger.core"})
    private static final class RedocPreviewCustomization
    implements SwPreviewCustomization {
        @NotNull
        private final CefRequestHandler requestHandler;
        @NotNull
        private final JBCefJSQuery myStatisticsQuery;
        @NotNull
        private final CefLoadHandler myStatisticsHandler;
        @NotNull
        private final Function1<String, JBCefJSQuery.Response> myJsStatisticsHandler;
        @NotNull
        private final CefLifeSpanHandler myLifeSpanHandler;
        @NotNull
        private final SwPreviewType previewType;

        public RedocPreviewCustomization(@NotNull CefRequestHandler requestHandler, @NotNull JBCefJSQuery myStatisticsQuery, @NotNull CefLoadHandler myStatisticsHandler, @NotNull Function1<? super String, ? extends JBCefJSQuery.Response> myJsStatisticsHandler, @NotNull CefLifeSpanHandler myLifeSpanHandler) {
            Intrinsics.checkNotNullParameter((Object)requestHandler, (String)"requestHandler");
            Intrinsics.checkNotNullParameter((Object)myStatisticsQuery, (String)"myStatisticsQuery");
            Intrinsics.checkNotNullParameter((Object)myStatisticsHandler, (String)"myStatisticsHandler");
            Intrinsics.checkNotNullParameter(myJsStatisticsHandler, (String)"myJsStatisticsHandler");
            Intrinsics.checkNotNullParameter((Object)myLifeSpanHandler, (String)"myLifeSpanHandler");
            this.requestHandler = requestHandler;
            this.myStatisticsQuery = myStatisticsQuery;
            this.myStatisticsHandler = myStatisticsHandler;
            this.myJsStatisticsHandler = myJsStatisticsHandler;
            this.myLifeSpanHandler = myLifeSpanHandler;
            this.previewType = SwPreviewType.REDOC;
        }

        @NotNull
        public final CefRequestHandler getRequestHandler() {
            return this.requestHandler;
        }

        @NotNull
        public final JBCefJSQuery getMyStatisticsQuery() {
            return this.myStatisticsQuery;
        }

        @NotNull
        public final CefLoadHandler getMyStatisticsHandler() {
            return this.myStatisticsHandler;
        }

        @NotNull
        public final Function1<String, JBCefJSQuery.Response> getMyJsStatisticsHandler() {
            return this.myJsStatisticsHandler;
        }

        @NotNull
        public final CefLifeSpanHandler getMyLifeSpanHandler() {
            return this.myLifeSpanHandler;
        }

        @Override
        @NotNull
        public SwPreviewType getPreviewType() {
            return this.previewType;
        }

        @Override
        public void removeFrom(@NotNull TextEditor textEditor, @NotNull JBCefBrowser cefBrowser) {
            Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
            Intrinsics.checkNotNullParameter((Object)cefBrowser, (String)"cefBrowser");
            SwCommonJsUtilsKt.removeCefRequestHandler(cefBrowser, this.requestHandler);
            SwCommonJsUtilsKt.removeCefLoadHandler(cefBrowser, this.myStatisticsHandler);
            SwCommonJsUtilsKt.removeJsHandler(this.myStatisticsQuery, this.myJsStatisticsHandler);
            SwCommonJsUtilsKt.removeCefLifeSpanHandler(cefBrowser, this.myLifeSpanHandler);
        }
    }
}

